/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadListUtils;

public class MaterialRangeImportHelper {
    private static final Log LOG = LogFactory.getLog(MaterialRangeImportHelper.class);
    private static final String BOM_TYPE_ID = "bomTypeIdList";
    private static final String ATTR_OUT_SOURCING = "10040";
    private static final int QUERY_MATERIAL_BATCH_SIZE = 5000;

    public static List<Map<String, Object>> queryMaterialProduceListByParam(Long materialGroupStandard, List<Long> materialGroupList, Long produceOrgId, List<Long> bomMaterialIdList) {
        LOG.info("MaterialRangeImportHelper#queryMaterialProduceListByParam start produceOrgId={}, materialGroupStandard={},materialGroupList size={}, bomMaterialIdList size={}", new Object[]{produceOrgId, materialGroupStandard, materialGroupList.size(), bomMaterialIdList.size()});
        ArrayList<Map<String, Object>> produceMaterialList = new ArrayList<Map<String, Object>>();
        if (CadEmptyUtils.isEmpty(materialGroupStandard) || CadEmptyUtils.isEmpty(materialGroupList) || CadEmptyUtils.isEmpty(produceOrgId) || CadEmptyUtils.isEmpty(bomMaterialIdList)) {
            return produceMaterialList;
        }
        ArrayList<Long> materialGroupTempList = new ArrayList<Long>(materialGroupList);
        ArrayList<Long> defaultFilterGroupIdList = new ArrayList<Long>();
        defaultFilterGroupIdList.add(1703587904586090496L);
        defaultFilterGroupIdList.add(1675236224446617600L);
        materialGroupTempList.removeAll(defaultFilterGroupIdList);
        LOG.info("MaterialRangeImportHelper#queryMaterialProduceListByParam after filter group materialGroupList size={}, defaultFilterGroupIdList={}", (Object)materialGroupTempList.size(), defaultFilterGroupIdList);
        long startTime = System.currentTimeMillis();
        List<Long> materialIdList = MaterialGroupHelper.queryMaterialIdList(materialGroupStandard, materialGroupTempList);
        if (CadEmptyUtils.isEmpty(materialIdList)) {
            LOG.info("MaterialRangeImportHelper#queryMaterialProduceListByParam materialIdList  is empty, materialGroupStandard={}, materialGroupTempList={}, costTime={}", new Object[]{materialGroupStandard, materialGroupTempList, System.currentTimeMillis() - startTime});
            return produceMaterialList;
        }
        List<Long> filteredGroupMaterialIdList = MaterialRangeImportHelper.queryFilterMaterialIdByGroup();
        LOG.info("MaterialRangeImportHelper#queryMaterialProduceListByParam before materialIdList size={},bomMaterialIdList size={},filteredGroupMaterialIdList size={} costTime={}", new Object[]{materialIdList.size(), bomMaterialIdList.size(), filteredGroupMaterialIdList.size(), System.currentTimeMillis() - startTime});
        HashSet<Long> bomMaterialIdSet = new HashSet<Long>(bomMaterialIdList);
        HashSet<Long> materialIdSet = new HashSet<Long>(materialIdList);
        HashSet<Long> filteredGroupMaterialIdSet = new HashSet<Long>(filteredGroupMaterialIdList);
        materialIdSet.removeAll(filteredGroupMaterialIdSet);
        bomMaterialIdSet.retainAll(materialIdSet);
        if (CadEmptyUtils.isEmpty(bomMaterialIdSet)) {
            LOG.info("MaterialRangeImportHelper#queryMaterialProduceListByParam filtered materialIdList is empty.");
            return produceMaterialList;
        }
        materialIdList = new ArrayList<Long>(bomMaterialIdSet);
        LOG.info("MaterialRangeImportHelper#queryMaterialProduceListByParam after materialIdList size={},bomMaterialIdList size={}, costTime={}", new Object[]{materialIdList.size(), bomMaterialIdList.size(), System.currentTimeMillis() - startTime});
        QFilter qFilter = new QFilter("createorg", "=", (Object)produceOrgId);
        qFilter.and(new QFilter("materialattr", "!=", (Object)ATTR_OUT_SOURCING));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        QFilter materialIdFilter = InFilterHelper.getQFilterByBachSize("masterid", new ArrayList<Object>(materialIdList), "in", 20000);
        qFilter.and(materialIdFilter);
        DataSet produceDataSet = QueryServiceHelper.queryDataSet((String)MaterialRangeImportHelper.class.getName(), (String)"bd_materialmftinfo", (String)"masterid,materialattr,createorg.id as createorg", (QFilter[])qFilter.toArray(), null);
        if (produceDataSet == null || produceDataSet.isEmpty()) {
            LOG.info("MaterialRangeImportHelper#queryMaterialProduceListByParam  produceDataSet is empty costTime={}", (Object)(System.currentTimeMillis() - startTime));
            return produceMaterialList;
        }
        produceDataSet.forEach(item -> {
            HashMap<String, Object> material = new HashMap<String, Object>(3);
            material.put("id", item.getLong("masterid"));
            material.put("materialattr", item.getString("materialattr"));
            material.put("createorg", item.getLong("createorg"));
            produceMaterialList.add(material);
        });
        LOG.info("MaterialRangeImportHelper#queryMaterialProduceListByParam end produceMaterialList size={}, costTime={}", (Object)produceMaterialList.size(), (Object)(System.currentTimeMillis() - startTime));
        return produceMaterialList;
    }

    public static List<Long> getBomMaterialIdList(Long produceOrgId) {
        LOG.info("getBomMaterialIdList start produceOrgId={}", (Object)produceOrgId);
        ArrayList<Long> bomMaterialIdList = new ArrayList<Long>();
        String bomTypeIdStr = CadBgParamUtils.getCadBgParamForString(BOM_TYPE_ID, "");
        ArrayList<Long> typeList = new ArrayList<Long>();
        if (!CadEmptyUtils.isEmpty(bomTypeIdStr)) {
            String[] bomTypeIdArray;
            for (String bomTypeId : bomTypeIdArray = bomTypeIdStr.split(",")) {
                typeList.add(Long.parseLong(bomTypeId));
            }
        }
        QFilter qFilter = new QFilter("createorg", "=", (Object)produceOrgId);
        qFilter.and(new QFilter("type", "not in", typeList));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)MaterialRangeImportHelper.class.getName(), (String)"pdm_mftbom", (String)"material.masterid as material", (QFilter[])new QFilter[]{qFilter}, null);
        if (dataSet == null || dataSet.isEmpty()) {
            LOG.info("getBomMaterialIdList end dataSet is empty. produceOrgId={}", (Object)produceOrgId);
            return bomMaterialIdList;
        }
        dataSet.forEach(item -> bomMaterialIdList.add(item.getLong("material")));
        LOG.info("getBomMaterialIdList end produceOrgId={}, bomMaterialIdList size={}", (Object)produceOrgId, (Object)bomMaterialIdList.size());
        return bomMaterialIdList;
    }

    public static int deleteData(List<Long> materialIdList, Long manuOrg) {
        if (CadEmptyUtils.isEmpty(materialIdList)) {
            LOG.info("delete material range materialIdList is empty.");
            return 0;
        }
        QFilter qFilter = new QFilter("manuorg", "=", (Object)manuOrg);
        qFilter.and(new QFilter("material", "in", materialIdList));
        DeleteServiceHelper.delete((String)"cad_autocalcmatrange", (QFilter[])qFilter.toArray());
        return materialIdList.size();
    }

    private static int saveData(List<DynamicObject> dynamicObjectList) {
        if (CadEmptyUtils.isEmpty(dynamicObjectList)) {
            LOG.info("saveData dynamicObjectList is empty.");
            return 0;
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[0]));
        return dynamicObjectList.size();
    }

    public static int saveAndUpdateMaterialRange(List<Map<String, Object>> materialList, Long produceOrgId) {
        LOG.info("saveAndUpdateMaterialRange start produceOrgId={}, materialList size={}", (Object)produceOrgId, (Object)materialList.size());
        if (CadEmptyUtils.isEmpty(materialList)) {
            return 0;
        }
        ArrayList<Long> materialIdList = new ArrayList<Long>();
        materialList.forEach(item -> materialIdList.add((Long)item.get("id")));
        Map<Long, Boolean> materialMap = MaterialRangeImportHelper.queryMaterialBatchById(materialIdList);
        Map<Long, Map<String, Object>> importHistoryMap = MaterialRangeImportHelper.queryMaterialRangeImportHistory(produceOrgId, materialIdList);
        LOG.info("saveAndUpdateMaterialRange produceOrgId={}, importHistoryMap size={}", (Object)produceOrgId, (Object)importHistoryMap.size());
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>();
        ArrayList<Long> deleteMaterialIdList = new ArrayList<Long>();
        for (Map<String, Object> material : materialList) {
            DynamicObject dynamicObject;
            Long materialId = (Long)material.get("id");
            Long manuOrg = (Long)material.get("createorg");
            String materialAttr = (String)material.get("materialattr");
            Map<String, Object> materialDb = importHistoryMap.get(materialId);
            if (CadEmptyUtils.isEmpty(materialDb)) {
                dynamicObject = MaterialRangeImportHelper.transToMaterialDbModel(manuOrg, materialId, materialAttr, materialMap.get(materialId));
                dynamicObjectList.add(dynamicObject);
                continue;
            }
            if (String.valueOf(materialDb.get("materialattr")).equals(MaterialRangeImportHelper.matAttrTransTo(materialAttr))) continue;
            deleteMaterialIdList.add(materialId);
            dynamicObject = MaterialRangeImportHelper.transToMaterialDbModel(manuOrg, materialId, materialAttr, materialMap.get(materialId));
            dynamicObjectList.add(dynamicObject);
        }
        int deleteNum = MaterialRangeImportHelper.deleteData(deleteMaterialIdList, produceOrgId);
        int addNum = MaterialRangeImportHelper.saveData(dynamicObjectList);
        LOG.info("saveAndUpdateMaterialRange success produceOrgId={}, deleteNum={}, addNum={}", new Object[]{produceOrgId, deleteNum, addNum});
        return addNum;
    }

    private static DynamicObject transToMaterialDbModel(Long manuorg, Long materialId, String materialAttr, Boolean configAttr) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"cad_autocalcmatrange");
        dynamicObject.set("manuorg", (Object)manuorg);
        dynamicObject.set("material", (Object)materialId);
        dynamicObject.set("materialattr", (Object)MaterialRangeImportHelper.matAttrTransTo(materialAttr));
        dynamicObject.set("syndate", (Object)new Date());
        dynamicObject.set("status", (Object)0);
        dynamicObject.set("configmat", (Object)(configAttr == null ? Boolean.FALSE : configAttr));
        return dynamicObject;
    }

    private static Map<Long, Boolean> queryMaterialBatchById(List<Long> idList) {
        HashMap<Long, Boolean> materialMap = new HashMap<Long, Boolean>();
        List<List<Object>> splitMaterialList = CadListUtils.splitLists(new ArrayList<Object>(idList), 5000);
        for (List<Object> materialList : splitMaterialList) {
            List<Object> materialIdList = materialList;
            QFilter qFilter = new QFilter("id", "in", materialIdList);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_material", (String)"id,configproperties", (QFilter[])qFilter.toArray());
            if (CadEmptyUtils.isEmpty(dynamicObjects)) continue;
            dynamicObjects.forEach(item -> materialMap.put(item.getLong("id"), "2".equals(item.getString("configproperties"))));
        }
        return materialMap;
    }

    public static String matAttrTransTo(String attrValue) {
        switch (attrValue) {
            case "10020": {
                return "D";
            }
            case "10030": {
                return "A";
            }
            case "10040": {
                return "B";
            }
            case "10050": {
                return "C";
            }
        }
        return "B";
    }

    public static Map<Long, Map<String, Object>> queryMaterialRangeImportHistory(Long manuOrg, List<Long> materialIdList) {
        QFilter qFilter = new QFilter("manuorg", "=", (Object)manuOrg);
        qFilter.and(new QFilter("material", "in", materialIdList));
        DataSet dataSetDb = QueryServiceHelper.queryDataSet((String)MaterialRangeImportHelper.class.getName(), (String)"cad_autocalcmatrange", (String)"id,material,materialattr", (QFilter[])qFilter.toArray(), null);
        if (dataSetDb == null || dataSetDb.isEmpty()) {
            return new HashMap<Long, Map<String, Object>>();
        }
        HashMap<Long, Map<String, Object>> resultMap = new HashMap<Long, Map<String, Object>>();
        dataSetDb.forEach(item -> {
            HashMap<String, Object> material = new HashMap<String, Object>(2);
            material.put("material", item.getLong("material"));
            material.put("materialattr", item.getString("materialattr"));
            resultMap.put(item.getLong("material"), material);
        });
        return resultMap;
    }

    private static List<Long> queryFilterMaterialIdByGroup() {
        ArrayList<Long> defaultFilterGroupIdList = new ArrayList<Long>();
        defaultFilterGroupIdList.add(1703587904586090496L);
        defaultFilterGroupIdList.add(1675236224446617600L);
        List<Long> materialIdList = MaterialGroupHelper.queryMaterialIdList(730148448254487552L, defaultFilterGroupIdList);
        LOG.info("queryFilterMaterialIdByGroup materialIdList size={}", (Object)materialIdList.size());
        return materialIdList;
    }
}

