/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.AutoExecSchemeDTO;
import kd.macc.cad.common.enums.ScaMfgFeeImpSchEnum;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class MfgfeeBillHelper {
    private static final Log logger = LogFactory.getLog(MfgfeeBillHelper.class);
    private static final String Field_AutoExecSchemeDto = "autoExecSchemeDTO";
    private static final int idCapacity = 1900;

    public static ExecuteResult importMfgFeeBillBySys(Long orgId, Set<Long> costAccountSet, String appNum, AutoExecSchemeDTO autoExecSchemeDTO) {
        QFilter orgQF = new QFilter("accountorg", "=", (Object)orgId);
        QFilter sysParamCostCenterQF = SysParamHelper.getSysParamCostCenterQF(orgId, "mfgfeebilltype", SysParamEnum.COMPTYPE_SYS.getValue(), "id", appNum);
        DynamicObjectCollection costCenterDyc = QueryServiceHelper.query((String)"bos_costcenter", (String)"id", (QFilter[])new QFilter[]{orgQF, sysParamCostCenterQF});
        if (CadEmptyUtils.isEmpty(costCenterDyc)) {
            ExecuteResult result = new ExecuteResult();
            result.setFalseNotification(ResManager.loadKDString((String)"\u201c\u6210\u672c\u53c2\u6570\u201d\u4e2d\u5236\u9020\u8d39\u7528\u5f52\u96c6\u65b0\u589e\u65b9\u5f0f\u4e3a\u624b\u5de5\u5f55\u5165\u3002 ", (String)"MfgfeeBillHelper_0", (String)"macc-cad-common", (Object[])new Object[0]));
            return result;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put(Field_AutoExecSchemeDto, autoExecSchemeDTO);
        QFilter sysOrgQF = new QFilter("org", "=", (Object)orgId);
        QFilter costAccountQF = new QFilter("entry.costaccount", "in", costAccountSet);
        DynamicObjectCollection res = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id, entry.costaccount AS costaccount, entry.currentperiod AS currentperiod", (QFilter[])new QFilter[]{sysOrgQF, costAccountQF});
        if (!CadEmptyUtils.isEmpty(res)) {
            for (DynamicObject costAccount : res) {
                paramMap.put(costAccount.getString("costaccount"), costAccount.get("currentperiod"));
            }
        }
        ArrayList<Object> costCenterList = new ArrayList<Object>();
        costCenterList.add("0");
        costCenterList.addAll(SysParamHelper.getSysParamCostCenter(orgId.toString(), "mfgfeebilltype", SysParamEnum.COMPTYPE_SYS.getValue(), appNum));
        paramMap.put("appnum", appNum);
        return MfgfeeBillHelper.importMfgFeeBillBySys(orgId, costAccountSet, costCenterList, paramMap);
    }

    public static ExecuteResult importMfgFeeBillBySys(Long orgId, Set<Long> costAccountSet, List<Object> costCenterIdList, Map<String, Object> paramMap) {
        ExecuteResult result = new ExecuteResult();
        DynamicObjectCollection idCollec = MfgfeeBillHelper.getImpSchIdCollec(orgId, costAccountSet, paramMap);
        if (CadEmptyUtils.isEmpty(idCollec)) {
            result.setFalseNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u5f15\u5165\u65b9\u6848\u3002 ", (String)"MfgfeeBillHelper_1", (String)"macc-cad-common", (Object[])new Object[0]));
            return result;
        }
        paramMap.put("currDate", new Date());
        MfgfeeBillHelper.addCurrency(paramMap, costAccountSet);
        MfgfeeBillHelper.addCurrentPeriodLastDate(paramMap, costAccountSet);
        HashMap cacheMap = new HashMap();
        paramMap.put("cacheMap", cacheMap);
        Object[] ids = MfgfeeBillHelper.toArrIds(idCollec);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"sca_mfgfeeimpsch");
        DynamicObject[] mfgFeeImpSchs = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)mainEntityType);
        HashSet costCenterIdSet = new HashSet(16);
        if (costCenterIdList != null && !costCenterIdList.isEmpty()) {
            costCenterIdList.forEach(id -> costCenterIdSet.add(id.toString()));
        }
        HashSet repeatSchSet = new HashSet();
        paramMap.put("repeatSchSet", repeatSchSet);
        Set<Long> voucherEntryIds = MfgfeeBillHelper.getImportedSrcBillEntryIds(orgId, costAccountSet, (String)paramMap.get("appnum"));
        Map<String, List<DynamicObject>> srcBillMap = MfgfeeBillHelper.getAllSrcBillByImpSch(mfgFeeImpSchs, paramMap, orgId, voucherEntryIds);
        Map<String, String> flexFieldMap = MfgfeeBillHelper.getFlexFieldMap();
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>();
        for (DynamicObject mfgFeeImpSch : mfgFeeImpSchs) {
            Map<String, List<DynamicObject>> voucherMap;
            DynamicObjectCollection entryentity = mfgFeeImpSch.getDynamicObjectCollection("entryentity");
            DynamicObject mfgFeeImpSchRow = (DynamicObject)entryentity.get(0);
            Long schCostCenterId = mfgFeeImpSchRow.getLong("costcenter.id");
            if (!CadEmptyUtils.isEmpty(schCostCenterId) && !costCenterIdSet.contains(schCostCenterId.toString()) || CadEmptyUtils.isEmpty(voucherMap = MfgfeeBillHelper.getVoucher(mfgFeeImpSch, paramMap, srcBillMap))) continue;
            MfgfeeBillHelper.toMfgFeeBill(mfgFeeImpSch, billList, voucherMap, paramMap, flexFieldMap);
        }
        ArrayList<DynamicObject> saveBillList = new ArrayList<DynamicObject>(10);
        if ("sca".equals((String)paramMap.get("appnum"))) {
            HashMap groupBillMap = new HashMap(16);
            HashMap<String, Integer> billCurrCountMap = new HashMap<String, Integer>(16);
            StringBuilder groupKey = new StringBuilder();
            HashMap<String, Set<String>> srcSysCombMap = new HashMap<String, Set<String>>(16);
            for (DynamicObject bill : billList) {
                Long costCenterId = bill.getLong("costcenter");
                if (!costCenterIdSet.contains(costCenterId.toString())) continue;
                MfgfeeBillHelper.generateGroupBill(groupBillMap, bill, groupKey, billCurrCountMap, srcSysCombMap, paramMap);
            }
            MfgfeeBillHelper.fillMulSrcSys(groupBillMap, srcSysCombMap);
            if (!groupBillMap.isEmpty()) {
                for (DynamicObject bill : groupBillMap.values()) {
                    saveBillList.add(bill);
                }
            }
        } else {
            for (DynamicObject bill : billList) {
                Long costCenterId = bill.getLong("costcenter");
                if (!costCenterIdSet.contains(costCenterId.toString())) continue;
                saveBillList.add(bill);
            }
        }
        if (CadEmptyUtils.isEmpty(saveBillList)) {
            result.setFalseNotification(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u5f15\u5165\u6570\u636e\u3002\u8bf7\u68c0\u67e5\uff1a%1$s 1\u3001\u6765\u6e90\u5355\u636e\u5df2\u7ecf\u5168\u90e8\u5f15\u5165\uff1b%2$s 2\u3001\u6210\u672c\u4e2d\u5fc3\u5bf9\u5e94\u5173\u7cfb\u7ef4\u62a4\u7684\u6b63\u786e\u6027\uff1b%3$s 3\u3001\u6570\u636e\u89c4\u5219\u65b9\u6848\u914d\u7f6e\u7684\u6b63\u786e\u6027\uff1b%4$s 4\u3001\u5728\u542f\u7528\u6570\u636e\u89c4\u5219\u65b9\u6848\u7684\u524d\u63d0\u4e0b\uff0c\u5f15\u5165\u6240\u9009\u6210\u672c\u4e2d\u5fc3\u5728\u6570\u636e\u89c4\u5219\u7684\u8303\u56f4\u5185\u3002", (String)"MfgfeeBillHelper_6", (String)"macc-cad-common", (Object[])new Object[0]), "\n", "\n", "\n", "\n"));
            return result;
        }
        String mfgFeeEntity = MfgfeeBillHelper.getMfgFeeEntity((String)paramMap.get("appnum"));
        CodeRuleServiceHelper.injectNumbers((String)mfgFeeEntity, saveBillList);
        SaveServiceHelper.save((DynamicObject[])saveBillList.toArray(new DynamicObject[0]));
        result.setSuccessQty(saveBillList.size());
        result.setSuccessNotificatio(String.format(ResManager.loadKDString((String)"\u6210\u529f\u5bfc\u5165%s\u6761\u6570\u636e\u3002", (String)"MfgfeeBillHelper_7", (String)"macc-cad-common", (Object[])new Object[0]), saveBillList.size()));
        MfgfeeBillHelper.submitAndAuditBill(saveBillList, result, mfgFeeEntity);
        return result;
    }

    private static void submitAndAuditBill(List<DynamicObject> billList, ExecuteResult result, String mfgFeeEntity) {
        DynamicObject[] mfgfeebills;
        List submitSuccessPkIds;
        ArrayList<Object> billIds = new ArrayList<Object>(16);
        for (DynamicObject bill : billList) {
            billIds.add(bill.getPkValue());
        }
        OperationResult submitRes = OperationServiceHelper.executeOperate((String)"submit", (String)mfgFeeEntity, (Object[])billIds.toArray(new Object[0]), (OperateOption)OperateOption.create());
        if (!submitRes.isSuccess()) {
            String submitTip = MfgfeeBillHelper.generateValidateErrMessage(submitRes);
            result.setSubmitTip(submitTip);
        }
        if ((submitSuccessPkIds = submitRes.getSuccessPkIds()) == null || submitSuccessPkIds.isEmpty()) {
            return;
        }
        OperationResult auditRes = OperationServiceHelper.executeOperate((String)"audit", (String)mfgFeeEntity, (Object[])submitSuccessPkIds.toArray(new Object[0]), (OperateOption)OperateOption.create());
        if (!auditRes.isSuccess()) {
            String aduitTip = MfgfeeBillHelper.generateValidateErrMessage(auditRes);
            result.setAduitTip(aduitTip);
        }
        for (DynamicObject mfgfeebill : mfgfeebills = BusinessDataServiceHelper.load((Object[])submitSuccessPkIds.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sca_mfgfeebill"))) {
            mfgfeebill.set("modifier", (Object)0L);
            mfgfeebill.set("modifytime", null);
        }
        SaveServiceHelper.save((DynamicObject[])mfgfeebills);
    }

    private static String generateValidateErrMessage(OperationResult res) {
        List validateErrors = res.getValidateResult().getValidateErrors();
        StringBuilder tip = new StringBuilder();
        for (ValidateResult validateRes : validateErrors) {
            List allErrorInfo = validateRes.getAllErrorInfo();
            for (OperateErrorInfo errorInfo : allErrorInfo) {
                String message = errorInfo.getMessage();
                tip.append(message).append("\r\n");
            }
        }
        return tip.toString();
    }

    private static void fillMulSrcSys(Map<String, DynamicObject> groupBillMap, Map<String, Set<String>> srcSysCombMap) {
        for (Map.Entry<String, DynamicObject> groupBill : groupBillMap.entrySet()) {
            String key = groupBill.getKey();
            DynamicObject bill = groupBill.getValue();
            Set<String> srcSysComb = srcSysCombMap.get(key);
            if (srcSysComb == null || srcSysComb.isEmpty()) continue;
            DynamicObjectCollection mulSrcSys = bill.getDynamicObjectCollection("mulsrcsys");
            for (String srcSysId : srcSysComb) {
                DynamicObject srcSys = mulSrcSys.addNew();
                srcSys.set("fbasedataid", (Object)srcSysId);
            }
        }
    }

    private static Map<String, List<DynamicObject>> getAllSrcBillByImpSch(DynamicObject[] mfgFeeImpSchs, Map<String, Object> paramMap, Long orgId, Set<Long> voucherEntryIds) {
        HashSet<Long> accountViewIds = new HashSet<Long>(16);
        HashSet<Long> periodIds = new HashSet<Long>(16);
        HashSet<String> bizDateFields = new HashSet<String>(16);
        boolean allIsFromGl = true;
        for (DynamicObject mfgFeeImpSch : mfgFeeImpSchs) {
            if (!mfgFeeImpSch.getBoolean("isfromgl")) {
                allIsFromGl = false;
            }
            Long accountViewId = mfgFeeImpSch.getLong("accountview.id");
            accountViewIds.add(accountViewId);
            Long currPeriod = (Long)paramMap.get(String.valueOf(mfgFeeImpSch.getLong("costaccount.id")));
            periodIds.add(currPeriod);
            DynamicObjectCollection entryentity = mfgFeeImpSch.getDynamicObjectCollection("entryentity");
            String bizdate = ((DynamicObject)entryentity.get(0)).getString("bizdate");
            bizDateFields.add(bizdate);
        }
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        QFilter accountViewQF = new QFilter("entries.account", "in", accountViewIds);
        QFilter billStatusQF = new QFilter("billstatus", "=", (Object)"C");
        QFilter currPeriodQF = new QFilter("period.id", "in", periodIds);
        QFilter idNotQF = null;
        if (!CadEmptyUtils.isEmpty(voucherEntryIds)) {
            idNotQF = new QFilter("entries.id", "not in", voucherEntryIds);
        }
        QFilter sourceSysQF = null;
        sourceSysQF = allIsFromGl ? new QFilter("sourcesys.number", "=", (Object)"gl") : new QFilter("sourcesys.number", "!=", (Object)"sca");
        StringBuilder bizDateFieldStr = new StringBuilder();
        bizDateFields.forEach(bizDateField -> bizDateFieldStr.append((String)bizDateField).append(','));
        String bizDateFieldSql = bizDateFieldStr.toString();
        String fields = "id," + bizDateFieldSql + "sourcesys,sourcesys.number AS srcSysNum,period.id AS periodId,vouchertype,billno AS srcbillnum,entries.id AS voucherentry,entries.account.id AS accountId,entries.assgrp.id AS assgrpId,entries.assgrp.value AS assgrpValue,entries.account.dc AS dc,entries.debitlocal AS debitlocal,entries.creditlocal AS creditlocal";
        QFilter[] qf = new QFilter[]{orgQF, accountViewQF, billStatusQF, currPeriodQF, idNotQF, sourceSysQF};
        DynamicObjectCollection vouchers = QueryServiceHelper.query((String)"gl_voucher", (String)fields, (QFilter[])qf);
        logger.error("\u83b7\u53d6\u5230\u7684\u672a\u89e3\u6790\u7684\u51ed\u8bc1\u6761\u6570 : " + vouchers.size());
        HashMap<String, List<DynamicObject>> srcBillMap = new HashMap<String, List<DynamicObject>>(16);
        if (vouchers.isEmpty()) {
            return srcBillMap;
        }
        StringBuilder srcBillKeySb = new StringBuilder();
        for (DynamicObject srcBill : vouchers) {
            srcBillKeySb.setLength(0);
            srcBillKeySb.append(srcBill.getLong("accountId")).append('@').append(srcBill.getString("periodId"));
            srcBillMap.computeIfAbsent(srcBillKeySb.toString(), s -> new ArrayList()).add(srcBill);
        }
        return srcBillMap;
    }

    private static Set<Long> getImportedSrcBillEntryIds(Long orgId, Set<Long> costAccountSet, String appNum) {
        HashSet<Long> voucherEntryIds = new HashSet<Long>(16);
        QFilter qf = new QFilter("org", "=", (Object)orgId);
        qf.and("costaccount", "in", costAccountSet);
        String fields = "mfgfeebillentry.voucherentry AS voucherentry";
        DynamicObjectCollection res = QueryServiceHelper.query((String)MfgfeeBillHelper.getMfgFeeEntity(appNum), (String)fields, (QFilter[])new QFilter[]{qf});
        if (CadEmptyUtils.isEmpty(res)) {
            return voucherEntryIds;
        }
        for (DynamicObject entry : res) {
            String[] srcBillEntryIdArr;
            String srcBillEntryIds = entry.getString("voucherentry");
            if (StringUtils.isEmpty((CharSequence)srcBillEntryIds)) continue;
            for (String srcBillEntryId : srcBillEntryIdArr = srcBillEntryIds.split("@")) {
                voucherEntryIds.add(Long.parseLong(srcBillEntryId));
            }
        }
        return voucherEntryIds;
    }

    private static void generateGroupBill(Map<String, DynamicObject> groupBillMap, DynamicObject bill, StringBuilder groupKey, Map<String, Integer> billCurrCountMap, Map<String, Set<String>> srcSysCombMap, Map<String, Object> paramMap) {
        String commonBillKey = MfgfeeBillHelper.getBillGroupKey(bill, groupKey);
        if (!billCurrCountMap.containsKey(commonBillKey)) {
            billCurrCountMap.put(commonBillKey, 1);
        }
        String currBillKey = commonBillKey + "@" + billCurrCountMap.get(commonBillKey);
        String srcSys = bill.getString("srcsys");
        srcSysCombMap.computeIfAbsent(currBillKey, s -> new HashSet()).add(srcSys);
        if (!groupBillMap.containsKey(currBillKey)) {
            groupBillMap.put(currBillKey, bill);
        } else {
            DynamicObjectCollection currEntryEntity;
            String currSrcBillEntryIds;
            DynamicObject needSavedBill = groupBillMap.get(currBillKey);
            DynamicObjectCollection entryEntity = needSavedBill.getDynamicObjectCollection("mfgfeebillentry");
            String srcBillEntryIds = ((DynamicObject)entryEntity.get(0)).getString("voucherentry");
            if (srcBillEntryIds.length() > 1900) {
                int currBillCount = billCurrCountMap.get(commonBillKey);
                billCurrCountMap.put(commonBillKey, currBillCount + 1);
            }
            String impSchIds = needSavedBill.getString("impschid");
            String srcBillIds = needSavedBill.getString("srcbillid");
            String srcBillNums = needSavedBill.getString("srcbillnum");
            Date srcBillBizDate = needSavedBill.getDate("bizdate");
            String srcBillBizDateStr = DateUtils.formatDate(srcBillBizDate, null);
            String currImpSchIds = bill.getString("impschid");
            String currSrcBillIds = bill.getString("srcbillid");
            String currSrcBillNums = bill.getString("srcbillnum");
            Date currSrcBillBizDate = bill.getDate("bizdate");
            String currSrcBillBizDateStr = DateUtils.formatDate(currSrcBillBizDate, null);
            if (impSchIds.indexOf(currImpSchIds) < 0) {
                impSchIds = impSchIds + "@" + currImpSchIds;
                needSavedBill.set("impschid", (Object)impSchIds);
            }
            if (srcBillIds.indexOf(currSrcBillIds) < 0) {
                srcBillIds = srcBillIds + "@" + currSrcBillIds;
                needSavedBill.set("srcbillid", (Object)srcBillIds);
            }
            if (srcBillNums.indexOf(currSrcBillNums) < 0) {
                srcBillNums = srcBillNums + "," + currSrcBillNums;
                needSavedBill.set("srcbillnum", (Object)srcBillNums);
            }
            if (srcBillEntryIds.indexOf(currSrcBillEntryIds = ((DynamicObject)(currEntryEntity = bill.getDynamicObjectCollection("mfgfeebillentry")).get(0)).getString("voucherentry")) < 0) {
                srcBillEntryIds = srcBillEntryIds + "@" + currSrcBillEntryIds;
                ((DynamicObject)entryEntity.get(0)).set("voucherentry", (Object)srcBillEntryIds);
            }
            BigDecimal totalAmout = needSavedBill.getBigDecimal("totalamount");
            BigDecimal currTotalAmout = bill.getBigDecimal("totalamount");
            needSavedBill.set("totalamount", (Object)totalAmout.add(currTotalAmout));
            if (!srcBillBizDateStr.equals(currSrcBillBizDateStr)) {
                Date currPeriodEndDate = (Date)paramMap.get(MfgfeeBillHelper.getPeriodKey(needSavedBill.getLong("period")));
                needSavedBill.set("bizdate", (Object)currPeriodEndDate);
            }
        }
    }

    private static String getBillGroupKey(DynamicObject bill, StringBuilder groupKey) {
        groupKey.setLength(0);
        char split = '@';
        Long orgId = bill.getLong("org.id");
        Long costAccountId = bill.getLong("costaccount.id");
        String period = bill.getString("period");
        String allocMold = bill.getString("allocmold");
        Long costCenterId = bill.getLong("costcenter");
        Long expenseItemId = bill.getLong("expenseitem");
        groupKey.append(orgId).append(split).append(orgId).append(split).append(costAccountId).append(split).append(period).append(split).append(allocMold).append(split).append(costCenterId).append(split).append(expenseItemId);
        DynamicObjectCollection entryentity = bill.getDynamicObjectCollection("mfgfeebillentry");
        if (entryentity != null && !entryentity.isEmpty()) {
            DynamicObject row = (DynamicObject)entryentity.get(0);
            Long elementId = row.getLong("element.id");
            Long subElementId = row.getLong("subelement.id");
            groupKey.append(split).append(elementId).append(split).append(subElementId);
        }
        return groupKey.toString();
    }

    private static Object[] toArrIds(DynamicObjectCollection idCollec) {
        int size = idCollec.size();
        Object[] ids = new Object[size];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = ((DynamicObject)idCollec.get(i)).get("id");
        }
        return ids;
    }

    private static DynamicObjectCollection getImpSchIdCollec(Long orgId, Set<Long> costAccountSet, Map<String, Object> paramMap) {
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        QFilter costAccountQF = new QFilter("costaccount", "in", costAccountSet);
        QFilter billStatusQF = new QFilter("billstatus", "=", (Object)"C");
        QFilter appNumQF = new QFilter("appnum", "=", paramMap.get("appnum"));
        Long manuorg = (Long)paramMap.get("manuorg");
        if (!CadEmptyUtils.isEmpty(manuorg)) {
            orgQF.and("manuorg", "=", (Object)manuorg);
        }
        QFilter[] mfgFeeImpSchQF = new QFilter[]{orgQF, costAccountQF, billStatusQF, appNumQF};
        return QueryServiceHelper.query((String)"sca_mfgfeeimpsch", (String)"id", (QFilter[])mfgFeeImpSchQF);
    }

    private static void addCurrency(Map<String, Object> paramMap, Set<Long> costAccountSet) {
        DynamicObjectCollection costAccountCollec = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id, calpolicy.currency AS currency", (QFilter[])new QFilter[]{new QFilter("id", "in", costAccountSet)});
        if (CadEmptyUtils.isEmpty(costAccountCollec)) {
            return;
        }
        for (DynamicObject costAccount : costAccountCollec) {
            paramMap.put("currency" + costAccount.getString("id"), costAccount.get("currency"));
        }
    }

    private static void addCurrentPeriodLastDate(Map<String, Object> paramMap, Set<Long> costAccountSet) {
        HashSet<Long> periodIdSet = new HashSet<Long>(16);
        for (Long costAccount : costAccountSet) {
            String costAccountId = ((Object)costAccount).toString();
            Long periodId = (Long)paramMap.get(costAccountId);
            periodIdSet.add(periodId);
        }
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id, enddate", (QFilter[])new QFilter[]{new QFilter("id", "in", periodIdSet)});
        periods.forEach(e -> {
            String periodKey = MfgfeeBillHelper.getPeriodKey(e.getLong("id"));
            paramMap.put(periodKey, e.getDate("enddate"));
        });
    }

    private static String getPeriodKey(Long periodId) {
        return "period@" + periodId;
    }

    private static void toMfgFeeBill(DynamicObject mfgFeeImpSch, List<DynamicObject> billList, Map<String, List<DynamicObject>> voucherMap, Map<String, Object> paramMap, Map<String, String> flexFieldMap) {
        DynamicObjectCollection entryentity = mfgFeeImpSch.getDynamicObjectCollection("entryentity");
        DynamicObject mfgFeeImpSchRow = (DynamicObject)entryentity.get(0);
        String costcentertype = mfgFeeImpSchRow.getString("costcentertype");
        String expenseitemtype = mfgFeeImpSchRow.getString("expenseitemtype");
        LinkedHashMap vAssgrpValueMap = new LinkedHashMap(16);
        for (Map.Entry<String, List<DynamicObject>> voucherEntry : voucherMap.entrySet()) {
            List<DynamicObject> vouchers = voucherEntry.getValue();
            for (DynamicObject voucher : vouchers) {
                String flexField;
                DynamicObject mfgFeeBill = BusinessDataServiceHelper.newDynamicObject((String)MfgfeeBillHelper.getMfgFeeEntity((String)paramMap.get("appnum")));
                vAssgrpValueMap.clear();
                String assgrpValue = voucher.getString("assgrpValue");
                if (!StringUtils.isEmpty((CharSequence)assgrpValue)) {
                    vAssgrpValueMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)assgrpValue, Map.class);
                }
                if (ScaMfgFeeImpSchEnum.VALUETYPE_FIXED.getValue().equals(costcentertype)) {
                    mfgFeeBill.set("costcenter", (Object)mfgFeeImpSchRow.getLong("costcenter.id"));
                } else if (ScaMfgFeeImpSchEnum.VALUETYPE_MATCH.getValue().equals(costcentertype)) {
                    flexField = flexFieldMap.get("bos_costcenter");
                    mfgFeeBill.set("costcenter", vAssgrpValueMap.get(flexField));
                }
                if (ScaMfgFeeImpSchEnum.VALUETYPE_FIXED.getValue().equals(expenseitemtype)) {
                    mfgFeeBill.set("expenseitem", (Object)mfgFeeImpSchRow.getLong("expenseitem.id"));
                } else if (ScaMfgFeeImpSchEnum.VALUETYPE_MATCH.getValue().equals(expenseitemtype)) {
                    flexField = flexFieldMap.get("er_expenseitemedit");
                    Long expenseItemId = (Long)vAssgrpValueMap.get(flexField);
                    if (CadEmptyUtils.isEmpty(expenseItemId)) continue;
                    mfgFeeBill.set("expenseitem", (Object)expenseItemId);
                }
                MfgfeeBillHelper.setEntityValue(mfgFeeBill, Collections.singletonList(voucher), mfgFeeImpSch, paramMap);
                String onlyKey = mfgFeeImpSch.getString("costaccount.id") + "@" + voucher.getString("voucherentry");
                if (MfgfeeBillHelper.isVoucherRepeat(onlyKey, paramMap)) continue;
                billList.add(mfgFeeBill);
            }
        }
    }

    private static boolean isVoucherRepeat(String onlyKey, Map<String, Object> paramMap) {
        HashSet repeatSchSet = (HashSet)paramMap.get("repeatSchSet");
        if (repeatSchSet.contains(onlyKey)) {
            return true;
        }
        repeatSchSet.add(onlyKey);
        return false;
    }

    private static void fillAllocMold(DynamicObject mfgFeeBill, Map<String, Object> paramMap) {
        String allocMold;
        if (!StringUtils.isEmpty((CharSequence)mfgFeeBill.getString("allocmold"))) {
            return;
        }
        Long costCenterId = mfgFeeBill.getLong("costcenter");
        if (CadEmptyUtils.isEmpty(costCenterId)) {
            mfgFeeBill.set("allocmold", (Object)"A");
            return;
        }
        HashMap<Long, String> costCenterDutyMap = (HashMap<Long, String>)paramMap.get("costCenterDutyMap");
        if (CadEmptyUtils.isEmpty(costCenterDutyMap)) {
            costCenterDutyMap = new HashMap<Long, String>();
            paramMap.put("costCenterDutyMap", costCenterDutyMap);
        }
        if (!StringUtils.isEmpty((CharSequence)(allocMold = (String)costCenterDutyMap.get(costCenterId)))) {
            mfgFeeBill.set("allocmold", (Object)allocMold);
            return;
        }
        DynamicObject costCenter = QueryServiceHelper.queryOne((String)"bos_costcenter", (String)"orgduty.number AS orgduty", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costCenterId)});
        String orgduty = costCenter.getString("orgduty");
        allocMold = "4".equals(orgduty) ? "C" : ("5".equals(orgduty) ? "B" : "A");
        mfgFeeBill.set("allocmold", (Object)allocMold);
        costCenterDutyMap.put(costCenterId, allocMold);
    }

    private static void setEntityValue(DynamicObject mfgFeeBill, List<DynamicObject> vouchers, DynamicObject mfgFeeImpSch, Map<String, Object> paramMap) {
        DynamicObjectCollection entryentity = mfgFeeImpSch.getDynamicObjectCollection("entryentity");
        DynamicObject mfgFeeImpSchRow = (DynamicObject)entryentity.get(0);
        MfgfeeBillHelper.fillEntity(mfgFeeBill, mfgFeeImpSch, paramMap);
        String bizdate = mfgFeeImpSchRow.getString("bizdate");
        mfgFeeBill.set("bizdate", (Object)vouchers.get(0).getDate(bizdate));
        MfgfeeBillHelper.fillEntryEntity(mfgFeeBill, vouchers, mfgFeeImpSchRow, paramMap);
    }

    private static void fillEntryEntity(DynamicObject mfgFeeBill, List<DynamicObject> vouchers, DynamicObject mfgFeeImpSchRow, Map<String, Object> paramMap) {
        mfgFeeBill.set("srcbillnum", (Object)vouchers.get(0).getString("srcbillnum"));
        mfgFeeBill.set("srcsys", vouchers.get(0).get("sourcesys"));
        mfgFeeBill.set("srcbillid", (Object)vouchers.get(0).getLong("id"));
        String appNum = (String)paramMap.get("appnum");
        DynamicObjectCollection mfgFeeBillEntry = mfgFeeBill.getDynamicObjectCollection("mfgfeebillentry");
        int seq = 1;
        for (DynamicObject voucher : vouchers) {
            DynamicObject mfgFeeBillEntryRow = mfgFeeBillEntry.addNew();
            mfgFeeBillEntryRow.set("seq", (Object)seq);
            ++seq;
            mfgFeeBillEntryRow.set("voucherentry", voucher.get("voucherentry"));
            mfgFeeBillEntryRow.set("element", mfgFeeImpSchRow.get("element"));
            mfgFeeBillEntryRow.set("subelement", mfgFeeImpSchRow.get("subelement"));
            if ("aca".equalsIgnoreCase(appNum) && !"C".equalsIgnoreCase(mfgFeeBill.getString("allocmold"))) {
                mfgFeeBillEntryRow.set("benefcostcenter", mfgFeeBill.get("costcenter"));
            }
            List<String> amoutTypeList = MfgfeeBillHelper.getAmountTypeList(mfgFeeImpSchRow);
            BigDecimal amoutValue = BigDecimal.ZERO;
            String dc = voucher.getString("dc");
            if (amoutTypeList.size() == 1) {
                if (ScaMfgFeeImpSchEnum.AMOUNT_DEBITLOCAL.getValue().equals(amoutTypeList.get(0))) {
                    if ("1".equals(dc)) {
                        amoutValue = voucher.getBigDecimal("debitlocal");
                    }
                    if ("-1".equals(dc)) {
                        amoutValue = voucher.getBigDecimal("debitlocal").multiply(new BigDecimal(-1));
                    }
                } else if (ScaMfgFeeImpSchEnum.AMOUNT_CREDITLOCAL.getValue().equals(amoutTypeList.get(0))) {
                    if ("1".equals(dc)) {
                        amoutValue = voucher.getBigDecimal("creditlocal");
                    }
                    if ("-1".equals(dc)) {
                        amoutValue = voucher.getBigDecimal("creditlocal").multiply(new BigDecimal(-1));
                    }
                }
            } else if (amoutTypeList.size() == 2) {
                if ("1".equals(dc)) {
                    amoutValue = voucher.getBigDecimal("debitlocal").subtract(voucher.getBigDecimal("creditlocal"));
                }
                if ("-1".equals(dc)) {
                    amoutValue = voucher.getBigDecimal("creditlocal").subtract(voucher.getBigDecimal("debitlocal"));
                }
            }
            mfgFeeBill.set("totalamount", (Object)amoutValue);
        }
    }

    private static List<String> getAmountTypeList(DynamicObject mfgFeeImpSchRow) {
        String amoutTypes = mfgFeeImpSchRow.getString("amount");
        String[] amoutTypeArr = amoutTypes.split(",");
        ArrayList<String> amoutTypeList = new ArrayList<String>();
        for (String amoutType : amoutTypeArr) {
            if (StringUtils.isEmpty((CharSequence)amoutType)) continue;
            amoutTypeList.add(amoutType);
        }
        return amoutTypeList;
    }

    private static void fillEntity(DynamicObject mfgFeeBill, DynamicObject mfgFeeImpSch, Map<String, Object> paramMap) {
        mfgFeeBill.set("billstatus", (Object)"A");
        mfgFeeBill.set("source", (Object)SysParamEnum.COMPTYPE_SYS.getValue());
        mfgFeeBill.set("impschid", (Object)mfgFeeImpSch.getLong("id"));
        mfgFeeBill.set("creator", (Object)RequestContext.get().getUserId());
        mfgFeeBill.set("createtime", (Object)((Date)paramMap.get("currDate")));
        mfgFeeBill.set("modifier", (Object)RequestContext.get().getUserId());
        mfgFeeBill.set("modifytime", (Object)((Date)paramMap.get("currDate")));
        mfgFeeBill.set("org", mfgFeeImpSch.get("org"));
        mfgFeeBill.set("costaccount", mfgFeeImpSch.get("costaccount"));
        mfgFeeBill.set("manuorg", mfgFeeImpSch.get("manuorg"));
        mfgFeeBill.set("period", (Object)((Long)paramMap.get(mfgFeeImpSch.getDynamicObject("costaccount").getString("id"))));
        mfgFeeBill.set("totalamount", null);
        mfgFeeBill.set("currency", (Object)((Long)paramMap.get("currency" + mfgFeeImpSch.getDynamicObject("costaccount").getString("id"))));
        MfgfeeBillHelper.fillAllocMold(mfgFeeBill, paramMap);
        String allocMold = mfgFeeBill.getString("allocmold");
        if ("C".equals(allocMold)) {
            mfgFeeBill.set("range", (Object)"A");
        }
    }

    private static Map<String, String> getFlexFieldMap() {
        return MfgfeeBillHelper.getFlexFieldMap(new String[]{"bos_costcenter", "er_expenseitemedit"});
    }

    private static Map<String, String> getFlexFieldMap(String[] entityArr) {
        DynamicObjectCollection asstactTypes = QueryServiceHelper.query((String)"bd_asstacttype", (String)"number, flexfield, valuesource.number AS valuesourceNum", (QFilter[])new QFilter[]{new QFilter("valuesource.number", "in", (Object)entityArr)});
        HashMap<String, String> asstactTypeMap = new HashMap<String, String>();
        for (DynamicObject asstactType : asstactTypes) {
            asstactTypeMap.put(asstactType.getString("valuesourceNum"), asstactType.getString("flexfield"));
        }
        return asstactTypeMap;
    }

    private static Map<String, List<DynamicObject>> getVoucher(DynamicObject mfgFeeImpSch, Map<String, Object> paramMap, Map<String, List<DynamicObject>> srcBillMap) {
        DynamicObjectCollection entryentity = mfgFeeImpSch.getDynamicObjectCollection("entryentity");
        DynamicObject mfgFeeImpSchRow = (DynamicObject)entryentity.get(0);
        Long accountViewId = mfgFeeImpSch.getLong("accountview.id");
        Long currPeriod = (Long)paramMap.get(String.valueOf(mfgFeeImpSch.getLong("costaccount.id")));
        List<DynamicObject> srcBillList = srcBillMap.get(accountViewId + "@" + currPeriod);
        if (CadEmptyUtils.isEmpty(srcBillList)) {
            return null;
        }
        List<String> amoutTypeList = MfgfeeBillHelper.getAmountTypeList(mfgFeeImpSchRow);
        HashMap<String, List<DynamicObject>> voucherMap = new HashMap<String, List<DynamicObject>>(16);
        for (DynamicObject voucher : srcBillList) {
            boolean isFromGL = mfgFeeImpSch.getBoolean("isfromgl");
            if (isFromGL && !"gl".equals(voucher.getString("srcSysNum")) || MfgfeeBillHelper.isAmountZero(voucher, amoutTypeList)) continue;
            MfgfeeBillHelper.filterAssgrp(voucher, voucherMap, mfgFeeImpSch);
        }
        return voucherMap;
    }

    private static void filterAssgrp(DynamicObject voucher, Map<String, List<DynamicObject>> voucherMap, DynamicObject mfgFeeImpSch) {
        String assgrpValue = voucher.getString("assgrpValue");
        LinkedHashMap vAssgrpValueMap = new LinkedHashMap();
        if (!StringUtils.isEmpty((CharSequence)assgrpValue)) {
            vAssgrpValueMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)assgrpValue, Map.class);
        }
        boolean isAll = false;
        String assgrp = mfgFeeImpSch.getString("assgrp");
        if (StringUtils.isEmpty((CharSequence)assgrp)) {
            isAll = true;
        } else {
            Map srcAssgrpMap = (Map)SerializationUtils.fromJsonString((String)assgrp, Map.class);
            if (CadEmptyUtils.isEmpty(srcAssgrpMap)) {
                isAll = true;
            }
        }
        if (isAll) {
            voucherMap.computeIfAbsent(voucher.getString("id"), s -> new ArrayList()).add(voucher);
        } else {
            Map assgrpMap = (Map)SerializationUtils.fromJsonString((String)assgrp, Map.class);
            if (!CadEmptyUtils.isEmpty(vAssgrpValueMap)) {
                Set assgrpNumSet = assgrpMap.keySet();
                Set vAssgrpNumSet = vAssgrpValueMap.keySet();
                if (!vAssgrpNumSet.containsAll(assgrpNumSet)) {
                    return;
                }
                for (Map.Entry assgrpEntrySet : assgrpMap.entrySet()) {
                    String vAssgrpId;
                    String assgrpNum = (String)assgrpEntrySet.getKey();
                    List assgrpIds = (List)assgrpEntrySet.getValue();
                    if (assgrpIds.contains(vAssgrpId = vAssgrpValueMap.get(assgrpNum).toString())) continue;
                    return;
                }
                voucherMap.computeIfAbsent(voucher.getString("id"), s -> new ArrayList()).add(voucher);
            }
        }
    }

    private static boolean isAmountZero(DynamicObject voucher, List<String> amoutTypeList) {
        BigDecimal amoutValue;
        if (amoutTypeList.size() == 1) {
            if (ScaMfgFeeImpSchEnum.AMOUNT_DEBITLOCAL.getValue().equals(amoutTypeList.get(0)) && BigDecimal.ZERO.compareTo(voucher.getBigDecimal("debitlocal")) == 0) {
                return true;
            }
            if (ScaMfgFeeImpSchEnum.AMOUNT_CREDITLOCAL.getValue().equals(amoutTypeList.get(0)) && BigDecimal.ZERO.compareTo(voucher.getBigDecimal("creditlocal")) == 0) {
                return true;
            }
        } else if (amoutTypeList.size() == 2 && BigDecimal.ZERO.compareTo(amoutValue = voucher.getBigDecimal("debitlocal").subtract(voucher.getBigDecimal("creditlocal"))) == 0) {
            return true;
        }
        return false;
    }

    private static String getMfgFeeEntity(String appNum) {
        if ("aca".equalsIgnoreCase(appNum)) {
            return "aca_mfgfeebill";
        }
        return "sca_mfgfeebill";
    }
}

