/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.macc.cad.common.constants.LogarithmParam;
import kd.macc.cad.common.constants.MultiLanguageConstants;
import kd.macc.cad.common.helper.LogarithmHelper;
import kd.macc.cad.common.helper.OldCollectConfigHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang.StringUtils;

public class NumDiffHelper {
    public static DataSet getNumDiff(LogarithmParam logarithmParam, String[] targetBills) {
        DataSet result;
        ArrayList<DataSet> dataSetList = new ArrayList<DataSet>(5);
        DataSet resultDataSet = null;
        if (targetBills == null || targetBills.length == 0) {
            return resultDataSet;
        }
        for (int i = 0; i < targetBills.length; ++i) {
            DataSet dataSet;
            if (CadEmptyUtils.isEmpty(targetBills[i]) || (dataSet = NumDiffHelper.getResultDataSet(targetBills[i], logarithmParam)) == null) continue;
            if (resultDataSet == null) {
                resultDataSet = dataSet;
                continue;
            }
            dataSetList.add(dataSet);
        }
        DataSet dataSet = result = resultDataSet == null || CadEmptyUtils.isEmpty(dataSetList) ? resultDataSet : resultDataSet.union(dataSetList.toArray(new DataSet[0]));
        if (result == null) {
            return null;
        }
        DataSet totalDataSet = NumDiffHelper.getTotalDataSet(result, "6");
        return result.union(totalDataSet).orderBy(new String[]{"top", "datatype", "entrybizorg", "sourcebilltype DESC"});
    }

    private static DataSet getResultDataSet(String billType, LogarithmParam logarithmParam) {
        String appNum = logarithmParam.getAppnum();
        Long orgId = logarithmParam.getOrgId();
        String algoKey = "kd.macc.cad.report.queryplugin.CollectionCheckRptQuery#getLogarithmDataSet";
        String dealQtyDisplayStr = "entryorg,entrybizorg,entrybizorgname,transactiontypeid,transactiontype,bizbillrow,sourcebilltype,targetbill,targetbillrow,case when targetbillrow=null then bizbillrow when bizbillrow=null then targetbillrow when targetbillrow>bizbillrow then targetbillrow-bizbillrow else bizbillrow-targetbillrow end numabnormal,'' as contentabnormal";
        String dealOrgStr = "case when entryorg=null then " + orgId + " else entryorg end entryorg ,entrybizorg,entrybizorgname,case when transactiontypeid = null then 0L else transactiontypeid end transactiontypeid,case when transactiontype = null then '' else transactiontype end transactiontype,case when sourcebilltype = '" + MultiLanguageConstants.getCadMftOrderLog() + "' or sourcebilltype = '" + MultiLanguageConstants.getCadMftOrderSplitLog() + "' then '" + MultiLanguageConstants.getCadMftOrder() + "' when sourcebilltype = '" + MultiLanguageConstants.getCadOmMftOrderLog() + "' or sourcebilltype = '" + MultiLanguageConstants.getCadOmMftOrderLog() + "' then '" + MultiLanguageConstants.getCadOmMftOrder() + "' else sourcebilltype end sourcebilltype,targetbill,srcbillnum,billnum";
        String dealResultStr = "entryorg,entrybizorg,entrybizorgname,transactiontypeid,transactiontype,bizbillrow,sourcebilltype,targetbill,targetbillrow,numabnormal,case when entryseq=null then '' else '" + MultiLanguageConstants.getCadIs() + "' end contentabnormal,top,0 as datatype";
        QFilter filter = null;
        if ("A".equals(billType)) {
            filter = NumDiffHelper.getCollectionQFilter("A", logarithmParam);
            DataSet costObjectSourceDataSet = LogarithmHelper.getCostObjectSource(logarithmParam, algoKey);
            DataSet bizBillRowDataSet = costObjectSourceDataSet.copy().groupBy(new String[]{"bizorg", "sourcebilltype", "transactiontype"}).sum("srcbillnum", "bizbillrow").finish();
            String unionFields = "entryorg,entrybizorg,entrybizorgname,bizbillno,entryseq,transactiontypeid,transactiontype,sourcebilltype,'A' as targetbill,bizmaterial,srcbillnum,costcenter,costobjectbillno,material,bizstatus,billnum";
            DataSet costObjectDataSet = LogarithmHelper.getCostObject(filter, algoKey);
            DataSet dataSet1 = costObjectSourceDataSet.join(costObjectDataSet, JoinType.LEFT).on("entryId", "probill").on("entryseq", "srcbillrow").select(new String[]{"bizorg as entrybizorg", "bizorgname as entrybizorgname", "bizbillno", "entryseq", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "sourcebilltype", "targetbill", "bizmaterial", "srcbillnum"}, new String[]{"org as entryorg", "costcenter", "costobjectbillno", "material", "bizstatus", "billnum"}).finish().select(unionFields);
            DataSet dataSet2 = costObjectSourceDataSet.join(costObjectDataSet, JoinType.RIGHT).on("entryId", "probill").on("entryseq", "srcbillrow").select(new String[]{"org as entryorg", "manuorg as entrybizorg", "manuorgname as entrybizorgname", "costcenter", "costobjectbillno", "material", "bizstatus", "billnum"}, new String[]{"bizbillno", "entryseq", "case when transactiontype = null then 0 else transactiontype end transactiontypeid", "case when transactiontypename = ' ' then null else transactiontypename end transactiontype", "sourcebilltype", "targetbill", "bizmaterial", "srcbillnum"}).finish().select(unionFields);
            DataSet dataSet = dataSet1.union(dataSet2).groupBy(dataSet1.getRowMeta().getFieldNames()).finish().select(dealOrgStr);
            dataSet = dataSet.groupBy(new String[]{"entryorg", "entrybizorg", "entrybizorgname", "transactiontypeid", "transactiontype", "sourcebilltype", "targetbill"}).sum("srcbillnum", "bizbillrow").sum("billnum", "targetbillrow").finish().select(dealQtyDisplayStr);
            dataSet = dataSet.join(bizBillRowDataSet, JoinType.LEFT).on("entrybizorg", "bizorg").on("sourcebilltype", "sourcebilltype").on("transactiontypeid", "transactiontype").select(new String[]{"entryorg", "entrybizorg", "entrybizorgname", "transactiontypeid", "transactiontype", "sourcebilltype", "targetbill", "targetbillrow", "numabnormal", "contentabnormal"}, new String[]{"bizbillrow"}).finish().addField("1", "top");
            DataSet logarithmDataSet = NumDiffHelper.getLogarithmDataSet(billType, null, logarithmParam);
            dataSet = dataSet.join(logarithmDataSet, JoinType.LEFT).on("entrybizorg", "bizorg").on("sourcebilltype", "sourcebilltype").on("targetbill", "targetbill").on("transactiontypeid", "transactiontype").select(dataSet.getRowMeta().getFieldNames(), new String[]{"entryseq"}).finish();
            dataSet = dataSet.select(dealResultStr);
            DataSet subTotalDataSet = NumDiffHelper.getSubTotalDataSet(dataSet, "1");
            return dataSet.union(subTotalDataSet);
        }
        if ("B".equals(billType)) {
            Set<String> ranges = OldCollectConfigHelper.getInnerSys(orgId, "cad_plannedoutputbill", appNum);
            Map<String, Map<String, Set<Long>>> collectMap = OldCollectConfigHelper.getCollectBillBizIdsMap(orgId, "cad_plannedoutputbill", appNum);
            filter = NumDiffHelper.getCollectionQFilter("B", logarithmParam);
            DataSet plannedOutputSourceDataSet = LogarithmHelper.getPlannedOutputSource(logarithmParam, algoKey);
            DataSet manuBillsSourceDataSet = plannedOutputSourceDataSet.copy().filter("srcbilltype = 'pom_mftorder'");
            DataSet pomXmftOrderLogDataSet = LogarithmHelper.getPomXmftOrderLog(NumDiffHelper.getResourceLogQFilter(logarithmParam), algoKey);
            DataSet pomXmftOrderSplitLogDataSet = LogarithmHelper.getPomMftOrderSplitLog(NumDiffHelper.getResourceSplitLogQFilter(logarithmParam), algoKey);
            manuBillsSourceDataSet = LogarithmHelper.getManuBillDataSet(manuBillsSourceDataSet, pomXmftOrderLogDataSet, pomXmftOrderSplitLogDataSet, NumDiffHelper.getNotCurrManuBillQFilter(logarithmParam), Boolean.FALSE, algoKey, collectMap);
            DataSet omManuBillsSourceDataSet = plannedOutputSourceDataSet.copy().filter("srcbilltype = 'om_mftorder'");
            DataSet omXmftOrderLogDataSet = LogarithmHelper.getOmXmftOrderLog(NumDiffHelper.getResourceLogQFilter(logarithmParam), algoKey);
            DataSet omXmftOrderSplitLogDataSet = LogarithmHelper.getOmMftOrderSplitLog(NumDiffHelper.getResourceSplitLogQFilter(logarithmParam), algoKey);
            omManuBillsSourceDataSet = LogarithmHelper.getManuBillDataSet(omManuBillsSourceDataSet, omXmftOrderLogDataSet, omXmftOrderSplitLogDataSet, NumDiffHelper.getNotCurrManuBillQFilter(logarithmParam), Boolean.TRUE, algoKey, collectMap);
            plannedOutputSourceDataSet = manuBillsSourceDataSet.union(omManuBillsSourceDataSet.select(manuBillsSourceDataSet.getRowMeta().getFieldNames())).groupBy(manuBillsSourceDataSet.getRowMeta().getFieldNames()).finish();
            DataSet plannedOutputDataSet = LogarithmHelper.getPlannedOutput(filter, algoKey);
            if ("aca".equals(appNum)) {
                ArrayList<String> srcbilltype = new ArrayList<String>(10);
                ArrayList<String> source = new ArrayList<String>(10);
                if (ranges.contains("SCGD")) {
                    srcbilltype.add(String.format("'%s'", "pom_mftorder"));
                    source.add(String.format("'%s'", "pom_mftorder"));
                    source.add(String.format("'%s'", "pom_xmftorderlog"));
                    source.add(String.format("'%s'", "pom_mftorder_splitlog"));
                }
                if (ranges.contains("WWGD")) {
                    srcbilltype.add(String.format("'%s'", "om_mftorder"));
                    source.add(String.format("'%s'", "om_mftorder"));
                    source.add(String.format("'%s'", "om_xmftorderlog"));
                    source.add(String.format("'%s'", "om_mftorder_splitog"));
                }
                if (srcbilltype.size() > 0) {
                    plannedOutputSourceDataSet = plannedOutputSourceDataSet.filter("srcbilltype in (" + StringUtils.join(srcbilltype, (String)",") + ")");
                }
                if (source.size() > 0) {
                    plannedOutputDataSet = plannedOutputDataSet.filter("sourceType in (" + StringUtils.join(source, (String)",") + ")");
                }
            }
            DataSet bizBillRowDataSet = plannedOutputSourceDataSet.copy().groupBy(new String[]{"bizorg", "sourcebilltype", "transactiontype"}).sum("srcbillnum", "bizbillrow").finish();
            String unionFields = "entryorg,entrybizorg,entrybizorgname,bizbillno,entryseq,transactiontypeid,transactiontype,bizmaterial,bizbaseunit,bizqty,bizstatus,bizclosetime,'B' as targetbill,sourcebilltype,srcbillnum,costcenter,plannedoutputbillno,material,baseunit,qty,closestatus,closetime,billnum";
            DataSet plannedOutputSourceDataSet1 = plannedOutputSourceDataSet.filter("fromlogid = 0");
            DataSet plannedOutputDataSet1 = plannedOutputDataSet.filter("fromlogid = 0");
            DataSet plannedOutputSourceDataSet2 = plannedOutputSourceDataSet.filter("fromlogid != 0");
            DataSet plannedOutputDataSet2 = plannedOutputDataSet.filter("fromlogid != 0");
            DataSet dataSet1 = plannedOutputSourceDataSet1.join(plannedOutputDataSet1, JoinType.LEFT).on("id", "sourcebill").on("entryId", "sourcebillentry").select(new String[]{"bizorg as entrybizorg", "bizorgname as entrybizorgname", "bizbillno", "entryseq", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "bizmaterial", "bizbaseunit", "bizqty", "bizstatus", "bizclosetime", "targetbill", "sourcebilltype", "srcbillnum"}, new String[]{"accountorg as entryorg", "costcenter", "plannedoutputbillno", "material", "baseunit", "qty", "closestatus", "closetime", "billnum"}).finish().select(unionFields);
            DataSet dataSet11 = plannedOutputSourceDataSet2.join(plannedOutputDataSet2, JoinType.LEFT).on("id", "sourcebill").on("entryId", "sourcebillentry").on("fromlogid", "fromlogid").select(new String[]{"bizorg as entrybizorg", "bizorgname as entrybizorgname", "bizbillno", "entryseq", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "bizmaterial", "bizbaseunit", "bizqty", "bizstatus", "bizclosetime", "targetbill", "sourcebilltype", "srcbillnum"}, new String[]{"accountorg as entryorg", "costcenter", "plannedoutputbillno", "material", "baseunit", "qty", "closestatus", "closetime", "billnum"}).finish().select(unionFields);
            DataSet dataSet2 = plannedOutputSourceDataSet1.join(plannedOutputDataSet1, JoinType.RIGHT).on("id", "sourcebill").on("entryId", "sourcebillentry").select(new String[]{"accountorg as entryorg", "manuorg as entrybizorg", "manuorgname as entrybizorgname", "costcenter", "plannedoutputbillno", "material", "baseunit", "qty", "closestatus", "closetime", "billnum"}, new String[]{"bizbillno", "entryseq", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "bizmaterial", "bizbaseunit", "bizqty", "bizstatus", "bizclosetime", "targetbill", "sourcebilltype", "srcbillnum"}).finish().select(unionFields);
            DataSet dataSet21 = plannedOutputSourceDataSet2.join(plannedOutputDataSet2, JoinType.RIGHT).on("id", "sourcebill").on("entryId", "sourcebillentry").on("fromlogid", "fromlogid").select(new String[]{"accountorg as entryorg", "manuorg as entrybizorg", "manuorgname as entrybizorgname", "costcenter", "plannedoutputbillno", "material", "baseunit", "qty", "closestatus", "closetime", "billnum"}, new String[]{"bizbillno", "entryseq", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "bizmaterial", "bizbaseunit", "bizqty", "bizstatus", "bizclosetime", "targetbill", "sourcebilltype", "srcbillnum"}).finish().select(unionFields);
            DataSet dataSet = dataSet1.union(dataSet2).union(dataSet11).union(dataSet21).groupBy(dataSet1.getRowMeta().getFieldNames()).finish().select(dealOrgStr);
            dataSet = dataSet.groupBy(new String[]{"entryorg", "entrybizorg", "entrybizorgname", "transactiontypeid", "transactiontype", "sourcebilltype", "targetbill"}).sum("srcbillnum", "bizbillrow").sum("billnum", "targetbillrow").finish().select(dealQtyDisplayStr);
            dataSet = dataSet.join(bizBillRowDataSet, JoinType.LEFT).on("entrybizorg", "bizorg").on("sourcebilltype", "sourcebilltype").on("transactiontypeid", "transactiontype").select(new String[]{"entryorg", "entrybizorg", "entrybizorgname", "transactiontypeid", "transactiontype", "sourcebilltype", "targetbill", "targetbillrow", "numabnormal", "contentabnormal"}, new String[]{"bizbillrow"}).finish().addField("2", "top");
            DataSet logarithmDataSet = NumDiffHelper.getLogarithmDataSet(billType, ranges, logarithmParam);
            dataSet = dataSet.join(logarithmDataSet, JoinType.LEFT).on("entrybizorg", "bizorg").on("sourcebilltype", "sourcebilltype").on("targetbill", "targetbill").on("transactiontypeid", "transactiontype").select(dataSet.getRowMeta().getFieldNames(), new String[]{"entryseq"}).finish();
            dataSet = dataSet.select(dealResultStr);
            DataSet subTotalDataSet = NumDiffHelper.getSubTotalDataSet(dataSet, "2");
            return dataSet.union(subTotalDataSet);
        }
        if ("C".equals(billType)) {
            Set<String> ranges = OldCollectConfigHelper.getInnerSys(orgId, "cad_factnedoutputbill", appNum);
            filter = NumDiffHelper.getCollectionQFilter("C", logarithmParam);
            DataSet factOutputSourceDataSet = LogarithmHelper.getFactoutputSource(logarithmParam, algoKey);
            DataSet factOutputDataSet = LogarithmHelper.getFactoutput(filter, algoKey, "cad_factnedoutputbill");
            ArrayList<String> srcbilltype = new ArrayList<String>(10);
            if (ranges.contains("WIPCOMPELETE")) {
                srcbilltype.add(String.format("'%s'", "im_mdc_mftmanuinbill"));
                srcbilltype.add(String.format("'%s'", "im_mdc_mftreturnbill"));
            }
            if (ranges.contains("WWGRK")) {
                srcbilltype.add(String.format("'%s'", "im_mdc_omcmplinbill"));
            }
            if (srcbilltype.size() > 0) {
                factOutputSourceDataSet = factOutputSourceDataSet.filter("srcbilltype in (" + StringUtils.join(srcbilltype, (String)",") + ")");
                factOutputDataSet = factOutputDataSet.filter("completetype in (" + StringUtils.join(srcbilltype, (String)",") + ")");
            }
            DataSet bizBillRowDataSet = factOutputSourceDataSet.copy().groupBy(new String[]{"bizorg", "sourcebilltype", "transactiontype"}).sum("srcbillnum", "bizbillrow").finish();
            String unionFields = "entryorg,entrybizorg,entrybizorgname,manubillno,bizbillno,entryseq,transactiontypeid,transactiontype,bizmaterial,bizbaseunit,bizqty,srcbilltype,'C' as targetbill,sourcebilltype,srcbillnum,costcenter,factoutputbillno,material,baseunit,completeqty,costobject,billnum";
            DataSet dataSet1 = factOutputSourceDataSet.join(factOutputDataSet, JoinType.LEFT).on("id", "sourcebill").on("entryId", "sourcebillentry").select(new String[]{"bizorg as entrybizorg", "bizorgname as entrybizorgname", "manubillno", "bizbillno", "entryseq", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "bizmaterial", "bizbaseunit", "bizqty", "srcbilltype", "targetbill", "sourcebilltype", "srcbillnum"}, new String[]{"org as entryorg", "costcenter", "factoutputbillno", "material", "baseunit", "completeqty", "costobject", "billnum"}).finish().select(unionFields);
            DataSet dataSet2 = factOutputSourceDataSet.join(factOutputDataSet, JoinType.RIGHT).on("id", "sourcebill").on("entryId", "sourcebillentry").select(new String[]{"org as entryorg", "manuorg as entrybizorg", "manuorgname as entrybizorgname", "costcenter", "factoutputbillno", "material", "baseunit", "completeqty", "costobject", "billnum"}, new String[]{"manubillno", "bizbillno", "entryseq", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "bizmaterial", "bizbaseunit", "bizqty", "srcbilltype", "targetbill", "sourcebilltype", "srcbillnum"}).finish().select(unionFields);
            DataSet dataSet = dataSet1.union(dataSet2).groupBy(dataSet1.getRowMeta().getFieldNames()).finish().select(dealOrgStr);
            dataSet = dataSet.groupBy(new String[]{"entryorg", "entrybizorg", "entrybizorgname", "transactiontypeid", "transactiontype", "sourcebilltype", "targetbill"}).sum("srcbillnum", "bizbillrow").sum("billnum", "targetbillrow").finish().select(dealQtyDisplayStr);
            dataSet = dataSet.join(bizBillRowDataSet, JoinType.LEFT).on("entrybizorg", "bizorg").on("sourcebilltype", "sourcebilltype").on("transactiontypeid", "transactiontype").select(new String[]{"entryorg", "entrybizorg", "entrybizorgname", "transactiontypeid", "transactiontype", "sourcebilltype", "targetbill", "targetbillrow", "numabnormal", "contentabnormal"}, new String[]{"bizbillrow"}).finish().addField("5", "top");
            DataSet logarithmDataSet = NumDiffHelper.getLogarithmDataSet(billType, ranges, logarithmParam);
            dataSet = dataSet.join(logarithmDataSet, JoinType.LEFT).on("entrybizorg", "bizorg").on("sourcebilltype", "sourcebilltype").on("targetbill", "targetbill").on("transactiontypeid", "transactiontype").select(dataSet.getRowMeta().getFieldNames(), new String[]{"entryseq"}).finish();
            dataSet = dataSet.select(dealResultStr);
            DataSet subTotalDataSet = NumDiffHelper.getSubTotalDataSet(dataSet, "5");
            return dataSet.union(subTotalDataSet);
        }
        if ("D".equals(billType)) {
            Set<String> ranges = OldCollectConfigHelper.getInnerSys(orgId, "sca_resourceuse", appNum);
            filter = NumDiffHelper.getCollectionQFilter("D", logarithmParam);
            DataSet resourceUseSourceDataSet = LogarithmHelper.getResourceUseSource(logarithmParam, algoKey).addField("bizbillno+'-'+cast(seq as String)+'-'+cast(subseq as String)", "selectKey");
            DataSet resourceUseDataSet = LogarithmHelper.getResourceUse(filter, algoKey, "sca_resourceuse");
            ArrayList<String> srcbilltype = new ArrayList<String>(10);
            ArrayList<String> sourcebilltype = new ArrayList<String>(10);
            if (ranges.contains("PROCESSREPORT")) {
                srcbilltype.add(String.format("'%s'", "sfc_processreportbill"));
                sourcebilltype.add(String.format("'%s'", MultiLanguageConstants.getCadProcessReportBill()));
            }
            if (ranges.contains("PROCESSADJUST")) {
                srcbilltype.add(String.format("'%s'", "sfc_reportresource_adjust"));
                sourcebilltype.add(String.format("'%s'", MultiLanguageConstants.getCadReportResourceAdjust()));
            }
            if (ranges.contains("MFTORDERREPORT")) {
                srcbilltype.add(String.format("'%s'", "pom_mftorderreport"));
                sourcebilltype.add(String.format("'%s'", MultiLanguageConstants.getCadMftOrderReport()));
            }
            if (ranges.contains("WGXHB")) {
                srcbilltype.add(String.format("'%s'", "om_processreport"));
                sourcebilltype.add(String.format("'%s'", MultiLanguageConstants.getCadProcessReport()));
            }
            if (srcbilltype.size() > 0) {
                resourceUseSourceDataSet = resourceUseSourceDataSet.filter("srcbilltype in (" + StringUtils.join(srcbilltype, (String)",") + ")");
            }
            if (sourcebilltype.size() > 0) {
                resourceUseDataSet = resourceUseDataSet.filter("sourcebilltype in (" + StringUtils.join(sourcebilltype, (String)",") + ")");
            }
            DataSet bizBillRowDataSet = resourceUseSourceDataSet.copy().groupBy(new String[]{"bizorg", "sourcebilltype", "transactiontype"}).sum("srcbillnum", "bizbillrow").finish();
            String unionFields = "entryorg,entrybizorg,entrybizorgname,manubillno,bizbillno,subseq,bizmaterial,oprunit,completqty,srcbilltype,entryresource,subentryunit,subentrysumqty,'D' as targetbill,sourcebilltype,transactiontypeid,transactiontype,srcbillnum,costcenter,resourceusebillno,material,resource,workhour,facthour,factuse,factbatch,costobject,billnum";
            DataSet dataSet1 = resourceUseSourceDataSet.join(resourceUseDataSet, JoinType.LEFT).on("id", "srcbillid").on("selectKey", "resourceusebillno").select(new String[]{"bizorg as entrybizorg", "bizorgname as entrybizorgname", "manubillno", "bizbillno", "subseq", "bizmaterial", "oprunit", "completqty", "srcbilltype", "entryresource", "subentryunit", "subentrysumqty", "targetbill", "sourcebilltype", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "srcbillnum"}, new String[]{"case when org = null then " + orgId + " else org end entryorg", "costcenter", "resourceusebillno", "material", "resource", "workhour", "facthour", "factuse", "factbatch", "costobject", "billnum"}).finish().select(unionFields);
            DataSet dataSet2 = resourceUseSourceDataSet.join(resourceUseDataSet, JoinType.RIGHT).on("id", "srcbillid").on("selectKey", "resourceusebillno").select(new String[]{"org as entryorg", "manuorg as entrybizorg", "manuorgname as entrybizorgname", "costcenter", "resourceusebillno", "material", "resource", "workhour", "facthour", "factuse", "factbatch", "costobject", "billnum"}, new String[]{"manubillno", "bizbillno", "subseq", "bizmaterial", "oprunit", "completqty", "srcbilltype", "entryresource", "subentryunit", "subentrysumqty", "sourcebilltype", "targetbill", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "srcbillnum"}).finish().select(unionFields);
            DataSet dataSet = dataSet1.union(dataSet2).groupBy(dataSet1.getRowMeta().getFieldNames()).finish().select(dealOrgStr);
            dataSet = dataSet.groupBy(new String[]{"entryorg", "entrybizorg", "entrybizorgname", "transactiontypeid", "transactiontype", "sourcebilltype", "targetbill"}).sum("srcbillnum", "bizbillrow").sum("billnum", "targetbillrow").finish().select(dealQtyDisplayStr);
            dataSet = dataSet.join(bizBillRowDataSet, JoinType.LEFT).on("entrybizorg", "bizorg").on("sourcebilltype", "sourcebilltype").on("transactiontypeid", "transactiontype").select(new String[]{"entryorg", "entrybizorg", "entrybizorgname", "transactiontypeid", "transactiontype", "sourcebilltype", "targetbill", "targetbillrow", "numabnormal", "contentabnormal"}, new String[]{"bizbillrow"}).finish().addField("4", "top");
            DataSet logarithmDataSet = NumDiffHelper.getLogarithmDataSet(billType, ranges, logarithmParam);
            dataSet = dataSet.join(logarithmDataSet, JoinType.LEFT).on("entrybizorg", "bizorg").on("sourcebilltype", "sourcebilltype").on("targetbill", "targetbill").on("transactiontypeid", "transactiontype").select(dataSet.getRowMeta().getFieldNames(), new String[]{"entryseq"}).finish();
            dataSet = dataSet.select(dealResultStr);
            DataSet subTotalDataSet = NumDiffHelper.getSubTotalDataSet(dataSet, "4");
            return dataSet.union(subTotalDataSet);
        }
        String entity = "sca_matusecollect";
        if ("ACA".equalsIgnoreCase(appNum)) {
            entity = "aca_matusecollect";
        }
        Set<String> ranges = OldCollectConfigHelper.getInnerSys(orgId, entity, appNum);
        filter = NumDiffHelper.getCollectionQFilter("E", logarithmParam);
        DataSet matUseCollectSourceDataSet = LogarithmHelper.getMatUseCollectSource(logarithmParam, algoKey);
        DataSet matUseCollectDataSet = LogarithmHelper.getMatUseCollect(filter, algoKey, entity);
        ArrayList<String> srcbilltype = new ArrayList<String>(10);
        if (ranges.contains("PRO_GET")) {
            srcbilltype.add(String.format("'%s'", "im_mdc_mftproorder"));
            srcbilltype.add(String.format("'%s'", "im_mdc_mftreturnorder"));
            srcbilltype.add(String.format("'%s'", "im_mdc_mftfeedorder"));
        }
        if (ranges.contains("GET_OUTSTORAGE")) {
            srcbilltype.add(String.format("'%s'", "im_materialreqoutbill"));
        }
        if (ranges.contains("WLL")) {
            srcbilltype.add(String.format("'%s'", "im_mdc_omoutbill"));
            srcbilltype.add(String.format("'%s'", "im_mdc_omreturnbill"));
            srcbilltype.add(String.format("'%s'", "im_mdc_omfeedbill"));
        }
        if (srcbilltype.size() > 0) {
            matUseCollectSourceDataSet = matUseCollectSourceDataSet.filter("srcbilltype in (" + StringUtils.join(srcbilltype, (String)",") + ")");
            matUseCollectDataSet = matUseCollectDataSet.filter("srcbill in (" + StringUtils.join(srcbilltype, (String)",") + ")");
        }
        DataSet bizBillRowDataSet = matUseCollectSourceDataSet.copy().groupBy(new String[]{"bizorg", "sourcebilltype", "transactiontype"}).sum("srcbillnum", "bizbillrow").finish();
        String unionFields = "entryorg,entrybizorg,entrybizorgname,manubillno,bizbillno,entryseq,transactiontypeid,transactiontype,bizmaterial,bizbaseunit,bizqty,srcbilltype,'E' as targetbill,sourcebilltype,srcbillnum,costcenter,matcollectbillno,material,unit,qty,appnum,billnum";
        DataSet dataSet1 = matUseCollectSourceDataSet.join(matUseCollectDataSet, JoinType.LEFT).on("id", "sourcebillid").on("entryId", "sourceEntryId").select(new String[]{"bizorg as entrybizorg", "bizorgname as entrybizorgname", "manubillno", "bizbillno", "entryseq", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "bizmaterial", "bizbaseunit", "bizqty", "srcbilltype", "targetbill", "sourcebilltype", "srcbillnum"}, new String[]{"org as entryorg", "costcenter", "matcollectbillno", "material", "unit", "qty", "appnum", "billnum"}).finish().select(unionFields);
        DataSet dataSet2 = matUseCollectSourceDataSet.join(matUseCollectDataSet, JoinType.RIGHT).on("id", "sourcebillid").on("entryId", "sourceEntryId").select(new String[]{"org as entryorg", "manuorg as entrybizorg", "manuorgname as entrybizorgname", "costcenter", "matcollectbillno", "material", "unit", "qty", "appnum", "billnum"}, new String[]{"manubillno", "bizbillno", "entryseq", "transactiontype as transactiontypeid", "transactiontypename as transactiontype", "bizmaterial", "bizbaseunit", "bizqty", "srcbilltype", "targetbill", "sourcebilltype", "srcbillnum"}).finish().select(unionFields);
        DataSet dataSet = dataSet1.union(dataSet2).groupBy(dataSet1.getRowMeta().getFieldNames()).finish().select(dealOrgStr);
        dataSet = dataSet.groupBy(new String[]{"entryorg", "entrybizorg", "entrybizorgname", "transactiontypeid", "transactiontype", "sourcebilltype", "targetbill"}).sum("srcbillnum", "bizbillrow").sum("billnum", "targetbillrow").finish().select(dealQtyDisplayStr);
        dataSet = dataSet.join(bizBillRowDataSet, JoinType.LEFT).on("entrybizorg", "bizorg").on("sourcebilltype", "sourcebilltype").on("transactiontypeid", "transactiontype").select(new String[]{"entryorg", "entrybizorg", "entrybizorgname", "transactiontypeid", "transactiontype", "sourcebilltype", "targetbill", "targetbillrow", "numabnormal", "contentabnormal"}, new String[]{"bizbillrow"}).finish().addField("3", "top");
        DataSet logarithmDataSet = NumDiffHelper.getLogarithmDataSet(billType, ranges, logarithmParam);
        dataSet = dataSet.join(logarithmDataSet, JoinType.LEFT).on("entrybizorg", "bizorg").on("sourcebilltype", "sourcebilltype").on("targetbill", "targetbill").on("transactiontypeid", "transactiontype").select(dataSet.getRowMeta().getFieldNames(), new String[]{"entryseq"}).finish();
        dataSet = dataSet.select(dealResultStr);
        DataSet subTotalDataSet = NumDiffHelper.getSubTotalDataSet(dataSet, "3");
        return dataSet.union(subTotalDataSet);
    }

    private static DataSet getLogarithmDataSet(String billType, Set<String> ranges, LogarithmParam logarithmParam) {
        String algoKey = "kd.macc.cad.report.queryplugin.CollectionCheckRptQuery#getLogarithmDataSet";
        String selectFields = "bizorg,sourcebilltype,targetbill,transactiontype";
        QFilter filter = null;
        if ("A".equals(billType)) {
            filter = NumDiffHelper.getCollectionQFilter("A", logarithmParam);
            DataSet costObjectDataSet = LogarithmHelper.getLogarithmInfo(logarithmParam, filter, algoKey, "cad_costobject", ranges);
            return costObjectDataSet.groupBy(selectFields.split(",")).sum("entryseq").finish();
        }
        if ("B".equals(billType)) {
            filter = NumDiffHelper.getCollectionQFilter("B", logarithmParam);
            DataSet planOutDataSet = LogarithmHelper.getLogarithmInfo(logarithmParam, filter, algoKey, "cad_plannedoutputbill", ranges);
            return planOutDataSet.groupBy(selectFields.split(",")).sum("entryseq").finish();
        }
        if ("C".equals(billType)) {
            filter = NumDiffHelper.getCollectionQFilter("C", logarithmParam);
            DataSet factOutDataSet = LogarithmHelper.getLogarithmInfo(logarithmParam, filter, algoKey, "cad_factnedoutputbill", ranges);
            return factOutDataSet.groupBy(selectFields.split(",")).sum("entryseq").finish();
        }
        if ("D".equals(billType)) {
            filter = NumDiffHelper.getCollectionQFilter("D", logarithmParam);
            DataSet resourceUseDataSet = LogarithmHelper.getLogarithmInfo(logarithmParam, filter, algoKey, "sca_resourceuse", ranges);
            return resourceUseDataSet.groupBy(selectFields.split(",")).sum("subseq", "entryseq").finish();
        }
        filter = NumDiffHelper.getCollectionQFilter("E", logarithmParam);
        DataSet matUseDataSet = LogarithmHelper.getLogarithmInfo(logarithmParam, filter, algoKey, "sca_matusecollect", ranges);
        return matUseDataSet.groupBy(selectFields.split(",")).sum("entryseq").finish();
    }

    private static QFilter getCollectionQFilter(String billType, LogarithmParam logarithmParam) {
        QFilter filter = null;
        Long orgId = logarithmParam.getOrgId();
        List<Long> bizorgIds = logarithmParam.getBizorgIds();
        Date startDate = logarithmParam.getStartDate();
        Date endDate = logarithmParam.getEndDate();
        String appNum = logarithmParam.getAppnum();
        switch (billType) {
            case "A": {
                filter = new QFilter("org", "=", (Object)orgId);
                filter.and(new QFilter("sotype", "=", (Object)"PB"));
                filter.and(new QFilter("billstatus", "=", (Object)"C"));
                filter.and(new QFilter("manuorg", "in", bizorgIds));
                filter.and(new QFilter("bookdate", ">=", (Object)startDate));
                filter.and(new QFilter("bookdate", "<", (Object)endDate));
                break;
            }
            case "B": {
                filter = new QFilter("accountorg", "=", (Object)orgId);
                filter.and(new QFilter("srcbilltype", "in", (Object)new String[]{"pom_mftorder", "pom_xmftorderlog", "pom_mftorder_splitlog", "om_mftorder", "om_xmftorderlog", "om_mftorder_splitog"}));
                filter.and(new QFilter("billstatus", "=", (Object)"C"));
                filter.and(new QFilter("manuorg", "in", bizorgIds));
                filter.and(new QFilter("bizdate", ">=", (Object)startDate));
                filter.and(new QFilter("bizdate", "<", (Object)endDate));
                filter.and(new QFilter("appnum", "=", (Object)appNum));
                break;
            }
            case "C": {
                filter = new QFilter("org", "=", (Object)orgId);
                filter.and(new QFilter("completetype", "in", (Object)new String[]{"WIPCOMPELETE", "WIPCOMPELETEBACK", "WWGRK", "CONFIG"}));
                filter.and(new QFilter("billstatus", "=", (Object)"C"));
                filter.and(new QFilter("manuorg", "in", bizorgIds));
                filter.and(new QFilter("bookdate", ">=", (Object)startDate));
                filter.and(new QFilter("bookdate", "<", (Object)endDate));
                filter.and(new QFilter("appnum", "=", (Object)appNum));
                break;
            }
            case "D": {
                filter = new QFilter("org", "=", (Object)orgId);
                filter.and(new QFilter("source", "in", (Object)new String[]{"OBJECTRULE", "CONFIG"}));
                filter.and(new QFilter("billstatus", "=", (Object)"C"));
                filter.and(new QFilter("manuorg", "in", bizorgIds));
                filter.and(new QFilter("bookdate", ">=", (Object)startDate));
                filter.and(new QFilter("bookdate", "<", (Object)endDate));
                filter.and(new QFilter("appnum", "=", (Object)appNum));
                break;
            }
            case "E": {
                filter = new QFilter("org", "=", (Object)orgId);
                filter.and(new QFilter("srcbilltype", "in", (Object)new String[]{"im_materialreqoutbill", "im_mdc_mftproorder", "im_mdc_mftreturnorder", "im_mdc_mftfeedorder", "im_mdc_omoutbill", "im_mdc_omreturnbill", "im_mdc_omfeedbill"}));
                filter.and(new QFilter("billstatus", "=", (Object)"C"));
                filter.and(new QFilter("manuorg", "in", bizorgIds));
                filter.and(new QFilter("bookdate", ">=", (Object)startDate));
                filter.and(new QFilter("bookdate", "<", (Object)endDate));
                filter.and(new QFilter("appnum", "=", (Object)appNum));
            }
        }
        return filter;
    }

    private static QFilter getResourceLogQFilter(LogarithmParam logarithmParam) {
        QFilter filter = new QFilter("changestatus", "=", (Object)"B");
        filter.and(new QFilter("biztime", ">=", (Object)logarithmParam.getStartDate()));
        filter.and(new QFilter("biztime", "<", (Object)logarithmParam.getEndDate()));
        return filter;
    }

    private static QFilter getResourceSplitLogQFilter(LogarithmParam logarithmParam) {
        QFilter filter = new QFilter("orderstatus", "=", (Object)"C");
        filter.and(new QFilter("createtime", ">=", (Object)logarithmParam.getStartDate()));
        filter.and(new QFilter("createtime", "<", (Object)logarithmParam.getEndDate()));
        return filter;
    }

    private static QFilter getNotCurrManuBillQFilter(LogarithmParam logarithmParam) {
        QFilter filter = new QFilter("org", "in", logarithmParam.getBizorgIds());
        filter.and(new QFilter("treeentryentity.taskstatus", "!=", (Object)"A"));
        if ("sca".equals(logarithmParam.getAppnum())) {
            filter.and(new QFilter("treeentryentity.producttype", "=", (Object)"C"));
        }
        return filter;
    }

    private static DataSet getSubTotalDataSet(DataSet resultDataSet, String dataType) {
        String sum = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"NumDiffHelper_0", (String)"macc-cad-common", (Object[])new Object[0]);
        DataSet dataSet = resultDataSet.copy();
        return dataSet.groupBy(new String[]{"entryorg", "targetbill"}).sum("bizbillrow").sum("targetbillrow").sum("numabnormal").finish().select("0 AS entryorg,0 AS entrybizorg,'" + sum + "' AS entrybizorgname,0 AS transactiontypeid,'' AS transactiontype,bizbillrow,'' AS sourcebilltype,targetbill,targetbillrow,numabnormal,'' AS contentabnormal," + dataType + " AS top," + Long.valueOf(dataType) + " AS datatype");
    }

    private static DataSet getTotalDataSet(DataSet resultDataSet, String dataType) {
        String sum = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"NumDiffHelper_0", (String)"macc-cad-common", (Object[])new Object[0]);
        String total = ResManager.loadKDString((String)"\u603b\u8ba1", (String)"NumDiffHelper_1", (String)"macc-cad-common", (Object[])new Object[0]);
        DataSet dataSet = resultDataSet.copy().filter("entrybizorgname='" + sum + "'");
        return dataSet.groupBy(new String[]{"entryorg"}).sum("bizbillrow").sum("targetbillrow").sum("numabnormal").finish().select("0 AS entryorg,0 AS entrybizorg,'" + total + "' AS entrybizorgname,0 AS transactiontypeid,'' AS transactiontype,bizbillrow,'' AS sourcebilltype,'' AS targetbill,targetbillrow,numabnormal,'' AS contentabnormal," + dataType + " AS top," + Long.valueOf(dataType) + " AS datatype");
    }
}

