/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class OldCollectConfigHelper {
    public static Map<String, List<Long>> getBillRangeMap(Long accountOrg, List<Long> costCenters, String targetEntity, String appNum, CollectReport collectReport) {
        Map<String, List<Long>> billRangeMap = new HashMap<String, List<Long>>(16);
        if (CadEmptyUtils.isEmpty(targetEntity)) {
            return billRangeMap;
        }
        switch (targetEntity) {
            case "cad_plannedoutputbill": {
                if ("aca".equals(appNum)) {
                    billRangeMap = ImportServiceHelper.getInnerSys(accountOrg, costCenters, "plancollectrange", appNum, collectReport);
                    break;
                }
                billRangeMap.put("norange", new ArrayList());
                break;
            }
            case "cad_factnedoutputbill": {
                billRangeMap = ImportServiceHelper.getInnerSys(accountOrg, costCenters, "billrange", appNum, collectReport);
                break;
            }
            case "sca_matusecollect": 
            case "aca_matusecollect": {
                billRangeMap = ImportServiceHelper.getInnerSys(accountOrg, costCenters, "matcollectrange", appNum, collectReport);
                break;
            }
            case "sca_resourceuse": {
                billRangeMap = ImportServiceHelper.getInnerSys(accountOrg, costCenters, "resourcerange", appNum, collectReport);
                break;
            }
            default: {
                billRangeMap.put("norange", new ArrayList());
            }
        }
        return billRangeMap;
    }

    public static Map<String, Map<String, Set<Long>>> getCollectBillBizIdsMap(Long org, String collectionBillType, String appNum) {
        String selectFields = "bizsettingentry.sourcebill sourcebill,bizsettingentry.transactiontype.fbasedataid.id transactiontype,bizsettingentry.biztype.fbasedataid.id biztype,bizsettingentry.invscheme.fbasedataid.id invscheme";
        HashMap<String, Map<String, Set<Long>>> resultMap = new HashMap<String, Map<String, Set<Long>>>(16);
        QFilter filter = new QFilter("org", "=", (Object)org);
        filter.and("bizsettingentry.collectionbill", "=", (Object)collectionBillType);
        filter.and("appnum", "=", (Object)appNum);
        DataSet ccSetting = QueryServiceHelper.queryDataSet((String)"getCollectBillBizIdsMap", (String)"cad_costcollectionsetting", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
        if (ccSetting == null) {
            return resultMap;
        }
        while (ccSetting.hasNext()) {
            Row row = ccSetting.next();
            String sourcebill = row.getString("sourcebill");
            if (resultMap.containsKey(sourcebill)) {
                Long transactiontype = row.getLong("transactiontype");
                Long biztype = row.getLong("biztype");
                Long invscheme = row.getLong("invscheme");
                if (transactiontype != 0L) {
                    ((Set)((Map)resultMap.get(sourcebill)).get("transactiontype")).add(transactiontype);
                }
                if (biztype != 0L) {
                    ((Set)((Map)resultMap.get(sourcebill)).get("biztype")).add(biztype);
                }
                if (invscheme == 0L) continue;
                ((Set)((Map)resultMap.get(sourcebill)).get("invscheme")).add(invscheme);
                continue;
            }
            HashMap entryMap = new HashMap(16);
            Long transactiontype = row.getLong("transactiontype");
            Long biztype = row.getLong("biztype");
            Long invscheme = row.getLong("invscheme");
            HashSet<Long> transactiontypeSet = new HashSet<Long>(16);
            HashSet<Long> biztypeSet = new HashSet<Long>(16);
            HashSet<Long> invschemeSet = new HashSet<Long>(16);
            if (transactiontype != 0L) {
                transactiontypeSet.add(transactiontype);
            }
            if (biztype != 0L) {
                biztypeSet.add(biztype);
            }
            if (invscheme != 0L) {
                invschemeSet.add(invscheme);
            }
            entryMap.put("transactiontype", transactiontypeSet);
            entryMap.put("biztype", biztypeSet);
            entryMap.put("invscheme", invschemeSet);
            resultMap.put(sourcebill, entryMap);
        }
        return resultMap;
    }

    public static Set<String> getInnerSys(Long org, String billType, String appNum) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter orgQf = new QFilter("accountorg", "=", (Object)org);
        if (!CadEmptyUtils.isEmpty(org)) {
            filters.add(orgQf);
        }
        filters.add(new QFilter("appnum", "=", (Object)appNum));
        String field = "";
        switch (billType) {
            case "cad_plannedoutputbill": {
                filters.add(new QFilter("plancollecttype", "=", (Object)"OBJECTRULE"));
                field = "plancollectrange";
                break;
            }
            case "cad_factnedoutputbill": {
                filters.add(new QFilter("completetype", "=", (Object)"OBJECTRULE"));
                field = "billrange";
                break;
            }
            case "sca_resourceuse": {
                filters.add(new QFilter("resourceusetype", "=", (Object)"OBJECTRULE"));
                field = "resourcerange";
                break;
            }
            case "sca_matusecollect": 
            case "aca_matusecollect": {
                filters.add(new QFilter("matcollectway", "=", (Object)"INNERSYSIMPORT"));
                field = "matcollectrange";
                break;
            }
        }
        DynamicObjectCollection sysParam = QueryServiceHelper.query((String)"cad_sysparam", (String)field, (QFilter[])filters.toArray(new QFilter[0]));
        HashSet<String> rangeSets = new HashSet<String>(16);
        for (DynamicObject dy : sysParam) {
            String[] ranges = dy.getString(field).split(",");
            rangeSets.addAll(Arrays.asList(ranges));
        }
        return rangeSets;
    }
}

