/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.field.ComboItem;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class OrgHelper {
    private static Map<Long, Boolean> orgEnableMultiFactoryMap = new HashMap<Long, Boolean>(200);

    public static List<ComboItem> getOrgComboItems(String entityId, String appNum) {
        List<Long> permCalOrgIds = OrgHelper.getCurrAccountOrg(entityId, appNum);
        QFilter filter = new QFilter("id", "in", permCalOrgIds);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{filter}, (String)"number asc");
        if (CollectionUtils.isEmpty((Collection)cols)) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ComboItem firstItem = null;
        int i = 0;
        for (DynamicObject acctOrg : cols) {
            String acctOrgId = acctOrg.getString("id");
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(acctOrg.getString("name")));
            item.setValue(acctOrgId);
            if (i == 0) {
                firstItem = item;
            }
            if (acctItems.contains(item)) continue;
            acctItems.add(item);
            String loginOrgId = String.valueOf(RequestContext.get().getOrgId());
            if (acctOrgId.equals(loginOrgId)) {
                acctItems.set(0, item);
                acctItems.set(i, firstItem);
            }
            ++i;
        }
        return acctItems;
    }

    @Deprecated
    public static List<ComboItem> getOrgComboItems(String entityId) {
        List<Long> permCalOrgIds = OrgHelper.getCurrAccountOrg(entityId);
        QFilter filter = new QFilter("id", "in", permCalOrgIds);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{filter}, (String)"number asc");
        if (CollectionUtils.isEmpty((Collection)cols)) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ComboItem firstItem = null;
        int i = 0;
        for (DynamicObject acctOrg : cols) {
            String acctOrgId = acctOrg.getString("id");
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(acctOrg.getString("name")));
            item.setValue(acctOrgId);
            if (i == 0) {
                firstItem = item;
            }
            if (acctItems.contains(item)) continue;
            acctItems.add(item);
            String loginOrgId = String.valueOf(RequestContext.get().getOrgId());
            if (acctOrgId.equals(loginOrgId)) {
                acctItems.set(0, item);
                acctItems.set(i, firstItem);
            }
            ++i;
        }
        return acctItems;
    }

    public static List<ComboItem> getAccountOrg(String entityId, String appNum) {
        ArrayList<ComboItem> orgItems = new ArrayList<ComboItem>();
        List<Long> orgIds = OrgHelper.getCurrAccountOrg(entityId, appNum);
        QFilter qfId = new QFilter("id", "in", orgIds);
        DynamicObjectCollection org = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{qfId}, (String)"number asc");
        for (DynamicObject acctOrg : org) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(acctOrg.getString("name")));
            item.setValue(acctOrg.getString("id"));
            if (orgItems.contains(item)) continue;
            orgItems.add(item);
        }
        return orgItems;
    }

    @Deprecated
    public static List<ComboItem> getAccountOrg(String entityId) {
        ArrayList<ComboItem> orgItems = new ArrayList<ComboItem>();
        List<Long> orgIds = OrgHelper.getCurrAccountOrg(entityId);
        QFilter qfId = new QFilter("id", "in", orgIds);
        DynamicObjectCollection org = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{qfId}, (String)"number asc");
        for (DynamicObject acctOrg : org) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(acctOrg.getString("name")));
            item.setValue(acctOrg.getString("id"));
            if (orgItems.contains(item)) continue;
            orgItems.add(item);
        }
        return orgItems;
    }

    public static List<Long> getCurrAccountOrg(String entityId, String appNum) {
        List hasPermOrgIds = Lists.newArrayListWithCapacity((int)16);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (CadEmptyUtils.isEmpty(appNum)) {
            appNum = "sca";
        }
        String appInnerId = AppMetadataCache.getAppInfo((String)appNum).getId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appInnerId, (String)entityId, (String)"47150e89000000ac");
        boolean hasAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
        List allOrgIds = hasPermOrgResult.getHasPermOrgs();
        if (hasAllOrgPerm) {
            hasPermOrgIds = OrgUnitServiceHelper.getAllOrg((String)"10");
        } else if (!CadEmptyUtils.isEmpty(allOrgIds)) {
            hasPermOrgIds = OrgUnitServiceHelper.filterOrgDuty((List)allOrgIds, (String)"10");
        }
        return hasPermOrgIds;
    }

    @Deprecated
    public static List<Long> getCurrAccountOrg(String entityId) {
        List hasPermOrgIds = Lists.newArrayListWithCapacity((int)16);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String appInnerId = AppMetadataCache.getAppInfo((String)"cal").getId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appInnerId, (String)entityId, (String)"47150e89000000ac");
        boolean hasAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
        List allOrgIds = hasPermOrgResult.getHasPermOrgs();
        if (hasAllOrgPerm) {
            hasPermOrgIds = OrgUnitServiceHelper.getAllOrg((String)"10");
        } else if (!CadEmptyUtils.isEmpty(allOrgIds)) {
            hasPermOrgIds = OrgUnitServiceHelper.filterOrgDuty((List)allOrgIds, (String)"10");
        }
        return hasPermOrgIds;
    }

    public static List<ComboItem> getCostCenterByAccoutOrg(String orgId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!StringUtils.isEmpty((String)orgId)) {
            filters.add(new QFilter("accountorg", "=", (Object)Long.valueOf(orgId)));
        }
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        Object[] costCenter = BusinessDataServiceHelper.load((String)"bos_costcenter", (String)"id,name", (QFilter[])filters.toArray(new QFilter[0]), (String)"number asc");
        if (CadEmptyUtils.isEmpty(costCenter)) {
            return null;
        }
        ArrayList<ComboItem> centerItems = new ArrayList<ComboItem>();
        for (Object center : costCenter) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(center.getString("name")));
            item.setValue(center.getString("id"));
            if (centerItems.contains(item)) continue;
            centerItems.add(item);
        }
        return centerItems;
    }

    public static List<ComboItem> getCostCenterGroup(Long orgId, List<Long> manuOrgIds) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!CadEmptyUtils.isEmpty(orgId)) {
            filters.add(new QFilter("org", "=", (Object)orgId));
        }
        if (!CadEmptyUtils.isEmpty(manuOrgIds)) {
            QFilter manuOrgFilter = new QFilter("manuorg", "in", manuOrgIds);
            filters.add(manuOrgFilter);
        }
        Date date = new Date();
        QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
        dateFilter.and("expdate", ">", (Object)date);
        filters.add(dateFilter);
        Object[] costCenterGroup = BusinessDataServiceHelper.load((String)"cad_costcentergroup", (String)"id,name", (QFilter[])filters.toArray(new QFilter[0]), (String)"number asc");
        if (CadEmptyUtils.isEmpty(costCenterGroup)) {
            return null;
        }
        ArrayList<ComboItem> centerGroupItems = new ArrayList<ComboItem>();
        for (Object centerGroup : costCenterGroup) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(centerGroup.getString("name")));
            item.setValue(centerGroup.getString("id"));
            if (centerGroupItems.contains(item)) continue;
            centerGroupItems.add(item);
        }
        return centerGroupItems;
    }

    public static List<ComboItem> getCostCenter(Long orgId, List<Long> manuOrgIds, List<Long> costCenterGroupIds, String appId, String entityId) {
        Object[] costCenter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!CadEmptyUtils.isEmpty(orgId)) {
            filters.add(new QFilter("accountorg", "=", (Object)orgId));
        }
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        if (!CadEmptyUtils.isEmpty(manuOrgIds)) {
            QFilter costCenterIdFilter = CostCenterHelper.getCostCenterByMultFactoryForList(orgId, manuOrgIds, appId, entityId);
            filters.add(costCenterIdFilter);
        }
        if (!CadEmptyUtils.isEmpty(costCenterGroupIds)) {
            QFilter costGroupFilter = new QFilter("id", "in", costCenterGroupIds);
            DynamicObjectCollection cosCenterGroup = QueryServiceHelper.query((String)"cad_costcentergroup", (String)"entryentity.costcenter coscenterid", (QFilter[])new QFilter[]{costGroupFilter});
            if (!CadEmptyUtils.isEmpty(cosCenterGroup)) {
                Set cosCenterId = cosCenterGroup.stream().map(dynamicObject -> dynamicObject.getLong("coscenterid")).collect(Collectors.toSet());
                QFilter manuOrgFilter = new QFilter("id", "in", cosCenterId);
                filters.add(manuOrgFilter);
            } else {
                filters.add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            }
        }
        if (CadEmptyUtils.isEmpty(costCenter = BusinessDataServiceHelper.load((String)"bos_costcenter", (String)"id,name", (QFilter[])filters.toArray(new QFilter[0]), (String)"number asc"))) {
            return null;
        }
        ArrayList<ComboItem> centerItems = new ArrayList<ComboItem>();
        for (Object center : costCenter) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(center.getString("name")));
            item.setValue(center.getString("id"));
            if (centerItems.contains(item)) continue;
            centerItems.add(item);
        }
        return centerItems;
    }

    public static Long getCostAccountByAccoutOrg(Long accountOrgId) {
        QFilter accountorgQF = new QFilter("calorg", "=", (Object)accountOrgId);
        QFilter enablestdtQF = new QFilter("enablestandardcost", "=", (Object)Boolean.TRUE);
        QFilter ismainaccountQF = new QFilter("ismainaccount", "=", (Object)Boolean.TRUE);
        String orderby = "ismainaccount DESC, number ASC";
        DynamicObjectCollection result = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id, name,ismainaccount", (QFilter[])new QFilter[]{accountorgQF, enablestdtQF, ismainaccountQF}, (String)orderby);
        if (result == null || result.size() == 0 || result.size() > 1) {
            return 0L;
        }
        DynamicObject costaccount = (DynamicObject)result.get(0);
        return costaccount.getLong("id");
    }

    public static Long getCostAccountByOrg(Long orgId, String appId) {
        DynamicObjectCollection ccs;
        if (CadEmptyUtils.isEmpty(orgId) || CadEmptyUtils.isEmpty(appId)) {
            return 0L;
        }
        QFilter filter = new QFilter("calorg", "in", (Object)orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(orgId)) {
            filter.and(StartCostHelper.getEnabledCostAccountIdsFilter(orgId, appId));
        }
        return CollectionUtils.isEmpty((Collection)(ccs = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,name", (QFilter[])new QFilter[]{filter, statusFilter, enableFilter}, (String)"ismainaccount desc,number asc"))) ? 0L : ((DynamicObject)ccs.get(0)).getLong("id");
    }

    public static List<Long> getHasPermAccountOrgIds(String entityId, String appNum) {
        List hasPermOrgIds = Lists.newArrayListWithCapacity((int)16);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (CadEmptyUtils.isEmpty(appNum)) {
            appNum = "sca";
        }
        String appInnerId = AppMetadataCache.getAppInfo((String)appNum).getId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appInnerId, (String)entityId, (String)"47150e89000000ac");
        boolean hasAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
        List allOrgIds = hasPermOrgResult.getHasPermOrgs();
        if (hasAllOrgPerm) {
            hasPermOrgIds = OrgUnitServiceHelper.getAllOrg((String)"10");
        } else if (!CadEmptyUtils.isEmpty(allOrgIds)) {
            hasPermOrgIds = OrgUnitServiceHelper.filterOrgDuty((List)allOrgIds, (String)"10");
        }
        return hasPermOrgIds;
    }

    @Deprecated
    public static List<Long> getHasPermAccountOrgIds(String entityId) {
        List hasPermOrgIds = Lists.newArrayListWithCapacity((int)16);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String appInnerId = AppMetadataCache.getAppInfo((String)"cal").getId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appInnerId, (String)entityId, (String)"47150e89000000ac");
        boolean hasAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
        List allOrgIds = hasPermOrgResult.getHasPermOrgs();
        if (hasAllOrgPerm) {
            hasPermOrgIds = OrgUnitServiceHelper.getAllOrg((String)"10");
        } else if (!CadEmptyUtils.isEmpty(allOrgIds)) {
            hasPermOrgIds = OrgUnitServiceHelper.filterOrgDuty((List)allOrgIds, (String)"10");
        }
        return hasPermOrgIds;
    }

    public static List<Long> getHasPermAccountOrgIds(Long userId) {
        List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)userId).getHasPermOrgs();
        List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"10");
        if (CadEmptyUtils.isEmpty(permOrgIds) && CadEmptyUtils.isEmpty(orgIds)) {
            orgIds = OrgUnitServiceHelper.getAllOrg((String)"10");
        }
        return orgIds;
    }

    public static List<Long> getHasPermAccountOrgIdsByPermItem(String entityId, String appNum, String perm) {
        List hasPermOrgIds = Lists.newArrayListWithCapacity((int)16);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (CadEmptyUtils.isEmpty(appNum)) {
            appNum = "sca";
        }
        String appInnerId = AppMetadataCache.getAppInfo((String)appNum).getId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appInnerId, (String)entityId, (String)perm);
        boolean hasAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
        List allOrgIds = hasPermOrgResult.getHasPermOrgs();
        if (hasAllOrgPerm) {
            hasPermOrgIds = OrgUnitServiceHelper.getAllOrg((String)"10");
        } else if (!CadEmptyUtils.isEmpty(allOrgIds)) {
            hasPermOrgIds = OrgUnitServiceHelper.filterOrgDuty((List)allOrgIds, (String)"10");
        }
        return hasPermOrgIds;
    }

    @Deprecated
    public static List<Long> getHasPermAccountOrgIdsByPermItem(String entityId, String perm) {
        List hasPermOrgIds = Lists.newArrayListWithCapacity((int)16);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String appInnerId = AppMetadataCache.getAppInfo((String)"cal").getId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appInnerId, (String)entityId, (String)perm);
        boolean hasAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
        List allOrgIds = hasPermOrgResult.getHasPermOrgs();
        if (hasAllOrgPerm) {
            hasPermOrgIds = OrgUnitServiceHelper.getAllOrg((String)"10");
        } else if (!CadEmptyUtils.isEmpty(allOrgIds)) {
            hasPermOrgIds = OrgUnitServiceHelper.filterOrgDuty((List)allOrgIds, (String)"10");
        }
        return hasPermOrgIds;
    }

    public static List<Long> getOrgRangBy(List<Long> orgIds, String strage) {
        List<Long> list = new ArrayList<Long>();
        switch (strage) {
            case "1": 
            case "2": {
                list = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.parseLong("10"), orgIds, (boolean)true);
                break;
            }
            case "5": {
                list = OrgUnitServiceHelper.getAllOrgByViewId((long)Long.parseLong("10"), (boolean)true);
                break;
            }
            case "6": {
                List listSub = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.parseLong("10"), orgIds, (boolean)true);
                if (CadEmptyUtils.isEmpty(listSub)) break;
                list.addAll(listSub);
                break;
            }
            case "7": {
                list.addAll(orgIds);
                break;
            }
        }
        return list;
    }

    public static boolean isOrgEnableMultiFactory(Long calOrgId) {
        if (calOrgId == null) {
            return false;
        }
        Boolean isEnable = orgEnableMultiFactoryMap.get(calOrgId);
        if (isEnable == null && (isEnable = (Boolean)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)calOrgId, (Long)0L, (String)"multifactoryaccount")).booleanValue()) {
            orgEnableMultiFactoryMap.put(calOrgId, isEnable);
        }
        if (isEnable == null) {
            return false;
        }
        return isEnable;
    }

    public static List<ComboItem> getOrgComboItems(String entityName, String permItemId, String appId) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (CadEmptyUtils.isEmpty(appId)) {
            appId = "sca";
        }
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityName, (String)permItemId);
        QFilter filter = null;
        filter = rs.hasAllOrgPerm() ? new QFilter("id", "in", (Object)OrgUnitServiceHelper.getAllOrg((String)"10")) : new QFilter("id", "in", (Object)OrgUnitServiceHelper.filterOrgDuty((List)rs.getHasPermOrgs(), (String)"10"));
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{filter}, (String)"number asc");
        if (CollectionUtils.isEmpty((Collection)cols)) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ComboItem firstItem = null;
        int i = 0;
        for (DynamicObject acctOrg : cols) {
            String acctOrgId = acctOrg.getString("id");
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(acctOrg.getString("name")));
            item.setValue(acctOrgId);
            if (i == 0) {
                firstItem = item;
            }
            if (acctItems.contains(item)) continue;
            acctItems.add(item);
            String loginOrgId = String.valueOf(RequestContext.get().getOrgId());
            if (acctOrgId.equals(loginOrgId)) {
                acctItems.set(0, item);
                acctItems.set(i, firstItem);
            }
            ++i;
        }
        return acctItems;
    }

    public static Set<Long> getMaterialByCalOrgId(Set<Long> calOrgIds) {
        HashSet<Long> mats = new HashSet<Long>();
        for (Long calOrgId : calOrgIds) {
            QFilter qfMat = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)calOrgId);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getMaterialByCalOrgId", (String)"bd_material", (String)"masterid", (QFilter[])new QFilter[]{qfMat}, null);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long masterid = row.getLong("masterid");
                if (CadEmptyUtils.isEmpty(masterid)) continue;
                mats.add(masterid);
            }
        }
        return mats;
    }

    public static List<Long> getOrgEnableMultiFactory(List<Long> orgIds) {
        ArrayList<Long> resultOrg = new ArrayList<Long>();
        if (orgIds.isEmpty()) {
            return resultOrg;
        }
        for (Long orgId : orgIds) {
            Boolean isEnable = orgEnableMultiFactoryMap.get(orgId);
            if (isEnable == null) {
                Boolean multiFactoryAccount = (Boolean)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)orgId, (Long)0L, (String)"multifactoryaccount");
                if (!multiFactoryAccount.booleanValue()) continue;
                orgEnableMultiFactoryMap.put(orgId, multiFactoryAccount);
                resultOrg.add(orgId);
                continue;
            }
            resultOrg.add(orgId);
        }
        return resultOrg;
    }

    public static List<ComboItem> getMultiOrgComboItems(String entityId, String appNum) {
        List<Long> permCalOrgIds = OrgHelper.getCurrAccountOrg(entityId, appNum);
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)Long.valueOf(RequestContext.get().getUserId()), (String)"sca", (String)entityId, (String)"47150e89000000ac");
        QFilter filter = null;
        if (rs.hasAllOrgPerm()) {
            filter = new QFilter("id", "in", permCalOrgIds);
        } else {
            List<Long> orgEnableMultiFactoryIds = OrgHelper.getOrgEnableMultiFactory(permCalOrgIds);
            filter = new QFilter("id", "in", orgEnableMultiFactoryIds);
        }
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{filter}, (String)"number asc");
        if (CollectionUtils.isEmpty((Collection)cols)) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ComboItem firstItem = null;
        int i = 0;
        for (DynamicObject acctOrg : cols) {
            String acctOrgId = acctOrg.getString("id");
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(acctOrg.getString("name")));
            item.setValue(acctOrgId);
            if (i == 0) {
                firstItem = item;
            }
            if (acctItems.contains(item)) continue;
            acctItems.add(item);
            String loginOrgId = String.valueOf(RequestContext.get().getOrgId());
            if (acctOrgId.equals(loginOrgId)) {
                acctItems.set(0, item);
                acctItems.set(i, firstItem);
            }
            ++i;
        }
        return acctItems;
    }

    @Deprecated
    public static List<ComboItem> getMultiOrgComboItems(String entityId) {
        List<Long> permCalOrgIds = OrgHelper.getCurrAccountOrg(entityId);
        List<Long> orgEnableMultiFactoryIds = OrgHelper.getOrgEnableMultiFactory(permCalOrgIds);
        QFilter filter = new QFilter("id", "in", orgEnableMultiFactoryIds);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{filter}, (String)"number asc");
        if (CollectionUtils.isEmpty((Collection)cols)) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ComboItem firstItem = null;
        int i = 0;
        for (DynamicObject acctOrg : cols) {
            String acctOrgId = acctOrg.getString("id");
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(acctOrg.getString("name")));
            item.setValue(acctOrgId);
            if (i == 0) {
                firstItem = item;
            }
            if (acctItems.contains(item)) continue;
            acctItems.add(item);
            String loginOrgId = String.valueOf(RequestContext.get().getOrgId());
            if (acctOrgId.equals(loginOrgId)) {
                acctItems.set(0, item);
                acctItems.set(i, firstItem);
            }
            ++i;
        }
        return acctItems;
    }

    public static List<ComboItem> getCentersByManuOrgIds(Long orgId, List<Long> manuList, String appId) {
        Set<Long> centerIds;
        if (CadEmptyUtils.isEmpty(appId)) {
            appId = "sca";
        }
        if ((centerIds = OrgHelper.getCenterIdsByManuOrgIds(orgId, manuList, appId)).isEmpty()) {
            return null;
        }
        QFilter filters = new QFilter("status", "=", (Object)"C");
        filters.and("enable", "=", (Object)Boolean.TRUE);
        filters.and("id", "in", centerIds);
        Object[] costCenter = BusinessDataServiceHelper.load((String)"bos_costcenter", (String)"id,name", (QFilter[])filters.toArray());
        if (CadEmptyUtils.isEmpty(costCenter)) {
            return null;
        }
        ArrayList<ComboItem> centerItems = new ArrayList<ComboItem>();
        for (Object center : costCenter) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(center.getString("name")));
            item.setValue(center.getString("id"));
            if (centerItems.contains(item)) continue;
            centerItems.add(item);
        }
        return centerItems;
    }

    public static Set<Long> getCenterIdsByManuOrgIds(Long orgId, List<Long> manuList, String appId) {
        if (CadEmptyUtils.isEmpty(appId)) {
            appId = "sca";
        }
        HashSet<Long> centerIds = new HashSet<Long>(20);
        Date nowTime = new Date();
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and("manuorg", "in", manuList);
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("effectdate", "<=", (Object)nowTime);
        qFilter.and("expdate", ">", (Object)nowTime);
        qFilter.and("appnum", "=", (Object)appId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_centermanuorg", (String)"entryentity.costcenter as costcenterid", (QFilter[])qFilter.toArray());
        if (dynamicObjects.isEmpty()) {
            centerIds.add(-1L);
            return centerIds;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            centerIds.add(dynamicObject.getLong("costcenterid"));
        }
        return centerIds;
    }

    public static DynamicObjectCollection getCenterManyByManuOrgIds(Long orgId, List<Long> manuList, String appId) {
        if (CadEmptyUtils.isEmpty(appId)) {
            appId = "sca";
        }
        Date nowTime = new Date();
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        if (!CadEmptyUtils.isEmpty(manuList)) {
            qFilter.and("manuorg", "in", manuList);
        }
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("effectdate", "<=", (Object)nowTime);
        qFilter.and("expdate", ">", (Object)nowTime);
        qFilter.and("appnum", "=", (Object)appId);
        return QueryServiceHelper.query((String)"cad_centermanuorg", (String)"manuorg,entryentity.costcenter as costcenterid", (QFilter[])qFilter.toArray());
    }

    public static Set<Long> getCenterManuOrgByIds(Long orgId, Set<Long> centerIds, String appId) {
        if (CadEmptyUtils.isEmpty(appId)) {
            appId = "sca";
        }
        HashSet<Long> centerSet = new HashSet<Long>(20);
        Date nowTime = new Date();
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and("entryentity.costcenter", "in", centerIds);
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("effectdate", "<=", (Object)nowTime);
        qFilter.and("expdate", ">", (Object)nowTime);
        qFilter.and("appnum", "=", (Object)appId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"cad_centermanuorg", (String)"entryentity.costcenter as costcenterid", (QFilter[])qFilter.toArray());
        for (DynamicObject dynamicObject : query) {
            centerSet.add(dynamicObject.getLong("costcenterid"));
        }
        return centerSet;
    }

    public static Map<Long, Long> getCostCenterAndManuOrgMap(List<Long> costCenterIds, String appId) {
        if (CadEmptyUtils.isEmpty(appId)) {
            appId = "sca";
        }
        HashMap<Long, Long> costCenterAndManuOrgMap = new HashMap<Long, Long>(128);
        Date nowTime = new Date();
        QFilter qFilter = new QFilter("entryentity.costcenter", "in", costCenterIds);
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("effectdate", "<=", (Object)nowTime);
        qFilter.and("expdate", ">", (Object)nowTime);
        qFilter.and("appnum", "=", (Object)appId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_centermanuorg", (String)"manuorg,entryentity.costcenter as costcenterid", (QFilter[])qFilter.toArray());
        if (dynamicObjects.isEmpty()) {
            return costCenterAndManuOrgMap;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (CadEmptyUtils.isEmpty(dynamicObject.getLong("costcenterid"))) continue;
            costCenterAndManuOrgMap.put(dynamicObject.getLong("costcenterid"), dynamicObject.getLong("manuorg"));
        }
        return costCenterAndManuOrgMap;
    }

    public static Map<Long, List<Long>> getCenterIdsByManuOrgIds(Long orgId, List<Long> manuList, List<Long> enableCostCenters, String appId) {
        if (CadEmptyUtils.isEmpty(appId)) {
            appId = "sca";
        }
        HashMap<Long, List<Long>> costCenterIdsMap = new HashMap<Long, List<Long>>(20);
        Date nowTime = new Date();
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        qFilter.and("manuorg", "in", manuList);
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("effectdate", "<=", (Object)nowTime);
        qFilter.and("expdate", ">", (Object)nowTime);
        qFilter.and("appnum", "=", (Object)appId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_centermanuorg", (String)"org,manuorg,entryentity.costcenter as costcenterid", (QFilter[])qFilter.toArray());
        if (dynamicObjects.isEmpty()) {
            return costCenterIdsMap;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!enableCostCenters.contains(dynamicObject.getLong("costcenterid"))) continue;
            costCenterIdsMap.computeIfAbsent(dynamicObject.getLong("costcenterid"), p -> new ArrayList()).add(dynamicObject.getLong("manuorg"));
        }
        return costCenterIdsMap;
    }

    @Deprecated
    public static List<Long> getHasPermAccountOrgIds() {
        List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId())).getHasPermOrgs();
        List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"10");
        if (CadEmptyUtils.isEmpty(permOrgIds) && CadEmptyUtils.isEmpty(orgIds)) {
            orgIds = OrgUnitServiceHelper.getAllOrg((String)"10");
        }
        return orgIds;
    }

    public static List<Long> getUserHasPermStoreOrgsByAccOrg(Long accOrg, String entityId, String appId) {
        QFilter statusQf;
        QFilter orgQf;
        DynamicObjectCollection invStarts;
        if (CadEmptyUtils.isEmpty(appId)) {
            appId = "sca";
        }
        List<Long> proOrgsByOrgEntity = OrgHelper.getProOrgsByOrgEntity(accOrg, entityId, appId);
        ArrayList inventoryOrgs = Lists.newArrayListWithExpectedSize((int)8);
        if (proOrgsByOrgEntity != null && !proOrgsByOrgEntity.isEmpty()) {
            for (Long proOrg : proOrgsByOrgEntity) {
                List wtInventoryOrgs = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)proOrg, (boolean)true);
                if (wtInventoryOrgs == null) continue;
                inventoryOrgs.addAll(wtInventoryOrgs);
            }
        }
        if (inventoryOrgs != null && !inventoryOrgs.isEmpty() && (invStarts = QueryServiceHelper.query((String)"im_invstart", (String)"org", (QFilter[])new QFilter[]{orgQf = new QFilter("org", "in", (Object)inventoryOrgs), statusQf = new QFilter("startstatus", "=", (Object)"B")})) != null && !invStarts.isEmpty()) {
            return invStarts.stream().map(dynamicObject -> dynamicObject.getLong("org")).collect(Collectors.toList());
        }
        return inventoryOrgs;
    }

    public static List<Long> getProOrgsByOrgEntity(Long orgId, String entityId, String appNum) {
        if (CadEmptyUtils.isEmpty(orgId)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        if (StringUtils.isEmpty((String)entityId)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        return ImportServiceHelper.getUserHasPermProOrgsByAccOrg(orgId, entityId, appNum);
    }

    public static List<Long> getCostCentersByOrg(long orgId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("accountorg", "=", (Object)orgId));
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)true));
        filters.add(new QFilter("orgduty", "=", (Object)4L));
        DynamicObjectCollection costCenters = QueryServiceHelper.query((String)"bos_costcenter", (String)"id", (QFilter[])filters.toArray(new QFilter[0]));
        if (costCenters.isEmpty()) {
            return null;
        }
        return costCenters.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    public static List<Long> getOrgOrderByNumber(List<Long> orgIds) {
        ArrayList<Long> result = new ArrayList<Long>(10);
        ArrayList filters = Lists.newArrayList();
        filters.add(new QFilter("id", "in", orgIds));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getOrgInfo", (String)"bos_org", (String)"id", (QFilter[])filters.toArray(new QFilter[0]), (String)"number asc");
        if (dataSet == null) {
            return result;
        }
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long id = row.getLong("id");
            result.add(id);
        }
        return result;
    }

    public static Long getInvOrgIdByProduce(Long manuOrgId) {
        Long stOrgId = 0L;
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(manuOrgId.longValue());
        param.setFromViewType("04");
        param.setToViewType("05");
        param.setDirectViewType("toorg");
        param.setIncludeSelf(true);
        List invList = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
        if (!CadEmptyUtils.isEmpty(invList)) {
            stOrgId = Sets.newHashSet((Iterable)invList).contains(manuOrgId) ? manuOrgId : (Long)invList.get(0);
        }
        return stOrgId;
    }

    public static List<Long> getProOrgIdsByCalcOrg(Long calcOrg) {
        ArrayList<Long> prodOrgs = new ArrayList<Long>(10);
        OrgRelationParam param = new OrgRelationParam();
        param.setNumber("Accounting_TO_Production_S");
        param.setOrgId(calcOrg.longValue());
        param.setToViewType("04");
        param.setFromViewType("10");
        param.setDirectViewType("toorg");
        param.setIncludeSelf(true);
        List bizRelationOrgIds = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
        if (!CadEmptyUtils.isEmpty(bizRelationOrgIds)) {
            prodOrgs.addAll(bizRelationOrgIds);
        }
        return prodOrgs;
    }

    public static Long getCalcOrgByCostType(Long mnCostTypeId, Long hsCostTypeId, String appNum) {
        Long calOrg = 0L;
        if ("sca".equals(appNum)) {
            Date date = new Date();
            QFilter filter = new QFilter("costtype", "=", (Object)hsCostTypeId);
            filter.and(new QFilter("bizstatus", "=", (Object)"1"));
            filter.and(new QFilter("effectdate", "<=", (Object)date));
            filter.and(new QFilter("invaliddate", ">", (Object)date));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cal_bd_costtypeorg", (String)"calorg", (QFilter[])new QFilter[]{filter});
            if (dynamicObject != null) {
                calOrg = dynamicObject.getLong("calorg");
            }
        } else {
            DynamicObject dynamicObject = CostTypeHelper.getCostType(mnCostTypeId, "createorg");
            if (dynamicObject != null) {
                calOrg = dynamicObject.getLong("createorg.id");
            }
        }
        return calOrg;
    }
}

