/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PeriodHelper {
    public static List<ComboItem> getPeriodItems(Long periodType) {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        QFilter orgFilter = new QFilter("periodtype.id", "=", (Object)periodType);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bd_period", (String)"id,name", (QFilter[])orgFilter.toArray());
        for (DynamicObject dy : dynamicObjectCollection) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(dy.getString("name")));
            item.setValue(dy.getString("id"));
            if (comboItemList.contains(item)) continue;
            comboItemList.add(item);
        }
        return comboItemList;
    }

    public static DynamicObject getCurrentPeriod(Long costAccountID) {
        DynamicObject sysCtrl = PeriodHelper.getSysCtrlEntity(costAccountID);
        if (sysCtrl != null) {
            return sysCtrl.getDynamicObject("currentperiod");
        }
        return null;
    }

    public static List<Long> getCurrentPreviousPeriod(Long costAccountID) {
        DynamicObject currentPeriod;
        ArrayList<Long> periodIds = new ArrayList<Long>(10);
        DynamicObject sysCtrl = PeriodHelper.getSysCtrlEntity(costAccountID);
        if (sysCtrl != null && (currentPeriod = sysCtrl.getDynamicObject("currentperiod")) != null) {
            periodIds.add(currentPeriod.getLong("id"));
            DynamicObject prePeriod = PeriodHelper.getPreviousPeriod(periodIds.get(0));
            if (prePeriod != null) {
                periodIds.add(prePeriod.getLong("id"));
            }
        }
        return periodIds;
    }

    public static DynamicObject getCurrentPeriodAndEnAblePeriod(Long costAccountID) {
        QFilter costAccountQf = new QFilter("entry.costaccount.id", "=", (Object)costAccountID);
        QFilter isEnabledQf = new QFilter("entry.isenabled", "=", (Object)Boolean.TRUE);
        String fields = "org,entry.costaccount,entry.currentperiod,entry.startperiod";
        DynamicObject sysPeriod = BusinessDataServiceHelper.loadSingle((String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{costAccountQf, isEnabledQf});
        DynamicObject retValue = null;
        if (sysPeriod == null) {
            return null;
        }
        DynamicObjectCollection entrys = sysPeriod.getDynamicObjectCollection("entry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entryInfo = (DynamicObject)entrys.get(i);
            long recordCostAccountID = entryInfo.getLong("costaccount.id");
            if (costAccountID != recordCostAccountID) continue;
            retValue = entryInfo;
            break;
        }
        return retValue;
    }

    public static Map<Long, String> voucherInCurrentPeriod(String billEntityNumber, Map<Long, Long> billToVch) {
        HashMap<Long, String> errorMap = new HashMap<Long, String>(16);
        HashSet<Long> billIdSet = new HashSet<Long>(10);
        HashSet<Long> voucherIdSet = new HashSet<Long>(10);
        for (Map.Entry<Long, Long> billVoucherEntry : billToVch.entrySet()) {
            Long billId = billVoucherEntry.getKey();
            billIdSet.add(billId);
            Long voucherId = billVoucherEntry.getValue();
            voucherIdSet.add(voucherId);
        }
        QFilter billFilter = new QFilter("id", "in", billIdSet);
        DynamicObjectCollection bills = QueryServiceHelper.query((String)billEntityNumber, (String)"id,org,costaccount", (QFilter[])new QFilter[]{billFilter});
        if (!CadEmptyUtils.isEmpty(bills)) {
            Map<Long, Long> billCostAccountMap = bills.stream().collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getLong("costaccount"), (o1, o2) -> o1));
            Set<Long> costAccountIds = bills.stream().map(e -> e.getLong("costaccount")).collect(Collectors.toSet());
            Map<Long, String> costAccountAndAppNumberMap = StartCostHelper.getAppNumberByStartCost(costAccountIds);
            Map<Long, DynamicObject> costAccountPeriodMap = PeriodHelper.getAccountCurrentPeriodDynamicObject(costAccountIds);
            QFilter voucherFilter = new QFilter("id", "in", voucherIdSet);
            DynamicObjectCollection vouchers = QueryServiceHelper.query((String)"gl_voucher", (String)"id,bookeddate", (QFilter[])new QFilter[]{voucherFilter});
            Map<Long, Date> voucherDateMap = vouchers.stream().collect(Collectors.toMap(x -> x.getLong("id"), y -> y.getDate("bookeddate"), (o1, o2) -> o1));
            for (Map.Entry<Long, Long> entry : billToVch.entrySet()) {
                Long voucherId;
                Date bookDate;
                DynamicObject currentPeriod;
                Long billId = entry.getKey();
                Long costAccountId = billCostAccountMap.get(billId);
                if (costAccountId == null) continue;
                String appNumber = costAccountAndAppNumberMap.get(costAccountId);
                String appName = AppIdHelper.getAppName(appNumber);
                if (costAccountPeriodMap == null || (currentPeriod = costAccountPeriodMap.get(costAccountId)) == null || !(bookDate = voucherDateMap.get(voucherId = entry.getValue())).after(currentPeriod.getDate("enddate")) && !bookDate.before(currentPeriod.getDate("begindate"))) continue;
                errorMap.put(voucherId, String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u6765\u6e90\u7cfb\u7edf\u4e3a%s\uff0c\u4e0d\u80fd\u5220\u9664\u6838\u7b97\u5df2\u7ed3\u8d26\u671f\u95f4\u7684\u51ed\u8bc1", (String)"PeriodHelper_0", (String)"macc-cad-common", (Object[])new Object[0]), appName));
            }
        }
        return errorMap;
    }

    public static Map<Long, Long> getAccountCurrentPeriod(Set<Long> costAccountIDs) {
        HashMap<Long, Long> retValue = new HashMap<Long, Long>(16);
        QFilter filter = new QFilter("entry.costaccount.id", "in", costAccountIDs);
        String fields = "org,entry.currentperiod,entry.costaccount";
        DynamicObject[] sysPeriods = BusinessDataServiceHelper.load((String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{filter});
        if (sysPeriods == null) {
            return null;
        }
        for (DynamicObject sysPeriod : sysPeriods) {
            DynamicObjectCollection entrys = sysPeriod.getDynamicObjectCollection("entry");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entryInfo = (DynamicObject)entrys.get(i);
                long recordCostAccountID = entryInfo.getLong("costaccount.id");
                long currentperiodID = entryInfo.getLong("currentperiod.id");
                if (!costAccountIDs.contains(recordCostAccountID)) continue;
                retValue.putIfAbsent(recordCostAccountID, currentperiodID);
            }
        }
        return retValue;
    }

    public static Map<Long, DynamicObject> getAccountCurrentPeriodDynamicObject(Set<Long> costAccountIDs) {
        HashMap<Long, DynamicObject> retValue = new HashMap<Long, DynamicObject>(16);
        QFilter filter = new QFilter("entry.costaccount.id", "in", costAccountIDs);
        String fields = "org,entry.currentperiod,entry.costaccount";
        DynamicObject[] sysPeriods = BusinessDataServiceHelper.load((String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{filter});
        if (sysPeriods == null) {
            return null;
        }
        for (DynamicObject sysPeriod : sysPeriods) {
            DynamicObjectCollection entrys = sysPeriod.getDynamicObjectCollection("entry");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entryInfo = (DynamicObject)entrys.get(i);
                long recordCostAccountID = entryInfo.getLong("costaccount.id");
                DynamicObject currentperiod = entryInfo.getDynamicObject("currentperiod");
                if (!costAccountIDs.contains(recordCostAccountID)) continue;
                retValue.putIfAbsent(recordCostAccountID, currentperiod);
            }
        }
        return retValue;
    }

    public static Set<DynamicObject> getAccountCurrentPeriods(Set<Long> costAccountIDs) {
        HashSet curPeriods = Sets.newHashSet();
        QFilter filter = new QFilter("entry.costaccount.id", "in", costAccountIDs);
        String fields = "org,entry.currentperiod,entry.costaccount";
        DynamicObject[] sysPeriods = BusinessDataServiceHelper.load((String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{filter});
        if (sysPeriods == null) {
            return null;
        }
        for (DynamicObject sysPeriod : sysPeriods) {
            DynamicObjectCollection entrys = sysPeriod.getDynamicObjectCollection("entry");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entryInfo = (DynamicObject)entrys.get(i);
                long recordCostAccountID = entryInfo.getLong("costaccount.id");
                DynamicObject currentPeriod = entryInfo.getDynamicObject("currentperiod");
                if (!costAccountIDs.contains(recordCostAccountID)) continue;
                curPeriods.add(currentPeriod);
            }
        }
        return curPeriods;
    }

    public static DynamicObject getCurrentPeriodType(Long costAccountID) {
        DynamicObject sysCtrl = PeriodHelper.getSysCtrlEntity(costAccountID);
        if (sysCtrl != null) {
            return sysCtrl.getDynamicObject("calpolicy.periodtype");
        }
        return null;
    }

    public static Date getCurrentPeriodenddate(Long costAccountID) {
        DynamicObject sysCtrl = PeriodHelper.getSysCtrlEntity(costAccountID);
        if (sysCtrl != null) {
            return sysCtrl.getDate("currentperiod.enddate");
        }
        return null;
    }

    public static DynamicObject getPeriodByDate(Date date, Long costAccountID) {
        QFilter filter = new QFilter("id", "=", (Object)costAccountID);
        String fields = "calpolicy,calpolicy.periodtype";
        DynamicObject value = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)fields, (QFilter[])new QFilter[]{filter});
        DynamicObject period = PeriodHelper.getPeriodByDate(date, null, value.getLong("calpolicy.periodtype"));
        return period;
    }

    public static int compare2period(DynamicObject period1, DynamicObject period2) {
        int result = 1;
        if (period1.get("begindate").equals(period2.get("begindate")) && period1.get("enddate").equals(period2.get("enddate"))) {
            result = 0;
        } else if (period1.getDate("begindate").after(period2.getDate("enddate")) || period1.get("begindate").equals(period2.get("enddate"))) {
            result = 1;
        } else if (period1.getDate("enddate").before(period2.getDate("begindate")) || period1.get("enddate").equals(period2.get("begindate"))) {
            result = -1;
        }
        return result;
    }

    public static DynamicObject getPeriodByDate(Date date, String selectField, long periodType) {
        if (selectField == null) {
            selectField = "id,name,number,beginDate,enddate";
        }
        QFilter f = new QFilter("beginDate", "<=", (Object)date);
        QFilter g = new QFilter("enddate", ">=", (Object)date);
        QFilter t = new QFilter("periodtype", "=", (Object)periodType);
        QFilter q = new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE);
        return QueryServiceHelper.queryOne((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t, q});
    }

    public static DynamicObject getPeriodByNumber(int year, int periodNum, String selectField, long periodType) {
        if (selectField == null) {
            selectField = "id,name,number,beginDate,enddate";
        }
        QFilter f = new QFilter("periodyear", "=", (Object)year);
        QFilter g = new QFilter("periodnumber", "=", (Object)periodNum);
        QFilter t = new QFilter("periodtype", "=", (Object)periodType);
        return QueryServiceHelper.queryOne((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t});
    }

    public static DynamicObject getPreviousPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", "<", (Object)currPeriod.getInt("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        QFilter pYear = new QFilter("periodyear", "<", (Object)currPeriod.getInt("periodyear"));
        pfilter.or(pYear);
        QFilter q = new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filterType, pfilter, q}, (String)"periodyear desc, periodnumber desc");
        if (cols.size() > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cols.get(0)).getLong("id"), (DynamicObjectType)type);
        }
        return null;
    }

    public static DynamicObject getNextPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (DynamicObjectType)type);
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        QFilter filterYear = new QFilter("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        QFilter filterNum = new QFilter("periodnumber", ">", (Object)currPeriod.getInt("periodnumber"));
        QFilter pfilter = filterYear.and(filterNum);
        QFilter pYear = new QFilter("periodyear", ">", (Object)currPeriod.getInt("periodyear"));
        pfilter.or(pYear);
        QFilter q = new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])new QFilter[]{filterType, pfilter, q}, (String)"periodyear asc, periodnumber asc");
        if (cols.size() > 0) {
            return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)cols.get(0)).getLong("id"), (DynamicObjectType)type);
        }
        return null;
    }

    public static DynamicObject getStartPeriod(Long costAccountID) {
        DynamicObject sysCtrl = PeriodHelper.getSysCtrlEntity(costAccountID);
        if (sysCtrl != null) {
            return sysCtrl.getDynamicObject("startperiod");
        }
        return null;
    }

    public static DynamicObject getSysCtrlEntity(Long costAccountID) {
        DynamicObject retValue = null;
        QFilter filter = new QFilter("entry.costaccount.id", "=", (Object)costAccountID);
        String fields = "org,entry.currentperiod,entry.startperiod,entry.costaccount,entry.currentperiod.begindate,entry.currentperiod.enddate,entry.startperiod.begindate,entry.startperiod.enddate,entry.calpolicy,entry.calpolicy.periodtype,entry.isenabled";
        DynamicObject sysPeriod = BusinessDataServiceHelper.loadSingle((String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{filter});
        if (sysPeriod == null) {
            return null;
        }
        DynamicObjectCollection entrys = sysPeriod.getDynamicObjectCollection("entry");
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject entryInfo = (DynamicObject)entrys.get(i);
            long recordCostAccountID = entryInfo.getLong("costaccount.id");
            if (costAccountID != recordCostAccountID) continue;
            retValue = entryInfo;
            break;
        }
        return retValue;
    }

    public static DynamicObject getPeriodByYearMonth(long costAccountID, String selectField, int year, int month) {
        QFilter filter = new QFilter("id", "=", (Object)costAccountID);
        String fields = "calpolicy,calpolicy.periodtype";
        DynamicObject value = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)fields, (QFilter[])new QFilter[]{filter});
        if (selectField == null) {
            selectField = "id,name,number,beginDate,enddate";
        }
        QFilter f = new QFilter("periodyear", "=", (Object)year);
        QFilter g = new QFilter("periodnumber", "=", (Object)month);
        QFilter t = new QFilter("periodtype", "=", (Object)value.getLong("calpolicy.periodtype"));
        QFilter q = new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE);
        return BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t, q});
    }

    public static List<Long> getPeriodByYear(long costAccountID, int year) {
        QFilter q;
        QFilter t;
        List<Long> periodIds = new ArrayList<Long>(10);
        QFilter filter = new QFilter("id", "=", (Object)costAccountID);
        String fields = "calpolicy,calpolicy.periodtype";
        DynamicObject value = QueryServiceHelper.queryOne((String)"cal_bd_costaccount", (String)fields, (QFilter[])new QFilter[]{filter});
        String selectField = "id,name,number,beginDate,enddate";
        QFilter f = new QFilter("periodyear", "=", (Object)year);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, t = new QFilter("periodtype", "=", (Object)value.getLong("calpolicy.periodtype")), q = new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE)});
        if (collection != null && collection.size() > 0) {
            periodIds = collection.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        }
        return periodIds;
    }

    public static DynamicObjectCollection getSysCtrlEntity(Long[] costAccountIds, String selects) {
        QFilter filter = new QFilter("entry.costaccount.id", "in", (Object)costAccountIds);
        if (selects == null) {
            selects = "org,entry.currentperiod as currentperiod,entry.startperiod as startperiod,entry.costaccount as costaccount";
        }
        DynamicObjectCollection sysPeriods = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)selects, (QFilter[])new QFilter[]{filter});
        return sysPeriods;
    }

    public static boolean isEndInit(Long costAccountID) {
        DynamicObject sysCtrl = PeriodHelper.getSysCtrlEntity(costAccountID);
        if (sysCtrl != null) {
            return sysCtrl.getBoolean("isenabled");
        }
        return false;
    }

    public static List<Object> getStart2EndAllPeriodIds(DynamicObject startPeriod, DynamicObject endPeriod) {
        Object periodType = startPeriod.get("periodtype.id");
        Date begindate = startPeriod.getDate("begindate");
        Date enddate = endPeriod.getDate("enddate");
        QFilter periodTypeFilter = new QFilter("periodtype", "=", periodType);
        QFilter beginDateFilter = new QFilter("begindate", ">=", (Object)begindate);
        QFilter endDateFilter = new QFilter("enddate", "<=", (Object)enddate);
        return QueryServiceHelper.queryPrimaryKeys((String)"bd_period", (QFilter[])new QFilter[]{periodTypeFilter, beginDateFilter, endDateFilter}, null, (int)9999);
    }

    public static Map<String, Date> getDateByPeriod(Set<Long> periodIds) {
        HashMap<String, Date> date = new HashMap<String, Date>(10);
        QFilter qfIds = new QFilter("id", "in", periodIds);
        DynamicObjectCollection period = QueryServiceHelper.query((String)"bd_period", (String)"begindate,enddate", (QFilter[])new QFilter[]{qfIds}, (String)"begindate");
        if (period.size() == 0) {
            return null;
        }
        date.put("begindate", ((DynamicObject)period.get(0)).getDate("begindate"));
        date.put("enddate", ((DynamicObject)period.get(period.size() - 1)).getDate("enddate"));
        return date;
    }

    public static Map<Long, Date> getEndDateByPeriod(Set<Long> periodIds) {
        HashMap<Long, Date> date = new HashMap<Long, Date>(10);
        QFilter qfIds = new QFilter("id", "in", periodIds);
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id,enddate", (QFilter[])new QFilter[]{qfIds});
        if (periods.size() == 0) {
            return null;
        }
        for (DynamicObject period : periods) {
            date.put(period.getLong("id"), period.getDate("enddate"));
        }
        return date;
    }

    public static Map<String, Date> getPeriodBeginDateAndEndDate(DynamicObject period) {
        HashMap<String, Date> resultPeriod = new HashMap<String, Date>(16);
        Date beginDate = period.getDate("begindate");
        Date endDate = period.getDate("enddate");
        resultPeriod.put("begindate", beginDate);
        Date curDate = TimeServiceHelper.now();
        if (beginDate.compareTo(curDate) <= 0 && curDate.compareTo(endDate) <= 0) {
            resultPeriod.put("enddate", curDate);
        } else {
            resultPeriod.put("enddate", endDate);
        }
        return resultPeriod;
    }

    public static Date[] getPeriodStartAndEndTime(Long periodId) {
        ArrayList<String> selectFields = new ArrayList<String>(2);
        selectFields.add("begindate");
        selectFields.add("enddate");
        MainEntityType type = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"bd_period", selectFields);
        Map periods = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{periodId}, (DynamicObjectType)type);
        if (CadEmptyUtils.isEmpty(periods)) {
            return null;
        }
        DynamicObject period = (DynamicObject)periods.get(periodId);
        if (period == null) {
            return null;
        }
        Date[] dates = new Date[]{period.getDate("begindate"), period.getDate("enddate")};
        return dates;
    }

    public static Map<Long, Date> getPeriodLastDate() {
        HashMap<Long, Date> date = new HashMap<Long, Date>(100);
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id,enddate", (QFilter[])new QFilter[0]);
        if (periods.size() == 0) {
            return null;
        }
        for (DynamicObject period : periods) {
            date.put(period.getLong("id"), period.getDate("enddate"));
        }
        return date;
    }

    public static List<ComboItem> getCurPrePre(Long org) {
        ArrayList periods = Lists.newArrayList();
        if (org != null) {
            DynamicObject period = PeriodHelper.getCurrentPeriod(org);
            if (PeriodHelper.getComboItem(period) != null) {
                periods.add(PeriodHelper.getComboItem(period));
            }
            if (period != null) {
                DynamicObject prePrePeriod;
                DynamicObject prePeriod = PeriodHelper.getPreviousPeriod(period.getLong("id"));
                if (PeriodHelper.getComboItem(prePeriod) != null) {
                    periods.add(PeriodHelper.getComboItem(prePeriod));
                }
                if (prePeriod != null && PeriodHelper.getComboItem(prePrePeriod = PeriodHelper.getPreviousPeriod(prePeriod.getLong("id"))) != null) {
                    periods.add(PeriodHelper.getComboItem(prePrePeriod));
                }
            }
        }
        return periods;
    }

    private static ComboItem getComboItem(DynamicObject period) {
        if (period != null) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(period.getString("name")));
            comboItem.setValue(period.getString("id"));
            return comboItem;
        }
        return null;
    }

    public static DynamicObject getMaxCurrentPeriod(List<Long> costAccountIDs) {
        String fields = "org,entry.currentperiod";
        QFilter filter = new QFilter("entry.costaccount.id", "in", costAccountIDs);
        DynamicObject[] sysPeriods = BusinessDataServiceHelper.load((String)"cal_sysctrlentity", (String)fields, (QFilter[])new QFilter[]{filter});
        if (sysPeriods == null) {
            return null;
        }
        DynamicObject maxPeriod = null;
        for (DynamicObject sysPeriod : sysPeriods) {
            DynamicObjectCollection entrys = sysPeriod.getDynamicObjectCollection("entry");
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entryInfo = (DynamicObject)entrys.get(i);
                DynamicObject currentPeriod = entryInfo.getDynamicObject("currentperiod");
                maxPeriod = maxPeriod == null ? currentPeriod : (PeriodHelper.compare2period(maxPeriod, currentPeriod) == -1 ? currentPeriod : maxPeriod);
            }
        }
        return maxPeriod;
    }

    public static Long getMaxPeriodByAcctOrg(Long acctOrg, String appnum) {
        DynamicObject period;
        List<Long> costaccountList = CostAccountHelper.getOrgUseStdCostAccount(acctOrg, appnum);
        if (costaccountList.size() > 0 && (period = PeriodHelper.getMaxCurrentPeriod(costaccountList)) != null) {
            return period.getLong("id");
        }
        return 0L;
    }

    public static Set<DynamicObject> getPeriodsByAcctOrg(Long acctOrg, String appnum) {
        Set<Object> curPeriods = Sets.newHashSet();
        List<Long> costaccountList = CostAccountHelper.getOrgUseStdCostAccount(acctOrg, appnum);
        if (costaccountList.size() > 0) {
            curPeriods = PeriodHelper.getAccountCurrentPeriods(new HashSet<Long>(costaccountList));
        }
        return curPeriods;
    }

    public static boolean isCurPeriodBizDate(Date bizeDate, Long acctOrg, String appNum) {
        boolean isCurPeriodBizDate = false;
        Set<DynamicObject> curPeriods = PeriodHelper.getPeriodsByAcctOrg(acctOrg, appNum);
        for (DynamicObject period : curPeriods) {
            Date beginDate = period.getDate("beginDate");
            Date enddate = period.getDate("enddate");
            if (bizeDate.compareTo(beginDate) < 0 || bizeDate.compareTo(enddate) > 0) continue;
            isCurPeriodBizDate = true;
            break;
        }
        return isCurPeriodBizDate;
    }

    public static Map<Long, Date[]> getPeriodStartAndEndTime(Set<Long> periodIds) {
        HashMap<Long, Date[]> periodStartEndTime = new HashMap<Long, Date[]>(periodIds.size());
        ArrayList<String> selectFields = new ArrayList<String>(2);
        selectFields.add("begindate");
        selectFields.add("enddate");
        selectFields.add("id");
        MainEntityType type = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"bd_period", selectFields);
        Map periods = BusinessDataServiceHelper.loadFromCache((Object[])periodIds.toArray(new Object[0]), (DynamicObjectType)type);
        if (!CadEmptyUtils.isEmpty(periods)) {
            for (Long periodId : periodIds) {
                DynamicObject period = (DynamicObject)periods.get(periodId);
                if (period == null) continue;
                Date[] dates = new Date[]{period.getDate("begindate"), period.getDate("enddate")};
                periodStartEndTime.put(periodId, dates);
            }
        }
        return periodStartEndTime;
    }

    public static DynamicObjectCollection getSysCtrlEntity(List<Long> costAccountIds) {
        QFilter filter = new QFilter("entry.costaccount", "in", costAccountIds);
        String selects = "org orgid,entry.costaccount acctid,entry.calpolicy.periodtype periodtype,entry.startperiod startperiod,entry.currentperiod currentperiod";
        DynamicObjectCollection sysPeriods = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)selects, (QFilter[])new QFilter[]{filter});
        return sysPeriods;
    }

    public static Set<Long> getCurPeriodYear(Long curPeriodId) {
        HashSet<Long> periodSet = new HashSet<Long>(10);
        if (curPeriodId == null) {
            return periodSet;
        }
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)curPeriodId, (DynamicObjectType)type);
        if (currPeriod == null) {
            return periodSet;
        }
        Object periodtypeid = currPeriod.getDynamicObject("periodtype").getPkValue();
        QFilter filter = new QFilter("periodtype.id", "=", periodtypeid);
        filter.and("periodyear", "=", (Object)currPeriod.getInt("periodyear"));
        filter.and("periodnumber", "<=", (Object)currPeriod.getInt("periodnumber"));
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])filter.toArray(), null);
        if (cols.size() > 0) {
            for (DynamicObject dyn : cols) {
                periodSet.add(dyn.getLong("id"));
            }
        }
        return periodSet;
    }

    public static List<Long> getPeriodIdByType(Long curPeriodId, String gainType) {
        String entityName = "bd_period";
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)curPeriodId, (DynamicObjectType)type);
        if (currPeriod == null) {
            return new ArrayList<Long>(0);
        }
        return PeriodHelper.getPeriodIdByType(currPeriod, gainType);
    }

    public static List<Long> getPeriodIdByType(DynamicObject curPeriodDyn, String gainType) {
        if (curPeriodDyn == null) {
            return new ArrayList<Long>(0);
        }
        return PeriodHelper.getPeriodIdByType(curPeriodDyn.getLong("periodtype.id"), curPeriodDyn.getInt("periodyear"), curPeriodDyn.getInt("periodnumber"), gainType);
    }

    private static List<Long> getPeriodIdByType(Long periodType, int periodyear, int periodnumber, String gainType) {
        int i;
        ArrayList<Integer> periodnums;
        QFilter periodFilter = new QFilter("periodtype", "=", (Object)periodType);
        if ("1".equals(gainType)) {
            periodFilter.and("periodyear", "=", (Object)(periodyear - 1 < 0 ? -1 : periodyear - 1));
            periodFilter.and("periodnumber", "=", (Object)periodnumber);
        }
        if ("2".equals(gainType)) {
            periodnums = new ArrayList<Integer>(10);
            for (i = 1; i <= periodnumber; ++i) {
                periodnums.add(i);
            }
            periodFilter.and("periodyear", "=", (Object)periodyear);
            periodFilter.and("periodnumber", "in", periodnums);
        }
        if ("3".equals(gainType)) {
            periodnums = new ArrayList(10);
            for (i = 1; i <= periodnumber; ++i) {
                periodnums.add(i);
            }
            periodFilter.and("periodyear", "=", (Object)(periodyear - 1));
            periodFilter.and("periodnumber", "in", periodnums);
        }
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])periodFilter.toArray());
        ArrayList<Long> list = new ArrayList<Long>(12);
        periods.forEach(p -> list.add(p.getLong("id")));
        return list;
    }

    public static Set<Long> getYearByCostAccount(long costAccountId) {
        HashSet<Long> set = new HashSet<Long>(12);
        QFilter periodFilter = new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0'));
        QFilter startPeriodFilter = StartCostHelper.getPlanPeriodFilter(costAccountId);
        periodFilter.and(startPeriodFilter);
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])periodFilter.toArray());
        periods.forEach(p -> set.add(p.getLong("periodyear")));
        return set;
    }

    public static Set<Long> getYearByPeriod(List<Long> periodIds) {
        HashSet<Long> set = new HashSet<Long>(12);
        QFilter periodFilter = new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0'));
        QFilter qfIds = new QFilter("id", "in", periodIds);
        periodFilter.and(qfIds);
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])periodFilter.toArray());
        periods.forEach(p -> set.add(p.getLong("periodyear")));
        return set;
    }

    public static Set<Long> getNumberByTypeYear(long periodType, long periodYear) {
        QFilter periodFilter = new QFilter("periodtype", "=", (Object)periodType);
        periodFilter.and(new QFilter("periodyear", "=", (Object)periodYear));
        periodFilter.and(new QFilter("isadjustperiod", "=", (Object)Character.valueOf('0')));
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear,periodnumber", (QFilter[])periodFilter.toArray());
        HashSet<Long> set = new HashSet<Long>(12);
        periods.forEach(p -> set.add(p.getLong("periodnumber")));
        return set;
    }
}

