/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.AppMetadataCache;
import kd.bos.mutex.DataMutex;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PermissionHelper {
    public static List<Long> getUserPermOrgs(Long userId, String entityNum, String permItem) {
        return PermissionHelper.getUserPermOrgs(userId, entityNum, permItem, "0DDNKGUZRMR8");
    }

    public static List<Long> getUserPermOrgs(Long userId, String entityNum, String permItem, String appnum) {
        HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appnum, (String)entityNum, (String)permItem);
        if (!rs.hasAllOrgPerm()) {
            return rs.getHasPermOrgs();
        }
        return null;
    }

    public static boolean checkPermission(Long userId, Long costTypeId, String entityNum, String permItem) {
        List<Long> permorgs = PermissionHelper.getUserPermOrgs(userId, entityNum, permItem);
        if (permorgs == null) {
            return true;
        }
        List<Long> costTypeOrgs = CostTypeHelper.getCalcOrgByCostType(costTypeId);
        if (costTypeOrgs != null && costTypeOrgs.size() > 0) {
            for (int index = 0; index < costTypeOrgs.size(); ++index) {
                if (!permorgs.contains(costTypeOrgs.get(index))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkPermission(String appId, long orgId, String entityId, String permitItemKey) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (CadEmptyUtils.isEmpty(appId)) {
            appId = "sca";
        }
        String appInnerId = AppMetadataCache.getAppInfo((String)appId).getId();
        int i = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)appInnerId, (String)entityId, (String)permitItemKey);
        return i == 1;
    }

    public static boolean checkOrgPermission(Long userId, Long orgId, String entityNum, String permItem) {
        return PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)"0DDNKGUZRMR8", (String)entityNum, (String)permItem) == 1;
    }

    public static Boolean isLock(String dataObjId, String groupId, String entityKey) {
        DataMutex dataMutex = DataMutex.create();
        Map lockInfo = dataMutex.getLockInfo(dataObjId, groupId, entityKey);
        if (CadEmptyUtils.isEmpty(lockInfo)) {
            return false;
        }
        return true;
    }

    public static Map<String, String> getLockInfo(String dataObjId, String groupId, String entityKey) {
        if (CadEmptyUtils.isEmpty(dataObjId)) {
            return null;
        }
        DataMutex dataMutex = DataMutex.create();
        return dataMutex.getLockInfo(dataObjId, groupId, entityKey);
    }
}

