/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PlanFeeAllocHelper {
    public static final String SUMTYPE_DIRECT = "DIRECT";
    public static final String SUMTYPE_SUMMARY = "SUMMARY";

    public static List<Long> getPlanEnableSchemeList(Long costaccountId) {
        QFilter qFilter = new QFilter("costaccount", "=", (Object)costaccountId);
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"PlanFeeAllocHelper-getPlanEnableSchemeList", (String)"cad_planscheme", (String)"id", (QFilter[])qFilter.toArray(), (String)"modifytime desc");
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (Row row : resultDs) {
            ids.add(row.getLong("id"));
        }
        return ids;
    }

    public static String getPeriodDateRange(Long schemeId) {
        String dateRange = "";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        DynamicObject dynamicObj = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"cad_planscheme");
        if (dynamicObj != null) {
            DynamicObjectCollection entryentity = dynamicObj.getDynamicObjectCollection("entryentity");
            for (int index = entryentity.size() - 1; index >= 0; --index) {
                DynamicObject dyn = (DynamicObject)entryentity.get(index);
                if (!dyn.getBoolean("enabled") || dyn.getBoolean("close")) continue;
                String excutemethod = dyn.getString("excutemethod");
                if (SUMTYPE_SUMMARY.equals(excutemethod)) {
                    dateRange = simpleDateFormat.format(dyn.getDate("startperiod.begindate"));
                    dateRange = dateRange.concat("\uff5e").concat(simpleDateFormat.format(dyn.getDate("startperiod.enddate")));
                    break;
                }
                dateRange = simpleDateFormat.format(dyn.getDate("startperiod.begindate"));
                dateRange = dateRange.concat("\uff5e").concat(simpleDateFormat.format(dyn.getDate("endperiod.enddate")));
                break;
            }
        }
        return dateRange;
    }

    public static String checkPeriodClosed(Long schemeId, Long periodId) {
        DynamicObject dynamicObj = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"cad_planscheme");
        String errorMsg = "";
        boolean inPeriodRange = false;
        if (dynamicObj != null) {
            DynamicObjectCollection entryentity = dynamicObj.getDynamicObjectCollection("entryentity");
            for (int index = entryentity.size() - 1; index >= 0; --index) {
                DynamicObject dyn = (DynamicObject)entryentity.get(index);
                String excutemethod = dyn.getString("excutemethod");
                if (SUMTYPE_SUMMARY.equals(excutemethod)) {
                    if (periodId.longValue() != dyn.getLong("startperiod.id")) continue;
                    inPeriodRange = true;
                    if (dyn.getBoolean("enabled") && !dyn.getBoolean("close")) continue;
                    errorMsg = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u975e\u5df2\u542f\u7528\u672a\u9501\u5b9a\u7684\u671f\u95f4\u8303\u56f4\u4e0d\u5141\u8bb8\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PlanFeeAllocHelper_0", (String)"macc-cad-common", (Object[])new Object[0]);
                    break;
                }
                if (periodId < dyn.getLong("startperiod.id") || periodId > dyn.getLong("endperiod.id")) continue;
                inPeriodRange = true;
                if (dyn.getBoolean("enabled") && !dyn.getBoolean("close")) continue;
                errorMsg = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u975e\u5df2\u542f\u7528\u672a\u9501\u5b9a\u7684\u671f\u95f4\u8303\u56f4\u4e0d\u5141\u8bb8\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PlanFeeAllocHelper_0", (String)"macc-cad-common", (Object[])new Object[0]);
                break;
            }
        }
        if (!inPeriodRange) {
            errorMsg = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u975e\u5df2\u542f\u7528\u672a\u9501\u5b9a\u7684\u671f\u95f4\u8303\u56f4\u4e0d\u5141\u8bb8\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PlanFeeAllocHelper_0", (String)"macc-cad-common", (Object[])new Object[0]);
        }
        return errorMsg;
    }

    public static String checkPlanLastEnablePeriodClosed(Long schemeId) {
        DynamicObject dynamicObj = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"cad_planscheme");
        boolean existEnableUnClose = false;
        String errorMsg = "";
        if (dynamicObj != null) {
            DynamicObjectCollection entryentity = dynamicObj.getDynamicObjectCollection("entryentity");
            for (int index = entryentity.size() - 1; index >= 0; --index) {
                DynamicObject dyn = (DynamicObject)entryentity.get(index);
                if (!dyn.getBoolean("enabled") || dyn.getBoolean("close")) continue;
                existEnableUnClose = true;
                break;
            }
            if (!existEnableUnClose) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u65b9\u6848\u201c%1$s/%2$s\u201d\u4e0b\uff0c\u4e0d\u5b58\u5728\u5df2\u542f\u7528\u4e14\u672a\u9501\u5b9a\u7684\u671f\u95f4\u8303\u56f4\u3002", (String)"PlanFeeAllocHelper_1", (String)"macc-cad-common", (Object[])new Object[0]), dynamicObj.getString("number"), dynamicObj.getString("name"));
            }
        }
        return errorMsg;
    }

    public static List<Long> getPlanLastEnablePeriods(Long schemeId) {
        DynamicObject dynamicObj = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"cad_planscheme");
        ArrayList<Long> periodIds = new ArrayList<Long>(10);
        if (dynamicObj == null) {
            return periodIds;
        }
        DynamicObjectCollection entryentity = dynamicObj.getDynamicObjectCollection("entryentity");
        for (int index = entryentity.size() - 1; index >= 0; --index) {
            DynamicObject dyn = (DynamicObject)entryentity.get(index);
            if (!dyn.getBoolean("enabled") || dyn.getBoolean("close")) continue;
            Long startperiod = dyn.getLong("startperiod.id");
            Long endperiod = dyn.getLong("endperiod.id");
            String excutemethod = dyn.getString("excutemethod");
            if (SUMTYPE_SUMMARY.equals(excutemethod)) {
                periodIds.add(startperiod);
                break;
            }
            Long periodType = dyn.getLong("startperiod.periodtype.id");
            QFilter periodFilter = new QFilter("periodtype", "=", (Object)periodType);
            periodFilter.and("id", ">=", (Object)startperiod);
            periodFilter.and("id", "<=", (Object)endperiod);
            periodFilter.and("isadjustperiod", "=", (Object)false);
            DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])periodFilter.toArray(), (String)"id asc");
            periods.forEach(p -> periodIds.add(p.getLong("id")));
            break;
        }
        return periodIds;
    }

    public static List<Long> getPlanStartPeriods(Long schemeId) {
        return PlanFeeAllocHelper.getPeriodIds(schemeId, true, false);
    }

    private static List<Long> getPeriodIds(Long schemeId, Boolean enable, Boolean close) {
        QFilter qFilter = new QFilter("id", "=", (Object)schemeId);
        if (enable != null) {
            qFilter.and("entryentity.enabled", "=", (Object)enable);
        }
        if (close != null) {
            qFilter.and("entryentity.close", "=", (Object)close);
        }
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"PlanFeeAllocHelper-queryPeriod", (String)"cad_planscheme", (String)"entryentity.excutemethod excutemethod,entryentity.startperiod.periodtype periodtype,entryentity.startperiod startperiod,entryentity.endperiod endperiod,entryentity.enabled enable,entryentity.close close", (QFilter[])qFilter.toArray(), null);
        ArrayList<Long> periodIds = new ArrayList<Long>(10);
        if (resultDs.isEmpty()) {
            return periodIds;
        }
        for (Row row : resultDs) {
            Long periodType = row.getLong("periodtype");
            Long startperiod = row.getLong("startperiod");
            Long endperiod = row.getLong("endperiod");
            String excutemethod = row.getString("excutemethod");
            if (SUMTYPE_SUMMARY.equals(excutemethod) || startperiod.equals(endperiod)) {
                periodIds.add(startperiod);
                continue;
            }
            QFilter periodFilter = new QFilter("periodtype", "=", (Object)periodType);
            periodFilter.and("id", ">=", (Object)startperiod);
            periodFilter.and("id", "<=", (Object)endperiod);
            periodFilter.and(new QFilter("isadjustperiod", "=", (Object)false));
            DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])periodFilter.toArray());
            periods.forEach(p -> periodIds.add(p.getLong("id")));
        }
        return periodIds;
    }

    public static Date[] getPlanStartPeriodBeginAndEndDate(Long schemeId) {
        QFilter qFilter = new QFilter("id", "=", (Object)schemeId);
        qFilter.and("entryentity.enabled", "=", (Object)true);
        qFilter.and("entryentity.close", "=", (Object)false);
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"PlanFeeAllocHelper-queryPeriod", (String)"cad_planscheme", (String)"entryentity.excutemethod excutemethod,entryentity.startperiod.begindate begindate,entryentity.startperiod.enddate stenddate,entryentity.endperiod.enddate enddate", (QFilter[])qFilter.toArray(), null);
        if (resultDs.isEmpty()) {
            return null;
        }
        Date[] date = null;
        for (Row row : resultDs) {
            String excutemethod = row.getString("excutemethod");
            if (SUMTYPE_SUMMARY.equals(excutemethod)) {
                date = new Date[]{row.getDate("begindate"), row.getDate("stenddate")};
                continue;
            }
            date = new Date[]{row.getDate("begindate"), row.getDate("enddate")};
        }
        return date;
    }

    public static List<Long> getPlanStartAllPeriods(Long schemeId) {
        return PlanFeeAllocHelper.getPeriodIds(schemeId, Boolean.TRUE, null);
    }

    public static List<Long> getAllPeriodsNoSummaryHandle(Long schemeId) {
        QFilter qFilter = new QFilter("id", "=", (Object)schemeId);
        qFilter.and("entryentity.enabled", "=", (Object)true);
        DataSet resultDs = QueryServiceHelper.queryDataSet((String)"PlanFeeAllocHelper-queryPeriod", (String)"cad_planscheme", (String)"entryentity.excutemethod excutemethod,entryentity.startperiod.periodtype periodtype,entryentity.startperiod startperiod,entryentity.endperiod endperiod,entryentity.enabled enable,entryentity.close close", (QFilter[])qFilter.toArray(), null);
        ArrayList<Long> periodIds = new ArrayList<Long>(10);
        if (resultDs.isEmpty()) {
            return periodIds;
        }
        for (Row row : resultDs) {
            Long periodType = row.getLong("periodtype");
            Long startperiod = row.getLong("startperiod");
            Long endperiod = row.getLong("endperiod");
            QFilter periodFilter = new QFilter("periodtype", "=", (Object)periodType);
            periodFilter.and(new QFilter("isadjustperiod", "=", (Object)false));
            periodFilter.and("id", ">=", (Object)startperiod);
            periodFilter.and("id", "<=", (Object)endperiod);
            DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])periodFilter.toArray());
            periods.forEach(p -> periodIds.add(p.getLong("id")));
        }
        return periodIds;
    }

    public static List<Map<String, Date>> getImportScopeDate(Long schemeId) {
        ArrayList<Map<String, Date>> importScopeList = new ArrayList<Map<String, Date>>();
        HashMap<String, Date> importScopeDate = new HashMap<String, Date>(16);
        DynamicObject dynamicObj = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"cad_planscheme");
        DynamicObjectCollection entryentity = dynamicObj.getDynamicObjectCollection("entryentity");
        for (int index = entryentity.size() - 1; index >= 0; --index) {
            DynamicObject dyn = (DynamicObject)entryentity.get(index);
            if (!dyn.getBoolean("enabled") || dyn.getBoolean("close")) continue;
            String excutemethod = dyn.getString("excutemethod");
            Date startDate = dyn.getDynamicObject("startperiod").getDate("begindate");
            Date endDate = dyn.getDynamicObject("endperiod").getDate("enddate");
            if (SUMTYPE_SUMMARY.equals(excutemethod)) {
                endDate = dyn.getDynamicObject("startperiod").getDate("enddate");
            }
            importScopeDate.put("start", startDate);
            importScopeDate.put("end", endDate);
            importScopeList.add(importScopeDate);
            break;
        }
        return importScopeList;
    }

    public static boolean checkPlanSchemeEnableUnclose(Long schemeId) {
        boolean existEnableUnclosePeriods = false;
        DynamicObject dynamicObj = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"cad_planscheme");
        DynamicObjectCollection entryentity = dynamicObj.getDynamicObjectCollection("entryentity");
        for (int index = entryentity.size() - 1; index >= 0; --index) {
            DynamicObject dyn = (DynamicObject)entryentity.get(index);
            if (!dyn.getBoolean("enabled") || dyn.getBoolean("close")) continue;
            existEnableUnclosePeriods = true;
            break;
        }
        return existEnableUnclosePeriods;
    }

    public static List<Long> getPlanSchemeEnableUnclosePeriods(Long schemeId) {
        ArrayList periodIds = Lists.newArrayList();
        DynamicObject dynamicObj = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"cad_planscheme");
        DynamicObjectCollection entryentity = dynamicObj.getDynamicObjectCollection("entryentity");
        for (int index = entryentity.size() - 1; index >= 0; --index) {
            DynamicObject dyn = (DynamicObject)entryentity.get(index);
            if (!dyn.getBoolean("enabled") || dyn.getBoolean("close")) continue;
            QFilter periodFilter = new QFilter("periodtype", "=", (Object)dyn.getDynamicObject("startperiod").getLong("periodtype.id"));
            periodFilter.and(new QFilter("isadjustperiod", "=", (Object)false));
            periodFilter.and("id", ">=", (Object)dyn.getLong("startperiod.id"));
            periodFilter.and("id", "<=", (Object)dyn.getLong("endperiod.id"));
            String excutemethod = dyn.getString("excutemethod");
            if (SUMTYPE_SUMMARY.equals(excutemethod)) {
                periodIds.add(dyn.getLong("startperiod.id"));
                break;
            }
            DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])periodFilter.toArray());
            periods.forEach(p -> periodIds.add(p.getLong("id")));
            break;
        }
        return periodIds;
    }
}

