/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.MfgFeeReportConfig;
import kd.macc.cad.common.dto.PlanFeeImportReport;
import kd.macc.cad.common.dto.ProgressParamDto;
import kd.macc.cad.common.enums.BgParamEnum;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.enums.ScaMfgFeeImpSchEnum;
import kd.macc.cad.common.enums.SrcBillEnum;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.AccountViewHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.output.ExecuteResult;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PlanfeeBillImportHelper {
    private static final String ALGO_KEY_CLASS_NAME = PlanfeeBillImportHelper.class.getCanonicalName();
    private static final Log logger = LogFactory.getLog(PlanfeeBillImportHelper.class);
    private static final int idCapacity = 1300;
    private static final String GL = "gl";
    private static final String AP = "ap";
    private static final Integer BATCH_SIZE = 85;
    private static final String FEEIMPSCH_FILEDS = "id,billno,org,costaccount,manuorg,srcbizsys,accountbook,srcbill,accountview,accountviews,assgrp,entryentity.costcentertype,costcenter,expenseitemtype,expenseitem,amount,productgroup";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecuteResult importPlanFeeBillBySys(Long orgId, Set<Long> costAccountSet, List<Object> costCenterIdList, Map<String, Object> paramMap, String progressId) {
        PlanfeeBillImportHelper.refreshProgress(ResManager.loadKDString((String)"\u8ba1\u5212\u8d39\u7528\u5f52\u96c6\u5f00\u59cb", (String)"PlanfeeBillImportHelper_0", (String)"macc-cad-common", (Object[])new Object[0]), 1, 3, false, progressId);
        ExecuteResult result = new ExecuteResult();
        PlanFeeImportReport report = null;
        try {
            ExecuteResult executeResult;
            Object paramReport = paramMap.get("report");
            if (paramReport == null) {
                report = new PlanFeeImportReport();
                paramMap.put("report", report);
            } else {
                report = (PlanFeeImportReport)paramReport;
            }
            PlanfeeBillImportHelper.buildCostCenterManuOrgMap(orgId, paramMap);
            PlanfeeBillImportHelper.addCurrency(paramMap, costAccountSet);
            PlanfeeBillImportHelper.addCurrentPeriodLastDate(paramMap, costAccountSet);
            paramMap.put("currDate", new Date());
            ArrayList saveBillList = new ArrayList(100);
            boolean isCheck = paramMap.get("operation") != null && "check".equals(paramMap.get("operation"));
            int successQty = 0;
            String isCollConfig = "";
            PlanfeeBillImportHelper.refreshProgress(ResManager.loadKDString((String)"\u5904\u7406\u6210\u672c\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u5f15\u5165", (String)"PlanfeeBillImportHelper_1", (String)"macc-cad-common", (Object[])new Object[0]), 2, 3, false, progressId);
            if (!isCheck) {
                ArrayList importCostCenterIds = new ArrayList();
                costCenterIdList.forEach(p -> importCostCenterIds.add(Long.parseLong(p.toString())));
                report.logReportDetail(ResManager.loadKDString((String)"\u8c03\u7528\u6210\u672c\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u8ba1\u5212\u8d39\u7528\u5f52\u96c6\u670d\u52a1\u8fdb\u884c\u5f52\u96c6", (String)"PlanfeeBillImportHelper_2", (String)"macc-cad-common", (Object[])new Object[0]));
                Map resultInfo = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"mfgFeeService", (String)"importMfgBills", (Object[])new Object[]{orgId, costAccountSet, importCostCenterIds, "cad_planfeebill", paramMap});
                successQty = StringUtils.isEmpty((CharSequence)((CharSequence)resultInfo.get("successQty"))) ? 0 : Integer.parseInt((String)resultInfo.get("successQty"));
                isCollConfig = StringUtils.isEmpty((CharSequence)((CharSequence)resultInfo.get("isCollConfig"))) ? " " : String.valueOf(resultInfo.get("isCollConfig"));
                report.logCheckDesc(String.format(ResManager.loadKDString((String)"\u8c03\u7528\u6210\u672c\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u8ba1\u5212\u8d39\u7528\u5f52\u96c6\u670d\u52a1\u5f52\u96c6\u5230\u6570\u636e\u3010%s\u3011\u6761", (String)"PlanfeeBillImportHelper_3", (String)"macc-cad-common", (Object[])new Object[0]), successQty));
            }
            if ("false".equals(isCollConfig)) {
                report.logTip(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8ba1\u5212\u8d39\u7528\u5f15\u5165\u65b9\u6848\u6216\u6210\u672c\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u3002 ", (String)"PlanfeeBillImportHelper_4", (String)"macc-cad-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8ba1\u5212\u8d39\u7528\u5f15\u5165\u65b9\u6848\u6216\u6210\u672c\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u3002 ", (String)"PlanfeeBillImportHelper_4", (String)"macc-cad-common", (Object[])new Object[0]));
                result.setFalseNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u8ba1\u5212\u8d39\u7528\u5f15\u5165\u65b9\u6848\u6216\u6210\u672c\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u3002 ", (String)"PlanfeeBillImportHelper_4", (String)"macc-cad-common", (Object[])new Object[0]));
                executeResult = result;
                return executeResult;
            }
            if (isCheck) {
                paramMap.put("checkResult", saveBillList);
                executeResult = result;
                return executeResult;
            }
            if (CadEmptyUtils.isEmpty(saveBillList) && successQty == 0) {
                result.setFalseNotification(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u5f15\u5165\u6570\u636e\u3002\u8bf7\u68c0\u67e5\uff1a%1$s 1\u3001\u6765\u6e90\u5355\u636e\u5df2\u7ecf\u5168\u90e8\u5f15\u5165\uff1b%2$s 2\u3001\u6210\u672c\u4e2d\u5fc3\u5bf9\u5e94\u5173\u7cfb\u7ef4\u62a4\u7684\u6b63\u786e\u6027\uff1b%3$s 3\u3001\u6570\u636e\u89c4\u5219\u65b9\u6848\u914d\u7f6e\u7684\u6b63\u786e\u6027\uff1b%4$s 4\u3001\u5728\u542f\u7528\u6570\u636e\u89c4\u5219\u65b9\u6848\u7684\u524d\u63d0\u4e0b\uff0c\u5f15\u5165\u6240\u9009\u6210\u672c\u4e2d\u5fc3\u5728\u6570\u636e\u89c4\u5219\u7684\u8303\u56f4\u5185\u3002", (String)"PlanfeeBillImportHelper_5", (String)"macc-cad-common", (Object[])new Object[0]), "\n", "\n", "\n", "\n"));
                executeResult = result;
                return executeResult;
            }
            CodeRuleServiceHelper.injectNumbers((String)"cad_planfeebill", saveBillList);
            report.logReportDetail(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f15\u5165\u7684\u5f52\u96c6\u5355", (String)"PlanfeeBillImportHelper_6", (String)"macc-cad-common", (Object[])new Object[0]));
            PlanfeeBillImportHelper.refreshProgress(ResManager.loadKDString((String)"\u4fdd\u5b58\u5f15\u5165\u7684\u5f52\u96c6\u5355", (String)"PlanfeeBillImportHelper_6", (String)"macc-cad-common", (Object[])new Object[0]), 3, 3, false, progressId);
            SaveServiceHelper.save((DynamicObject[])saveBillList.toArray(new DynamicObject[0]));
            report.logCheckDesc(String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u5f20\u5f52\u96c6\u5355\u4fdd\u5b58\u6210\u529f", (String)"PlanfeeBillImportHelper_7", (String)"macc-cad-common", (Object[])new Object[0]), saveBillList.size()));
            result.setSuccessQty(saveBillList.size() + successQty);
            result.setSuccessNotificatio(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u6210\u529f\u3010%s\u3011\u6761\u6570\u636e\u3002 ", (String)"PlanfeeBillImportHelper_8", (String)"macc-cad-common", (Object[])new Object[0]), saveBillList.size() + successQty));
        }
        catch (Exception e) {
            String errorMsg = ResManager.loadKDString((String)"\u5185\u90e8\u7cfb\u7edf\u9519\u8bef", (String)"PlanfeeBillImportHelper_9", (String)"macc-cad-common", (Object[])new Object[0]);
            report.logError(e, errorMsg);
            result.setFalseNotification(ResManager.loadKDString((String)"\u5f52\u96c6\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u5f52\u96c6\u62a5\u544a\u3002", (String)"PlanfeeBillImportHelper_10", (String)"macc-cad-common", (Object[])new Object[0]));
        }
        finally {
            PlanfeeBillImportHelper.refreshProgress(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u5f52\u96c6\u7ed3\u675f", (String)"PlanfeeBillImportHelper_11", (String)"macc-cad-common", (Object[])new Object[0]), -1, 0, false, progressId);
        }
        return result;
    }

    protected static void refreshProgress(String opContent, int nowComplete, int total, Boolean isAddNum, String progressId) {
        ProgressParamDto paramDto = ProgressHelper.getProgressParam(progressId);
        if (paramDto == null) {
            return;
        }
        paramDto.setOpContent(opContent);
        if (isAddNum.booleanValue()) {
            Integer complete = paramDto.getComplete();
            paramDto.setComplete(complete + nowComplete);
        } else {
            paramDto.setComplete(nowComplete);
        }
        if (!CadEmptyUtils.isEmpty(total)) {
            paramDto.setTotal(total);
        }
        paramDto.setUnit(ResManager.loadKDString((String)"\u6b65", (String)"PlanfeeBillImportHelper_12", (String)"macc-cad-common", (Object[])new Object[0]));
        paramDto.setDurationTimes(0);
        if (nowComplete == -1) {
            paramDto.setComplete(paramDto.getTotal());
        }
        ProgressHelper.setProgressParam(progressId, paramDto);
    }

    private static void buildCostCenterManuOrgMap(Long orgId, Map<String, Object> paramMap) {
        DynamicObjectCollection centerManyByManuOrgs;
        boolean orgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory(orgId);
        if (orgEnableMultiFactory && !CadEmptyUtils.isEmpty(centerManyByManuOrgs = OrgHelper.getCenterManyByManuOrgIds(orgId, null, (String)paramMap.get("appnum")))) {
            HashMap<Long, Long> centerManuMap = new HashMap<Long, Long>();
            for (DynamicObject dynamicObject : centerManyByManuOrgs) {
                long centerId = dynamicObject.getLong("costcenterid");
                centerManuMap.put(centerId, dynamicObject.getLong("manuorg"));
            }
            paramMap.put("centerManuMap", centerManuMap);
        }
    }

    private static void getBeforeBusAmount(Long orgId, DataSet dataSet, Map<String, Object> paramMap, DynamicObject mfgFeeImpSch) {
        HashMap<String, BigDecimal> beforeBusAmount = new HashMap<String, BigDecimal>();
        if (!dataSet.isEmpty()) {
            String field;
            long impSachId = mfgFeeImpSch.getLong("id");
            HashSet<String> srcNumbers = new HashSet<String>(50);
            HashSet<Long> seqs = new HashSet<Long>(50);
            for (Row next : dataSet) {
                srcNumbers.add(next.getString("corebillno"));
                seqs.add(next.getLong("corebillentryseq"));
            }
            String srcBill = mfgFeeImpSch.getString("srcbill");
            String periodId = String.valueOf(paramMap.get(mfgFeeImpSch.getString("costaccount.id")));
            Map dataRange = (Map)paramMap.get(periodId);
            QFilter generalFilter = new QFilter("billstatus", "=", (Object)"C");
            generalFilter.and("org", "=", (Object)orgId);
            generalFilter.and("biztype.domain", "=", (Object)"5");
            for (Map.Entry entry : dataRange.entrySet()) {
                generalFilter.and("bookdate", "<", entry.getKey());
            }
            generalFilter.and("entry.e_corebillno", "in", srcNumbers);
            generalFilter.and("entry.e_corebillentryseq", "in", seqs);
            long expenId = 0L;
            boolean isProcess = SrcBillEnum.AMOUNT_CREDITLOCAL.getValue().equals(srcBill);
            if (isProcess) {
                DynamicObjectCollection entreaties = mfgFeeImpSch.getDynamicObjectCollection("entryentity");
                expenId = ((DynamicObject)entreaties.get(0)).getLong("expenseitem.id");
            }
            if (isProcess) {
                field = "billno,basecurrency as currency,'" + expenId + "' expenseitem,entry.e_localamt as e_amount,entry.e_corebillno as corebillno,entry.e_corebillentryseq as corebillentryseq,exratedate,exratetable.id as exratetableid";
                generalFilter.and("entry.e_expenseitem", "=", (Object)0L);
            } else {
                field = "billno,basecurrency as currency, entry.e_expenseitem as expenseitem,entry.e_localamt as e_amount,entry.e_corebillno as corebillno,entry.e_corebillentryseq as corebillentryseq,exratedate,exratetable.id as exratetableid";
                generalFilter.and("entry.e_expenseitem", "!=", (Object)0L);
            }
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"ap_busbill", (String)field, (QFilter[])generalFilter.toArray(), null);
            if (paramMap.get(impSachId + "@rate") == null) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    String orderObjKey = dynamicObject.getString("corebillno") + "@" + dynamicObject.getString("corebillentryseq");
                    Long costObjKey = PlanfeeBillImportHelper.getCostObjectKey(paramMap, orderObjKey);
                    String key = costObjKey + "@" + dynamicObject.getString("expenseitem");
                    BigDecimal amount = dynamicObject.getBigDecimal("e_amount");
                    beforeBusAmount.merge(key, amount, (a, b) -> b.add((BigDecimal)a));
                }
            } else {
                Long mfgCurrency = (Long)paramMap.get("currency" + mfgFeeImpSch.getDynamicObject("costaccount").getString("id"));
                for (DynamicObject dynamicObject : dynamicObjects) {
                    BigDecimal amount;
                    Map exchangeRateByRules;
                    String orderObjKey = dynamicObject.getString("corebillno") + "@" + dynamicObject.getString("corebillentryseq");
                    Long costObjKey = PlanfeeBillImportHelper.getCostObjectKey(paramMap, orderObjKey);
                    String key = costObjKey + "@" + dynamicObject.getString("expenseitem");
                    Long currency = dynamicObject.getLong("currency");
                    Date rateDate = dynamicObject.getDate("exratedate");
                    Long reteTableId = dynamicObject.getLong("exratetableid");
                    String rateKey = currency + "@" + mfgCurrency + "@" + reteTableId + "@" + rateDate.toString();
                    if (paramMap.get(rateKey) == null) {
                        exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)currency, (Long)mfgCurrency, (Long)reteTableId, (Date)rateDate);
                        paramMap.put(rateKey, exchangeRateByRules);
                    } else {
                        exchangeRateByRules = (Map)paramMap.get(rateKey);
                    }
                    logger.info("\u83b7\u53d6\u524d\u671f\u6682\u4f30\u5355\u6c47\u7387\u4fe1\u606f,\u6c47\u7387key==>{},\u6c47\u7387==>{}", (Object)rateKey, (Object)exchangeRateByRules);
                    Boolean quoteType = (Boolean)exchangeRateByRules.get("quoteType");
                    BigDecimal rate = (BigDecimal)exchangeRateByRules.get("exchangeRate");
                    if (rate == null || rate.compareTo(BigDecimal.ZERO) == 0) {
                        beforeBusAmount.put(key, new BigDecimal("0.00"));
                        continue;
                    }
                    if (quoteType.booleanValue()) {
                        amount = dynamicObject.getBigDecimal("e_amount").divide(rate).setScale(10, RoundingMode.HALF_UP);
                        beforeBusAmount.merge(key, amount, (a, b) -> b.add((BigDecimal)a));
                        continue;
                    }
                    amount = dynamicObject.getBigDecimal("e_amount").multiply(rate).setScale(10, RoundingMode.HALF_UP);
                    beforeBusAmount.merge(key, amount, (a, b) -> b.add((BigDecimal)a));
                }
            }
        }
        logger.info("getBeforeBusAmount beforeBusAmount ==>{}", beforeBusAmount);
        paramMap.put("beforeBusAmountMap", beforeBusAmount);
    }

    private static Map<String, BigDecimal> buildMfgFeeMapCosObj(Set<String> busBillNoSet, Map<String, Object> paramMap, DynamicObject mfgApFeeImpSach) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>();
        HashSet srcBillEntryIds = new HashSet();
        for (String billNoKey : busBillNoSet) {
            Map objMap = (Map)paramMap.get("billObjMap");
            if (objMap == null) continue;
            srcBillEntryIds.add(objMap.get(billNoKey));
        }
        String periodId = String.valueOf(paramMap.get(mfgApFeeImpSach.getString("costaccount.id")));
        Map dataRange = (Map)paramMap.get(periodId);
        QFilter filter = new QFilter("org", "=", (Object)mfgApFeeImpSach.getDynamicObject("org").getLong("id"));
        filter.and("appnum", "=", paramMap.get("appnum"));
        filter.and("srcbilltype", "=", (Object)"AP_BUS");
        for (Map.Entry entry : dataRange.entrySet()) {
            filter.and("period.begindate", "<", entry.getKey());
        }
        filter.and("costobject.probill", "in", srcBillEntryIds);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_planfeebill", (String)"id,costobject.probill as probill,expenseitem,totalamount", (QFilter[])filter.toArray());
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                Long proEntryBillId = dynamicObject.getLong("probill");
                String expenSeitem = dynamicObject.getString("expenseitem");
                BigDecimal totalAmount = dynamicObject.getBigDecimal("totalamount");
                String key = proEntryBillId + "@" + expenSeitem;
                resultMap.merge(key, totalAmount, BigDecimal::add);
            }
            logger.info("buildMfgFeeMapCosObj result ==>{}", resultMap);
            return resultMap;
        }
        return resultMap;
    }

    private static Long getCostObjectKey(Map<String, Object> paramMap, String orderObjKey) {
        Long costObjKey = 0L;
        Map objMap = (Map)paramMap.get("billObjMap");
        if (objMap == null) {
            logger.info("\u672a\u83b7\u53d6\u5230\u59d4\u5916\u5de5\u5355 ==>{}", (Object)orderObjKey);
            return costObjKey;
        }
        costObjKey = (Long)objMap.get(orderObjKey);
        if (CadEmptyUtils.isEmpty(costObjKey)) {
            logger.info("\u672a\u6839\u636e\u91c7\u8d2d\u8ba2\u5355\u83b7\u53d6\u5230\u59d4\u5916\u5de5\u5355 ==>{}", (Object)orderObjKey);
            return costObjKey;
        }
        return costObjKey;
    }

    private static void createSaveBill(List<DynamicObject> resultList, List<Row> rows, DynamicObject mfgApFeeImpSach, List<Object> costCenterIdList, Map<Long, DynamicObject> costObjectMap, Map<Long, DynamicObject> pzCostObjectMap, Map<String, Object> paramMap, Map<String, BigDecimal> mfgCostMap) {
        Row row = rows.get(0);
        String orderObjKey = row.getString("corebillno") + "@" + row.getString("corebillentryseq");
        Set noPomCoreBillSeq = (Set)paramMap.get("noPomCoreBillSeq");
        boolean hasCostObject = true;
        Object costCenterId = null;
        DynamicObject dynamicObject = null;
        Long costObjKey = null;
        if (noPomCoreBillSeq.contains(orderObjKey)) {
            hasCostObject = false;
        } else {
            costObjKey = PlanfeeBillImportHelper.getCostObjectKey(paramMap, orderObjKey);
            if (CadEmptyUtils.isEmpty(costObjKey)) {
                logger.info("\u672a\u6839\u636e\u91c7\u8d2d\u8ba2\u5355\u83b7\u53d6\u5230\u59d4\u5916\u5de5\u5355 ==>{}", (Object)orderObjKey);
                return;
            }
            dynamicObject = costObjectMap.get(costObjKey);
            if (dynamicObject == null) {
                if (!CadEmptyUtils.isEmpty(pzCostObjectMap)) {
                    dynamicObject = pzCostObjectMap.get(row.getLong("material"));
                    if (dynamicObject == null) {
                        return;
                    }
                } else {
                    Set<Long> costObjKeySet = new HashSet<Long>(16);
                    if (paramMap.get("noCostObjectPom") != null) {
                        costObjKeySet = (Set)paramMap.get("noCostObjectPom");
                    }
                    costObjKeySet.add(costObjKey);
                    paramMap.put("noCostObjectPom", costObjKeySet);
                    logger.info("\u672a\u6839\u636e\u59d4\u5916\u5de5\u5355\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u6210\u672c\u6838\u7b97\u5bf9\u8c61 ==>{}", (Object)costObjKey);
                    return;
                }
            }
            if (!costCenterIdList.contains(costCenterId = dynamicObject.get("costcenter"))) {
                logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5bf9\u5e94\u7684\u6210\u672c\u4e2d\u5fc3\u4e0d\u5728\u7528\u6237\u6743\u9650\u5185 ==>{}", (Object)costObjKey);
                return;
            }
        }
        DynamicObject mfgFeeBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_planfeebill");
        long costObjectId = 0L;
        if (hasCostObject) {
            mfgFeeBill.set("costcenter", (Object)Long.parseLong(String.valueOf(costCenterId)));
            costObjectId = dynamicObject.getLong("id");
            mfgFeeBill.set("costobject", (Object)costObjectId);
            String orgDuty = dynamicObject.getString("orgduty");
            if ("4".equals(orgDuty)) {
                DynamicObject productGroup;
                mfgFeeBill.set("allocmold", (Object)"C");
                DynamicObjectCollection entryEntity = mfgApFeeImpSach.getDynamicObjectCollection("entryentity");
                if (entryEntity != null && entryEntity.size() == 1 && (productGroup = ((DynamicObject)entryEntity.get(0)).getDynamicObject("productgroup")) != null) {
                    mfgFeeBill.set("productgroup", (Object)productGroup.getLong("id"));
                }
            } else if ("5".equals(orgDuty)) {
                mfgFeeBill.set("allocmold", (Object)"B");
            } else {
                mfgFeeBill.set("allocmold", (Object)"A");
            }
        } else {
            mfgFeeBill.set("allocmold", (Object)"A");
        }
        long expenseItemId = row.getLong("expenseitem");
        mfgFeeBill.set("expenseitem", (Object)expenseItemId);
        mfgFeeBill.set("billstatus", (Object)"C");
        mfgFeeBill.set("source", (Object)SysParamEnum.COMPTYPE_SYS.getValue());
        long impSachId = mfgApFeeImpSach.getLong("id");
        mfgFeeBill.set("impschid", (Object)impSachId);
        mfgFeeBill.set("creator", (Object)RequestContext.get().getUserId());
        mfgFeeBill.set("createtime", paramMap.get("currDate"));
        mfgFeeBill.set("modifier", (Object)RequestContext.get().getUserId());
        mfgFeeBill.set("modifytime", paramMap.get("currDate"));
        mfgFeeBill.set("org", mfgApFeeImpSach.get("org"));
        mfgFeeBill.set("costaccount", mfgApFeeImpSach.get("costaccount"));
        Map centerManuMap = (Map)paramMap.get("centerManuMap");
        long manuOrgId = 0L;
        if (centerManuMap != null && centerManuMap.get(mfgFeeBill.getLong("costcenter")) != null) {
            manuOrgId = (Long)centerManuMap.get(mfgFeeBill.getLong("costcenter"));
            mfgFeeBill.set("manuorg", (Object)manuOrgId);
        } else {
            mfgFeeBill.set("manuorg", mfgApFeeImpSach.get("manuorg"));
        }
        Object periodId = paramMap.get(mfgApFeeImpSach.getDynamicObject("costaccount").getString("id"));
        mfgFeeBill.set("bookdate", paramMap.get("period@" + periodId));
        mfgFeeBill.set("period", periodId);
        Long mfgCurrency = (Long)paramMap.get("currency" + mfgApFeeImpSach.getDynamicObject("costaccount").getString("id"));
        mfgFeeBill.set("currency", (Object)mfgCurrency);
        mfgFeeBill.set("sourcetype", (Object)"SYS");
        mfgFeeBill.set("appnum", paramMap.get("appnum"));
        mfgFeeBill.set("srcsys", (Object)mfgApFeeImpSach.getDynamicObject("srcbizsys"));
        DynamicObjectCollection mulSrcSys = mfgFeeBill.getDynamicObjectCollection("mulsrcsys");
        DynamicObject srcSys = mulSrcSys.addNew();
        srcSys.set("fbasedataid", (Object)mfgApFeeImpSach.getDynamicObject("srcbizsys"));
        BigDecimal amount = BigDecimal.ZERO;
        StringJoiner srcBillId = new StringJoiner("@");
        StringJoiner srcBillNum = new StringJoiner(",");
        StringJoiner voucherentryId = new StringJoiner("@");
        HashSet<String> srcBillIdSet = new HashSet<String>(16);
        HashSet<String> srcBillNumSet = new HashSet<String>(16);
        for (Row dataRow : rows) {
            Map exchangeRateByRules;
            srcBillIdSet.add(dataRow.getString("id"));
            srcBillNumSet.add(dataRow.getString("billno"));
            voucherentryId.add(dataRow.getString("entryid"));
            if (paramMap.get(impSachId + "@rate") == null) {
                amount = amount.add(dataRow.getBigDecimal("e_amount"));
                continue;
            }
            Long currency = dataRow.getLong("currency");
            Date rateDate = dataRow.getDate("exratedate");
            Long reteTableId = dataRow.getLong("exratetableid");
            String rateKey = currency + "@" + mfgCurrency + "@" + reteTableId + "@" + rateDate.toString();
            if (paramMap.get(rateKey) == null) {
                exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)currency, (Long)mfgCurrency, (Long)reteTableId, (Date)rateDate);
                paramMap.put(rateKey, exchangeRateByRules);
            } else {
                exchangeRateByRules = (Map)paramMap.get(rateKey);
            }
            logger.info("\u6839\u636e\u91c7\u8d2d\u8ba2\u5355\u5355\u53f7\u53ca\u884c\u53f7\u83b7\u53d6\u5230\u6c47\u7387\u8ba1\u7b97\u65b9\u5f0f,\u91c7\u8d2d\u8ba2\u5355\u53f7==>{},\u6c47\u7387==>{},\u6c47\u7387key==>{}", new Object[]{orderObjKey, exchangeRateByRules, rateKey});
            Boolean quoteType = (Boolean)exchangeRateByRules.get("quoteType");
            BigDecimal rate = (BigDecimal)exchangeRateByRules.get("exchangeRate");
            if (rate == null || rate.compareTo(BigDecimal.ZERO) == 0) {
                logger.info("\u636e\u91c7\u8d2d\u8ba2\u5355\u5355\u53f7\u53ca\u884c\u53f7\u83b7\u53d6\u5230\u6c47\u7387\u4e3a0\u6216\u4e3a\u7a7a,\u91c7\u8d2d\u8ba2\u5355\u53f7==>{},\u6c47\u7387==>{}", (Object)orderObjKey, (Object)exchangeRateByRules);
                return;
            }
            if (quoteType.booleanValue()) {
                amount = amount.add(dataRow.getBigDecimal("e_amount").divide(rate).setScale(10, RoundingMode.HALF_UP));
                continue;
            }
            amount = amount.add(dataRow.getBigDecimal("e_amount").multiply(rate).setScale(10, RoundingMode.HALF_UP));
        }
        srcBillIdSet.forEach(srcBillId::add);
        srcBillNumSet.forEach(srcBillNum::add);
        mfgFeeBill.set("srcbillid", (Object)srcBillId.toString());
        mfgFeeBill.set("srcbillnum", (Object)srcBillNum.toString());
        mfgFeeBill.set("voucherentry", (Object)voucherentryId.toString());
        if (StringUtils.equals((CharSequence)((String)paramMap.get("apBillType")), (CharSequence)"bus") && mfgCostMap != null) {
            mfgFeeBill.set("remark", (Object)ResManager.loadKDString((String)"\u4ece\u6682\u4f30\u5e94\u4ed8\u5355\u5f15\u5165", (String)"PlanfeeBillImportHelper_13", (String)"macc-cad-common", (Object[])new Object[0]));
            mfgFeeBill.set("srcbilltype", (Object)"AP_BUS");
            boolean isMerge = (Boolean)paramMap.get("isMerge");
            if (!isMerge) {
                Map beforeBusAmount = (Map)paramMap.get("beforeBusAmountMap");
                String feeBillKey = costObjKey + "@" + row.getString("expenseitem");
                BigDecimal bigDecimal = mfgCostMap.get(feeBillKey);
                logger.info("\u6682\u4f30\u5e94\u4ed8\u5355==>{},\u5f53\u671f\u91d1\u989d==>{},\u4ece\u5f52\u96c6\u5355\u83b7\u53d6\u5230\u5386\u53f2\u5408\u8ba1\u91d1\u989d:==>{}", new Object[]{feeBillKey, amount, bigDecimal});
                if (bigDecimal != null) {
                    mfgFeeBill.set("totalamount", (Object)amount.subtract(bigDecimal));
                } else {
                    mfgFeeBill.set("totalamount", (Object)amount);
                }
                if (beforeBusAmount.get(feeBillKey) != null) {
                    BigDecimal beforeAmount = (BigDecimal)beforeBusAmount.get(feeBillKey);
                    logger.info("\u5f53\u524d\u5355\u636e==>{},\u83b7\u53d6\u5230\u5386\u53f2\u91d1\u989d\u5408\u8ba1\u4e3a{}", (Object)row.getString("billno"), (Object)beforeAmount);
                    mfgFeeBill.set("totalamount", (Object)mfgFeeBill.getBigDecimal("totalamount").add(beforeAmount));
                }
                paramMap.put("isMerge", true);
            } else {
                mfgFeeBill.set("totalamount", (Object)amount);
            }
        } else {
            mfgFeeBill.set("remark", (Object)ResManager.loadKDString((String)"\u4ece\u8d22\u52a1\u5e94\u4ed8\u5355\u5f15\u5165", (String)"PlanfeeBillImportHelper_14", (String)"macc-cad-common", (Object[])new Object[0]));
            mfgFeeBill.set("srcbilltype", (Object)"AP_FI");
            mfgFeeBill.set("totalamount", (Object)amount);
        }
        String srcBill = mfgApFeeImpSach.getString("srcbill");
        if (SrcBillEnum.AMOUNT_CREDITLOCAL.getValue().equals(srcBill)) {
            mfgFeeBill.set("outsourcetype", (Object)"A");
        } else {
            mfgFeeBill.set("outsourcetype", (Object)"B");
        }
        if (paramMap.get("isEnableMultiFactory") != null && ((Boolean)paramMap.get("isEnableMultiFactory")).booleanValue()) {
            StringBuilder sb = new StringBuilder();
            sb.append(manuOrgId).append(costObjectId).append(expenseItemId).append(srcBillId);
            Set createMfgFeeBillKey = new HashSet<String>(16);
            if (paramMap.get("createMfgFeeBillKey") != null && (createMfgFeeBillKey = (Set)paramMap.get("createMfgFeeBillKey")).contains(sb.toString())) {
                logger.info("\u5f53\u524d\u5f52\u96c6\u5355\u7ef4\u5ea6{}\u5df2\u7ecf\u88ab\u5176\u4ed6\u5f15\u5165\u65b9\u6848\u5f15\u5165\uff0c\u4e0d\u518d\u91cd\u590d\u5f15\u5165", (Object)sb.toString());
                return;
            }
            createMfgFeeBillKey.add(sb.toString());
            paramMap.put("createMfgFeeBillKey", createMfgFeeBillKey);
        }
        BigDecimal resultAmount = mfgFeeBill.getBigDecimal("totalamount");
        logger.info("\u5f53\u524d\u5f52\u96c6\u5355\u6e90\u5355id{},\u5206\u5f55id{},\u6700\u7ec8\u91d1\u989d\u5408\u8ba1\u4e3a{}", new Object[]{srcBillId.toString(), voucherentryId.toString(), resultAmount});
        if (resultAmount.compareTo(BigDecimal.ZERO) != 0) {
            resultList.add(mfgFeeBill);
        }
    }

    private static void queryCostObject(Long orgId, DataSet busData, DataSet fiData, Map<String, Object> paramMap, List<Object> costCenterIdList) {
        HashMap<Long, DynamicObject> map;
        QFilter filter;
        String key;
        Row next;
        if (busData.isEmpty() && fiData.isEmpty()) {
            return;
        }
        HashSet<Long> srcBillIds = new HashSet<Long>(50);
        HashSet<Long> seqIds = new HashSet<Long>(50);
        HashSet<Long> materialIds = new HashSet<Long>(50);
        HashSet<String> allCoreBillSeq = new HashSet<String>(50);
        Iterator busIterator = busData.iterator();
        Iterator fiIterator = fiData.iterator();
        while (busIterator.hasNext()) {
            next = (Row)busIterator.next();
            srcBillIds.add(next.getLong("corebillid"));
            seqIds.add(next.getLong("corebillentryid"));
            allCoreBillSeq.add(next.getString("corebillno") + "@" + next.getString("corebillentryseq"));
            materialIds.add(next.getLong("material"));
        }
        while (fiIterator.hasNext()) {
            next = (Row)fiIterator.next();
            srcBillIds.add(next.getLong("corebillid"));
            seqIds.add(next.getLong("corebillentryid"));
            allCoreBillSeq.add(next.getString("corebillno") + "@" + next.getString("corebillentryseq"));
            materialIds.add(next.getLong("material"));
        }
        QFilter outFilter = new QFilter("id", "in", srcBillIds);
        outFilter.and("billentry.id", "in", seqIds);
        outFilter.and("billstatus", "=", (Object)"C");
        DynamicObjectCollection omMftOrderDynamicObj = QueryServiceHelper.query((String)"pm_purorderbill", (String)"billno,billentry.seq as seq,billentry.mftorderentryseq as omseq,billentry.mftordernumber as ombillno,billentry.mftorderid ombillid,billentry.mftorderentryid ombillentryid", (QFilter[])outFilter.toArray());
        QFilter pomFilter = new QFilter("id", "in", srcBillIds);
        pomFilter.and("billentry.id", "in", seqIds);
        pomFilter.and("billstatus", "=", (Object)"C");
        DynamicObjectCollection pomMftOrderDynamicObj = QueryServiceHelper.query((String)"pm_om_purorderbill", (String)"billno as billno,billentry.seq as seq,billentry.mftorderentryseq as pomseq,billentry.mftordernumber as pombillno,billentry.mftorderid pombillid,billentry.mftorderentryid pombillentryid", (QFilter[])pomFilter.toArray());
        HashMap<String, Long> billObjMap = new HashMap<String, Long>();
        HashSet<Long> objSrcBillEntryIds = new HashSet<Long>(50);
        HashSet<String> hasPomCoreBillSeq = new HashSet<String>(50);
        for (DynamicObject dynamicObject : omMftOrderDynamicObj) {
            key = dynamicObject.getString("billno") + "@" + dynamicObject.getString("seq");
            long omBillEntryId = dynamicObject.getLong("ombillentryid");
            billObjMap.put(key, omBillEntryId);
            hasPomCoreBillSeq.add(key);
            objSrcBillEntryIds.add(omBillEntryId);
        }
        for (DynamicObject dynamicObject : pomMftOrderDynamicObj) {
            key = dynamicObject.getString("billno") + "@" + dynamicObject.getString("seq");
            long pomBillEntryId = dynamicObject.getLong("pombillentryid");
            billObjMap.put(key, pomBillEntryId);
            hasPomCoreBillSeq.add(key);
            objSrcBillEntryIds.add(pomBillEntryId);
        }
        HashSet pzCostCenterIds = new HashSet(16);
        if (!CadEmptyUtils.isEmpty(costCenterIdList)) {
            ArrayList<Long> costCenterIds = new ArrayList<Long>();
            costCenterIdList.forEach(s -> costCenterIds.add(Long.parseLong(String.valueOf(s))));
            Map<String, DynamicObject> ruleMap = CostObjectHelper.getRulesMap(orgId, costCenterIds);
            String org = String.valueOf(orgId);
            DynamicObject orgRule = ruleMap.get(org);
            costCenterIds.forEach(s -> {
                DynamicObject rule = (DynamicObject)ruleMap.get(org.concat(String.valueOf(s)));
                String bizType = "";
                if (rule != null) {
                    bizType = rule.getString("biztype");
                } else if (orgRule != null) {
                    bizType = orgRule.getString("biztype");
                }
                if (CostObjectEnum.BIZTYPE_PZ.getValue().equals(bizType)) {
                    pzCostCenterIds.add(s);
                }
            });
        }
        allCoreBillSeq.removeAll(hasPomCoreBillSeq);
        paramMap.put("noPomCoreBillSeq", allCoreBillSeq);
        if (!billObjMap.isEmpty()) {
            paramMap.put("billObjMap", billObjMap);
            filter = new QFilter("billstatus", "=", (Object)"C");
            filter.and("org", "=", (Object)orgId);
            filter.and("probill", "in", objSrcBillEntryIds);
            map = new HashMap<Long, DynamicObject>(50);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costobject", (String)"id,probill,srcbillnumber,srcbillrow,costcenter,costcenter.orgduty.number AS orgduty", (QFilter[])filter.toArray());
            if (dynamicObjects != null && dynamicObjects.size() > 0) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    long proBillEntryId = dynamicObject.getLong("probill");
                    map.put(proBillEntryId, dynamicObject);
                }
            }
            paramMap.put("billDynamicObjMap", map);
        }
        if (!CadEmptyUtils.isEmpty(pzCostCenterIds) && !CadEmptyUtils.isEmpty(materialIds)) {
            filter = new QFilter("billstatus", "=", (Object)"C");
            filter.and("org", "=", (Object)orgId);
            filter.and("costcenter", "in", pzCostCenterIds);
            filter.and("material", "in", materialIds);
            map = new HashMap(50);
            DynamicObjectCollection pzCostObject = QueryServiceHelper.query((String)"cad_costobject", (String)"id,material,srcbillnumber,srcbillrow,costcenter,costcenter.orgduty.number AS orgduty", (QFilter[])filter.toArray());
            if (pzCostObject != null && pzCostObject.size() > 0) {
                for (DynamicObject costObject : pzCostObject) {
                    long materialId = costObject.getLong("material");
                    map.put(materialId, costObject);
                }
            }
            paramMap.put("pzBillDynamicObjMap", map);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static DataSet queryApData(Long orgId, Map<String, Object> paramMap, Set<Long> existIds, String type, DynamicObject mfgFeeImpSch) {
        DataSet busDataSet;
        void var14_20;
        String field;
        String srcBill = mfgFeeImpSch.getString("srcbill");
        String algoKey = ALGO_KEY_CLASS_NAME + ".queryApData()";
        String periodId = String.valueOf(paramMap.get(mfgFeeImpSch.getString("costaccount.id")));
        Map dataRange = (Map)paramMap.get(periodId);
        QFilter generalFilter = new QFilter("billstatus", "=", (Object)"C");
        generalFilter.and("org", "=", (Object)orgId);
        generalFilter.and("biztype.domain", "=", (Object)"5");
        long expenId = 0L;
        boolean isProcess = SrcBillEnum.AMOUNT_CREDITLOCAL.getValue().equals(srcBill);
        if (isProcess) {
            DynamicObjectCollection entreaties = mfgFeeImpSch.getDynamicObjectCollection("entryentity");
            expenId = ((DynamicObject)entreaties.get(0)).getLong("expenseitem.id");
        }
        for (Map.Entry entry : dataRange.entrySet()) {
            generalFilter.and("bookdate", ">=", entry.getKey());
            generalFilter.and("bookdate", "<=", entry.getValue());
        }
        if ("fi".equals(type)) {
            void var14_17;
            if (isProcess) {
                field = "id,billno,basecurrency as currency,exratedate,exratetable.id as exratetableid,detailentry.id as entryid,billtypeid as billtype,'" + expenId + "' expenseitem,detailentry.e_amountbase as e_amount,detailentry.corebillno as corebillno,detailentry.corebillentryseq as corebillentryseq,detailentry.material as material,detailentry.corebillid as corebillid,detailentry.corebillentryid as corebillentryid,'fi' importtype";
                generalFilter.and("detailentry.expenseitem", "=", (Object)0L);
            } else {
                field = "id,billno,basecurrency as currency,exratedate,exratetable.id as exratetableid,detailentry.id as entryid,billtypeid as billtype, detailentry.expenseitem as expenseitem,detailentry.e_amountbase as e_amount,detailentry.corebillno corebillno,detailentry.corebillentryseq as corebillentryseq,detailentry.material as material,detailentry.corebillid as corebillid,detailentry.corebillentryid as corebillentryid,'fi' importtype";
                generalFilter.and("detailentry.expenseitem", "!=", (Object)0L);
            }
            if (paramMap.get("operation") == null || !"check".equals(paramMap.get("operation"))) {
                generalFilter.and("detailentry.id", "not in", existIds);
            }
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"ap_finapbill", (String)field, (QFilter[])generalFilter.toArray(), null);
            if (CadBgParamUtils.getBgParamBoolean(BgParamEnum.CHECK_AP_RECORD).booleanValue()) {
                HashSet<Long> billIds = new HashSet<Long>(32);
                for (Row row : dataSet.copy()) {
                    Long fiId = row.getLong("id");
                    billIds.add(fiId);
                }
                if (!CadEmptyUtils.isEmpty(billIds)) {
                    QFilter asstFilter = new QFilter("entry.e_billid", "in", billIds);
                    if (!CadEmptyUtils.isEmpty(dataRange)) {
                        long startPeriodId;
                        Map<String, Date> dateByPeriod;
                        Long costAccountId = mfgFeeImpSch.getLong("costaccount.id");
                        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
                        qFilter.and("entryentity.costaccount", "=", (Object)costAccountId);
                        qFilter.and("entryentity.isenabled", "=", (Object)Boolean.TRUE);
                        DynamicObject startCostDy = QueryServiceHelper.queryOne((String)"sca_startstdcost", (String)"entryentity.startperiod startperiod", (QFilter[])qFilter.toArray());
                        Date startDate = null;
                        if (startCostDy != null && (dateByPeriod = PeriodHelper.getDateByPeriod(Sets.newHashSet((Object[])new Long[]{startPeriodId = startCostDy.getLong("startperiod")}))) != null) {
                            startDate = dateByPeriod.get("begindate");
                        }
                        if (startDate != null) {
                            asstFilter.and("billdate", "<=", startDate);
                            try (DataSet vr4Assets = QueryServiceHelper.queryDataSet((String)"queryVR4Asst", (String)"ap_verifyrecord", (String)"entry.e_billentryid as entryid,entry.e_localverifyamt verifyamount", (QFilter[])new QFilter[]{asstFilter}, null).groupBy(new String[]{"entryid"}).sum("verifyamount").finish();){
                                DataSet dataSet3 = dataSet.leftJoin(vr4Assets).on("entryid", "entryid").select(dataSet.getRowMeta().getFieldNames(), new String[]{"verifyamount"}).finish();
                                dataSet3 = dataSet3.select("id,billno,currency,exratedate,exratetableid,entryid,billtype,expenseitem,material,case when verifyamount is null then e_amount else e_amount-verifyamount end e_amount,corebillno,corebillentryseq,corebillid,corebillentryid,importtype");
                            }
                        }
                    }
                }
            }
            return var14_17;
        }
        if (isProcess) {
            field = "id,billno,basecurrency as currency,exratedate,exratetable.id as exratetableid,entry.id as entryid,billtype,'" + expenId + "' expenseitem,entry.e_localamt as e_amount,entry.e_corebillno as corebillno,entry.e_corebillentryseq as corebillentryseq,entry.e_material as material,entry.corebillid as corebillid,entry.corebillentryid as corebillentryid,'bus' importtype,entry.e_srcentryid srcbusentryid,bizdate";
            generalFilter.and("entry.e_expenseitem", "=", (Object)0L);
        } else {
            field = "id,billno,basecurrency as currency,exratedate,exratetable.id as exratetableid,entry.id as entryid,billtype, entry.e_expenseitem as expenseitem,entry.e_localamt as e_amount,entry.e_corebillno as corebillno,entry.e_corebillentryseq as corebillentryseq,entry.e_material as material,entry.corebillid as corebillid,entry.corebillentryid as corebillentryid,'bus' importtype,entry.e_srcentryid srcbusentryid,bizdate";
            generalFilter.and("entry.e_expenseitem", "!=", (Object)0L);
        }
        if (paramMap.get("operation") == null || !"check".equals(paramMap.get("operation"))) {
            generalFilter.and("entry.id", "not in", existIds);
        }
        Object var14_18 = null;
        if (CadBgParamUtils.getBgParamBoolean(BgParamEnum.CHECK_AP_RECORD).booleanValue()) {
            if (!CadEmptyUtils.isEmpty(dataRange)) {
                long startPeriodId;
                Map<String, Date> dateByPeriod;
                Long costAccountId = mfgFeeImpSch.getLong("costaccount.id");
                QFilter qFilter = new QFilter("org", "=", (Object)orgId);
                qFilter.and("entryentity.costaccount", "=", (Object)costAccountId);
                qFilter.and("entryentity.isenabled", "=", (Object)Boolean.TRUE);
                DynamicObject startCostDy = QueryServiceHelper.queryOne((String)"sca_startstdcost", (String)"entryentity.startperiod startperiod", (QFilter[])qFilter.toArray());
                if (startCostDy != null && (dateByPeriod = PeriodHelper.getDateByPeriod(Sets.newHashSet((Object[])new Long[]{startPeriodId = startCostDy.getLong("startperiod")}))) != null) {
                    Date date = dateByPeriod.get("begindate");
                }
            }
            if (var14_20 != null) {
                generalFilter.and("bizdate", ">=", (Object)var14_20);
            }
        }
        if ((busDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"ap_busbill", (String)field, (QFilter[])generalFilter.toArray(), null)) != null && CadBgParamUtils.getBgParamBoolean(BgParamEnum.CHECK_AP_RECORD).booleanValue() && var14_20 != null) {
            QFilter entryIdQf;
            DataSet srcDataSet;
            logger.info("\u5f00\u59cb\u65e5\u671f:{}", (Object)var14_20);
            DataSet cxDataSet = busDataSet.copy().filter("srcbusentryid !=0");
            HashSet<Long> cxEntryIds = new HashSet<Long>(32);
            HashSet<Long> filterEntryId = new HashSet<Long>(32);
            if (cxDataSet != null) {
                for (Row row : cxDataSet) {
                    Long cxEntryId = row.getLong("srcbusentryid");
                    cxEntryIds.add(cxEntryId);
                }
            }
            logger.info("\u9500\u5355\u5206\u5f55id:{}", (Object)SerializationUtils.toJsonString(cxEntryIds));
            if (!CadEmptyUtils.isEmpty(cxEntryIds) && (srcDataSet = QueryServiceHelper.queryDataSet((String)"MfgBillImp-filbizdate", (String)"ap_busbill", (String)"entry.id entryid,bizdate", (QFilter[])new QFilter[]{entryIdQf = new QFilter("entry.id", "in", cxEntryIds)}, null)) != null) {
                for (Row row : srcDataSet) {
                    Long entryId = row.getLong("entryid");
                    Date bizDate = row.getDate("bizdate");
                    if (bizDate == null || !bizDate.before((Date)var14_20)) continue;
                    filterEntryId.add(entryId);
                }
            }
            logger.info("\u9700\u8981\u6392\u9664\u7684\u9500\u5355\u5206\u5f55id:{}", (Object)SerializationUtils.toJsonString(filterEntryId));
            StringBuilder sb = new StringBuilder();
            for (Long entryId : filterEntryId) {
                sb.append(entryId).append(",");
            }
            logger.info("\u8fc7\u6ee4str\uff1a{}", (Object)sb);
            if (sb.length() > 1) {
                String filterStr = "srcbusentryid not in(" + sb.substring(0, sb.length() - 1) + ")";
                busDataSet = busDataSet.filter(filterStr);
            }
        }
        return busDataSet;
    }

    private static List<DynamicObject> buildGlBills(Long orgId, Set<Long> costAccountSet, List<Object> costCenterIdList, DynamicObjectCollection glCollect, Map<String, Object> paramMap) {
        boolean isCheck;
        ArrayList<DynamicObject> resultBillList = new ArrayList<DynamicObject>(10);
        if (CadEmptyUtils.isEmpty(glCollect)) {
            return resultBillList;
        }
        HashMap cacheMap = new HashMap();
        paramMap.put("cacheMap", cacheMap);
        QFilter impIdQFilter = new QFilter("id", "in", (Object)PlanfeeBillImportHelper.toArrIds(glCollect));
        DynamicObject[] mfgFeeImpSachs = BusinessDataServiceHelper.load((String)"sca_mfgfeeimpsch", (String)FEEIMPSCH_FILEDS, (QFilter[])impIdQFilter.toArray(), (String)"level asc,auditdate desc");
        List<DynamicObject> dynamicObjects = Arrays.asList(mfgFeeImpSachs);
        HashSet costCenterIdSet = new HashSet(16);
        if (costCenterIdList != null && !costCenterIdList.isEmpty()) {
            costCenterIdList.forEach(id -> costCenterIdSet.add(id.toString()));
        }
        HashSet repeatSchSet = new HashSet();
        paramMap.put("repeatSchSet", repeatSchSet);
        PlanFeeImportReport report = (PlanFeeImportReport)paramMap.get("report");
        report.logReportDetail(ResManager.loadKDString((String)"\u83b7\u53d6\u5df2\u5bfc\u5165\u7684\u6e90\u5355", (String)"PlanfeeBillImportHelper_15", (String)"macc-cad-common", (Object[])new Object[0]));
        HashMap<Long, Set<Long>> existBillGlVoucherIds = new HashMap<Long, Set<Long>>(16);
        HashMap<Long, Map<Long, Date>> existMfgBills = new HashMap<Long, Map<Long, Date>>(16);
        Set<Long> voucherEntryIds = PlanfeeBillImportHelper.getImportedSrcBillEntryIds(orgId, costAccountSet, paramMap, existBillGlVoucherIds, existMfgBills);
        boolean bl = isCheck = paramMap.get("operation") != null && "check".equals(paramMap.get("operation"));
        if (!isCheck) {
            QFilter idQFilter = new QFilter("entries.id", "in", voucherEntryIds);
            DataSet glVoucherIdsDs = QueryServiceHelper.queryDataSet((String)"getGlVoucherIds", (String)"gl_voucher", (String)"entries.id entryid,posttime", (QFilter[])idQFilter.toArray(), null);
            HashSet existVoucherEntryIds = new HashSet(16);
            HashSet deleteMfgBillIds = new HashSet(16);
            glVoucherIdsDs.forEach(s -> {
                long voucherEntryId = s.getLong("entryid");
                existVoucherEntryIds.add(voucherEntryId);
                Map existBillDateMap = (Map)existMfgBills.get(voucherEntryId);
                if (s.get("posttime") != null && !CadEmptyUtils.isEmpty(existBillDateMap) && s.getDate("posttime").getTime() > ((Date)existBillDateMap.values().iterator().next()).getTime()) {
                    long mfgBillId = (Long)existBillDateMap.keySet().iterator().next();
                    deleteMfgBillIds.add(mfgBillId);
                    if (!CadEmptyUtils.isEmpty((Set)existBillGlVoucherIds.get(mfgBillId))) {
                        voucherEntryIds.removeAll((Collection)existBillGlVoucherIds.get(mfgBillId));
                    }
                    logger.info("update voucherEntryId ==>{}", (Object)voucherEntryId);
                }
            });
            logger.info("voucherEntryId update, deleteMfgBillIds size ==> {}", (Object)deleteMfgBillIds.size());
            HashSet<Long> deleteVoucherEntryIds = new HashSet<Long>(voucherEntryIds.size());
            deleteVoucherEntryIds.addAll(voucherEntryIds);
            deleteVoucherEntryIds.removeAll(existVoucherEntryIds);
            if (!CadEmptyUtils.isEmpty(deleteVoucherEntryIds)) {
                logger.info("delete voucherEntryIds size ==>{}", (Object)deleteVoucherEntryIds.size());
                deleteVoucherEntryIds.forEach(s -> {
                    Map existBillDateMap = (Map)existMfgBills.get(s);
                    if (!CadEmptyUtils.isEmpty(existBillDateMap)) {
                        long mfgBillId = (Long)existBillDateMap.keySet().iterator().next();
                        deleteMfgBillIds.add(mfgBillId);
                        if (!CadEmptyUtils.isEmpty((Set)existBillGlVoucherIds.get(mfgBillId))) {
                            voucherEntryIds.removeAll((Collection)existBillGlVoucherIds.get(mfgBillId));
                        }
                    }
                });
            }
            if (!CadEmptyUtils.isEmpty(deleteMfgBillIds)) {
                logger.info("deleteMfgBillIds size ==>{}", (Object)deleteMfgBillIds.size());
                paramMap.put("deleteMfgBillIds", deleteMfgBillIds.size());
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"cad_planfeebill");
                DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])deleteMfgBillIds.toArray());
            }
        }
        Map<String, List<DynamicObject>> costCenterSourceDataListMap = PlanfeeBillImportHelper.getCostCenterSourceDataMap(costCenterIdList);
        report.logCheckDesc(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5230\u5df2\u5b58\u5728\u7684\u5355\u636e\u3010%s\u3011\u6761", (String)"PlanfeeBillImportHelper_16", (String)"macc-cad-common", (Object[])new Object[0]), voucherEntryIds.size()));
        report.logReportDetail(ResManager.loadKDString((String)"\u67e5\u8be2\u51ed\u8bc1\u5e76\u6309\u79d1\u76ee\u548c\u671f\u95f4\u5bf9\u51ed\u8bc1\u6570\u636e\u5206\u7ec4", (String)"PlanfeeBillImportHelper_17", (String)"macc-cad-common", (Object[])new Object[0]));
        HashMap<Long, Long> vouIdToAccountMap = new HashMap<Long, Long>(16);
        Map<String, List<DynamicObject>> srcBillMap = PlanfeeBillImportHelper.getAllSrcBillByImpSch(mfgFeeImpSachs, paramMap, orgId, voucherEntryIds, vouIdToAccountMap);
        report.logCheckDesc(String.format(ResManager.loadKDString((String)"\u5171\u83b7\u5f97\u51ed\u8bc1\u5206\u7ec4\u6570\u636e\u3010%s\u3011\u7ec4", (String)"PlanfeeBillImportHelper_18", (String)"macc-cad-common", (Object[])new Object[0]), srcBillMap.size()));
        logger.info("importPlanFeeBillBySys getAllSrcBillByImpSch size ==>{}", srcBillMap.keySet());
        Map<String, List<String>> flexFieldMap = PlanfeeBillImportHelper.getFlexFieldMap();
        logger.info("getFlexFieldMap result ==>{}", flexFieldMap);
        HashSet<Long> booksTypeIds = new HashSet<Long>(10);
        for (DynamicObject dynamicObject : dynamicObjects) {
            booksTypeIds.add(dynamicObject.getLong("accountbook.bookstype.id"));
        }
        if (!booksTypeIds.isEmpty()) {
            QFilter filter = new QFilter("id", "in", booksTypeIds);
            DynamicObjectCollection accountBookTypes = QueryServiceHelper.query((String)"bd_accountbookstype", (String)"id,accounttype", (QFilter[])new QFilter[]{filter});
            for (DynamicObject accountBookType : accountBookTypes) {
                paramMap.put("accountBookType@" + accountBookType.getLong("id"), accountBookType.getString("accounttype"));
            }
        }
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>();
        for (DynamicObject mfgFeeImpSch : dynamicObjects) {
            DynamicObjectCollection entreaties = mfgFeeImpSch.getDynamicObjectCollection("entryentity");
            if (entreaties.size() == 0) continue;
            DynamicObject mfgFeeImpSchRow = (DynamicObject)entreaties.get(0);
            Long schCostCenterId = mfgFeeImpSchRow.getLong("costcenter.id");
            if (!CadEmptyUtils.isEmpty(schCostCenterId) && !costCenterIdSet.contains(schCostCenterId.toString())) {
                logger.info("\u7b26\u5408\u7684\u6210\u672c\u4e2d\u5fc3\u96c6\u5408==>{},\u5f53\u524d\u6210\u672c\u4e2d\u5fc3==>{}", costCenterIdSet, (Object)schCostCenterId);
                continue;
            }
            report.logReportDetail(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u65b9\u6848\u3010%s\u3011\u5f00\u59cb\u5339\u914d\u51ed\u8bc1", (String)"PlanfeeBillImportHelper_19", (String)"macc-cad-common", (Object[])new Object[0]), mfgFeeImpSch.getString("billno")));
            Map<String, List<DynamicObject>> voucherMap = PlanfeeBillImportHelper.getVoucher(mfgFeeImpSch, paramMap, srcBillMap);
            if (CadEmptyUtils.isEmpty(voucherMap)) {
                report.logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u65b9\u6848\u3010%s\u3011\u672a\u5339\u914d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u51ed\u8bc1", (String)"PlanfeeBillImportHelper_20", (String)"macc-cad-common", (Object[])new Object[0]), mfgFeeImpSch.getString("billno")));
                logger.info("\u5f53\u524d\u5355\u636e\u672a\u5339\u914d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u51ed\u8bc1==>{}", srcBillMap);
                continue;
            }
            report.logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u65b9\u6848\u3010%1$s\u3011\u5339\u914d\u51ed\u8bc1\u5b8c\u6210\uff0c\u5206\u7ec4\u6570\u636e\u3010%2$s\u3011\u6761", (String)"PlanfeeBillImportHelper_21", (String)"macc-cad-common", (Object[])new Object[0]), mfgFeeImpSch.getString("billno"), voucherMap == null ? 0 : voucherMap.size()));
            report.logReportDetail(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u65b9\u6848\u3010%s\u3011\u751f\u6210\u5f52\u96c6\u5355", (String)"PlanfeeBillImportHelper_22", (String)"macc-cad-common", (Object[])new Object[0]), mfgFeeImpSch.getString("billno")));
            if (!CadEmptyUtils.isEmpty(voucherMap)) {
                PlanfeeBillImportHelper.toMfgFeeBill(mfgFeeImpSch, billList, voucherMap, paramMap, flexFieldMap, costCenterSourceDataListMap);
            }
            report.logCheckDesc(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u65b9\u6848\u3010%1$s\u3011\u751f\u6210\u5f52\u96c6\u5355\u3010%2$s\u3011\u6761", (String)"PlanfeeBillImportHelper_23", (String)"macc-cad-common", (Object[])new Object[0]), mfgFeeImpSch.getString("billno"), billList.size()));
        }
        report.logReportDetail(ResManager.loadKDString((String)"\u5f00\u59cb\u5408\u5355", (String)"PlanfeeBillImportHelper_24", (String)"macc-cad-common", (Object[])new Object[0]));
        HashMap<String, DynamicObject> groupBillMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, Integer> billCurrCountMap = new HashMap<String, Integer>(16);
        StringBuilder groupKey = new StringBuilder();
        HashMap<String, Set<String>> srcSysCombMap = new HashMap<String, Set<String>>(16);
        for (DynamicObject bill : billList) {
            long costCenterId = bill.getLong("costcenter");
            if (!costCenterIdSet.contains(Long.toString(costCenterId))) {
                logger.info("\u6210\u672c\u4e2d\u5fc3\u4e0d\u6ee1\u8db3\u8981\u6c42,\u81ea\u52a8\u8df3\u8fc7==>{}", (Object)costCenterId);
                continue;
            }
            PlanfeeBillImportHelper.generateGroupBill(groupBillMap, bill, groupKey, billCurrCountMap, srcSysCombMap, vouIdToAccountMap);
        }
        PlanfeeBillImportHelper.fillMulSrcSys(groupBillMap, srcSysCombMap);
        Map<String, DynamicObject> resultMap = PlanfeeBillImportHelper.groupBillMapFilterAmount(groupBillMap);
        if (!resultMap.isEmpty()) {
            resultBillList.addAll(resultMap.values());
        }
        report.logCheckDesc(String.format(ResManager.loadKDString((String)"\u5408\u5355\u5b8c\u6210\uff0c\u5408\u5355\u540e\u5355\u636e\u3010%s\u3011\u6761", (String)"PlanfeeBillImportHelper_25", (String)"macc-cad-common", (Object[])new Object[0]), resultBillList.size()));
        return resultBillList;
    }

    private static Map<String, List<DynamicObject>> getCostCenterSourceDataMap(List<Object> costCenterIds) {
        HashMap<String, List<DynamicObject>> costCenterSourceDataListMap = new HashMap<String, List<DynamicObject>>(16);
        QFilter ccFilter = new QFilter("costcenter", "in", costCenterIds);
        Object[] centerSourceMap = BusinessDataServiceHelper.load((String)"bos_costcentersourcemap", (String)"id,costcenter,effectdate,expdate,entryentity.sourcetype,entryentity.sourcedata", (QFilter[])ccFilter.toArray());
        if (CadEmptyUtils.isEmpty(centerSourceMap)) {
            return costCenterSourceDataListMap;
        }
        for (Object sourceMap : centerSourceMap) {
            DynamicObjectCollection entryEntity = sourceMap.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                String mapKey = entry.getString("sourcetype") + "@" + entry.getLong("sourcedata.id");
                costCenterSourceDataListMap.computeIfAbsent(mapKey, s -> new ArrayList()).add(sourceMap);
            }
        }
        return costCenterSourceDataListMap;
    }

    private static Map<String, DynamicObject> groupBillMapFilterAmount(Map<String, DynamicObject> groupBillMap) {
        HashMap<String, DynamicObject> resultMap = new HashMap<String, DynamicObject>();
        for (Map.Entry<String, DynamicObject> entry : groupBillMap.entrySet()) {
            DynamicObject dynamicObject = entry.getValue();
            BigDecimal amount = dynamicObject.getBigDecimal("totalamount");
            if (amount.compareTo(BigDecimal.ZERO) != 0) {
                resultMap.put(entry.getKey(), dynamicObject);
                continue;
            }
            logger.info("\u5f53\u524d\u5f52\u96c6\u5355\u91d1\u989d\u5408\u5e76\u540e\u4e3a0,\u81ea\u52a8\u8df3\u8fc7");
        }
        return resultMap;
    }

    private static void fillMulSrcSys(Map<String, DynamicObject> groupBillMap, Map<String, Set<String>> srcSysCombMap) {
        QFilter filter = new QFilter("number", "=", (Object)GL);
        filter.and("deploystatus", "=", (Object)"2");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bos_devportal_bizapp", (String)"id", (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            String sourceSysId = dynamicObject.getString("id");
            for (DynamicObject bill : groupBillMap.values()) {
                DynamicObjectCollection mulSrcSys = bill.getDynamicObjectCollection("mulsrcsys");
                DynamicObject srcSys = mulSrcSys.addNew();
                srcSys.set("fbasedataid", (Object)sourceSysId);
            }
        }
    }

    private static Map<String, List<DynamicObject>> getAllSrcBillByImpSch(DynamicObject[] mfgFeeImpSchs, Map<String, Object> paramMap, Long orgId, Set<Long> voucherEntryIds, Map<Long, Long> vouIdToAccountMap) {
        HashSet<Long> accountViewIds = new HashSet<Long>(16);
        HashSet<Long> origAccountViewIds = new HashSet<Long>(16);
        HashSet<Long> periodIds = new HashSet<Long>(16);
        HashSet<Long> accountBookOrg = new HashSet<Long>(5);
        for (DynamicObject mfgFeeImpSch : mfgFeeImpSchs) {
            DynamicObjectCollection collection = mfgFeeImpSch.getDynamicObjectCollection("accountviews");
            for (DynamicObject dynamicObject : collection) {
                origAccountViewIds.add(dynamicObject.getDynamicObject("fbasedataid").getLong("id"));
            }
            Long currPeriod = (Long)paramMap.get(String.valueOf(mfgFeeImpSch.getLong("costaccount.id")));
            Set<Long> transAccountViewIds = PlanfeeBillImportHelper.tranAccountViewIds(origAccountViewIds, currPeriod);
            accountViewIds.addAll(transAccountViewIds);
            periodIds.add(currPeriod);
            accountBookOrg.add(mfgFeeImpSch.getDynamicObject("accountbook").getLong("org.id"));
        }
        QFilter orgQF = new QFilter("org", "in", accountBookOrg);
        Set<Long> leafAccountViewIds = AccountViewHelper.getLeafAccountViewByIds(accountViewIds);
        logger.info("\u539f\u79d1\u76ee==>{},\u67e5\u8be2\u5230\u7684\u53f6\u5b50\u8282\u70b9\u79d1\u76ee==>{}", accountViewIds, leafAccountViewIds);
        QFilter accountViewQF = new QFilter("entries.account", "in", leafAccountViewIds);
        QFilter billStatusQF = new QFilter("ispost", "=", (Object)Boolean.TRUE);
        QFilter currPeriodQF = new QFilter("period.id", "in", periodIds);
        logger.info("getAllSrcBillByImpSch periodIds==>{}", (Object)JSON.toJSONString(periodIds));
        QFilter idNotQF = null;
        if (!(CadEmptyUtils.isEmpty(voucherEntryIds) || paramMap.get("operation") != null && "check".equals(paramMap.get("operation")))) {
            idNotQF = new QFilter("entries.id", "not in", voucherEntryIds);
        }
        HashSet<String> numbers = new HashSet<String>();
        numbers.add("sca");
        numbers.add("cad");
        QFilter sourceSysQF = new QFilter("sourcesys.number", "not in", numbers);
        String fields = "id,org.id as org,sourcesys,bookeddate,booktype.accounttype as accountType,sourcesys.number AS srcSysNum,period.id AS periodId,vouchertype,billno AS srcbillnum,entries.id AS voucherentry,entries.account.id AS accountId,entries.assgrp.id AS assgrpId,entries.assgrp.value AS assgrpValue,entries.account.dc AS dc,entries.debitlocal AS debitlocal,entries.creditlocal AS creditlocal";
        QFilter[] qf = new QFilter[]{orgQF, accountViewQF, billStatusQF, currPeriodQF, idNotQF, sourceSysQF};
        DynamicObjectCollection vouchers = QueryServiceHelper.query((String)"gl_voucher", (String)fields, (QFilter[])qf);
        logger.info("\u83b7\u53d6\u5230\u7684\u672a\u89e3\u6790\u7684\u51ed\u8bc1\u6761\u6570 : " + vouchers.size());
        HashMap<String, List<DynamicObject>> srcBillMap = new HashMap<String, List<DynamicObject>>(16);
        if (vouchers.isEmpty()) {
            return srcBillMap;
        }
        StringBuilder srcBillKeySb = new StringBuilder();
        for (DynamicObject srcBill : vouchers) {
            srcBillKeySb.setLength(0);
            long accountId = srcBill.getLong("accountId");
            srcBillKeySb.append(accountId).append('@').append(srcBill.getString("periodId")).append('@').append(srcBill.getString("accountType")).append('@').append(srcBill.getString("org"));
            srcBillMap.computeIfAbsent(srcBillKeySb.toString(), s -> new ArrayList()).add(srcBill);
            vouIdToAccountMap.put(srcBill.getLong("voucherentry"), accountId);
        }
        return srcBillMap;
    }

    private static Set<Long> tranAccountViewIds(Set<Long> origAccountViewIds, Long currPeriod) {
        Map<String, Date> dateByPeriod;
        HashSet<Long> accountViewIds = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("id", "in", origAccountViewIds);
        DynamicObject[] accountViews = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"id", (QFilter[])qFilter.toArray());
        HashSet<Long> accountViewMasterIds = new HashSet<Long>(16);
        for (DynamicObject accountView : accountViews) {
            accountViewMasterIds.add(accountView.getLong("masterid"));
        }
        if (!CadEmptyUtils.isEmpty(accountViewMasterIds) && (dateByPeriod = PeriodHelper.getDateByPeriod(Sets.newHashSet((Object[])new Long[]{currPeriod}))) != null) {
            QFilter dateQFilter = new QFilter("startdate", "<=", (Object)dateByPeriod.get("enddate"));
            dateQFilter.and(new QFilter("enddate", ">", (Object)dateByPeriod.get("enddate")));
            QFilter midQFilter = new QFilter("masterid", "in", accountViewMasterIds);
            DataSet rows = QueryServiceHelper.queryDataSet((String)"getAccountViewId", (String)"bd_accountview", (String)"id", (QFilter[])new QFilter[]{dateQFilter, midQFilter}, null);
            rows.forEach(s -> accountViewIds.add(s.getLong("id")));
            logger.info("\u79d1\u76ee\u7248\u672c\u5316\u8f6c\u6362\u7ed3\u679c\uff0c\u539f\u59cb\u79d1\u76ee==>{},\u8f6c\u6362\u79d1\u76ee==>{}", origAccountViewIds, accountViewIds);
        }
        if (CadEmptyUtils.isEmpty(accountViewIds)) {
            return origAccountViewIds;
        }
        return accountViewIds;
    }

    private static Set<Long> getImportedSrcBillEntryIds(Long orgId, Set<Long> costAccountSet, Map<String, Object> paramMap, Map<Long, Set<Long>> existBillGlVoucherIds, Map<Long, Map<Long, Date>> existMfgBills) {
        HashSet<Long> voucherEntryIds = new HashSet<Long>(16);
        String appNum = (String)paramMap.get("appnum");
        for (Long costAccountId : costAccountSet) {
            QFilter qf = new QFilter("org", "=", (Object)orgId);
            qf.and("costaccount", "=", (Object)costAccountId);
            qf.and("appnum", "=", (Object)appNum);
            qf.and("period", "=", paramMap.get(String.valueOf(costAccountId)));
            DynamicObjectCollection res = QueryServiceHelper.query((String)"cad_planfeebill", (String)"id,voucherentry,srcbilltype,createtime", (QFilter[])new QFilter[]{qf});
            if (CadEmptyUtils.isEmpty(res)) continue;
            for (DynamicObject entry : res) {
                String srcBillEntryIds = entry.getString("voucherentry");
                String srcBillType = entry.getString("srcbilltype");
                long id = entry.getLong("id");
                if (StringUtils.isEmpty((CharSequence)srcBillEntryIds)) continue;
                for (String srcBillEntryId : srcBillEntryIds.split("@")) {
                    long billEntryId = Long.parseLong(srcBillEntryId);
                    voucherEntryIds.add(billEntryId);
                    if (existMfgBills != null) {
                        HashMap<Long, Date> billDateMap = new HashMap<Long, Date>(2);
                        billDateMap.put(id, entry.getDate("createtime"));
                        existMfgBills.put(billEntryId, billDateMap);
                    }
                    if (!"VOUCHER".equals(srcBillType)) continue;
                    existBillGlVoucherIds.computeIfAbsent(id, p -> new HashSet(16)).add(billEntryId);
                }
            }
        }
        logger.info("\u83b7\u53d6\u5230\u6e90\u5355\u5206\u5f55ID\u6761\u6570==>{}", (Object)voucherEntryIds.size());
        return voucherEntryIds;
    }

    private static void generateGroupBill(Map<String, DynamicObject> groupBillMap, DynamicObject bill, StringBuilder groupKey, Map<String, Integer> billCurrCountMap, Map<String, Set<String>> srcSysCombMap, Map<Long, Long> vouIdToAccountMap) {
        String commonBillKey = PlanfeeBillImportHelper.getBillGroupKey(bill, groupKey, vouIdToAccountMap);
        if (!billCurrCountMap.containsKey(commonBillKey)) {
            billCurrCountMap.put(commonBillKey, 1);
        }
        String currBillKey = commonBillKey + "@" + billCurrCountMap.get(commonBillKey);
        String srcSys = bill.getString("srcsys");
        srcSysCombMap.computeIfAbsent(currBillKey, s -> new HashSet()).add(srcSys);
        if (!groupBillMap.containsKey(currBillKey)) {
            groupBillMap.put(currBillKey, bill);
        } else {
            DynamicObject needSavedBill = groupBillMap.get(currBillKey);
            String srcBillEntryIds = needSavedBill.getString("voucherentry");
            if (srcBillEntryIds.length() > 1300) {
                int currBillCount = billCurrCountMap.get(commonBillKey);
                billCurrCountMap.put(commonBillKey, currBillCount + 1);
            }
            String impSchIds = needSavedBill.getString("impschid");
            String srcBillIds = needSavedBill.getString("srcbillid");
            String socBillNumbs = needSavedBill.getString("srcbillnum");
            String vouchers = needSavedBill.getString("voucherentry");
            String currImpSchIds = bill.getString("impschid");
            String currSrcBillIds = bill.getString("srcbillid");
            String currSocBillNumbs = bill.getString("srcbillnum");
            String currVouchers = bill.getString("voucherentry");
            if (!impSchIds.contains(currImpSchIds)) {
                impSchIds = impSchIds + "@" + currImpSchIds;
                needSavedBill.set("impschid", (Object)impSchIds);
            }
            if (!srcBillIds.contains(currSrcBillIds)) {
                srcBillIds = srcBillIds + "@" + currSrcBillIds;
                needSavedBill.set("srcbillid", (Object)srcBillIds);
            }
            if (!socBillNumbs.contains(currSocBillNumbs)) {
                socBillNumbs = socBillNumbs + "," + currSocBillNumbs;
                needSavedBill.set("srcbillnum", (Object)socBillNumbs);
            }
            if (!vouchers.contains(currVouchers)) {
                vouchers = vouchers + "@" + currVouchers;
                needSavedBill.set("voucherentry", (Object)vouchers);
            }
            BigDecimal totalAmount = needSavedBill.getBigDecimal("totalamount");
            BigDecimal currTotalAmount = bill.getBigDecimal("totalamount");
            needSavedBill.set("totalamount", (Object)totalAmount.add(currTotalAmount));
        }
    }

    private static String getBillGroupKey(DynamicObject bill, StringBuilder groupKey, Map<Long, Long> vouIdToAccountMap) {
        groupKey.setLength(0);
        char split = '@';
        Long orgId = bill.getLong("org.id");
        Long costAccountId = bill.getLong("costaccount.id");
        String period = bill.getString("period");
        String allocMold = bill.getString("allocmold");
        Long costCenterId = bill.getLong("costcenter");
        Long vouCherEntryId = bill.getLong("voucherentry");
        Long accountId = vouIdToAccountMap.get(vouCherEntryId);
        Long expenseItemId = bill.getLong("expenseitem");
        Long productGroupId = bill.getLong("productgroup");
        groupKey.append(orgId).append(split).append(orgId).append(split).append(costAccountId).append(split).append(period).append(split).append(allocMold).append(split).append(costCenterId).append(split).append(accountId).append(split).append(expenseItemId).append(split).append(productGroupId);
        return groupKey.toString();
    }

    private static Object[] toArrIds(DynamicObjectCollection idCollec) {
        if (idCollec == null) {
            return new Object[0];
        }
        int size = idCollec.size();
        Object[] ids = new Object[size];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = ((DynamicObject)idCollec.get(i)).get("id");
        }
        return ids;
    }

    private static DynamicObjectCollection getImpSchIdCollec(Long orgId, Set<Long> costAccountSet, Map<String, Object> paramMap, String sys) {
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        QFilter costAccountQF = new QFilter("costaccount", "in", costAccountSet);
        QFilter billStatusQF = new QFilter("billstatus", "=", (Object)"C");
        QFilter appNumQF = new QFilter("appnum", "=", paramMap.get("appnum"));
        QFilter srcBizSysFilter = new QFilter("srcbizsys.number", "=", (Object)sys);
        QFilter[] mfgFeeImpSchQF = new QFilter[]{orgQF, costAccountQF, billStatusQF, appNumQF, srcBizSysFilter};
        return QueryServiceHelper.query((String)"sca_mfgfeeimpsch", (String)"id,costaccount,accountbook,srcbill", (QFilter[])mfgFeeImpSchQF, (String)"level asc");
    }

    private static void addCurrency(Map<String, Object> paramMap, Set<Long> costAccountSet) {
        DynamicObjectCollection costAccountCollec = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id, calpolicy.currency AS currency", (QFilter[])new QFilter[]{new QFilter("id", "in", costAccountSet)});
        if (CadEmptyUtils.isEmpty(costAccountCollec)) {
            return;
        }
        for (DynamicObject costAccount : costAccountCollec) {
            paramMap.put("currency" + costAccount.getString("id"), costAccount.get("currency"));
        }
    }

    private static void addCurrentPeriodLastDate(Map<String, Object> paramMap, Set<Long> costAccountSet) {
        HashSet<Long> periodIdSet = new HashSet<Long>(16);
        for (Long costAccount : costAccountSet) {
            String costAccountId = ((Object)costAccount).toString();
            Long periodId = (Long)paramMap.get(costAccountId);
            periodIdSet.add(periodId);
        }
        paramMap.put("periodIds", periodIdSet);
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id, begindate,enddate", (QFilter[])new QFilter[]{new QFilter("id", "in", periodIdSet)});
        periods.forEach(e -> {
            String periodKey = PlanfeeBillImportHelper.getPeriodKey(e.getLong("id"));
            paramMap.put(periodKey, e.getDate("enddate"));
            HashMap<Date, Date> rangeMap = new HashMap<Date, Date>();
            rangeMap.put(e.getDate("begindate"), e.getDate("enddate"));
            paramMap.put(e.getString("id"), rangeMap);
        });
    }

    private static String getPeriodKey(Long periodId) {
        return "period@" + periodId;
    }

    private static void toMfgFeeBill(DynamicObject mfgFeeImpSch, List<DynamicObject> billList, Map<String, List<DynamicObject>> voucherMap, Map<String, Object> paramMap, Map<String, List<String>> flexFieldMap, Map<String, List<DynamicObject>> costCenterSourceDataListMap) {
        DynamicObjectCollection entreaties = mfgFeeImpSch.getDynamicObjectCollection("entryentity");
        DynamicObject mfgFeeImpSchRow = (DynamicObject)entreaties.get(0);
        String costCenterType = mfgFeeImpSchRow.getString("costcentertype");
        String expenseType = mfgFeeImpSchRow.getString("expenseitemtype");
        LinkedHashMap vAssgrpValueMap = new LinkedHashMap(16);
        for (Map.Entry<String, List<DynamicObject>> voucherEntry : voucherMap.entrySet()) {
            List<DynamicObject> vouchers = voucherEntry.getValue();
            for (DynamicObject voucher : vouchers) {
                List<String> flexFields;
                DynamicObject mfgFeeBill = BusinessDataServiceHelper.newDynamicObject((String)"cad_planfeebill");
                vAssgrpValueMap.clear();
                String assgrpValue = voucher.getString("assgrpValue");
                if (!StringUtils.isEmpty((CharSequence)assgrpValue)) {
                    vAssgrpValueMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)assgrpValue, Map.class);
                }
                logger.info("vAssgrpValueMap ==>{}", vAssgrpValueMap);
                if (ScaMfgFeeImpSchEnum.VALUETYPE_FIXED.getValue().equals(costCenterType)) {
                    mfgFeeBill.set("costcenter", (Object)mfgFeeImpSchRow.getLong("costcenter.id"));
                } else if (ScaMfgFeeImpSchEnum.VALUETYPE_MATCH.getValue().equals(costCenterType)) {
                    flexFields = flexFieldMap.get("bos_costcenter");
                    long benCenter = PlanfeeBillImportHelper.getFlexFieldValue(flexFields, vAssgrpValueMap);
                    if (CadEmptyUtils.isEmpty(benCenter)) {
                        Object periodId = paramMap.get(mfgFeeImpSch.getDynamicObject("costaccount").getString("id"));
                        Date periodEndDate = (Date)paramMap.get("period@" + periodId);
                        flexFields = flexFieldMap.get("mpdm_workcentre");
                        long workCenterId = PlanfeeBillImportHelper.getFlexFieldValue(flexFields, vAssgrpValueMap);
                        List<DynamicObject> costCenterSourceList = costCenterSourceDataListMap.get("mpdm_workcentre@" + workCenterId);
                        benCenter = PlanfeeBillImportHelper.getCostCenterBySrcBillDate(periodEndDate, costCenterSourceList);
                        if (CadEmptyUtils.isEmpty(benCenter)) {
                            flexFields = flexFieldMap.get("bos_adminorg");
                            long adminOrgId = PlanfeeBillImportHelper.getFlexFieldValue(flexFields, vAssgrpValueMap);
                            costCenterSourceList = costCenterSourceDataListMap.get("bos_adminorg@" + adminOrgId);
                            benCenter = PlanfeeBillImportHelper.getCostCenterBySrcBillDate(periodEndDate, costCenterSourceList);
                        }
                        if (CadEmptyUtils.isEmpty(benCenter)) {
                            flexFields = flexFieldMap.get("bos_org");
                            long orgId = PlanfeeBillImportHelper.getFlexFieldValue(flexFields, vAssgrpValueMap);
                            costCenterSourceList = costCenterSourceDataListMap.get("bos_org@" + orgId);
                            benCenter = PlanfeeBillImportHelper.getCostCenterBySrcBillDate(periodEndDate, costCenterSourceList);
                        }
                        if (CadEmptyUtils.isEmpty(benCenter)) {
                            logger.info("\u5f53\u524d\u6210\u672c\u4e2d\u5fc3\u4e3a\u7a7a,\u81ea\u52a8\u8df3\u8fc7\uff0c\u51ed\u8bc1\u5206\u5f55id -> {}", (Object)voucher.getLong("voucherentry"));
                            continue;
                        }
                    }
                    mfgFeeBill.set("costcenter", (Object)benCenter);
                }
                if (ScaMfgFeeImpSchEnum.VALUETYPE_FIXED.getValue().equals(expenseType)) {
                    mfgFeeBill.set("expenseitem", (Object)mfgFeeImpSchRow.getLong("expenseitem.id"));
                } else if (ScaMfgFeeImpSchEnum.VALUETYPE_MATCH.getValue().equals(expenseType)) {
                    flexFields = flexFieldMap.get("er_expenseitemedit");
                    Long expenseItemId = 0L;
                    for (String flexField : flexFields) {
                        long expId;
                        if (vAssgrpValueMap.get(flexField) == null || CadEmptyUtils.isEmpty(expId = Long.parseLong(String.valueOf(vAssgrpValueMap.get(flexField))))) continue;
                        expenseItemId = expId;
                        break;
                    }
                    if (CadEmptyUtils.isEmpty(expenseItemId)) {
                        logger.info("\u8d39\u7528\u9879\u76ee\u4e3a\u7a7a,\u81ea\u52a8\u8df3\u8fc7\uff0c\u51ed\u8bc1\u5206\u5f55id -> {}", (Object)voucher.getLong("voucherentry"));
                        continue;
                    }
                    mfgFeeBill.set("expenseitem", (Object)expenseItemId);
                }
                if ((mfgFeeBill = PlanfeeBillImportHelper.setEntityValue(mfgFeeBill, Collections.singletonList(voucher), mfgFeeImpSch, paramMap)) == null) continue;
                String onlyKey = mfgFeeImpSch.getString("costaccount.id") + "@" + voucher.getString("voucherentry");
                if (PlanfeeBillImportHelper.isVoucherRepeat(onlyKey, paramMap)) {
                    logger.info("\u6279\u91cf\u5f15\u5165,\u5f53\u524d\u51ed\u8bc1\u5df2\u88ab\u5f15\u5165\u6210\u529f,\u51ed\u8bc1key==>{}", (Object)onlyKey);
                    continue;
                }
                billList.add(mfgFeeBill);
                logger.info("billList size ==>{}", (Object)billList.size());
            }
        }
    }

    private static long getCostCenterBySrcBillDate(Date bizDate, List<DynamicObject> costCenterSourceList) {
        long costCenter = 0L;
        if (bizDate == null || CadEmptyUtils.isEmpty(costCenterSourceList)) {
            return costCenter;
        }
        for (DynamicObject costCenterSource : costCenterSourceList) {
            if (costCenterSource.getDate("effectdate").getTime() > bizDate.getTime() || costCenterSource.getDate("expdate").getTime() <= bizDate.getTime()) continue;
            costCenter = costCenterSource.getLong("costcenter.id");
            break;
        }
        return costCenter;
    }

    private static long getFlexFieldValue(List<String> flexFields, LinkedHashMap<String, Object> vAssgrpValueMap) {
        long flexFieldValue = 0L;
        if (CadEmptyUtils.isEmpty(flexFields) || CadEmptyUtils.isEmpty(vAssgrpValueMap)) {
            return flexFieldValue;
        }
        for (String flexField : flexFields) {
            if (vAssgrpValueMap.get(flexField) != null && !CadEmptyUtils.isEmpty(flexFieldValue = Long.parseLong(String.valueOf(vAssgrpValueMap.get(flexField))))) break;
        }
        return flexFieldValue;
    }

    private static boolean isVoucherRepeat(String onlyKey, Map<String, Object> paramMap) {
        HashSet repeatSchSet = (HashSet)paramMap.get("repeatSchSet");
        if (repeatSchSet.contains(onlyKey)) {
            return true;
        }
        repeatSchSet.add(onlyKey);
        return false;
    }

    private static void fillAllocMold(DynamicObject mfgFeeBill, Map<String, Object> paramMap, DynamicObject mfgFeeImpSchRow) {
        String allocMold;
        if (!StringUtils.isEmpty((CharSequence)mfgFeeBill.getString("allocmold"))) {
            return;
        }
        Long costCenterId = mfgFeeBill.getLong("costcenter");
        if (CadEmptyUtils.isEmpty(costCenterId)) {
            mfgFeeBill.set("allocmold", (Object)"A");
            return;
        }
        HashMap<Long, String> costCenterDutyMap = (HashMap<Long, String>)paramMap.get("costCenterDutyMap");
        if (CadEmptyUtils.isEmpty(costCenterDutyMap)) {
            costCenterDutyMap = new HashMap<Long, String>();
            paramMap.put("costCenterDutyMap", costCenterDutyMap);
        }
        if (!StringUtils.isEmpty((CharSequence)(allocMold = (String)costCenterDutyMap.get(costCenterId)))) {
            mfgFeeBill.set("allocmold", (Object)allocMold);
            if ("C".equals(allocMold)) {
                PlanfeeBillImportHelper.setProductGroup(mfgFeeBill, mfgFeeImpSchRow);
            }
            return;
        }
        DynamicObject costCenter = QueryServiceHelper.queryOne((String)"bos_costcenter", (String)"orgduty.number AS orgduty", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costCenterId)});
        String orgduty = costCenter.getString("orgduty");
        if ("4".equals(orgduty)) {
            allocMold = "C";
            PlanfeeBillImportHelper.setProductGroup(mfgFeeBill, mfgFeeImpSchRow);
        } else {
            allocMold = "5".equals(orgduty) ? "B" : "A";
        }
        mfgFeeBill.set("allocmold", (Object)allocMold);
        costCenterDutyMap.put(costCenterId, allocMold);
    }

    private static void setProductGroup(DynamicObject mfgFeeBill, DynamicObject mfgFeeImpSchRow) {
        if (mfgFeeBill == null || mfgFeeImpSchRow == null) {
            return;
        }
        DynamicObject productGroup = mfgFeeImpSchRow.getDynamicObject("productgroup");
        if (productGroup != null) {
            mfgFeeBill.set("productgroup", (Object)productGroup.getLong("id"));
        }
    }

    private static DynamicObject setEntityValue(DynamicObject mfgFeeBill, List<DynamicObject> vouchers, DynamicObject mfgFeeImpSch, Map<String, Object> paramMap) {
        DynamicObjectCollection entreaties = mfgFeeImpSch.getDynamicObjectCollection("entryentity");
        DynamicObject mfgFeeImpSchRow = (DynamicObject)entreaties.get(0);
        return PlanfeeBillImportHelper.setFillEntity(mfgFeeBill, mfgFeeImpSch, paramMap, vouchers, mfgFeeImpSchRow);
    }

    private static List<String> getAmountTypeList(DynamicObject mfgFeeImpSchRow) {
        String amountTypes = mfgFeeImpSchRow.getString("amount");
        String[] amountTypeArr = amountTypes.split(",");
        ArrayList<String> amountTypeList = new ArrayList<String>();
        for (String amountType : amountTypeArr) {
            if (StringUtils.isEmpty((CharSequence)amountType)) continue;
            amountTypeList.add(amountType);
        }
        return amountTypeList;
    }

    private static DynamicObject setFillEntity(DynamicObject mfgFeeBill, DynamicObject mfgFeeImpSch, Map<String, Object> paramMap, List<DynamicObject> vouchers, DynamicObject mfgFeeImpSchRow) {
        Map centerManuMap = (Map)paramMap.get("centerManuMap");
        mfgFeeBill.set("billstatus", (Object)"C");
        mfgFeeBill.set("source", (Object)SysParamEnum.COMPTYPE_SYS.getValue());
        mfgFeeBill.set("impschid", (Object)mfgFeeImpSch.getLong("id"));
        mfgFeeBill.set("creator", (Object)RequestContext.get().getUserId());
        mfgFeeBill.set("createtime", paramMap.get("currDate"));
        mfgFeeBill.set("modifier", (Object)RequestContext.get().getUserId());
        mfgFeeBill.set("modifytime", paramMap.get("currDate"));
        mfgFeeBill.set("org", mfgFeeImpSch.get("org"));
        mfgFeeBill.set("costaccount", mfgFeeImpSch.get("costaccount"));
        if (centerManuMap != null && centerManuMap.get(mfgFeeBill.getLong("costcenter")) != null) {
            mfgFeeBill.set("manuorg", centerManuMap.get(mfgFeeBill.getLong("costcenter")));
        } else {
            mfgFeeBill.set("manuorg", mfgFeeImpSch.get("manuorg"));
        }
        Object periodId = paramMap.get(mfgFeeImpSch.getDynamicObject("costaccount").getString("id"));
        mfgFeeBill.set("period", periodId);
        mfgFeeBill.set("bookdate", paramMap.get("period@" + periodId));
        mfgFeeBill.set("currency", paramMap.get("currency" + mfgFeeImpSch.getDynamicObject("costaccount").getString("id")));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bd_currency", (String)"amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "=", paramMap.get("currency" + mfgFeeImpSch.getDynamicObject("costaccount").getString("id")))});
        mfgFeeBill.set("srcbillnum", (Object)vouchers.get(0).getString("srcbillnum"));
        mfgFeeBill.set("srcsys", vouchers.get(0).get("sourcesys"));
        mfgFeeBill.set("srcbillid", (Object)vouchers.get(0).getLong("id"));
        mfgFeeBill.set("appnum", paramMap.get("appnum"));
        mfgFeeBill.set("srcbilltype", (Object)"VOUCHER");
        mfgFeeBill.set("voucherentry", vouchers.get(0).get("voucherentry"));
        mfgFeeBill.set("account", vouchers.get(0).get("accountId"));
        mfgFeeBill.set("sourcetype", (Object)"SYS");
        PlanfeeBillImportHelper.fillAllocMold(mfgFeeBill, paramMap, mfgFeeImpSchRow);
        for (DynamicObject voucher : vouchers) {
            List<String> amountTypeList = PlanfeeBillImportHelper.getAmountTypeList(mfgFeeImpSchRow);
            BigDecimal amountValue = BigDecimal.ZERO;
            String dc = voucher.getString("dc");
            if (amountTypeList.size() == 1) {
                if (ScaMfgFeeImpSchEnum.AMOUNT_DEBITLOCAL.getValue().equals(amountTypeList.get(0))) {
                    if ("1".equals(dc)) {
                        amountValue = voucher.getBigDecimal("debitlocal");
                    }
                    if ("-1".equals(dc)) {
                        amountValue = voucher.getBigDecimal("debitlocal").multiply(new BigDecimal(-1));
                    }
                } else if (ScaMfgFeeImpSchEnum.AMOUNT_CREDITLOCAL.getValue().equals(amountTypeList.get(0))) {
                    if ("1".equals(dc)) {
                        amountValue = voucher.getBigDecimal("creditlocal").multiply(new BigDecimal(-1));
                    }
                    if ("-1".equals(dc)) {
                        amountValue = voucher.getBigDecimal("creditlocal");
                    }
                }
            } else if (amountTypeList.size() == 2) {
                if ("1".equals(dc)) {
                    amountValue = voucher.getBigDecimal("debitlocal").subtract(voucher.getBigDecimal("creditlocal"));
                }
                if ("-1".equals(dc)) {
                    amountValue = voucher.getBigDecimal("creditlocal").subtract(voucher.getBigDecimal("debitlocal"));
                }
            }
            if (dynamicObject != null) {
                amountValue = amountValue.setScale(dynamicObject.getInt("amtprecision"), RoundingMode.HALF_UP);
            }
            long accBookCurreyId = mfgFeeImpSch.getLong("accountbook.basecurrency.id");
            long curreyId = (Long)paramMap.get("currency" + mfgFeeImpSch.getDynamicObject("costaccount").getString("id"));
            long rateTableId = mfgFeeImpSch.getLong("accountbook.exratetable.id");
            Date bookDate = voucher.getDate("bookeddate");
            if (curreyId != accBookCurreyId) {
                Map exchangeRateByRules;
                String rateKey = accBookCurreyId + "@" + curreyId + "@" + rateTableId + "@" + bookDate.toString();
                if (paramMap.get(rateKey) == null) {
                    exchangeRateByRules = BaseDataServiceHelper.getExchangeRateMap((Long)accBookCurreyId, (Long)curreyId, (Long)rateTableId, (Date)bookDate);
                    paramMap.put(rateKey, exchangeRateByRules);
                } else {
                    exchangeRateByRules = (Map)paramMap.get(rateKey);
                }
                logger.info("\u603b\u8d26\u5f15\u5165\u6570\u636e,\u6210\u672c\u8d26\u7c3f\u4e0e\u4f1a\u8ba1\u8d26\u7c3f\u5e01\u522b\u4e0d\u4e00\u81f4,\u5f15\u5165\u65b9\u6848ID==>{},\u6c47\u7387==>{}", (Object)mfgFeeImpSch.getLong("id"), (Object)exchangeRateByRules);
                Boolean quoteType = (Boolean)exchangeRateByRules.get("quoteType");
                BigDecimal rate = (BigDecimal)exchangeRateByRules.get("exchangeRate");
                if (rate == null || rate.compareTo(BigDecimal.ZERO) == 0) {
                    logger.info("\u603b\u8d26\u5f15\u5165\u6570\u636e,\u8c03\u7528\u63a5\u53e3\u83b7\u53d6\u6c47\u7387\u4e3a\u7a7a,\u63a5\u53e3key==>{},\u6c47\u7387==>{}", (Object)rateKey, (Object)exchangeRateByRules);
                    amountValue = new BigDecimal("0.00");
                } else {
                    amountValue = quoteType != false ? amountValue.divide(rate).setScale(10, RoundingMode.HALF_UP) : amountValue.multiply(rate).setScale(10, RoundingMode.HALF_UP);
                }
            }
            mfgFeeBill.set("totalamount", (Object)amountValue);
        }
        return mfgFeeBill;
    }

    private static Map<String, List<String>> getFlexFieldMap() {
        return PlanfeeBillImportHelper.getFlexFieldMap(new String[]{"bos_costcenter", "er_expenseitemedit", "mpdm_workcentre", "bos_org", "bos_adminorg"});
    }

    private static Map<String, List<String>> getFlexFieldMap(String[] entityArr) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_asstacttype", (String)"number, flexfield, valuesource.number AS valuesourceNum", (QFilter[])new QFilter[]{new QFilter("valuesource.number", "in", (Object)entityArr)});
        for (DynamicObject dynamicObject : dynamicObjects) {
            map.computeIfAbsent(dynamicObject.getString("valuesourceNum"), r -> new ArrayList()).add(dynamicObject.getString("flexfield"));
        }
        return map;
    }

    private static Map<String, List<DynamicObject>> getVoucher(DynamicObject mfgFeeImpSch, Map<String, Object> paramMap, Map<String, List<DynamicObject>> srcBillMap) {
        DynamicObjectCollection entreaties = mfgFeeImpSch.getDynamicObjectCollection("entryentity");
        DynamicObject mfgFeeImpSchRow = (DynamicObject)entreaties.get(0);
        Long currPeriod = (Long)paramMap.get(String.valueOf(mfgFeeImpSch.getLong("costaccount.id")));
        Long accountBookOrg = mfgFeeImpSch.getDynamicObject("accountbook").getLong("org.id");
        String booksType = paramMap.get("accountBookType@" + mfgFeeImpSch.getString("accountbook.bookstype.id")).toString();
        ArrayList<DynamicObject> srcBillList = new ArrayList<DynamicObject>();
        DynamicObjectCollection collection = mfgFeeImpSch.getDynamicObjectCollection("accountviews");
        HashSet<Long> accountViewsId = new HashSet<Long>();
        for (DynamicObject dynamicObject : collection) {
            Long accountViewId = dynamicObject.getDynamicObject("fbasedataid").getLong("id");
            accountViewsId.add(accountViewId);
        }
        Set<Long> transAccountViewIds = PlanfeeBillImportHelper.tranAccountViewIds(accountViewsId, currPeriod);
        Set<Long> leafAccountIds = AccountViewHelper.getLeafAccountViewByIds(Sets.newHashSet(transAccountViewIds));
        for (Long accountViewId : leafAccountIds) {
            List<DynamicObject> list = srcBillMap.get(accountViewId + "@" + currPeriod + "@" + booksType + "@" + accountBookOrg);
            if (CadEmptyUtils.isEmpty(list)) continue;
            srcBillList.addAll(list);
        }
        if (srcBillList.isEmpty()) {
            return null;
        }
        List<String> amountTypeList = PlanfeeBillImportHelper.getAmountTypeList(mfgFeeImpSchRow);
        HashMap<String, List<DynamicObject>> voucherMap = new HashMap<String, List<DynamicObject>>(16);
        for (DynamicObject voucher : srcBillList) {
            if (PlanfeeBillImportHelper.isAmountZero(voucher, amountTypeList)) continue;
            PlanfeeBillImportHelper.filterAssgrp(voucher, voucherMap, mfgFeeImpSch);
        }
        return voucherMap;
    }

    private static void filterAssgrp(DynamicObject voucher, Map<String, List<DynamicObject>> voucherMap, DynamicObject mfgFeeImpSch) {
        String assgrpValue = voucher.getString("assgrpValue");
        LinkedHashMap vAssgrpValueMap = new LinkedHashMap();
        if (!StringUtils.isEmpty((CharSequence)assgrpValue)) {
            vAssgrpValueMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)assgrpValue, Map.class);
        }
        boolean isAll = false;
        String assgrp = mfgFeeImpSch.getString("assgrp");
        if (StringUtils.isEmpty((CharSequence)assgrp)) {
            isAll = true;
        } else {
            Map srcAssgrpMap = (Map)SerializationUtils.fromJsonString((String)assgrp, Map.class);
            if (CadEmptyUtils.isEmpty(srcAssgrpMap)) {
                isAll = true;
            }
        }
        if (isAll) {
            voucherMap.computeIfAbsent(voucher.getString("id"), s -> new ArrayList()).add(voucher);
        } else {
            Map assgrpMap = (Map)SerializationUtils.fromJsonString((String)assgrp, Map.class);
            if (!CadEmptyUtils.isEmpty(vAssgrpValueMap)) {
                for (Map.Entry entry : vAssgrpValueMap.entrySet()) {
                    String voucherKey = (String)entry.getKey();
                    String voucherValue = String.valueOf(entry.getValue());
                    List list = (List)assgrpMap.get(voucherKey);
                    if (list == null || list.contains(voucherValue)) continue;
                    return;
                }
                voucherMap.computeIfAbsent(voucher.getString("id"), s -> new ArrayList()).add(voucher);
            }
        }
    }

    private static boolean isAmountZero(DynamicObject voucher, List<String> amoutTypeList) {
        BigDecimal amoutValue;
        if (amoutTypeList.size() == 1) {
            if (ScaMfgFeeImpSchEnum.AMOUNT_DEBITLOCAL.getValue().equals(amoutTypeList.get(0)) && BigDecimal.ZERO.compareTo(voucher.getBigDecimal("debitlocal")) == 0) {
                return true;
            }
            if (ScaMfgFeeImpSchEnum.AMOUNT_CREDITLOCAL.getValue().equals(amoutTypeList.get(0)) && BigDecimal.ZERO.compareTo(voucher.getBigDecimal("creditlocal")) == 0) {
                return true;
            }
        } else if (amoutTypeList.size() == 2 && BigDecimal.ZERO.compareTo(amoutValue = voucher.getBigDecimal("debitlocal").subtract(voucher.getBigDecimal("creditlocal"))) == 0) {
            return true;
        }
        return false;
    }

    private static void addToConfig(DynamicObjectCollection collection, Map<String, Object> paramMap, PlanFeeImportReport report) {
        if (collection != null) {
            HashSet<MfgFeeReportConfig> configList = new HashSet<MfgFeeReportConfig>(collection.size());
            for (DynamicObject dynamicObject : collection) {
                MfgFeeReportConfig config = new MfgFeeReportConfig();
                config.setAccountOrgId(dynamicObject.getLong("costaccount"));
                Object period = paramMap.get(dynamicObject.getString("costaccount"));
                if (period != null) {
                    long periodId = Long.parseLong(String.valueOf(period));
                    config.setPeriodId(periodId);
                }
                config.setAccountBook(dynamicObject.getLong("accountbook"));
                config.setSrcBill(dynamicObject.getString("srcbill"));
                configList.add(config);
            }
            report.getMfgFeeReportConfigSet().addAll(configList);
        }
    }
}

