/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.list.BillList;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.common.utils.ListViewUtils;
import org.apache.commons.lang3.StringUtils;

public class PriceHelper {
    public static void updateDate(BillList billList, String costType, String entityName) {
        if (costType == null) {
            return;
        }
        DynamicObject obj = CostTypeHelper.getCostType(Long.parseLong(costType), "type");
        if ("0".equals(obj.getString("type"))) {
            return;
        }
        ListSelectedRowCollection rows = billList.getCurrentListAllRowCollection();
        if (rows.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("id", "in", (Object)rows.getPrimaryKeyValues());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityName, (String)"id,effectdate,expdate", (QFilter[])new QFilter[]{filter});
        HashMap<Long, DynamicObject> idMap = new HashMap<Long, DynamicObject>(10);
        for (DynamicObject dynamicObject : dynamicObjects) {
            idMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        for (ListSelectedRow row : rows) {
            DynamicObject dynamicObject = (DynamicObject)idMap.get(row.getPrimaryKeyValue());
            if (dynamicObject == null) continue;
            billList.setCellFieldValue("priceeffectdate", row.getRowKey(), (Object)DateUtils.formatDate(dynamicObject.getDate("effectdate"), "yyyy-MM-dd"));
            billList.setCellFieldValue("priceexpdate", row.getRowKey(), (Object)DateUtils.formatDate(dynamicObject.getDate("expdate"), "yyyy-MM-dd"));
        }
    }

    public static void hideDate(String costType, BeforeCreateListColumnsArgs o) {
        if (StringUtils.isEmpty((CharSequence)costType)) {
            return;
        }
        DynamicObject obj = CostTypeHelper.getCostType(Long.parseLong(costType), "type");
        String type = obj.getString("type");
        HashSet<String> hideField = new HashSet<String>(5);
        if ("0".equals(type)) {
            hideField.add("priceeffectdate");
            hideField.add("priceexpdate");
        } else {
            hideField.add("effectdate");
            hideField.add("expdate");
        }
        ListViewUtils.hiddenListColumn(o, hideField);
    }

    public static void setVisibleField(long costType, IFormView view) {
        if (CadEmptyUtils.isEmpty(costType)) {
            return;
        }
        DynamicObject obj = CostTypeHelper.getCostType(costType, "type");
        if (obj != null) {
            if ("0".equals(obj.getString("type"))) {
                view.setVisible(Boolean.valueOf(false), new String[]{"priceeffectdate", "priceexpdate"});
                view.setVisible(Boolean.valueOf(true), new String[]{"effectdate", "expdate"});
            } else {
                view.setVisible(Boolean.valueOf(false), new String[]{"effectdate", "expdate"});
                view.setVisible(Boolean.valueOf(true), new String[]{"priceeffectdate", "priceexpdate"});
            }
        }
    }

    public static void effectDateEnable(IFormView view, IDataModel model, String entityNum) {
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            model.setValue("expdate", (Object)DateUtils.getDeFaultExpDate());
            model.setValue("priceexpdate", (Object)DateUtils.getDeFaultExpDate());
        } else {
            model.setValue("priceeffectdate", (Object)model.getDataEntity().getDate("effectdate"));
            model.setValue("priceexpdate", (Object)model.getDataEntity().getDate("expdate"));
        }
    }

    public static boolean checkOperation(BeforeDoOperationEventArgs e, IFormView view, String entityName, String costtypeId, String key) {
        if (costtypeId == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u6210\u672c\u7c7b\u578b\u3002", (String)"PriceHelper_0", (String)"macc-cad-common", (Object[])new Object[0]));
            return false;
        }
        DynamicObject costType = CostTypeHelper.getCostType(Long.parseLong(costtypeId), "type");
        if ("0".equals(costType.getString("type"))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u4ec5\u652f\u6301\u6a21\u62df\u6210\u672c\u7c7b\u578b\u3002", (String)"PriceHelper_1", (String)"macc-cad-common", (Object[])new Object[0]));
            return false;
        }
        Set<Long> ids = PriceHelper.getSelectIds(e);
        QFilter filter = new QFilter("id", "in", ids);
        QFilter qFilter = new QFilter("billstatus", "!=", (Object)"C");
        boolean exists = false;
        if ("cad_purprices".equals(entityName)) {
            qFilter.or("pricerule", "!=", (Object)PriceRuleConstants.PUR_MANUALLY_ID);
            exists = QueryServiceHelper.exists((String)"cad_purprices", (QFilter[])new QFilter[]{filter, qFilter});
        }
        if ("cad_resourcerate".equals(entityName)) {
            qFilter.or("pricerule", "!=", (Object)PriceRuleConstants.SELFRES_MANUALLY_ID);
            exists = QueryServiceHelper.exists((String)"cad_resourcerate", (QFilter[])new QFilter[]{filter, qFilter});
        }
        if ("cad_resourceout".equals(entityName)) {
            qFilter.or("pricerule", "!=", (Object)PriceRuleConstants.OUTRES_MANUALLY_ID);
            exists = QueryServiceHelper.exists((String)"cad_resourceout", (QFilter[])new QFilter[]{filter, qFilter});
        }
        if ("cad_outsourceprice".equals(entityName)) {
            qFilter.or("pricerule", "!=", (Object)PriceRuleConstants.OUTPRI_MANUALLY_ID);
            exists = QueryServiceHelper.exists((String)"cad_outsourceprice", (QFilter[])new QFilter[]{filter, qFilter});
        }
        if (exists) {
            String tips = "updatestandcost".equals(key) ? ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff1a\u5f53\u53d6\u4ef7\u89c4\u5219\u4e3a\u624b\u5de5\u6307\u5b9a\u4e14\u5df2\u5ba1\u6838\uff0c\u624d\u5141\u8bb8\u4fee\u6539\u6807\u51c6\u6210\u672c\u3002", (String)"PriceHelper_2", (String)"macc-cad-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fee\u6539\u5931\u8d25\uff1a\u5f53\u53d6\u4ef7\u89c4\u5219\u4e3a\u624b\u5de5\u6307\u5b9a\u4e14\u5df2\u5ba1\u6838\uff0c\u624d\u5141\u8bb8\u4fee\u6539\u751f\u6548\u65f6\u95f4\u3002", (String)"PriceHelper_3", (String)"macc-cad-common", (Object[])new Object[0]);
            view.showTipNotification(ResManager.loadKDString((String)tips, (String)"PriceHelper_3", (String)"PriceHelper_4", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static Set<Long> getSelectIds(BeforeDoOperationEventArgs e) {
        HashSet<Long> ids = new HashSet<Long>(10);
        ListSelectedRowCollection listSelectedData = e.getListSelectedData();
        for (ListSelectedRow listSelectedDatum : listSelectedData) {
            ids.add(Long.parseLong(String.valueOf(listSelectedDatum.getPrimaryKeyValue())));
        }
        return ids;
    }

    public static void filterExpDate(List<QFilter> filters) {
        HashMap result = new HashMap(8);
        ArrayList<Date> dates = new ArrayList<Date>(4);
        ArrayList<QFilter> newFilters = new ArrayList<QFilter>(filters.size());
        for (QFilter filter : filters) {
            for (QFilter fs : filter.recombine()) {
                if ("expdate".equals(fs.getProperty())) {
                    dates.add((Date)fs.getValue());
                    continue;
                }
                newFilters.add(fs);
            }
        }
        if (dates.size() > 1) {
            result.put("startDate", dates.get(dates.size() - 2));
            result.put("endDate", dates.get(dates.size() - 1));
        }
        filters.clear();
        filters.addAll(newFilters);
        if (!result.isEmpty()) {
            Date startDate = (Date)result.get("startDate");
            Date endDate = DateUtils.getLastSecond((Date)result.get("endDate"), 1);
            QFilter dateFilter1 = new QFilter("effectdate", "<", (Object)startDate).and(new QFilter("expdate", ">=", (Object)startDate));
            QFilter dateFilter2 = new QFilter("effectdate", "<=", (Object)startDate).and(new QFilter("expdate", ">", (Object)startDate));
            QFilter dateFilter3 = new QFilter("effectdate", ">=", (Object)startDate).and(new QFilter("effectdate", "<", (Object)endDate));
            QFilter dateFilter4 = new QFilter("effectdate", ">", (Object)startDate).and(new QFilter("effectdate", "<=", (Object)endDate));
            filters.add(dateFilter1.or(dateFilter2).or(dateFilter3).or(dateFilter4));
        }
    }

    public static String getPriceRouteEntity(Long costTypeId) {
        QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
        filter.or(new QFilter("costtype", "=", (Object)0L));
        QFilter enableFilter = new QFilter("enable", "=", (Object)true);
        DynamicObjectCollection ruleObjs = QueryServiceHelper.query((String)"cad_routerulesetting", (String)"costtype,srcroute", (QFilter[])new QFilter[]{filter, enableFilter});
        if (CadEmptyUtils.isEmpty(ruleObjs)) {
            return "cad_router";
        }
        HashMap<Long, String> costTypeSrcRouteMap = new HashMap<Long, String>(16);
        for (DynamicObject ruleObj : ruleObjs) {
            costTypeSrcRouteMap.put(ruleObj.getLong("costtype"), ruleObj.getString("srcroute"));
        }
        if (costTypeSrcRouteMap.containsKey(costTypeId)) {
            return (String)costTypeSrcRouteMap.get(costTypeId);
        }
        if (costTypeSrcRouteMap.containsKey(0L)) {
            return (String)costTypeSrcRouteMap.get(0L);
        }
        return "cad_router";
    }

    public static List<Long> getProdOrg(Long orgId, Long costtypeId, String appNum) {
        ArrayList<Long> prodOrgs = new ArrayList<Long>(10);
        if ("sca".equals(appNum)) {
            QFilter costTypeQf = new QFilter("id", "=", (Object)costtypeId);
            costTypeQf.and("costtypeentry.costtypeattr", "=", (Object)"0");
            DynamicObject cadCosttypeEntry = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"costtypeentry.costtype arrcosttype", (QFilter[])costTypeQf.toArray());
            if (cadCosttypeEntry == null) {
                return prodOrgs;
            }
            long arrcosttype = cadCosttypeEntry.getLong("arrcosttype");
            if (CadEmptyUtils.isEmpty(arrcosttype)) {
                return prodOrgs;
            }
            QFilter costTypeOrgQf = new QFilter("costtype", "=", (Object)arrcosttype);
            costTypeOrgQf.and("bizstatus", "=", (Object)"1");
            costTypeOrgQf.and("effectdate", "<=", (Object)new Date());
            costTypeOrgQf.and("invaliddate", ">", (Object)new Date());
            DynamicObjectCollection calBdCosttypeOrgs = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,storageorgunit,costtype", (QFilter[])costTypeOrgQf.toArray());
            if (CadEmptyUtils.isEmpty(calBdCosttypeOrgs)) {
                return prodOrgs;
            }
            for (DynamicObject calBdCosttypeOrg : calBdCosttypeOrgs) {
                boolean isProduce;
                long storageOrgUnit = calBdCosttypeOrg.getLong("storageorgunit");
                if (CadEmptyUtils.isEmpty(storageOrgUnit) || !(isProduce = OrgUnitServiceHelper.checkOrgFunction((Long)storageOrgUnit, (String)"04"))) continue;
                prodOrgs.add(storageOrgUnit);
            }
            if (CadEmptyUtils.isEmpty(prodOrgs)) {
                Long calOrg = ((DynamicObject)calBdCosttypeOrgs.get(0)).getLong("calorg");
                OrgRelationParam param = new OrgRelationParam();
                param.setNumber("Accounting_TO_Production_S");
                param.setOrgId(calOrg.longValue());
                param.setToViewType("04");
                param.setFromViewType("10");
                param.setDirectViewType("toorg");
                param.setIncludeSelf(true);
                List bizRelationOrgIds = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
                if (!CadEmptyUtils.isEmpty(bizRelationOrgIds)) {
                    prodOrgs.addAll(bizRelationOrgIds);
                }
            }
        } else {
            OrgRelationParam param = new OrgRelationParam();
            param.setNumber("Accounting_TO_Production_S");
            param.setOrgId(orgId.longValue());
            param.setToViewType("04");
            param.setFromViewType("10");
            param.setDirectViewType("toorg");
            param.setIncludeSelf(true);
            List bizRelationOrgIds = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
            if (!CadEmptyUtils.isEmpty(bizRelationOrgIds)) {
                prodOrgs.addAll(bizRelationOrgIds);
            }
        }
        return prodOrgs;
    }
}

