/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.dto.ProgressParamDto;
import kd.macc.cad.common.thread.TaskType;
import kd.macc.cad.common.thread.ThreadHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ProgressHelper {
    private static final Log logger = LogFactory.getLog(ProgressHelper.class);
    public static final String Result_success = "success";
    private static final String KEY_PRE = "progress:";
    private static final String KEY_APPID = "macc";

    public static void excute(IFormView view, String progressId, String titile, Runnable task) {
        ProgressHelper.excute(view, progressId, titile, task, null);
    }

    public static void excute(IFormView view, String progressId, String titile, Runnable task, CloseCallBack closeCallBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cad_common_progress");
        showParameter.setCaption(titile);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("progressId", (Object)progressId);
        if (closeCallBack != null) {
            showParameter.setCloseCallBack(closeCallBack);
        }
        ProgressHelper.setProgressParam(progressId, new ProgressParamDto());
        view.showForm(showParameter);
        view.showLoading(new LocaleString());
        ThreadHelper.execute(task, TaskType.CAD_PROCESS);
    }

    public static void setProgress(String progressId, String opContent, int complete, int total, String unit) {
        ProgressHelper.setProgress(progressId, opContent, complete, total, unit, -1);
    }

    public static void setProgress(String progressId, String opContent, int complete, int total, String unit, int duration) {
        ProgressParamDto paramDto = ProgressHelper.getProgressParam(progressId);
        if (paramDto == null) {
            return;
        }
        paramDto.setOpContent(opContent);
        paramDto.setComplete(complete);
        paramDto.setTotal(total);
        paramDto.setUnit(unit);
        if (duration >= 0) {
            paramDto.setDurationTimes(duration);
        } else {
            paramDto.setDurationTimes(null);
        }
        ProgressHelper.setProgressParam(progressId, paramDto);
    }

    public static void setProgress(String progressId, String opContent, int complete, String unit) {
        ProgressHelper.setProgress(progressId, opContent, complete, unit, -1);
    }

    public static void setProgress(String progressId, String opContent, int complete, String unit, int duration) {
        ProgressParamDto paramDto = ProgressHelper.getProgressParam(progressId);
        if (paramDto == null) {
            return;
        }
        paramDto.setOpContent(opContent);
        if (paramDto.getComplete() == null) {
            paramDto.setComplete(0);
        }
        paramDto.setComplete(paramDto.getComplete() + complete);
        paramDto.setUnit(unit);
        if (duration >= 0) {
            paramDto.setDurationTimes(duration);
        } else {
            paramDto.setDurationTimes(null);
        }
        ProgressHelper.setProgressParam(progressId, paramDto);
    }

    public static void showError(String progressId, String error) {
        ProgressParamDto paramDto;
        if (StringUtils.isBlank((CharSequence)error)) {
            return;
        }
        if (error.length() > 30) {
            error = error.substring(0, 30);
        }
        if ((paramDto = ProgressHelper.getProgressParam(progressId)) == null) {
            return;
        }
        paramDto.setError(error);
        ProgressHelper.setProgressParam(progressId, paramDto);
    }

    public static void showSuccess(String progressId, String msg) {
        ProgressHelper.showSuccess(progressId, msg, -1);
    }

    public static void showSuccess(String progressId, String msg, int duration) {
        ProgressParamDto paramDto;
        if (StringUtils.isBlank((CharSequence)msg)) {
            return;
        }
        if (msg.length() > 30) {
            msg = msg.substring(0, 30);
        }
        if ((paramDto = ProgressHelper.getProgressParam(progressId)) == null) {
            return;
        }
        paramDto.setSuccess(msg);
        if (duration >= 0) {
            paramDto.setDurationTimes(duration);
        } else {
            paramDto.setDurationTimes(null);
        }
        ProgressHelper.setProgressParam(progressId, paramDto);
    }

    public static ProgressParamDto getProgressParam(String progressId) {
        try {
            if (StringUtils.isEmpty((CharSequence)progressId)) {
                return null;
            }
            return (ProgressParamDto)AppCache.get((String)KEY_APPID).get(KEY_PRE + progressId, ProgressParamDto.class);
        }
        catch (Exception ex) {
            logger.error("\u83b7\u53d6\u8fdb\u5ea6\u6761\u8fd0\u884c\u53c2\u6570\u51fa\u73b0\u9519\u8bef\uff1a", (Throwable)ex);
            return null;
        }
    }

    public static void setProgressParam(String progressId, ProgressParamDto paramDto) {
        try {
            AppCache.get((String)KEY_APPID).put(KEY_PRE + progressId, (Object)paramDto);
        }
        catch (Exception ex) {
            logger.error("\u8bbe\u7f6e\u8fdb\u5ea6\u6761\u8fd0\u884c\u53c2\u6570\u51fa\u73b0\u9519\u8bef\uff1a", (Throwable)ex);
        }
    }

    public static void clearProgressParam(String progressId) {
        try {
            AppCache.get((String)KEY_APPID).remove(KEY_PRE + progressId);
        }
        catch (Exception ex) {
            logger.error("\u8bbe\u7f6e\u8fdb\u5ea6\u6761\u8fd0\u884c\u53c2\u6570\u51fa\u73b0\u9519\u8bef\uff1a", (Throwable)ex);
        }
    }

    public static void refreshProgress(String opContent, int nowComplete, int total, Boolean isAddNum, String progressId) {
        ProgressParamDto paramDto = ProgressHelper.getProgressParam(progressId);
        if (paramDto == null) {
            return;
        }
        paramDto.setOpContent(opContent);
        if (isAddNum.booleanValue()) {
            Integer complete = paramDto.getComplete();
            paramDto.setComplete(complete + nowComplete);
        } else {
            paramDto.setComplete(nowComplete);
        }
        if (!CadEmptyUtils.isEmpty(total)) {
            paramDto.setTotal(total);
        }
        paramDto.setUnit(ResManager.loadKDString((String)"\u6b65", (String)"ProgressHelper_1", (String)"macc-cad-common", (Object[])new Object[0]));
        paramDto.setDurationTimes(0);
        if (nowComplete == -1) {
            paramDto.setComplete(paramDto.getTotal());
        }
        ProgressHelper.setProgressParam(progressId, paramDto);
    }
}

