/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.dto.PurPriceParamDto;
import kd.macc.cad.common.helper.ElementRelationHelper;

public class PurPricingRuleHelper {
    public static boolean checkData(PurPriceParamDto param) {
        boolean isExistRule = PurPricingRuleHelper.checkRuleIsExist(param);
        if (!isExistRule) {
            param.getView().showTipNotification(ResManager.loadKDString((String)"\u91c7\u8d2d\u53d6\u4ef7\u5931\u8d25\uff0c\u8bf7\u8bbe\u7f6e\u91c7\u8d2d\u53d6\u4ef7\u89c4\u5219\u3002", (String)"PurPricingRuleHelper_0", (String)"macc-cad-common", (Object[])new Object[0]));
            return false;
        }
        if (param.isPurPricingRule()) {
            boolean isPricing;
            String fields = "id,ispricing_con,ispricing_order";
            DynamicObject rule = PurPricingRuleHelper.getPurpricingRuleSimple(param, fields);
            boolean bl = isPricing = rule.getBoolean("ispricing_con") || rule.getBoolean("ispricing_order");
            if (!isPricing) {
                param.getView().showTipNotification(ResManager.loadKDString((String)"\u91c7\u8d2d\u53d6\u4ef7\u5931\u8d25\uff0c\u8bf7\u8bbe\u7f6e\u91c7\u8d2d\u53d6\u4ef7\u89c4\u5219\u3002", (String)"PurPricingRuleHelper_0", (String)"macc-cad-common", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public static DynamicObject getPurpricingRuleSimple(PurPriceParamDto param, String fields) {
        QFilter commonQf = new QFilter("costtype", "=", (Object)param.getCostTypeId());
        commonQf.and("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        return QueryServiceHelper.queryOne((String)param.getEntity(), (String)fields, (QFilter[])new QFilter[]{commonQf});
    }

    private static boolean checkRuleIsExist(PurPriceParamDto param) {
        QFilter commonQf = new QFilter("costtype", "=", (Object)param.getCostTypeId());
        commonQf.and("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        return QueryServiceHelper.exists((String)param.getEntity(), (QFilter[])new QFilter[]{commonQf});
    }

    public static DynamicObject getSinglePurPricingRule(PurPriceParamDto param) {
        String fields = "res_mat,res_matversion,res_auxpty,subelement,calcbasis";
        QFilter ruleQF = new QFilter("user", "=", (Object)param.getUserId());
        ruleQF.and(new QFilter("costtype", "=", (Object)param.getCostTypeId()));
        DynamicObject rule = QueryServiceHelper.queryOne((String)param.getEntity(), (String)fields, (QFilter[])new QFilter[]{ruleQF});
        if (rule != null) {
            param.setSubelementId(rule.getLong("subelement"));
            long elementId = ElementRelationHelper.getElement(param.getSubelementId());
            param.setElementId(elementId);
            param.setCalcbasis(rule.getString("calcbasis"));
        }
        return rule;
    }

    public static Set<Long> splitMatIds(Map<String, PurPriceParamDto> matWithPriceMap, String splitor) {
        Set<String> matSet = matWithPriceMap.keySet();
        HashSet<Long> matIds = new HashSet<Long>(16);
        for (String matValue : matSet) {
            String[] matValueArr = matValue.split(splitor);
            matIds.add(Long.valueOf(matValueArr[0]));
        }
        return matIds;
    }

    public static List<ComboItem> getLongFieldItems(MainEntityType srcMainET, String field) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        if (srcMainET == null) {
            return items;
        }
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        items.add(blankItem);
        String currLCId = Lang.get().toString();
        for (IDataEntityProperty prop : srcMainET.getProperties()) {
            if (StringUtils.isEmpty((CharSequence)prop.getAlias()) || prop.getDisplayName() == null) continue;
            ComboItem item = new ComboItem();
            item.setValue(prop.getName());
            item.setCaption(new LocaleString(currLCId, (Object)prop.getDisplayName()));
            items.add(item);
        }
        return items;
    }

    public static Long getCostTypeCurrency(Long costTypeId) {
        DynamicObject costType = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costTypeId)});
        return costType.getLong("currency");
    }
}

