/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class ReflectUtil {
    private static final Log logger = LogFactory.getLog(ReflectUtil.class);

    public static Object getFieldValue(Object obj, String fieldName) {
        if (obj == null) {
            return null;
        }
        Object value = null;
        Field[] fields = obj.getClass().getDeclaredFields();
        for (int j = 0; j < fields.length; ++j) {
            Field field = fields[j];
            if (!field.getName().equals(fieldName)) continue;
            AccessibleObject.setAccessible(new AccessibleObject[]{field}, true);
            try {
                value = field.get(obj);
                continue;
            }
            catch (IllegalArgumentException e) {
                logger.error("ReflectUtil.getFieldValue", (Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                logger.error("ReflectUtil.getFieldValue", (Throwable)e);
            }
        }
        return value;
    }

    public static Object getFieldValueByMethod(Object obj, String fieldName, Class<?> ... parameterTypes) {
        if (obj == null) {
            return null;
        }
        Object value = null;
        try {
            Method method = obj.getClass().getMethod(ReflectUtil.fieldGetMethodName(fieldName), new Class[0]);
            value = method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            logger.error("ReflectUtil.getFieldValueByMethod", (Throwable)e);
        }
        return value;
    }

    private static String fieldGetMethodName(String fieldName) {
        String getMethod = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        return getMethod;
    }

    public static void setValue(Object object, String key, Object value) {
        Object oldObj = object;
        Object obj = object;
        String attr = null;
        while (key.indexOf(".") != -1) {
            attr = key.substring(0, key.indexOf("."));
            key = key.substring(key.indexOf(".") + 1);
            if (obj instanceof Map) {
                obj = ((Map)obj).get(attr);
            }
            if (obj instanceof List) {
                for (Object o : (List)oldObj) {
                    if (o instanceof Map) {
                        obj = ((Map)o).get(attr);
                        continue;
                    }
                    obj = ReflectUtil.getFieldValue(o, attr);
                }
                continue;
            }
            obj = ReflectUtil.getFieldValue(obj, attr);
        }
        if (obj != null) {
            if (obj instanceof Map) {
                if (oldObj instanceof List) {
                    for (Object o : (List)oldObj) {
                        if (obj instanceof Map) {
                            if (attr == null || (o = ReflectUtil.getFieldValue(o, attr)) == null) continue;
                            ((Map)o).put(key, value);
                            continue;
                        }
                        ReflectUtil.setFieldValue(o, key, value);
                    }
                } else {
                    ((Map)obj).put(key, value);
                }
            } else if (oldObj instanceof List) {
                for (Object o : (List)oldObj) {
                    if (obj instanceof Map) {
                        if (attr == null || (o = ReflectUtil.getFieldValue(o, attr)) == null) continue;
                        ((Map)o).put(key, value);
                        continue;
                    }
                    ReflectUtil.setFieldValue(o, key, value);
                }
            } else {
                ReflectUtil.setFieldValue(obj, key, value);
            }
        }
    }

    public static Object setFieldValue(Object obj, String fieldName, Object val) {
        if (obj == null) {
            return null;
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        for (int j = 0; j < fields.length; ++j) {
            Field field = fields[j];
            if (!field.getName().equals(fieldName)) continue;
            AccessibleObject.setAccessible(new AccessibleObject[]{field}, true);
            try {
                String type = field.getType().getSimpleName();
                if (val instanceof String) {
                    String value = val.toString();
                    if ("int".equals(type)) {
                        if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                        field.setInt(obj, Integer.parseInt(value));
                        continue;
                    }
                    if ("long".equals(type)) {
                        if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                        field.setLong(obj, Long.parseLong(value));
                        continue;
                    }
                    if ("double".equals(type)) {
                        if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                        field.setDouble(obj, Double.parseDouble(value));
                        continue;
                    }
                    if ("float".equals(type)) {
                        if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                        field.setFloat(obj, Float.parseFloat(value));
                        continue;
                    }
                    field.set(obj, val);
                    continue;
                }
                field.set(obj, val);
                continue;
            }
            catch (IllegalArgumentException e) {
                logger.error("ReflectUtil.setFieldValue", (Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                logger.error("ReflectUtil.setFieldValue", (Throwable)e);
            }
        }
        return val;
    }

    public static boolean isExistField(Object obj, String fieldName) {
        boolean r = false;
        if (obj != null) {
            Field[] fields = obj.getClass().getDeclaredFields();
            for (int j = 0; j < fields.length; ++j) {
                if (!fields[j].getName().equals(fieldName)) continue;
                r = true;
                break;
            }
        }
        return r;
    }
}

