/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.constants.ResourceAbsorbParam;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.UUIDUtils;

public class ResourceAbsorbHelper {
    private static final Log logger = LogFactory.getLog(ResourceAbsorbHelper.class);

    public static void buildCostAndPeriod(Long acctOrgId, ResourceAbsorbParam resourceSbsParam) {
        resourceSbsParam.setAccountOrg(acctOrgId);
        HashSet<Long> costAccountIds = new HashSet<Long>();
        String selectFields = "entryentity.costaccount.id as id,entryentity.calpolicy.currency as currency,entryentity.calpolicy.currency.amtprecision as amtprecision,entryentity.calpolicy.currency.priceprecision as priceprecision";
        DynamicObjectCollection costAccounts = StartCostHelper.getCostAccounts(acctOrgId, true, selectFields, "sca");
        for (DynamicObject costAccount : costAccounts) {
            costAccountIds.add(costAccount.getLong("id"));
            resourceSbsParam.getCostActCurrMap().put(costAccount.getLong("id"), costAccount.getLong("currency"));
            resourceSbsParam.getCurreyMap().put(costAccount.getLong("currency"), costAccount);
        }
        resourceSbsParam.setCostAccountSet(costAccountIds);
        QFilter orgQF = new QFilter("org", "=", (Object)acctOrgId);
        QFilter costAccountQF = new QFilter("entry.costaccount", "in", costAccountIds);
        DynamicObjectCollection res = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id,entry.costaccount as costaccount,entry.currentperiod AS currentperiod,entry.currentperiod.begindate as begindate", (QFilter[])new QFilter[]{orgQF, costAccountQF});
        for (DynamicObject re : res) {
            resourceSbsParam.getCostAccountPeriodMap().put(re.getLong("costaccount"), re.getLong("currentperiod"));
            resourceSbsParam.getPeriodTimeMap().put(re.getLong("currentperiod"), re.getDate("begindate"));
        }
    }

    public static DynamicObject getCostTypeByOrg(long org, long manuOrg) {
        QFilter filter = new QFilter("costtype.type", "=", (Object)"0");
        boolean enableFactory = OrgHelper.isOrgEnableMultiFactory(org);
        if (enableFactory) {
            List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)manuOrg, (boolean)true);
            Long invOrg = CadEmptyUtils.isEmpty(allToOrg) ? Long.valueOf(0L) : (allToOrg.contains(manuOrg) ? Long.valueOf(manuOrg) : (Long)allToOrg.get(0));
            filter.and("storageorgunit", "=", (Object)invOrg);
        } else {
            filter.and("calorg", "=", (Object)org);
        }
        filter.and("costtype", "!=", (Object)0L);
        filter.and("bizstatus", "=", (Object)"1");
        filter.and("effectdate", "<=", (Object)new Date());
        filter.and("invaliddate", ">", (Object)new Date());
        return QueryServiceHelper.queryOne((String)"cal_bd_costtypeorg", (String)"costtype.id as costType,costtype.name as name", (QFilter[])new QFilter[]{filter});
    }

    public static Map<String, List<DynamicObject>> getResourceMap(Set<Long> costTypes, Set<Long> resources, QFilter timeFilter) {
        DynamicObject[] objects;
        DynamicObject[] dynamicObjects;
        HashMap<String, List<DynamicObject>> resourceMap = new HashMap<String, List<DynamicObject>>(16);
        QFilter filter = new QFilter("costtype", "in", costTypes);
        if (timeFilter != null) {
            filter.and(timeFilter);
        }
        filter.and("billstatus", "=", (Object)"C");
        filter.and("resource", "in", resources);
        logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6_\u8d44\u6e90ID\u96c6\u5408==>{},\u6210\u672c\u7c7b\u578b==>{}", resources, costTypes);
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_resourcerate", (String)"billno,workcenter,resource,pricerule,costtype,calcbasis,element,subelement,resourceunit,qty,amount,effectdate,expdate,entryentity.attaelement,entryentity.attasubelement,entryentity.attaqty,entryentity.attaamt", (QFilter[])new QFilter[]{filter})) {
            String key = "zz@" + dynamicObject.getLong("costtype.id") + "@" + dynamicObject.getLong("resource.id") + "@" + dynamicObject.getLong("workcenter.id");
            logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6_\u83b7\u53d6\u81ea\u5236\u8d44\u6e90\u5bf9\u5e94key\u4e3a==>{}", (Object)key);
            resourceMap.computeIfAbsent(key, s -> new ArrayList()).add(dynamicObject);
        }
        filter.and(new QFilter("pdmrouteid", ">", (Object)0L));
        for (DynamicObject object : objects = BusinessDataServiceHelper.load((String)"cad_resourceout", (String)"material,auxpty,pdmrouteid,processseq,operationno,resource,pricerule,costtype,calcbasis,element,subelement,resourceunit,qty,amount,effectdate,expdate,entryentity.attaelement,entryentity.attasubelement,entryentity.attaqty,entryentity.attaamt", (QFilter[])new QFilter[]{filter})) {
            String key = "wx@" + object.getLong("costtype.id") + "@" + object.getLong("resource.id") + "@" + object.getLong("pdmrouteid") + "@" + object.getString("processseq") + "@" + object.getString("operationno");
            logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6_\u83b7\u53d6\u5916\u534f\u8d44\u6e90\u5bf9\u5e94key\u4e3a==>{}", (Object)key);
            resourceMap.computeIfAbsent(key, s -> new ArrayList()).add(object);
        }
        return resourceMap;
    }

    public static Set<Long> delOrRevertEntity(Set<Long> allSourceIds, String sourceEntity, String appNum, Set<String> revertHeadFields, Set<String> revertBodyFields) {
        HashSet<Long> deletedIds = new HashSet<Long>(16);
        if (CadEmptyUtils.isEmpty(allSourceIds)) {
            return deletedIds;
        }
        if ("sca".equals(appNum)) {
            List partitions = Lists.partition(new ArrayList<Long>(allSourceIds), (int)20000);
            for (List existSourceIds : partitions) {
                Sets.SetView difference;
                DynamicObjectCollection voucheredResourceAbsorbs = ResourceAbsorbHelper.getVoucheredResourceAbsorb(existSourceIds);
                HashSet<Long> needRevertAbsorbs = new HashSet<Long>();
                HashSet<Long> needRevertEntities = new HashSet<Long>();
                for (DynamicObject voucheredResourceAbsorb : voucheredResourceAbsorbs) {
                    needRevertAbsorbs.add(voucheredResourceAbsorb.getLong("id"));
                    needRevertEntities.add(voucheredResourceAbsorb.getLong("sourcebill"));
                }
                CloneUtils cloneUtils = new CloneUtils(Boolean.TRUE.booleanValue(), Boolean.TRUE.booleanValue());
                HashMap<Long, Long> idCxIdMap = new HashMap<Long, Long>(needRevertEntities.size());
                String randomCode = UUIDUtils.getUUIDN(4);
                if (!needRevertEntities.isEmpty()) {
                    DynamicObject[] revertEntities;
                    for (DynamicObject resource : revertEntities = BusinessDataServiceHelper.load((Object[])needRevertEntities.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)sourceEntity))) {
                        resource.set("billno", (Object)resource.getString("billno").concat(randomCode).concat("pz"));
                        resource.set("vouchertype", (Object)"1");
                    }
                    SaveServiceHelper.save((DynamicObject[])revertEntities);
                    ArrayList resources = new ArrayList(revertEntities.length);
                    DynamicObject[] dynamicObjectArray = revertEntities;
                    int n = dynamicObjectArray.length;
                    for (int resource = 0; resource < n; ++resource) {
                        DynamicObject revertEntity = dynamicObjectArray[resource];
                        long oldId = revertEntity.getLong("id");
                        DynamicObject entity = (DynamicObject)cloneUtils.clone((IDataEntityBase)revertEntity);
                        long cxId = ID.genLongId();
                        entity.set("id", (Object)cxId);
                        idCxIdMap.put(oldId, cxId);
                        entity.set("billno", (Object)entity.getString("billno").concat(randomCode).concat("cx"));
                        entity.set("createtime", (Object)TimeServiceHelper.now());
                        entity.set("creator", (Object)RequestContext.get().getCurrUserId());
                        entity.set("modifytime", (Object)TimeServiceHelper.now());
                        entity.set("modifier", (Object)RequestContext.get().getCurrUserId());
                        entity.set("auditor", (Object)RequestContext.get().getCurrUserId());
                        entity.set("auditdate", (Object)TimeServiceHelper.now());
                        entity.set("vouchertype", (Object)"-1");
                        for (String string : revertHeadFields) {
                            entity.set(string, (Object)entity.getBigDecimal(string).negate());
                        }
                        DynamicObjectCollection entryentity = entity.getDynamicObjectCollection("entryentity");
                        for (DynamicObject dynamicObject : entryentity) {
                            for (String revertBodyField : revertBodyFields) {
                                BigDecimal current = dynamicObject.getBigDecimal(revertBodyField);
                                if (current.compareTo(BigDecimal.ZERO) == 0) continue;
                                dynamicObject.set(revertBodyField, (Object)dynamicObject.getBigDecimal(revertBodyField).negate());
                            }
                        }
                        resources.add(entity);
                    }
                    SaveServiceHelper.save((DynamicObject[])resources.toArray(new DynamicObject[0]));
                }
                if (!needRevertAbsorbs.isEmpty()) {
                    DynamicObject[] resourceAbsorbs = BusinessDataServiceHelper.load((Object[])needRevertAbsorbs.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"sca_resourceabsorb"));
                    for (DynamicObject resourceAbsorb : resourceAbsorbs) {
                        resourceAbsorb.set("billno", (Object)resourceAbsorb.getString("billno").concat(randomCode).concat("pz"));
                    }
                    SaveServiceHelper.save((DynamicObject[])resourceAbsorbs);
                    ArrayList<DynamicObject> revertAbsorbs = new ArrayList<DynamicObject>(resourceAbsorbs.length);
                    for (DynamicObject resourceAbsorb : resourceAbsorbs) {
                        DynamicObject clone = (DynamicObject)cloneUtils.clone((IDataEntityBase)resourceAbsorb);
                        clone.set("billno", (Object)clone.getString("billno").concat("cx"));
                        clone.set("createtime", (Object)TimeServiceHelper.now());
                        clone.set("creator", (Object)RequestContext.get().getCurrUserId());
                        clone.set("modifytime", (Object)TimeServiceHelper.now());
                        long oldId = clone.getLong("sourcebill");
                        clone.set("sourcebill", idCxIdMap.get(oldId));
                        clone.set("modifier", (Object)RequestContext.get().getCurrUserId());
                        clone.set("auditor", (Object)RequestContext.get().getCurrUserId());
                        clone.set("auditdate", (Object)TimeServiceHelper.now());
                        clone.set("vouchernum", (Object)" ");
                        DynamicObjectCollection entryEntity = clone.getDynamicObjectCollection("entryentity");
                        for (DynamicObject dynamicObject : entryEntity) {
                            BigDecimal bigDecimal = dynamicObject.getBigDecimal("amount");
                            BigDecimal qty = dynamicObject.getBigDecimal("qty");
                            dynamicObject.set("amount", (Object)bigDecimal.negate());
                            dynamicObject.set("qty", (Object)qty.negate());
                        }
                        revertAbsorbs.add(clone);
                    }
                    SaveServiceHelper.save((DynamicObject[])revertAbsorbs.toArray(new DynamicObject[0]));
                }
                if ((difference = Sets.difference(new HashSet(existSourceIds), needRevertEntities)).isEmpty()) continue;
                deletedIds.addAll((Collection<Long>)difference);
                ResourceAbsorbHelper.delResourceAbsorb((Set<Long>)difference);
                ResourceAbsorbHelper.delSourceEntity((Collection<Long>)difference, sourceEntity);
            }
        } else {
            deletedIds.addAll(allSourceIds);
            List partitions = Lists.partition(new ArrayList<Long>(allSourceIds), (int)20000);
            for (List existSourceIds : partitions) {
                ResourceAbsorbHelper.delSourceEntity(existSourceIds, sourceEntity);
            }
        }
        return deletedIds;
    }

    private static DynamicObjectCollection getVoucheredResourceAbsorb(List<Long> existSourceIds) {
        if (!CadEmptyUtils.isEmpty(existSourceIds)) {
            QFilter filter = new QFilter("sourcebill", "in", existSourceIds);
            filter.and("vouchernum", "!=", (Object)" ");
            DynamicObjectCollection voucheredResourceAbsorbs = QueryServiceHelper.query((String)"sca_resourceabsorb", (String)"id,sourcebill", (QFilter[])new QFilter[]{filter});
            HashSet<Long> sourceBillIds = new HashSet<Long>(voucheredResourceAbsorbs.size());
            for (DynamicObject voucheredResourceAbsorb : voucheredResourceAbsorbs) {
                long sourceBillId = voucheredResourceAbsorb.getLong("sourcebill");
                if (CadEmptyUtils.isEmpty(sourceBillId)) continue;
                sourceBillIds.add(sourceBillId);
            }
            if (!sourceBillIds.isEmpty()) {
                QFilter sourceBillQf = new QFilter("sourcebill", "in", sourceBillIds);
                return QueryServiceHelper.query((String)"sca_resourceabsorb", (String)"id,sourcebill", (QFilter[])new QFilter[]{sourceBillQf});
            }
        }
        return new DynamicObjectCollection();
    }

    private static void delResourceAbsorb(Set<Long> resourceUseIds) {
        QFilter filter = new QFilter("sourcebill", "in", resourceUseIds);
        DeleteServiceHelper.delete((String)"sca_resourceabsorb", (QFilter[])new QFilter[]{filter});
    }

    private static void delSourceEntity(Collection<Long> resourceUseIds, String sourceEntity) {
        QFilter filter = new QFilter("id", "in", resourceUseIds);
        DeleteServiceHelper.delete((String)sourceEntity, (QFilter[])new QFilter[]{filter});
    }

    public static DynamicObject getResourceByPriceRule(Long costType, DynamicObject dynamicObject, Map<String, List<DynamicObject>> resultMap, ResourceAbsorbParam resourceSbsParam) {
        DynamicObject resourceObj;
        long workCenter = dynamicObject.get("workcenter") instanceof DynamicObject ? dynamicObject.getLong("workcenter.id") : dynamicObject.getLong("workcenter");
        long resource = dynamicObject.get("resource") instanceof DynamicObject ? dynamicObject.getLong("resource.id") : dynamicObject.getLong("resource");
        long route = dynamicObject.get("route") instanceof DynamicObject ? dynamicObject.getLong("route.id") : dynamicObject.getLong("route");
        String processseq = dynamicObject.getString("processseq");
        String operationno = dynamicObject.getString("operationno");
        String key = "zz@" + costType + "@" + resource + "@" + workCenter;
        if (resultMap.get(key) != null && (resourceObj = ResourceAbsorbHelper.filterByTime(dynamicObject, resultMap.get(key))) != null) {
            return resourceObj;
        }
        key = "zz@" + costType + "@" + resource + "@" + 0;
        if (resultMap.get(key) != null && (resourceObj = ResourceAbsorbHelper.filterByTime(dynamicObject, resultMap.get(key))) != null) {
            return resourceObj;
        }
        key = "wx@" + costType + "@" + resource + "@" + route + "@" + processseq + "@" + operationno;
        if (resultMap.get(key) != null && (resourceObj = ResourceAbsorbHelper.filterByTime(dynamicObject, resultMap.get(key))) != null) {
            return resourceObj;
        }
        return null;
    }

    private static DynamicObject filterByTime(DynamicObject targetObj, List<DynamicObject> matchObj) {
        Date matchDate = targetObj.getDate("pricedate") == null ? targetObj.getDate("bookdate") : targetObj.getDate("pricedate");
        for (DynamicObject dynamicObject : matchObj) {
            Date effectDate = dynamicObject.getDate("effectdate");
            Date expDate = dynamicObject.getDate("expdate");
            if (effectDate.compareTo(matchDate) > 0 || expDate.compareTo(matchDate) <= 0) continue;
            return dynamicObject;
        }
        return null;
    }

    public static Map<Long, DynamicObject> getRulePlanByCostTypes(Set<Long> costTypes) {
        HashMap<Long, DynamicObject> resultMap = new HashMap<Long, DynamicObject>();
        QFilter filter = new QFilter("id", "in", costTypes);
        filter.and("costtypeentry.costtypeattr", "=", (Object)"1");
        filter.and("enable", "=", (Object)true);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costtype", (String)"id,costtypeentry.costtype as costType", (QFilter[])new QFilter[]{filter});
        HashMap<Long, Long> map = new HashMap<Long, Long>(10);
        for (DynamicObject dynamicObject : dynamicObjects) {
            map.put(dynamicObject.getLong("costType"), dynamicObject.getLong("id"));
        }
        if (!map.isEmpty()) {
            DynamicObject[] load;
            Set costTypeSet = map.keySet();
            QFilter qFilter = new QFilter("costtype", "in", costTypeSet);
            qFilter.and("default", "=", (Object)true);
            qFilter.and("enable", "=", (Object)true);
            for (DynamicObject object : load = BusinessDataServiceHelper.load((String)"cad_calcruleplan", (String)"costtype,number,name,selfresourceentry.sereslevel,selfresourceentry.seresrule,outresourceentry.outreslevel,outresourceentry.outresrule", (QFilter[])new QFilter[]{qFilter})) {
                resultMap.put((Long)map.get(object.getLong("costtype.id")), object);
            }
        }
        return resultMap;
    }

    public static Set<Long> getUnAbsorbResource(List<Long> sourceBillIds) {
        Sets.SetView difference = new HashSet(32);
        if (!CadEmptyUtils.isEmpty(sourceBillIds)) {
            HashSet<Long> alreadyGen = new HashSet<Long>(32);
            QFilter sourceIdQf = new QFilter("sourcebill", "in", sourceBillIds);
            DataSet absorbDataSet = QueryServiceHelper.queryDataSet((String)"checkAbsorb_getUnabsorb", (String)"sca_resourceabsorb", (String)"sourcebill", (QFilter[])new QFilter[]{sourceIdQf}, null);
            for (Row row : absorbDataSet) {
                alreadyGen.add(row.getLong("sourcebill"));
            }
            difference = Sets.difference(new HashSet<Long>(sourceBillIds), alreadyGen);
        }
        return difference;
    }
}

