/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.operate.MutexHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class SimpleMutexHelper {
    private static final Map<String, List<String>> typeMap = new HashMap<String, List<String>>();
    public static final String MATALLOC_IMPORTCOLLC = "importcollc";
    public static final String COSTOBJECT_IMPORT = "costobject-import";
    public static final String PLAN_IMPORT = "plan-import";
    public static final String FACT_IMPORT = "fact-import";
    public static final String DIY_IMPORT = "diycostdriver-import";
    public static final String WORK_IMPORT = "work-import";
    public static final String MAT_IMPORT = "mat-import";
    public static final String RESOURCE_IMPORT = "resource-import";
    public static final String PLAN_RESOURCE_IMPORT = "plan-resource-import";
    public static final String MFGFEEIMPORT = "mfgFeeImport";
    public static final String NONIMPORT = "nonImport";
    public static final String NONALLOC = "nonAlloc";
    public static final String NONCONFIRM = "nonConfirm";
    public static final String AUXIMPORT = "auxImport";
    public static final String AUXALLOC = "auxAlloc";
    public static final String AUXCONFIRM = "auxConfirm";
    public static final String BASICIMPORT = "basicImport";
    public static final String BASICALLOC = "basicAlloc";
    public static final String BASICCONFIRM = "basicConfirm";
    public static final String PLANNONIMPORT = "plannonImport";
    public static final String PLANNONALLOC = "plannonAlloc";
    public static final String PLANNONCONFIRM = "plannonConfirm";
    public static final String PLANAUXIMPORT = "planauxImport";
    public static final String PLANAUXALLOC = "planauxAlloc";
    public static final String PLANAUXCONFIRM = "planauxConfirm";
    public static final String PLANBASICIMPORT = "planbasicImport";
    public static final String PLANBASICALLOC = "planbasicAlloc";
    public static final String PLANBASICCONFIRM = "planbasicConfirm";
    public static final String PLANRATEIMPORT = "planrateimport";
    public static final String COIMPORT = "coImport";
    public static final String COALLOC = "coAlloc";
    public static final String COCONFIRM = "coConfirm";

    public static String checkAndRequireXMutex(String type, Object id) {
        if (!MutexHelper.enableReentrant((String)typeMap.get(type).get(0), (Object)id, (String)typeMap.get(type).get(1))) {
            String tips = SimpleMutexHelper.getErrTips(type);
            return String.format(tips, ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7", (String)"SimpleMutexHelper_0", (String)"macc-cad-common", (Object[])new Object[0]));
        }
        if (!SimpleMutexHelper.requireXMutex(type, id)) {
            String tips = SimpleMutexHelper.getErrTips(type);
            return String.format(tips, ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7", (String)"SimpleMutexHelper_0", (String)"macc-cad-common", (Object[])new Object[0]));
        }
        return "";
    }

    public static String mfgCheckAndRequireXMutex(String type, Long costAccountId) {
        String requireXMutexKey = costAccountId + type;
        if (!MutexHelper.enableReentrant((String)typeMap.get(type).get(0), (Object)requireXMutexKey, (String)typeMap.get(type).get(1))) {
            return SimpleMutexHelper.getMfgErrTips(typeMap.get(type).get(0), typeMap.get(type).get(1), costAccountId);
        }
        if (!SimpleMutexHelper.requireXMutex(type, requireXMutexKey)) {
            return SimpleMutexHelper.getMfgErrTips(typeMap.get(type).get(0), typeMap.get(type).get(1), costAccountId);
        }
        return null;
    }

    private static String getMfgErrTips(String entity, String type, Long costAccountId) {
        DynamicObject costAccountDy = BusinessDataServiceHelper.loadSingleFromCache((Object)costAccountId, (String)"cal_bd_costaccount", (String)"name");
        String costAccountName = costAccountDy == null ? "" : costAccountDy.getString("name");
        String entityName = "";
        switch (entity) {
            case "cad_nonprodalloc": {
                entityName = ResManager.loadKDString((String)"\u975e\u751f\u4ea7", (String)"SimpleMutexHelper_2", (String)"macc-cad-common", (Object[])new Object[0]);
                break;
            }
            case "cad_auxprodalloc": {
                entityName = ResManager.loadKDString((String)"\u8f85\u52a9\u751f\u4ea7", (String)"SimpleMutexHelper_3", (String)"macc-cad-common", (Object[])new Object[0]);
                break;
            }
            case "cad_basicalloc": {
                entityName = ResManager.loadKDString((String)"\u57fa\u672c\u751f\u4ea7", (String)"SimpleMutexHelper_4", (String)"macc-cad-common", (Object[])new Object[0]);
                break;
            }
            case "cad_mfgfeeallocco": {
                entityName = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u5185", (String)"SimpleMutexHelper_5", (String)"macc-cad-common", (Object[])new Object[0]);
                break;
            }
            case "cad_mfgfeebill": {
                entityName = ResManager.loadKDString((String)"\u5b9e\u9645\u8d39\u7528\u5f52\u96c6", (String)"SimpleMutexHelper_18", (String)"macc-cad-common", (Object[])new Object[0]);
            }
        }
        switch (type) {
            case "sysimport": 
            case "importcollc": {
                return String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u6b63\u5728\u8fdb\u884c%2$s\u5f15\u5165\uff0c\u8bf7\u7a0d\u540e\u6267\u884c", (String)"SimpleMutexHelper_6", (String)"macc-cad-common", (Object[])new Object[0]), costAccountName, entityName);
            }
            case "importalloc": {
                return String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u6b63\u5728\u8fdb\u884c%2$s\u5f15\u5165\u6216\u5206\u914d\uff0c\u8bf7\u7a0d\u540e\u6267\u884c", (String)"SimpleMutexHelper_10", (String)"macc-cad-common", (Object[])new Object[0]), costAccountName, entityName);
            }
            case "allocation": {
                return String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u6b63\u5728\u8fdb\u884c%2$s\u5206\u914d\uff0c\u8bf7\u7a0d\u540e\u6267\u884c", (String)"SimpleMutexHelper_7", (String)"macc-cad-common", (Object[])new Object[0]), costAccountName, entityName);
            }
            case "op_confirm": {
                return String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u6b63\u5728\u8fdb\u884c%2$s\u786e\u8ba4\uff0c\u8bf7\u7a0d\u540e\u6267\u884c", (String)"SimpleMutexHelper_8", (String)"macc-cad-common", (Object[])new Object[0]), costAccountName, entityName);
            }
        }
        return null;
    }

    public static String planmfgCheckAndRequireXMutex(String type, Long costAccountId) {
        String requireXMutexKey = costAccountId + type;
        if (!MutexHelper.enableReentrant((String)typeMap.get(type).get(0), (Object)requireXMutexKey, (String)typeMap.get(type).get(1))) {
            return SimpleMutexHelper.getplanMfgErrTips(typeMap.get(type).get(0), typeMap.get(type).get(1), costAccountId);
        }
        if (!SimpleMutexHelper.requireXMutex(type, requireXMutexKey)) {
            return SimpleMutexHelper.getplanMfgErrTips(typeMap.get(type).get(0), typeMap.get(type).get(1), costAccountId);
        }
        return null;
    }

    private static String getplanMfgErrTips(String entity, String type, Long schemeId) {
        DynamicObject costAccountDy = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"cad_planscheme", (String)"name");
        String costAccountName = costAccountDy == null ? "" : costAccountDy.getString("name");
        String entityName = "";
        switch (entity) {
            case "cad_plannonprodalloc": {
                entityName = ResManager.loadKDString((String)"\u8ba1\u5212\u975e\u751f\u4ea7", (String)"SimpleMutexHelper_13", (String)"macc-cad-common", (Object[])new Object[0]);
                break;
            }
            case "cad_planauxprodalloc": {
                entityName = ResManager.loadKDString((String)"\u8ba1\u5212\u8f85\u52a9\u751f\u4ea7", (String)"SimpleMutexHelper_14", (String)"macc-cad-common", (Object[])new Object[0]);
                break;
            }
            case "cad_planbasicalloc": {
                entityName = ResManager.loadKDString((String)"\u8ba1\u5212\u57fa\u672c\u751f\u4ea7", (String)"SimpleMutexHelper_15", (String)"macc-cad-common", (Object[])new Object[0]);
                break;
            }
            case "cad_resourcplanrate": {
                entityName = ResManager.loadKDString((String)"\u8d44\u6e90\u8ba1\u5212\u8d39\u7387", (String)"SimpleMutexHelper_16", (String)"macc-cad-common", (Object[])new Object[0]);
            }
        }
        switch (type) {
            case "sysimport": {
                return String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u6b63\u5728\u8fdb\u884c%2$s\u8ba1\u7b97\uff0c\u8bf7\u7a0d\u540e\u6267\u884c", (String)"SimpleMutexHelper_17", (String)"macc-cad-common", (Object[])new Object[0]), costAccountName, entityName);
            }
            case "importcollc": {
                return String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u6b63\u5728\u8fdb\u884c%2$s\u5f15\u5165\uff0c\u8bf7\u7a0d\u540e\u6267\u884c", (String)"SimpleMutexHelper_6", (String)"macc-cad-common", (Object[])new Object[0]), costAccountName, entityName);
            }
            case "importalloc": {
                return String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u6b63\u5728\u8fdb\u884c%2$s\u5f15\u5165\u6216\u5206\u914d\uff0c\u8bf7\u7a0d\u540e\u6267\u884c", (String)"SimpleMutexHelper_10", (String)"macc-cad-common", (Object[])new Object[0]), costAccountName, entityName);
            }
            case "allocation": {
                return String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u6b63\u5728\u8fdb\u884c%2$s\u5206\u914d\uff0c\u8bf7\u7a0d\u540e\u6267\u884c", (String)"SimpleMutexHelper_7", (String)"macc-cad-common", (Object[])new Object[0]), costAccountName, entityName);
            }
            case "op_confirm": {
                return String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u6b63\u5728\u8fdb\u884c%2$s\u786e\u8ba4\uff0c\u8bf7\u7a0d\u540e\u6267\u884c", (String)"SimpleMutexHelper_8", (String)"macc-cad-common", (Object[])new Object[0]), costAccountName, entityName);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkMutexAndLock(String type, boolean enableMulFactory, Long acctId, Set<Long> orgSet) {
        boolean releaseFlag = true;
        boolean cancelFlag = false;
        HashSet<Long> cancelOrgSet = new HashSet<Long>(8);
        String lockErr = SimpleMutexHelper.checkAndRequireXMutex(type, acctId);
        try {
            if (StringUtils.isNotEmpty((String)lockErr)) {
                releaseFlag = false;
                String string = lockErr;
                return string;
            }
            if (enableMulFactory) {
                Iterator<Long> ite = orgSet.iterator();
                String lockStr = "";
                while (ite.hasNext()) {
                    Long orgId = ite.next();
                    lockStr = String.valueOf(acctId) + orgId;
                    lockErr = SimpleMutexHelper.checkAndRequireXMutex(type, lockStr.hashCode());
                    if (StringUtils.isNotEmpty((String)lockErr)) {
                        cancelFlag = true;
                        String string = lockErr;
                        return string;
                    }
                    cancelOrgSet.add(orgId);
                }
            }
        }
        finally {
            if (enableMulFactory && releaseFlag) {
                SimpleMutexHelper.releaseXMutex(type, acctId);
            }
            if (cancelFlag && cancelOrgSet.size() > 0) {
                for (Long orgId : cancelOrgSet) {
                    SimpleMutexHelper.releaseXMutex(type, (String.valueOf(acctId) + orgId).hashCode());
                }
            }
        }
        return null;
    }

    public static void releaseMuteFromSet(String type, boolean enableMulFactory, Long acctId, Set<Long> orgSet) {
        if (!enableMulFactory) {
            SimpleMutexHelper.releaseXMutex(type, acctId);
            return;
        }
        for (Long orgId : orgSet) {
            SimpleMutexHelper.releaseXMutex(type, (String.valueOf(acctId) + orgId).hashCode());
        }
    }

    private static synchronized boolean requireXMutex(String type, Object id) {
        StringBuilder errMsg = new StringBuilder();
        boolean allLock = MutexHelper.require((String)typeMap.get(type).get(0), (Object)id, (String)typeMap.get(type).get(1), (boolean)true, (StringBuilder)errMsg);
        if (!allLock) {
            SimpleMutexHelper.releaseXMutex(type, id);
        }
        return allLock;
    }

    public static synchronized boolean releaseXMutex(String type, Object id) {
        return MutexHelper.release((String)typeMap.get(type).get(0), (String)typeMap.get(type).get(1), (String)id.toString());
    }

    public static String getErrTips(String type) {
        return ResManager.loadKDString((String)"%s\u6b63\u5728\u8fdb\u884c\u5f15\u5165\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"SimpleMutexHelper_1", (String)"macc-cad-common", (Object[])new Object[0]);
    }

    static {
        typeMap.put(MATALLOC_IMPORTCOLLC, Arrays.asList("sca_matalloc", MATALLOC_IMPORTCOLLC));
        typeMap.put(COSTOBJECT_IMPORT, Arrays.asList("cad_costobject", "op_newbyrulecover"));
        typeMap.put(PLAN_IMPORT, Arrays.asList("cad_plannedoutputbill", "innerimport"));
        typeMap.put(FACT_IMPORT, Arrays.asList("cad_factnedoutputbill", "addimport"));
        typeMap.put(MAT_IMPORT, Arrays.asList("sca_matusecollect", "sysimportcover"));
        typeMap.put(RESOURCE_IMPORT, Arrays.asList("sca_resourceuse", "sysimportcover"));
        typeMap.put(PLAN_RESOURCE_IMPORT, Arrays.asList("cad_planresource", "sysimport"));
        typeMap.put(DIY_IMPORT, Arrays.asList("sca_diycostdriver", "sysimport"));
        typeMap.put(WORK_IMPORT, Arrays.asList("sca_workqtycollec", "sysimport"));
        typeMap.put(MFGFEEIMPORT, Arrays.asList("cad_mfgfeebill", "sysimport"));
        typeMap.put(NONIMPORT, Arrays.asList("cad_nonprodalloc", MATALLOC_IMPORTCOLLC));
        typeMap.put(NONALLOC, Arrays.asList("cad_nonprodalloc", "allocation"));
        typeMap.put(NONCONFIRM, Arrays.asList("cad_nonprodalloc", "op_confirm"));
        typeMap.put(AUXIMPORT, Arrays.asList("cad_auxprodalloc", MATALLOC_IMPORTCOLLC));
        typeMap.put(AUXALLOC, Arrays.asList("cad_auxprodalloc", "allocation"));
        typeMap.put(AUXCONFIRM, Arrays.asList("cad_auxprodalloc", "op_confirm"));
        typeMap.put(BASICIMPORT, Arrays.asList("cad_basicalloc", MATALLOC_IMPORTCOLLC));
        typeMap.put(BASICALLOC, Arrays.asList("cad_basicalloc", "allocation"));
        typeMap.put(BASICCONFIRM, Arrays.asList("cad_basicalloc", "op_confirm"));
        typeMap.put(COIMPORT, Arrays.asList("cad_mfgfeeallocco", "importalloc"));
        typeMap.put(COALLOC, Arrays.asList("cad_mfgfeeallocco", "allocation"));
        typeMap.put(COCONFIRM, Arrays.asList("cad_mfgfeeallocco", "op_confirm"));
        typeMap.put(PLANNONIMPORT, Arrays.asList("cad_plannonprodalloc", MATALLOC_IMPORTCOLLC));
        typeMap.put(PLANNONALLOC, Arrays.asList("cad_plannonprodalloc", "allocation"));
        typeMap.put(PLANNONCONFIRM, Arrays.asList("cad_plannonprodalloc", "op_confirm"));
        typeMap.put(PLANAUXIMPORT, Arrays.asList("cad_planauxprodalloc", MATALLOC_IMPORTCOLLC));
        typeMap.put(PLANAUXALLOC, Arrays.asList("cad_planauxprodalloc", "allocation"));
        typeMap.put(PLANAUXCONFIRM, Arrays.asList("cad_planauxprodalloc", "op_confirm"));
        typeMap.put(PLANBASICIMPORT, Arrays.asList("cad_planbasicalloc", MATALLOC_IMPORTCOLLC));
        typeMap.put(PLANBASICALLOC, Arrays.asList("cad_planbasicalloc", "allocation"));
        typeMap.put(PLANBASICCONFIRM, Arrays.asList("cad_planbasicalloc", "op_confirm"));
        typeMap.put(PLANRATEIMPORT, Arrays.asList("cad_resourcplanrate", "sysimport"));
    }
}

