/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.collections.CollectionUtils;

public class StartCostHelper {
    private static final Log logger = LogFactory.getLog(StartCostHelper.class);

    public static QFilter getEnabledCostAccountIdsFilter(Long orgId, String appnum) {
        ArrayList<Object> orgIdList = new ArrayList<Object>();
        orgIdList.add(orgId);
        return StartCostHelper.getEnabledCostAccountIdsFilter(orgIdList, appnum);
    }

    public static QFilter getEnabledCostAccountIdsFilter(List<Object> orgIdList, String appnum) {
        ArrayList orgIdLongList = new ArrayList();
        orgIdList.forEach(t -> orgIdLongList.add(Long.valueOf(t.toString())));
        QFilter orgFilter = new QFilter("org", "in", orgIdLongList);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isEndInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)appnum);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isEndInitFilter, appnumFilter};
        DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filters);
        if (CollectionUtils.isNotEmpty((Collection)costAccountIds)) {
            Set costAccountIdList = costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toSet());
            return new QFilter("id", "in", costAccountIdList);
        }
        return new QFilter("id", "=", (Object)0L);
    }

    public static QFilter getEnabledFilter(List<Object> orgIdList, String appnum) {
        ArrayList orgIdLongList = new ArrayList();
        orgIdList.forEach(t -> orgIdLongList.add(Long.valueOf(t.toString())));
        QFilter orgFilter = new QFilter("org", "in", orgIdLongList);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)appnum);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, appnumFilter};
        DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filters);
        if (CollectionUtils.isNotEmpty((Collection)costAccountIds)) {
            Set costAccountIdList = costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toSet());
            return new QFilter("id", "in", costAccountIdList);
        }
        return new QFilter("id", "=", (Object)0L);
    }

    public static QFilter getUseEnabledCostAccountIdsFilter(List<Long> orgIdList, String appnum) {
        QFilter orgFilter = new QFilter("org", "in", orgIdList);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isEndInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter appnumFilter = new QFilter("appnum", "=", (Object)appnum);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isEndInitFilter, appnumFilter};
        DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filters);
        if (CollectionUtils.isNotEmpty((Collection)costAccountIds)) {
            Set costAccountIdList = costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toSet());
            return new QFilter("id", "in", costAccountIdList);
        }
        return new QFilter("id", "=", (Object)0L);
    }

    public static Set<Long> getEnabledOrg(String appNum) {
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appNum);
        QFilter qfEnabled = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{qfAppNum, qfEnabled};
        DynamicObjectCollection startStdcost = QueryServiceHelper.query((String)"sca_startstdcost", (String)"org", (QFilter[])filters);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        startStdcost.forEach(p -> orgIds.add(p.getLong("org")));
        return orgIds;
    }

    public static Set<Long> getEnabledCostAccount(String appNum) {
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appNum);
        QFilter qfEnabled = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        qfEnabled.and(new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE));
        QFilter[] filters = new QFilter[]{qfAppNum, qfEnabled};
        DynamicObjectCollection startStdcost = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount", (QFilter[])filters);
        HashSet<Long> acctIds = new HashSet<Long>(16);
        startStdcost.forEach(p -> acctIds.add(p.getLong("entryentity.costaccount")));
        return acctIds;
    }

    public static Set<Long> getIsinitCostAccount(String appNum) {
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appNum);
        QFilter qfEnabled = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        qfEnabled.and(new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE));
        QFilter isinitQF = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{qfAppNum, qfEnabled, isinitQF};
        DynamicObjectCollection startStdcost = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount", (QFilter[])filters);
        HashSet<Long> acctIds = new HashSet<Long>(16);
        startStdcost.forEach(p -> acctIds.add(p.getLong("entryentity.costaccount")));
        return acctIds;
    }

    public static QFilter getEnabledCostAccountFilter(String appNum) {
        return new QFilter("id", "in", StartCostHelper.getEnabledCostAccount(appNum));
    }

    public static QFilter getIsinitCostAccountFilter(String appNum) {
        return new QFilter("id", "in", StartCostHelper.getIsinitCostAccount(appNum));
    }

    public static QFilter getEndInitCostAccountIdsFilter(Long orgId, String appNum) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appNum);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{orgFilter, qfAppNum, isInitFilter};
        DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filters);
        if (CollectionUtils.isNotEmpty((Collection)costAccountIds)) {
            Set costAccountIdList = costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toSet());
            return new QFilter("id", "in", costAccountIdList);
        }
        return new QFilter("id", "=", (Object)0L);
    }

    public static QFilter getEnableEndInitQfilterByOrg(Long orgId, String appNum) {
        return StartCostHelper.getEnableQfilterByOrg(orgId, Boolean.TRUE, appNum);
    }

    public static QFilter getEnableQfilterByOrg(Long orgId, Boolean isInit, String appNum) {
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appNum);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = null;
        if (isInit != null) {
            isInitFilter = new QFilter("entryentity.isinit", "=", (Object)isInit);
        }
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{appNumQF, orgFilter, isEnabledFilter, isInitFilter, enable};
        DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid", (QFilter[])filters);
        if (CollectionUtils.isNotEmpty((Collection)costAccountIds)) {
            Set costAccountIdList = costAccountIds.stream().map(costAccount -> costAccount.getLong("costaccountid")).collect(Collectors.toSet());
            return new QFilter("id", "in", costAccountIdList);
        }
        return new QFilter("id", "=", (Object)0L);
    }

    public static List<ComboItem> getCostAccountItems(Long orgId, String appNum) {
        return StartCostHelper.getCostAccountItems(orgId, Boolean.TRUE, appNum);
    }

    public static List<ComboItem> getCostAccountItems(Long orgId, Boolean isInit, String appNum) {
        DynamicObjectCollection costAccounts = StartCostHelper.getCostAccounts(orgId, isInit, appNum);
        return StartCostHelper.getComboItems(costAccounts);
    }

    public static DynamicObjectCollection getCostAccounts(Long orgId, Boolean isInit, String appNum) {
        String fields = "entryentity.costaccount.id id,entryentity.costaccount.name name";
        DynamicObjectCollection costAccounts = StartCostHelper.getCostAccounts(orgId, isInit, fields, appNum);
        return costAccounts;
    }

    public static DynamicObjectCollection getCostAccounts(Long orgId, Boolean isInit, String fields, String appNum) {
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = null;
        if (isInit != null) {
            isInitFilter = new QFilter("entryentity.isinit", "=", (Object)isInit);
        }
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appNum);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, enable, appNumQF};
        DynamicObjectCollection costAccounts = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])filters);
        return costAccounts;
    }

    private static List<ComboItem> getComboItems(DynamicObjectCollection dObjectCollec) {
        ArrayList<ComboItem> costAccountItems = new ArrayList<ComboItem>();
        for (DynamicObject dy : dObjectCollec) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(dy.getString("name")));
            item.setValue(dy.getString("id"));
            if (costAccountItems.contains(item)) continue;
            costAccountItems.add(item);
        }
        return costAccountItems;
    }

    public static boolean isInit(Long costAccountId, String appNum) {
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appNum);
        QFilter costAccountFilter = new QFilter("entryentity.costaccount", "=", (Object)costAccountId);
        DynamicObject startStdcost = QueryServiceHelper.queryOne((String)"sca_startstdcost", (String)"entryentity.isinit as isinit", (QFilter[])new QFilter[]{costAccountFilter, appNumQF});
        return startStdcost == null ? false : startStdcost.getBoolean("isinit");
    }

    public static Long getCostAccountByAccoutOrg(Long accountOrgId, String appNum) {
        QFilter accountorgQF = new QFilter("entryentity.costaccount.calorg", "=", (Object)accountOrgId);
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appNum);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        String orderby = "entryentity.costaccount.ismainaccount DESC,entryentity.costaccount.number";
        DynamicObjectCollection result = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount.id id,entryentity.costaccount.ismainaccount ismainaccount", (QFilter[])new QFilter[]{accountorgQF, appNumQF, enable, isEnabledFilter}, (String)orderby);
        if (result == null || result.size() == 0) {
            return 0L;
        }
        DynamicObject costaccount = (DynamicObject)result.get(0);
        return costaccount.getLong("id");
    }

    public static Long getCostAccountByOrg(Long accountOrgId, String appnum) {
        QFilter accountorgQF = new QFilter("org", "=", (Object)accountOrgId);
        QFilter enablestdtQF = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isinitaccountQF = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter appnumQF = new QFilter("appnum", "=", (Object)appnum);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount costaccount,entryentity.costaccount.ismainaccount ismainaccount", (QFilter[])new QFilter[]{accountorgQF, enablestdtQF, isinitaccountQF, appnumQF}, (String)"entryentity.costaccount.ismainaccount desc,entryentity.costaccount.id desc");
        if (CadEmptyUtils.isEmpty(result)) {
            return 0L;
        }
        if (((DynamicObject)result.get(0)).getBoolean("ismainaccount") || result.size() == 1) {
            return ((DynamicObject)result.get(0)).getLong("costaccount");
        }
        return null;
    }

    public static Map<Long, String> getAppNumberByStartCost(Set<Long> costAccountIDs) {
        QFilter filter = new QFilter("entryentity.costaccount", "in", costAccountIDs);
        String fields = "id,appnum,entryentity.costaccount";
        DynamicObjectCollection costAccountWithAppNumber = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])new QFilter[]{filter});
        if (costAccountWithAppNumber == null) {
            return null;
        }
        Map<Long, String> costAccountAndAppNumberMap = costAccountWithAppNumber.stream().collect(Collectors.toMap(x -> x.getLong("entryentity.costaccount"), y -> y.getString("appnum"), (o1, o2) -> o1));
        return costAccountAndAppNumberMap;
    }

    public static Long getCostaccountStartPeriod(String appNum, Long orgId, Long costAccountId) {
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appNum);
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entryentity.costaccount", "=", (Object)costAccountId);
        DynamicObject stdCost = QueryServiceHelper.queryOne((String)"sca_startstdcost", (String)"entryentity.calpolicy.periodtype periodtype, entryentity.startperiod startperiod", (QFilter[])new QFilter[]{qfAppNum, qfOrg, qfCostAccount});
        if (stdCost == null) {
            return 0L;
        }
        return stdCost.getLong("startperiod");
    }

    public static QFilter getPeriodTypeFilter(String appNum, Long orgId, Long costAccountId) {
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appNum);
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entryentity.costaccount", "=", (Object)costAccountId);
        DynamicObject stdCost = QueryServiceHelper.queryOne((String)"sca_startstdcost", (String)"entryentity.calpolicy.periodtype periodtype, entryentity.startperiod startperiod", (QFilter[])new QFilter[]{qfAppNum, qfOrg, qfCostAccount});
        if (stdCost == null) {
            return new QFilter("periodtype", ">", (Object)0L).and(new QFilter("isadjustperiod", "=", (Object)false));
        }
        return new QFilter("periodtype", "=", (Object)stdCost.getLong("periodtype")).and(new QFilter("id", ">=", (Object)stdCost.getLong("startperiod"))).and(new QFilter("isadjustperiod", "=", (Object)false));
    }

    public static QFilter getPeriodTypeFilter(String appNum, Long costAccountId) {
        QFilter qfAppNum = new QFilter("appnum", "=", (Object)appNum);
        QFilter qfCostAccount = new QFilter("entryentity.costaccount", "=", (Object)costAccountId);
        DynamicObject stdCost = QueryServiceHelper.queryOne((String)"sca_startstdcost", (String)"entryentity.calpolicy.periodtype periodtype", (QFilter[])new QFilter[]{qfAppNum, qfCostAccount});
        if (stdCost == null) {
            return new QFilter("periodtype", ">", (Object)0L);
        }
        return new QFilter("periodtype", "=", (Object)stdCost.getLong("periodtype"));
    }

    public static QFilter getUsePeriodFilter(Long orgId, Long costAccountId) {
        QFilter result = new QFilter("periodtype", ">", (Object)0L);
        QFilter periodfilter = new QFilter("org", "=", (Object)orgId);
        periodfilter.and(new QFilter("entry.costaccount", "=", (Object)costAccountId));
        DynamicObjectCollection cal_sysctrlentity = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"org.id orgid,entry.costaccount.id acctid,entry.calpolicy.periodtype periodtype,entry.startperiod.id startperiod,entry.currentperiod.id currentperiod", (QFilter[])periodfilter.toArray());
        if (cal_sysctrlentity.size() > 0) {
            DynamicObject periodDO = (DynamicObject)cal_sysctrlentity.get(0);
            result = new QFilter("periodtype", "=", (Object)periodDO.getLong("periodtype"));
            if (periodDO.get("startperiod") != null) {
                result.and(new QFilter("id", ">=", (Object)periodDO.getLong("startperiod")));
            }
            if (periodDO.get("currentperiod") != null) {
                result.and(new QFilter("id", "<=", (Object)periodDO.getLong("currentperiod")));
            }
        }
        result.and(new QFilter("isadjustperiod", "=", (Object)false));
        return result;
    }

    public static QFilter getPlanPeriodFilter(Long costAccountId) {
        QFilter result = new QFilter("periodtype", ">", (Object)0L);
        QFilter periodfilter = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        DynamicObjectCollection cal_sysctrlentity = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"org.id orgid,entry.costaccount.id acctid,entry.calpolicy.periodtype periodtype,entry.startperiod.id startperiod,entry.currentperiod.id currentperiod", (QFilter[])periodfilter.toArray());
        if (cal_sysctrlentity.size() > 0) {
            DynamicObject periodDO = (DynamicObject)cal_sysctrlentity.get(0);
            result = new QFilter("periodtype", "=", (Object)periodDO.getLong("periodtype"));
            if (periodDO.get("startperiod") != null) {
                result.and(new QFilter("id", ">=", (Object)periodDO.getLong("startperiod")));
            }
        }
        return result;
    }

    public static List<ComboItem> getCostAccountComboItemListBy(Long orgId, String appId) {
        String fields = "entryentity.costaccount.id id,entryentity.costaccount.name name,entryentity.costaccount.ismainaccount ismainaccount,entryentity.costaccount.number number";
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appId);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, enable, appNumQF};
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        DataSet dataSet = null;
        try {
            dataSet = QueryServiceHelper.queryDataSet((String)"StartCostHelper_getCostAccountComboItemListBy", (String)"sca_startstdcost", (String)fields, (QFilter[])filters, null);
            if (dataSet.isEmpty()) {
                return null;
            }
            ComboItem defaultItem = null;
            DataSet resultDataSet = dataSet.orderBy(new String[]{"number asc"});
            for (Row row : resultDataSet) {
                Boolean isMainAccount = row.getBoolean("ismainaccount");
                if (isMainAccount.booleanValue()) {
                    defaultItem = new ComboItem();
                    defaultItem.setCaption(new LocaleString(row.getString("name")));
                    defaultItem.setValue(row.getString("id"));
                    continue;
                }
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(row.getString("name")));
                item.setValue(row.getString("id"));
                if (acctItems.contains(item)) continue;
                acctItems.add(item);
            }
            if (defaultItem != null) {
                acctItems.add(0, defaultItem);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6210\u672c\u8d26\u7c3f\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return acctItems;
    }

    public static DynamicObjectCollection getCurrencyByCalPolicy(Set<Long> calpolicySet) {
        DynamicObjectCollection currencyCol = QueryServiceHelper.query((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "in", calpolicySet)});
        return currencyCol;
    }

    public static Set<Long> getCalPolicyByCostAccount(Set<Long> costAccIdSet) {
        DynamicObjectCollection calpolicyCol = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"calpolicy", (QFilter[])new QFilter[]{new QFilter("id", "in", costAccIdSet)});
        Set<Long> calpolicySet = calpolicyCol.stream().map(r -> r.getLong("calpolicy")).collect(Collectors.toSet());
        return calpolicySet;
    }

    public static boolean validateCurrencyWhenChooseCostAcc(Set<Long> costAccIdSet) {
        Set<Long> calpolicySet = StartCostHelper.getCalPolicyByCostAccount(costAccIdSet);
        if (CadEmptyUtils.isEmpty(calpolicySet)) {
            return false;
        }
        DynamicObjectCollection currencyCol = StartCostHelper.getCurrencyByCalPolicy(calpolicySet);
        if (CadEmptyUtils.isEmpty(currencyCol)) {
            return false;
        }
        Set currencySet = currencyCol.stream().map(r -> r.getLong("currency")).collect(Collectors.toSet());
        return currencySet != null && currencySet.size() > 1;
    }
}

