/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.operate.MutexHelper;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class StdCalculateHelper {
    protected static final Log logger = LogFactory.getLog(StdCalculateHelper.class);

    public static Set<String> getBomTreeKeycols(Long costType, Set<String> keycols) {
        Set<String> topFloorKeyCols = StdCalculateHelper.getTheTopFloorKeyCol(costType, new HashSet<String>(keycols), 0);
        Set<String> bomTreeAllKeyCols = StdCalculateHelper.getBomTreeAllKeyCols(costType, topFloorKeyCols, new HashSet<String>(), 0);
        bomTreeAllKeyCols.addAll(keycols);
        return bomTreeAllKeyCols;
    }

    public static Set<String> getTheTopFloorKeyCol(Long costType, Set<String> keycols, int count) {
        QFilter entryKeycolFilter = new QFilter("entry.entrykeycol", "in", keycols);
        DynamicObjectCollection boms = QueryServiceHelper.query((String)"cad_costbom", (String)"id,keycol,material,entry.entrymaterial entrymaterial,entry.entrykeycol entrykeycol", (QFilter[])new QFilter[]{entryKeycolFilter});
        HashSet bomIds = new HashSet(10);
        boms.forEach(bom -> {
            keycols.remove(bom.getString("entrykeycol"));
            keycols.add(bom.getString("keycol"));
            bomIds.add(bom.getLong("id"));
        });
        if (CadEmptyUtils.isEmpty(bomIds)) {
            return keycols;
        }
        QFilter filter = new QFilter("costtype", "=", (Object)costType);
        filter.and(new QFilter("bom", "in", bomIds));
        DynamicObjectCollection bomSettings = QueryServiceHelper.query((String)"cad_bomsetting", (String)"material,keycol", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty(bomSettings)) {
            return keycols;
        }
        bomSettings.forEach(bomSetting -> keycols.add(bomSetting.getString("keycol")));
        if (count > 20) {
            return keycols;
        }
        return StdCalculateHelper.getTheTopFloorKeyCol(costType, keycols, ++count);
    }

    public static Set<String> getBomTreeAllKeyCols(Long costTypeId, Set<String> topFloorKeyCols, Set<String> keycols, int count) {
        if (CadEmptyUtils.isEmpty(topFloorKeyCols)) {
            return keycols;
        }
        keycols.addAll(topFloorKeyCols);
        QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
        filter.and(new QFilter("keycol", "in", topFloorKeyCols));
        DynamicObjectCollection bomSettings = QueryServiceHelper.query((String)"cad_bomsetting", (String)"bom", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty(bomSettings)) {
            return keycols;
        }
        HashSet bomIds = new HashSet(10);
        bomSettings.forEach(bomSetting -> bomIds.add(bomSetting.getLong("bom")));
        filter = new QFilter("id", "in", bomIds);
        DynamicObjectCollection boms = QueryServiceHelper.query((String)"cad_costbom", (String)"material,entry.entrymaterial entrymaterial,entry.entrykeycol entrykeycol,entry.entryisjumplevel entryisjumplevel", (QFilter[])new QFilter[]{filter});
        topFloorKeyCols.clear();
        boms.forEach(bom -> {
            topFloorKeyCols.add(bom.getString("entrykeycol"));
            keycols.add(bom.getString("entrykeycol"));
        });
        if (CadEmptyUtils.isEmpty(topFloorKeyCols)) {
            return keycols;
        }
        if (count > 20) {
            return keycols;
        }
        return StdCalculateHelper.getBomTreeAllKeyCols(costTypeId, topFloorKeyCols, keycols, ++count);
    }

    public static int deleteResultRecordDatas(Object[] primaryKeyValues) {
        QFilter idFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        DynamicObjectCollection records = QueryServiceHelper.query((String)"cad_stdcalcrecord", (String)"name,costtype,keycol", (QFilter[])new QFilter[]{idFilter});
        Long costType = 0L;
        HashSet<String> keycols = new HashSet<String>(10);
        HashSet<String> recordName = new HashSet<String>(10);
        for (DynamicObject record : records) {
            if (CadEmptyUtils.isEmpty(costType)) {
                costType = record.getLong("costtype");
            }
            keycols.add(record.getString("keycol"));
            recordName.add(record.getString("name"));
        }
        try {
            Set<String> bomTreeKeycols = StdCalculateHelper.getBomTreeKeycols(costType, keycols);
            QFilter ctFilter = new QFilter("costtype", "=", (Object)costType);
            QFilter kcFilter = new QFilter("keycol", "in", bomTreeKeycols);
            QFilter nameFilter = new QFilter("name", "in", recordName);
            List recordIds = QueryServiceHelper.queryPrimaryKeys((String)"cad_stdcalcrecord", (QFilter[])new QFilter[]{ctFilter, kcFilter, nameFilter}, null, (int)-1);
            QFilter resultFilter = new QFilter("calcrecord", "in", (Object)recordIds);
            DeleteServiceHelper.delete((String)"cad_calcsimulationresult", (QFilter[])new QFilter[]{ctFilter, resultFilter});
            int deleteSize = DeleteServiceHelper.delete((String)"cad_stdcalcrecord", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)recordIds)});
            return deleteSize;
        }
        catch (Exception e) {
            logger.error("\u5377\u7b97\u6863\u6848\u5220\u9664\u5931\u8d25\u3002", (Throwable)e);
            return -1;
        }
    }

    public static void updateSalOrderLogs(List<Long> salOrderLogEntryIds, List<String> existResultKcs, String status, Boolean isCalc, String errInfo, Long taskId) {
        DynamicObject[] logs;
        QFilter filter = new QFilter("salorderentryid", "in", salOrderLogEntryIds);
        for (DynamicObject log : logs = BusinessDataServiceHelper.load((String)"sca_salorderstdcalclog", (String)"material,auxpty,configuredcode,tracknumber,status,operationtype,trytimes,lastexecdate,execlog,calctaskid", (QFilter[])new QFilter[]{filter})) {
            if (!CadEmptyUtils.isEmpty(status)) {
                log.set("status", (Object)status);
            } else {
                String material = log.getString("material.id");
                DynamicObject auxptyObj = log.getDynamicObject("auxpty");
                String auxpty = "0";
                if (auxptyObj != null) {
                    auxpty = auxptyObj.getString("id");
                }
                String configuredcode = log.getString("configuredcode.id");
                String tracknumber = log.getString("tracknumber.id");
                String key = material + "@" + auxpty + "@" + configuredcode + "@" + tracknumber;
                if (!CadEmptyUtils.isEmpty(existResultKcs) && existResultKcs.contains(key)) {
                    log.set("status", (Object)"02");
                } else {
                    log.set("status", (Object)"03");
                }
            }
            log.set("operationtype", (Object)(isCalc != false ? "1" : "2"));
            String logStatus = log.getString("status");
            if ("01".equals(logStatus)) {
                int time = log.getInt("trytimes");
                log.set("trytimes", (Object)(time + 1));
                log.set("lastexecdate", (Object)TimeServiceHelper.now());
            }
            if ("03".equals(logStatus)) {
                log.set("execlog", (Object)(errInfo == null ? " " : (errInfo.length() > 2000 ? errInfo.substring(0, 2000) : errInfo)));
            } else {
                log.set("execlog", (Object)" ");
            }
            log.set("calctaskid", (Object)taskId);
        }
        SaveServiceHelper.update((DynamicObject[])logs);
    }

    public static void updateLogStatusInfo(List<Long> salOrderLogEntryIds, String status, String errInfo, Boolean isCalc) {
        DynamicObject[] logs;
        QFilter filter = new QFilter("salorderentryid", "in", salOrderLogEntryIds);
        for (DynamicObject log : logs = BusinessDataServiceHelper.load((String)"sca_salorderstdcalclog", (String)"status,execlog,updatestatu,updatelog", (QFilter[])new QFilter[]{filter})) {
            if (isCalc.booleanValue()) {
                log.set("status", (Object)status);
                log.set("execlog", (Object)(errInfo == null ? " " : (errInfo.length() > 2000 ? errInfo.substring(0, 2000) : errInfo)));
                continue;
            }
            log.set("updatestatu", (Object)status);
            log.set("updatelog", (Object)(errInfo == null ? " " : (errInfo.length() > 2000 ? errInfo.substring(0, 2000) : errInfo)));
            if (!"F".equals(status)) continue;
            log.set("execlog", (Object)" ");
        }
        SaveServiceHelper.update((DynamicObject[])logs);
    }

    public static List<String> getConfigBomInfoJsStrNew(Long manuOrg, List<Long> configCodeIds, Date calcDate, boolean noConfigBomThrow, Set<Long> failMatId) {
        long start;
        ArrayList<String> configBomInfoJsStrList;
        block17: {
            configBomInfoJsStrList = new ArrayList<String>(10);
            logger.info("\u8c03\u7528\u5236\u9020\u65b0\u4ea7\u54c1\u9009\u914d\u67e5\u8be2\u63a5\u53e3\u5f00\u59cb\u3002\u751f\u4ea7\u7ec4\u7ec7id\uff1a{}\uff0c\u914d\u7f6e\u53f7id\uff1a{}\uff0c\u8ba1\u7b97\u65e5\u671f\uff1a{}", new Object[]{manuOrg, configCodeIds, calcDate});
            if (CadEmptyUtils.isEmpty(configCodeIds)) {
                return configBomInfoJsStrList;
            }
            start = System.currentTimeMillis();
            int count = 1;
            int partitionSize = CadBgParamUtils.getCadParamForInt("configBomPartitionSize", 200);
            try {
                for (List configCodeIdSubList : Lists.partition(configCodeIds, (int)partitionSize)) {
                    JSONObject paramObject = new JSONObject();
                    paramObject.put("searchTime", (Object)calcDate);
                    paramObject.put("isNeedProRoute", (Object)true);
                    paramObject.put("model", (Object)"model_cost");
                    paramObject.put("org", (Object)manuOrg);
                    paramObject.put("configCodeList", (Object)configCodeIdSubList.toString());
                    paramObject.put("purchaseExpand", (Object)Boolean.FALSE);
                    paramObject.put("uuid", (Object)ID.genLongId());
                    JSONObject returnJsonObject = StdCalculateHelper.getJsonObject(paramObject);
                    String status = returnJsonObject.getString("status");
                    JSONObject js = returnJsonObject.getJSONObject("data");
                    logger.info("\u65b0\u9009\u914d\u63a5\u53e3\uff0c\u83b7\u53d6\u9009\u914d\u7ed3\u679c\uff1a{}", (Object)(js == null ? "null" : js.toString()));
                    if ("failed".equals(status)) continue;
                    HashSet failIdSet = Sets.newHashSet();
                    JSONObject resultObject = new JSONObject();
                    if (js != null) {
                        Object configIdKeyListObj = js.get((Object)"configIdKeyList");
                        String redisCachePath = js.getString("redisCachePath");
                        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(redisCachePath);
                        if (configIdKeyListObj != null) {
                            String value;
                            int i;
                            Object configIdKeyList;
                            if (configIdKeyListObj instanceof JSONArray) {
                                configIdKeyList = (JSONArray)configIdKeyListObj;
                                for (i = 0; i < configIdKeyList.size(); ++i) {
                                    String cacheKeyString = configIdKeyList.getString(i);
                                    value = StdCalculateHelper.getString(cache, cacheKeyString);
                                    if (CadEmptyUtils.isEmpty(value)) continue;
                                    String configId = cacheKeyString.substring(0, cacheKeyString.indexOf("_"));
                                    JSONObject configBomInfoJSONObject = (JSONObject)JSON.parse((String)value);
                                    if (configBomInfoJSONObject == null || "failed".equals(configBomInfoJSONObject.get((Object)"status"))) {
                                        logger.info("\u65b0\u9009\u914d\u63a5\u53e3\uff0c\u914d\u7f6e\u53f7\uff1a{}\uff0c\u83b7\u53d6\u9009\u914d\u7ed3\u679c\u5931\u8d25\u3002", (Object)configId);
                                        failIdSet.add(Long.parseLong(configId));
                                        continue;
                                    }
                                    logger.info("\u65b0\u9009\u914d\u63a5\u53e3\uff0c\u914d\u7f6e\u53f7\uff1a{}\uff0c\u83b7\u53d6\u9009\u914d\u7ed3\u679c\uff1a{}", (Object)configId, (Object)value);
                                    resultObject.put(configId, (Object)configBomInfoJSONObject);
                                }
                            } else {
                                configIdKeyList = (ArrayList)configIdKeyListObj;
                                for (i = 0; i < configIdKeyList.size(); ++i) {
                                    String cacheKeyString = (String)configIdKeyList.get(i);
                                    value = StdCalculateHelper.getString(cache, cacheKeyString);
                                    JSONObject configBomInfoJSONObject = (JSONObject)JSON.parse((String)value);
                                    String configId = cacheKeyString.substring(0, cacheKeyString.indexOf("_"));
                                    if (configBomInfoJSONObject == null || "failed".equals(configBomInfoJSONObject.get((Object)"status"))) {
                                        logger.info("\u65b0\u9009\u914d\u63a5\u53e3\uff0c\u914d\u7f6e\u53f7id\uff1a{}\uff0c\u83b7\u53d6\u9009\u914d\u7ed3\u679c\u5931\u8d25\u3002", (Object)configId);
                                        failIdSet.add(Long.parseLong(configId));
                                        continue;
                                    }
                                    logger.info("\u65b0\u9009\u914d\u63a5\u53e3\uff0c\u914d\u7f6e\u53f7\uff1a{}\uff0c\u83b7\u53d6\u9009\u914d\u7ed3\u679c\uff1a{}", (Object)configId, (Object)value);
                                    resultObject.put(configId, (Object)configBomInfoJSONObject);
                                }
                            }
                        }
                    }
                    if (failIdSet.size() > 0) {
                        QFilter qf = new QFilter("id", "in", (Object)failIdSet);
                        DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"bd_configuredcode", (String)"material,number", (QFilter[])qf.toArray());
                        StringBuilder sb = new StringBuilder();
                        for (DynamicObject dyo : dyos) {
                            sb.append(",").append(dyo.getString("number"));
                            failMatId.add(dyo.getLong("material.id"));
                        }
                        if (noConfigBomThrow) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65b0\u9009\u914d\u63a5\u53e3\uff0c\u914d\u7f6e\u53f7\uff1a%1$s\uff0c\u83b7\u53d6\u9009\u914d\u7ed3\u679c\u5931\u8d25\u3002", (String)"StdCalculateHelper_0", (String)"macc-cad-common", (Object[])new Object[0]), sb));
                        }
                    }
                    StdCalculateHelper.clearConfigBomExpandCache(paramObject);
                    String res = resultObject.toString();
                    configBomInfoJsStrList.add(res);
                    logger.info("\u5206\u6279\u83b7\u53d6\u4ea7\u54c1\u9009\u914d\u7ed3\u679c--\u7b2c{}\u6279\u83b7\u53d6\u9009\u914d\u7684\u7ed3\u679c\uff1a{}", (Object)count, (Object)res);
                    ++count;
                }
            }
            catch (Exception e) {
                logger.error("\u8c03\u7528\u5236\u9020\u65b0\u4ea7\u54c1\u9009\u914d\u67e5\u8be2\u63a5\u53e3\u5931\u8d25\u3002\u9519\u8bef\u4fe1\u606f:", (Throwable)e);
                if (!noConfigBomThrow) break block17;
                throw e;
            }
        }
        if (configBomInfoJsStrList.isEmpty()) {
            QFilter qf = new QFilter("id", "in", configCodeIds);
            DynamicObject[] dyos = BusinessDataServiceHelper.load((String)"bd_configuredcode", (String)"number", (QFilter[])qf.toArray());
            StringBuilder sb = new StringBuilder();
            for (DynamicObject dyo : dyos) {
                sb.append(",").append(dyo.getString("number"));
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u65b0\u9009\u914d\u63a5\u53e3\uff0c\u914d\u7f6e\u53f7\uff1a%1$s\uff0c\u83b7\u53d6\u9009\u914d\u7ed3\u679c\u5931\u8d25\u3002", (String)"StdCalculateHelper_0", (String)"macc-cad-common", (Object[])new Object[0]), sb));
        }
        logger.info("\u8c03\u7528\u5236\u9020\u65b0\u4ea7\u54c1\u9009\u914d\u67e5\u8be2\u63a5\u53e3\u7ed3\u675f\u3002\u5171\u83b7\u53d6{}\u6279\u9009\u914d\u7ed3\u679c\u3002", (Object)configBomInfoJsStrList.size());
        logger.info("\u83b7\u53d6\u9009\u914d\u7ed3\u679c\u8017\u65f6\uff1a{}\u3002", (Object)(System.currentTimeMillis() - start));
        return configBomInfoJsStrList;
    }

    private static void clearConfigBomExpandCache(JSONObject paramObject) {
        DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"proConfigListQueryService", (String)"clearConfigBomExpandCache", (Object[])new Object[]{paramObject.toString()});
    }

    private static String getString(DistributeSessionlessCache cache, String cacheKeyString) {
        return (String)cache.get(cacheKeyString);
    }

    private static JSONObject getJsonObject(JSONObject paramObject) {
        JSONObject returnJsonObject = (JSONObject)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"proConfigListQueryService", (String)"getBatchProdConfigListByFeature", (Object[])new Object[]{paramObject.toString()});
        return returnJsonObject;
    }

    public static void updateDataStatus() {
        Date now = TimeServiceHelper.now();
        QFilter filter = new QFilter("status", "=", (Object)"01");
        Object[] logs = BusinessDataServiceHelper.load((String)"sca_salorderstdcalclog", (String)"costtype,status,lastexecdate", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty(logs)) {
            return;
        }
        HashMap<Long, Map> costTypeLogObjListMap = new HashMap<Long, Map>(16);
        for (Object log : logs) {
            long costType = log.getLong("costtype.id");
            Date lasteExecdDate = log.getDate("lastexecdate");
            Map groupLogsMap = costTypeLogObjListMap.computeIfAbsent(costType, p -> new HashMap());
            long second = DateUtils.getSecond(lasteExecdDate, now);
            if (lasteExecdDate == null || second > 3600L) {
                log.set("status", (Object)"03");
                groupLogsMap.computeIfAbsent("needUpdate", p -> new ArrayList()).add(log);
                continue;
            }
            groupLogsMap.computeIfAbsent("noNeedUpdate", p -> new ArrayList()).add(log);
        }
        for (Map.Entry entry : costTypeLogObjListMap.entrySet()) {
            Long costTypeId = (Long)entry.getKey();
            Map logObjsMap = (Map)entry.getValue();
            List needUpdateLogs = (List)logObjsMap.get("needUpdate");
            if (CadEmptyUtils.isEmpty(needUpdateLogs)) continue;
            SaveServiceHelper.update((DynamicObject[])needUpdateLogs.toArray(new DynamicObject[0]));
            List noNeedUpdateLogs = (List)logObjsMap.get("noNeedUpdate");
            if (!CadEmptyUtils.isEmpty(noNeedUpdateLogs)) continue;
            MutexHelper.release((String)"cad_stdcalcnew", (String)"calculate", (String)String.valueOf(costTypeId));
        }
    }

    public static void updateSalOrderLogTime(List<Long> ids, List<Long> orgIds) {
        QFilter filter = null;
        if (ids == null && orgIds == null) {
            filter = new QFilter("transmittime", "is null", null);
        } else if (ids == null) {
            filter = new QFilter("org", "in", orgIds);
            filter.and(new QFilter("transmittime", "is null", null));
        } else {
            filter = new QFilter("id", "in", ids);
            filter.and(new QFilter("transmittime", "is null", null));
        }
        Object[] logs = BusinessDataServiceHelper.load((String)"sca_salorderstdcalclog", (String)"manuorg,material,configuredcode,tracknumber,transmittime", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty(logs)) {
            return;
        }
        ArrayList<Long> manuOrgIds = new ArrayList<Long>(10);
        ArrayList<Long> materialIds = new ArrayList<Long>(10);
        ArrayList<Long> configuredCodeIds = new ArrayList<Long>(10);
        ArrayList<Long> tracknumberIds = new ArrayList<Long>(10);
        for (Object log : logs) {
            long tracknumber;
            long manuorg = log.getLong("manuorg.id");
            long material = log.getLong("material.id");
            if (CadEmptyUtils.isEmpty(manuorg) || CadEmptyUtils.isEmpty(material)) continue;
            manuOrgIds.add(manuorg);
            materialIds.add(material);
            long configuredcode = log.getLong("configuredcode.id");
            if (!CadEmptyUtils.isEmpty(configuredcode)) {
                configuredCodeIds.add(configuredcode);
            }
            if (CadEmptyUtils.isEmpty(tracknumber = log.getLong("tracknumber.id"))) continue;
            tracknumberIds.add(tracknumber);
        }
        filter = new QFilter("org", "in", manuOrgIds);
        filter.and(new QFilter("treeentryentity.material.masterid", "in", materialIds));
        filter.and(new QFilter("treeentryentity.configuredcode", "in", configuredCodeIds));
        filter.and(new QFilter("treeentryentity.tracknumber", "in", tracknumberIds));
        filter.and(new QFilter("treeentryentity.transmittime", "is not null", null));
        DataSet mftOrders = QueryServiceHelper.queryDataSet((String)"updateSalOrderLogTime", (String)"pom_mftorder", (String)"org,treeentryentity.material.masterid material,treeentryentity.configuredcode configuredcode,treeentryentity.tracknumber tracknumber,treeentryentity.transmittime transmittime", (QFilter[])new QFilter[]{filter}, (String)"treeentryentity.transmittime asc");
        DataSet omOrders = QueryServiceHelper.queryDataSet((String)"updateSalOrderLogTime", (String)"om_mftorder", (String)"org,treeentryentity.material.masterid material,treeentryentity.configuredcode configuredcode,treeentryentity.tracknumber tracknumber,treeentryentity.transmittime transmittime", (QFilter[])new QFilter[]{filter}, (String)"treeentryentity.transmittime asc");
        HashMap<String, Date> matTrackDateMap = new HashMap<String, Date>(16);
        DataSet dataSet = mftOrders.union(omOrders);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (row == null) continue;
            long manuorg = row.getLong("org");
            long material = row.getLong("material");
            long configuredcode = row.getLong("configuredcode");
            long tracknumber = row.getLong("tracknumber");
            String key = manuorg + "@" + material + "@" + configuredcode + "@" + tracknumber;
            if (matTrackDateMap.containsKey(key)) continue;
            matTrackDateMap.put(key, row.getDate("transmittime"));
        }
        if (CadEmptyUtils.isEmpty(matTrackDateMap)) {
            return;
        }
        for (Object log : logs) {
            long manuorg = log.getLong("manuorg.id");
            long material = log.getLong("material.id");
            long configuredcode = log.getLong("configuredcode.id");
            long tracknumber = log.getLong("tracknumber.id");
            String key = manuorg + "@" + material + "@" + configuredcode + "@" + tracknumber;
            if (!matTrackDateMap.containsKey(key)) continue;
            log.set("transmittime", matTrackDateMap.get(key));
        }
        SaveServiceHelper.update((DynamicObject[])logs);
    }

    public static Long getPriceSchemeId(Long costTypeId) {
        QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
        filter.and(new QFilter("default", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject plan = QueryServiceHelper.queryOne((String)"cad_calcruleplan", (String)"id", (QFilter[])new QFilter[]{filter});
        if (plan == null) {
            return 0L;
        }
        return plan.getLong("id");
    }

    public static Object getParamValue(String fieldKey) {
        QFilter filter = new QFilter("key", "=", (Object)fieldKey);
        DynamicObject param = QueryServiceHelper.queryOne((String)"cad_bgparam", (String)"value", (QFilter[])new QFilter[]{filter});
        if (param == null) {
            return null;
        }
        return param.get("value");
    }
}

