/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.constants.StdrptLevelParam;

public class StdrptLevelHelper {
    public static StdrptLevelParam getRptParam(ReportQueryParam reportQueryParam) {
        FilterInfo filter = reportQueryParam.getFilter();
        StdrptLevelParam rptParam = new StdrptLevelParam();
        rptParam.setCostType(filter.getDynamicObject("costtype"));
        rptParam.setMaterial(filter.getDynamicObject("querymaterial"));
        rptParam.setVersion(filter.getDynamicObject("version"));
        rptParam.setAuxprop(filter.getDynamicObject("auxprop"));
        rptParam.setQueryDate(filter.getDate("querydate"));
        rptParam.setIsDetail(filter.getBoolean("isdetail"));
        rptParam.setIsShowLevel(filter.getBoolean("isshowlevel"));
        return rptParam;
    }

    public static StdrptLevelParam getRptParam(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity();
        StdrptLevelParam rptParam = new StdrptLevelParam();
        rptParam.setCostType(dataEntity.getDynamicObject("costtype"));
        rptParam.setMaterial(dataEntity.getDynamicObject("materialparam"));
        rptParam.setQueryDate(TimeServiceHelper.now());
        rptParam.setIsDetail(true);
        rptParam.setIsShowLevel(dataEntity.getBoolean("isshowlevel"));
        rptParam.setShowLevel(dataEntity.getInt("showlevel"));
        return rptParam;
    }

    public static List<QFilter> getRptFilters(StdrptLevelParam param) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        boolean isQueryByMat = false;
        if (param.getCostTypeId() != null) {
            filters.add(new QFilter("costtype", "=", (Object)Long.valueOf(param.getCostTypeId())));
        } else if (param.getCostType() != null) {
            filters.add(new QFilter("costtype", "=", (Object)((Long)param.getCostType().getPkValue())));
        } else {
            filters.add(new QFilter("costtype", "=", (Object)0L));
        }
        if (param.getRootNode() != null && !"".equals(param.getRootNode())) {
            filters.add(new QFilter("rootnode", "=", (Object)param.getRootNode()));
        }
        if (param.getMaterial() != null) {
            filters.add(new QFilter("material", "=", param.getMaterial().getPkValue()));
            isQueryByMat = true;
        }
        if (param.getMaterialId() != null && param.getMaterialId() > 0L) {
            filters.add(new QFilter("material", "=", (Object)param.getMaterialId()));
            isQueryByMat = true;
        }
        if (param.getVersion() != null) {
            filters.add(new QFilter("matvers", "=", param.getVersion().getPkValue()));
        }
        if (param.getAuxprop() != null) {
            filters.add(new QFilter("auxproperty", "=", param.getAuxprop().getPkValue()));
        }
        if (param.getNextLevel() != null) {
            filters.add(new QFilter("level", "=", (Object)param.getNextLevel()));
        } else if (!isQueryByMat) {
            filters.add(new QFilter("level", "=", (Object)0));
        }
        return filters;
    }

    public static List<QFilter> getRptNextLevelFilters(StdrptLevelParam param) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (param.getCostType() != null) {
            filters.add(new QFilter("costtype", "=", (Object)((Long)param.getCostType().getPkValue())));
        } else {
            filters.add(new QFilter("costtype", "=", (Object)0L));
        }
        if (param.isShowLevel().booleanValue()) {
            filters.add(new QFilter("level", "<=", (Object)param.getShowLevel()));
        } else {
            filters.add(new QFilter("level", "<=", (Object)0));
        }
        return filters;
    }
}

