/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.dto.CollectReportDetail;
import kd.macc.cad.common.enums.CollectObjectEnum;
import kd.macc.cad.common.enums.CollectStatus;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class SysParamHelper {
    public static String getScaSysParamAddType(String orgId, String costCenterId, String addType, String appNumQF) {
        String fields = "accountorg, costcenter," + addType;
        DynamicObjectCollection sysParams = SysParamHelper.getScaSysParamByOrg(orgId, appNumQF, fields);
        if (CadEmptyUtils.isEmpty(sysParams)) {
            return "";
        }
        String paramKey = orgId + "@" + costCenterId;
        String orgDefaultWay = "";
        for (DynamicObject sysParam : sysParams) {
            String key = sysParam.getString("accountorg") + "@" + sysParam.getString("costcenter");
            String value = sysParam.getString(addType);
            if (key.equals(paramKey) && !StringUtils.isEmpty((CharSequence)value)) {
                return value;
            }
            if (!CadEmptyUtils.isEmpty(sysParam.getString("costcenter"))) continue;
            orgDefaultWay = StringUtils.isNotEmpty((CharSequence)sysParam.getString(addType)) ? sysParam.getString(addType) : "";
        }
        return orgDefaultWay;
    }

    public static QFilter getSysParamCostCenterQF(Long orgId, String addType, String addWay, String appId) {
        return SysParamHelper.getSysParamCostCenterQF(orgId, addType, addWay, "id", appId);
    }

    public static QFilter getSysParamCostCenterQF(Long orgId, String addType, String addWay, String qfField, String appId) {
        QFilter orgQF = new QFilter("accountorg", "=", (Object)orgId);
        QFilter addTypeQF1 = new QFilter(addType, "=", (Object)addWay);
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appId);
        QFilter[] qf = new QFilter[]{orgQF, addTypeQF1, appNumQF};
        DynamicObjectCollection sysParams = QueryServiceHelper.query((String)"cad_sysparam", (String)"costcenter", (QFilter[])qf);
        if (sysParams.isEmpty()) {
            return new QFilter(qfField, "=", (Object)-1L);
        }
        List<Long> costCenterIds = DynamicObjectHelper.getIdList(sysParams, "costcenter");
        if (costCenterIds.contains(0L)) {
            QFilter notAddTypeQF = new QFilter(addType, "!=", (Object)addWay);
            ArrayList<QFilter> qfList = new ArrayList<QFilter>();
            qfList.add(orgQF);
            qfList.add(appNumQF);
            qfList.add(notAddTypeQF);
            DynamicObjectCollection notMatchCostCenters = QueryServiceHelper.query((String)"cad_sysparam", (String)"costcenter", (QFilter[])qfList.toArray(new QFilter[0]));
            if (notMatchCostCenters.isEmpty()) {
                return new QFilter(qfField, "!=", (Object)-1L);
            }
            return new QFilter(qfField, "not in", DynamicObjectHelper.getFieldList(notMatchCostCenters, "costcenter"));
        }
        return new QFilter(qfField, "in", DynamicObjectHelper.getFieldList(sysParams, "costcenter"));
    }

    public static QFilter getManualSysParamCostCenterQF(Long orgId, String addType, String appId) {
        String fields = "costcenter";
        QFilter orgQF = new QFilter("accountorg", "=", (Object)orgId);
        QFilter addTypeNotQF1 = new QFilter(addType, "!=", (Object)SysParamEnum.COMPTYPE_MANUAL.getValue());
        QFilter addTypeNotQF2 = new QFilter(addType, "!=", (Object)"");
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appId);
        QFilter[] qf = new QFilter[]{orgQF, addTypeNotQF1, addTypeNotQF2, appNumQF};
        DynamicObjectCollection sysParams = QueryServiceHelper.query((String)"cad_sysparam", (String)fields, (QFilter[])qf);
        if (CadEmptyUtils.isEmpty(sysParams)) {
            return null;
        }
        boolean hasGlobalNotManul = false;
        ArrayList<Object> costCenterIds = new ArrayList<Object>();
        for (DynamicObject sysParam : sysParams) {
            costCenterIds.add(sysParam.get("costcenter"));
            if (!CadEmptyUtils.isEmpty(sysParam.getLong("costcenter"))) continue;
            hasGlobalNotManul = true;
        }
        if (!hasGlobalNotManul) {
            return new QFilter("id", "not in", costCenterIds);
        }
        QFilter addTypeQF = new QFilter(addType, "=", (Object)SysParamEnum.COMPTYPE_MANUAL.getValue());
        QFilter[] qf2 = new QFilter[]{orgQF, addTypeQF};
        DynamicObjectCollection res2 = QueryServiceHelper.query((String)"cad_sysparam", (String)fields, (QFilter[])qf2);
        if (CadEmptyUtils.isEmpty(res2)) {
            return new QFilter("id", "=", (Object)-1L);
        }
        return new QFilter("id", "in", DynamicObjectHelper.getFieldList(res2, "costcenter"));
    }

    public static List<Object> getSysParamCostCenter(String orgId, String addType, String addWay, String appId) {
        return SysParamHelper.getSysParamCostCenter(orgId, addType, addWay, appId, null);
    }

    public static List<Object> getSysParamCostCenter(String orgId, String addType, String addWay, String appId, String orgduty) {
        Long orgIdLong = StringUtils.isEmpty((CharSequence)orgId) ? 0L : Long.parseLong(orgId);
        ArrayList<QFilter> qfList = new ArrayList<QFilter>(10);
        qfList.add(new QFilter("accountorg", "=", (Object)orgIdLong));
        qfList.add(SysParamHelper.getSysParamCostCenterQF(orgIdLong, addType, addWay, "id", appId));
        qfList.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        if (!StringUtils.isEmpty((CharSequence)orgduty)) {
            qfList.add(new QFilter("orgduty.number", "=", (Object)orgduty));
        }
        DynamicObjectCollection dyCostCenter = QueryServiceHelper.query((String)"bos_costcenter", (String)"id", (QFilter[])qfList.toArray(new QFilter[0]));
        ArrayList<Object> costCenterIds = new ArrayList<Object>(16);
        if (!CadEmptyUtils.isEmpty(dyCostCenter)) {
            dyCostCenter.forEach(p -> costCenterIds.add(p.get("id")));
        }
        return costCenterIds;
    }

    public static DynamicObjectCollection getScaSysParamByOrg(String orgId, String appNum, String fields) {
        QFilter orgQF = new QFilter("accountorg", "=", (Object)Long.valueOf(orgId));
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appNum);
        QFilter[] qf = new QFilter[]{orgQF, appNumQF};
        DynamicObjectCollection sysParams = QueryServiceHelper.query((String)"cad_sysparam", (String)fields, (QFilter[])qf);
        return sysParams;
    }

    public static Date useMaxBeginDate(Date costAccountBeginDate, Date configDate) {
        if (costAccountBeginDate != null && configDate != null && costAccountBeginDate.after(configDate)) {
            return costAccountBeginDate;
        }
        return configDate;
    }

    public static Date useMinBeginDate(Date costAccountBeginDate, Date configDate) {
        if (costAccountBeginDate != null && configDate != null && costAccountBeginDate.before(configDate)) {
            return costAccountBeginDate;
        }
        return configDate;
    }

    public static QFilter getImportTimeScope(Long actOrg, String field, String appNum, CollectReport collectReport) {
        Date costAccountBeginDate = CostAccountHelper.getCostAccountBeginDate(actOrg, appNum);
        Date beginDate = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (costAccountBeginDate == null) {
            if (collectReport.getCollectObjectEnum() == CollectObjectEnum.COST_OBJECT) {
                costAccountBeginDate = DateUtils.getMonthFirstDay(-23);
                beginDate = SysParamHelper.useMinBeginDate(costAccountBeginDate, DateUtils.getMonthFirstDay(0));
                QFilter collectionTime = new QFilter(field, ">=", (Object)beginDate);
                collectionTime.and(new QFilter(field, "<=", (Object)DateUtils.getMonthEndDay(0)));
                if (StringUtils.isEmpty((CharSequence)collectReport.getDateRange())) {
                    String range = simpleDateFormat.format(beginDate);
                    range = range.concat("\uff5e").concat(simpleDateFormat.format(DateUtils.getMonthEndDay(0)));
                    CollectReportDetail collectReportDetail = new CollectReportDetail(ResManager.loadKDString((String)"\u83b7\u53d6\u5f52\u96c6\u65f6\u95f4\u8303\u56f4", (String)"SysParamHelper_0", (String)"macc-cad-common", (Object[])new Object[0]));
                    collectReportDetail.statusChange(CollectStatus.REMIND, ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f\u672a\u521d\u59cb\u5316\uff0c\u6210\u672c\u5bf9\u8c61\u5bfc\u5165\u65f6\uff0c\u5c06\u653e\u5f00\u65e5\u671f\u5bfc\u5165\u3002", (String)"SysParamHelper_2", (String)"macc-cad-common", (Object[])new Object[0]));
                    collectReport.getEntryEntity().add(collectReportDetail);
                    collectReport.setDateRange(range);
                }
                return collectionTime;
            }
            beginDate = DateUtils.getMonthFirstDay(0);
        } else {
            beginDate = SysParamHelper.useMaxBeginDate(costAccountBeginDate, DateUtils.getMonthFirstDay(0));
        }
        QFilter collectionTime = new QFilter(field, ">=", (Object)beginDate);
        collectionTime.and(new QFilter(field, "<=", (Object)DateUtils.getMonthEndDay(0)));
        DynamicObject sysParam = SysParamHelper.getSysParamDynamicObject(actOrg, appNum);
        String range = simpleDateFormat.format(beginDate);
        range = range.concat("\uff5e").concat(simpleDateFormat.format(DateUtils.getMonthEndDay(0)));
        if (sysParam == null || StringUtils.isEmpty((CharSequence)sysParam.getString("importperiodscope"))) {
            CollectReportDetail collectReportDetail = new CollectReportDetail(ResManager.loadKDString((String)"\u83b7\u53d6\u5f52\u96c6\u65f6\u95f4\u8303\u56f4", (String)"SysParamHelper_0", (String)"macc-cad-common", (Object[])new Object[0]));
            collectReportDetail.statusChange(CollectStatus.REMIND, ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u65f6\u95f4\u8303\u56f4\uff0c\u9ed8\u8ba4\u4f7f\u7528\u5f53\u524d\u6708\u3002", (String)"SysParamHelper_1", (String)"macc-cad-common", (Object[])new Object[0]));
            collectReport.getEntryEntity().add(collectReportDetail);
            collectReport.setDateRange(range);
            return collectionTime;
        }
        String importPeriodScope = sysParam.getString("importperiodscope");
        long costAccountId = SysParamHelper.getCostAccountByOrg(actOrg, appNum);
        DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod(costAccountId);
        DynamicObject nextPeriod = PeriodHelper.getNextPeriod(currentPeriod == null ? null : Long.valueOf(currentPeriod.getLong("id")));
        String importPeriodRange = SysParamHelper.getTimeStrByImportPeriodScope(importPeriodScope, actOrg, appNum);
        collectReport.setDateRange(CadEmptyUtils.isEmpty(importPeriodRange) ? range : importPeriodRange);
        if (importPeriodScope.contains("currentperiod") && !importPeriodScope.contains("nextperiod")) {
            if (currentPeriod == null) {
                return collectionTime;
            }
            collectionTime = new QFilter(field, ">=", (Object)currentPeriod.getDate("begindate"));
            collectionTime.and(new QFilter(field, "<=", (Object)DateUtils.getDayEndTime(currentPeriod.getDate("enddate"))));
            return collectionTime;
        }
        if (!importPeriodScope.contains("currentperiod") && importPeriodScope.contains("nextperiod")) {
            if (nextPeriod == null) {
                return collectionTime;
            }
            collectionTime = new QFilter(field, ">=", (Object)nextPeriod.getDate("begindate"));
            collectionTime.and(new QFilter(field, "<=", (Object)DateUtils.getDayEndTime(nextPeriod.getDate("enddate"))));
            return collectionTime;
        }
        if (importPeriodScope.contains("currentperiod") && importPeriodScope.contains("nextperiod")) {
            if (currentPeriod == null) {
                return collectionTime;
            }
            Date startDate = currentPeriod.getDate("begindate");
            Date endDate = DateUtils.getDayEndTime(currentPeriod.getDate("enddate"));
            if (nextPeriod != null) {
                endDate = DateUtils.getDayEndTime(nextPeriod.getDate("enddate"));
            }
            collectionTime = new QFilter(field, ">=", (Object)startDate);
            collectionTime.and(new QFilter(field, "<=", (Object)endDate));
            return collectionTime;
        }
        return collectionTime;
    }

    public static List<Map<String, Date>> getImportScopeDate(Long actOrg, String appNum) {
        Date costAccountBeginDate = CostAccountHelper.getCostAccountBeginDate(actOrg, appNum);
        Date beginDate = null;
        beginDate = costAccountBeginDate == null ? DateUtils.getMonthFirstDay(0) : SysParamHelper.useMaxBeginDate(costAccountBeginDate, DateUtils.getMonthFirstDay(0));
        ArrayList<Map<String, Date>> importScopeList = new ArrayList<Map<String, Date>>();
        HashMap<String, Date> importScopeDate = new HashMap<String, Date>(16);
        importScopeDate.put("start", beginDate);
        importScopeDate.put("end", DateUtils.getMonthEndDay(0));
        DynamicObject sysParam = SysParamHelper.getSysParamDynamicObject(actOrg, appNum);
        if (sysParam == null || StringUtils.isEmpty((CharSequence)sysParam.getString("importperiodscope"))) {
            importScopeList.add(importScopeDate);
            return importScopeList;
        }
        String importPeriodScope = sysParam.getString("importperiodscope");
        long costAccountId = SysParamHelper.getCostAccountByOrg(actOrg, appNum);
        DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod(costAccountId);
        DynamicObject nextPeriod = PeriodHelper.getNextPeriod(currentPeriod == null ? null : Long.valueOf(currentPeriod.getLong("id")));
        if (importPeriodScope.contains("currentperiod") && !importPeriodScope.contains("nextperiod")) {
            if (currentPeriod == null) {
                importScopeList.add(importScopeDate);
                return importScopeList;
            }
            importScopeDate.put("start", currentPeriod.getDate("begindate"));
            importScopeDate.put("end", DateUtils.getDayEndTime(currentPeriod.getDate("enddate")));
            importScopeList.add(importScopeDate);
            return importScopeList;
        }
        if (!importPeriodScope.contains("currentperiod") && importPeriodScope.contains("nextperiod")) {
            if (nextPeriod == null) {
                importScopeList.add(importScopeDate);
                return importScopeList;
            }
            importScopeDate.put("start", nextPeriod.getDate("begindate"));
            importScopeDate.put("end", DateUtils.getDayEndTime(nextPeriod.getDate("enddate")));
            importScopeList.add(importScopeDate);
            return importScopeList;
        }
        if (importPeriodScope.contains("currentperiod") && importPeriodScope.contains("nextperiod")) {
            if (currentPeriod == null) {
                importScopeList.add(importScopeDate);
                return importScopeList;
            }
            Date startDate = currentPeriod.getDate("begindate");
            Date endDate = DateUtils.getDayEndTime(currentPeriod.getDate("enddate"));
            if (nextPeriod != null) {
                endDate = DateUtils.getDayEndTime(nextPeriod.getDate("enddate"));
            }
            importScopeDate.put("start", startDate);
            importScopeDate.put("end", endDate);
            importScopeList.add(importScopeDate);
        }
        return importScopeList;
    }

    public static QFilter getImportTimeScope(Long actOrg, String field, String appNum) {
        Date costAccountBeginDate = CostAccountHelper.getCostAccountBeginDate(actOrg, appNum);
        Date beginDate = null;
        beginDate = costAccountBeginDate == null ? DateUtils.getMonthFirstDay(0) : SysParamHelper.useMaxBeginDate(costAccountBeginDate, DateUtils.getMonthFirstDay(0));
        QFilter collectionTime = new QFilter(field, ">=", (Object)beginDate);
        collectionTime.and(new QFilter(field, "<=", (Object)DateUtils.getMonthEndDay(0)));
        DynamicObject sysParam = SysParamHelper.getSysParamDynamicObject(actOrg, appNum);
        if (sysParam == null || StringUtils.isEmpty((CharSequence)sysParam.getString("importperiodscope"))) {
            return collectionTime;
        }
        String importPeriodScope = sysParam.getString("importperiodscope");
        long costAccountId = SysParamHelper.getCostAccountByOrg(actOrg, appNum);
        DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod(costAccountId);
        DynamicObject nextPeriod = PeriodHelper.getNextPeriod(currentPeriod == null ? null : Long.valueOf(currentPeriod.getLong("id")));
        if (importPeriodScope.contains("currentperiod") && !importPeriodScope.contains("nextperiod")) {
            if (currentPeriod == null) {
                return collectionTime;
            }
            collectionTime = new QFilter(field, ">=", (Object)currentPeriod.getDate("begindate"));
            collectionTime.and(new QFilter(field, "<=", (Object)DateUtils.getDayEndTime(currentPeriod.getDate("enddate"))));
            return collectionTime;
        }
        if (!importPeriodScope.contains("currentperiod") && importPeriodScope.contains("nextperiod")) {
            if (nextPeriod == null) {
                return collectionTime;
            }
            collectionTime = new QFilter(field, ">=", (Object)nextPeriod.getDate("begindate"));
            collectionTime.and(new QFilter(field, "<=", (Object)DateUtils.getDayEndTime(nextPeriod.getDate("enddate"))));
            return collectionTime;
        }
        if (importPeriodScope.contains("currentperiod") && importPeriodScope.contains("nextperiod")) {
            if (currentPeriod == null) {
                return collectionTime;
            }
            Date startDate = currentPeriod.getDate("begindate");
            Date endDate = DateUtils.getDayEndTime(currentPeriod.getDate("enddate"));
            if (nextPeriod != null) {
                endDate = DateUtils.getDayEndTime(nextPeriod.getDate("enddate"));
            }
            collectionTime = new QFilter(field, ">=", (Object)startDate);
            collectionTime.and(new QFilter(field, "<=", (Object)endDate));
            return collectionTime;
        }
        return collectionTime;
    }

    public static DynamicObject getSysParamDynamicObject(Long actOrg, String appNum) {
        QFilter qfScope = new QFilter("actorg", "=", (Object)(actOrg == null ? Long.valueOf(-1L) : actOrg));
        qfScope.and(new QFilter("tab", "=", (Object)"costaccumultabpage"));
        qfScope.and(new QFilter("appnum", "=", (Object)appNum));
        QFilter[] filters = new QFilter[]{qfScope};
        return QueryServiceHelper.queryOne((String)"cad_sysparam", (String)"importperiodscope,importtimescope,num", (QFilter[])filters);
    }

    public static QFilter getImportTimeScope(String field, DynamicObject sysParam, CollectReport collectReport, long actOrg, String appNum) {
        Date costAccountBeginDate = CostAccountHelper.getCostAccountBeginDate(actOrg, appNum);
        Date beginDate = null;
        beginDate = costAccountBeginDate == null ? DateUtils.getMonthFirstDay(0) : SysParamHelper.useMaxBeginDate(costAccountBeginDate, DateUtils.getMonthFirstDay(0));
        QFilter collectionTime = new QFilter(field, ">=", (Object)beginDate);
        collectionTime.and(new QFilter(field, "<=", (Object)DateUtils.getMonthEndDay(0)));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String range = simpleDateFormat.format(beginDate);
        range = range.concat("\uff5e").concat(simpleDateFormat.format(DateUtils.getMonthEndDay(0)));
        if (sysParam == null || StringUtils.isEmpty((CharSequence)sysParam.getString("importperiodscope"))) {
            collectReport.logStatusChange(CollectStatus.REMIND, ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u65f6\u95f4\u8303\u56f4\uff0c\u9ed8\u8ba4\u4f7f\u7528\u5f53\u524d\u6708\u3002", (String)"SysParamHelper_1", (String)"macc-cad-common", (Object[])new Object[0]));
            collectReport.setDateRange(range);
            return collectionTime;
        }
        String importPeriodScope = sysParam.getString("importperiodscope");
        long costAccountId = SysParamHelper.getCostAccountByOrg(actOrg, appNum);
        DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod(costAccountId);
        DynamicObject nextPeriod = PeriodHelper.getNextPeriod(currentPeriod == null ? null : Long.valueOf(currentPeriod.getLong("id")));
        String importPeriodRange = SysParamHelper.getTimeStrByImportPeriodScope(importPeriodScope, actOrg, appNum);
        collectReport.setDateRange(CadEmptyUtils.isEmpty(importPeriodRange) ? range : importPeriodRange);
        if (importPeriodScope.contains("currentperiod") && !importPeriodScope.contains("nextperiod")) {
            if (currentPeriod == null) {
                return collectionTime;
            }
            collectionTime = new QFilter(field, ">=", (Object)currentPeriod.getDate("begindate"));
            collectionTime.and(new QFilter(field, "<=", (Object)DateUtils.getDayEndTime(currentPeriod.getDate("enddate"))));
            return collectionTime;
        }
        if (!importPeriodScope.contains("currentperiod") && importPeriodScope.contains("nextperiod")) {
            if (nextPeriod == null) {
                return collectionTime;
            }
            collectionTime = new QFilter(field, ">=", (Object)nextPeriod.getDate("begindate"));
            collectionTime.and(new QFilter(field, "<=", (Object)DateUtils.getDayEndTime(nextPeriod.getDate("enddate"))));
            return collectionTime;
        }
        if (importPeriodScope.contains("currentperiod") && importPeriodScope.contains("nextperiod")) {
            if (currentPeriod == null) {
                return collectionTime;
            }
            Date startDate = currentPeriod.getDate("begindate");
            Date endDate = DateUtils.getDayEndTime(currentPeriod.getDate("enddate"));
            if (nextPeriod != null) {
                endDate = DateUtils.getDayEndTime(nextPeriod.getDate("enddate"));
            }
            collectionTime = new QFilter(field, ">=", (Object)startDate);
            collectionTime.and(new QFilter(field, "<=", (Object)endDate));
            return collectionTime;
        }
        return collectionTime;
    }

    public static QFilter getImportTimeScope(String field, DynamicObject sysParam, long actOrg, String appNum) {
        Date costAccountBeginDate = CostAccountHelper.getCostAccountBeginDate(actOrg, appNum);
        Date beginDate = null;
        beginDate = costAccountBeginDate == null ? DateUtils.getMonthFirstDay(0) : SysParamHelper.useMaxBeginDate(costAccountBeginDate, DateUtils.getMonthFirstDay(0));
        QFilter collectionTime = new QFilter(field, ">=", (Object)beginDate);
        collectionTime.and(new QFilter(field, "<=", (Object)DateUtils.getMonthEndDay(0)));
        if (sysParam == null || StringUtils.isEmpty((CharSequence)sysParam.getString("importperiodscope"))) {
            return collectionTime;
        }
        String importPeriodScope = sysParam.getString("importperiodscope");
        long costAccountId = SysParamHelper.getCostAccountByOrg(actOrg, appNum);
        DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod(costAccountId);
        DynamicObject nextPeriod = PeriodHelper.getNextPeriod(currentPeriod == null ? null : Long.valueOf(currentPeriod.getLong("id")));
        if (importPeriodScope.contains("currentperiod") && !importPeriodScope.contains("nextperiod")) {
            if (currentPeriod == null) {
                return collectionTime;
            }
            collectionTime = new QFilter(field, ">=", (Object)currentPeriod.getDate("begindate"));
            collectionTime.and(new QFilter(field, "<=", (Object)DateUtils.getDayEndTime(currentPeriod.getDate("enddate"))));
            return collectionTime;
        }
        if (!importPeriodScope.contains("currentperiod") && importPeriodScope.contains("nextperiod")) {
            if (nextPeriod == null) {
                return collectionTime;
            }
            collectionTime = new QFilter(field, ">=", (Object)nextPeriod.getDate("begindate"));
            collectionTime.and(new QFilter(field, "<=", (Object)DateUtils.getDayEndTime(nextPeriod.getDate("enddate"))));
            return collectionTime;
        }
        if (importPeriodScope.contains("currentperiod") && importPeriodScope.contains("nextperiod")) {
            if (currentPeriod == null) {
                return collectionTime;
            }
            Date startDate = currentPeriod.getDate("begindate");
            Date endDate = DateUtils.getDayEndTime(currentPeriod.getDate("enddate"));
            if (nextPeriod != null) {
                endDate = DateUtils.getDayEndTime(nextPeriod.getDate("enddate"));
            }
            collectionTime = new QFilter(field, ">=", (Object)startDate);
            collectionTime.and(new QFilter(field, "<=", (Object)endDate));
            return collectionTime;
        }
        return collectionTime;
    }

    public static List<String> getSysImportBillRanges(Long org, String billType, String appNum) {
        QFilter filter = new QFilter("accountorg", "=", (Object)org);
        filter.and("appnum", "=", (Object)appNum);
        String fields = "billrange";
        if ("cad_factnedoutputbill".equals(billType)) {
            fields = "billrange";
        }
        if ("sca_resourceuse".equals(billType)) {
            fields = "resourcerange";
        }
        if ("sca_matusecollect".equals(billType) || "aca_matusecollect".equals(billType)) {
            fields = "matcollectrange";
        }
        DynamicObjectCollection sysParams = QueryServiceHelper.query((String)"cad_sysparam", (String)fields, (QFilter[])new QFilter[]{filter});
        ArrayList<String> billRanges = new ArrayList<String>(10);
        for (DynamicObject sysParam : sysParams) {
            String[] split;
            String ranges = sysParam.getString(fields);
            for (String s : split = ranges.split(",")) {
                if (CadEmptyUtils.isEmpty(s) || billRanges.contains(s)) continue;
                billRanges.add(s);
            }
        }
        return billRanges;
    }

    @Deprecated
    public static String getTimeStrByImportTimeScope(String importTimeScope, int num) {
        if (CadEmptyUtils.isEmpty(importTimeScope)) {
            return null;
        }
        String start = "";
        String end = "";
        if (importTimeScope.contains("previousmonth")) {
            if (num > 0) {
                start = DateUtils.formatDate(DateUtils.getMonthFirstDay(-num), "yyyy-MM-dd");
                end = DateUtils.formatDate(DateUtils.getMonthEndDay(0), "yyyy-MM-dd");
            } else {
                start = DateUtils.formatDate(DateUtils.getMonthFirstDay(1), "yyyy-MM-dd");
                end = DateUtils.formatDate(DateUtils.getMonthEndDay(-num), "yyyy-MM-dd");
                if (importTimeScope.contains("currentmonth")) {
                    start = DateUtils.formatDate(DateUtils.getMonthFirstDay(0), "yyyy-MM-dd");
                }
            }
            return start + "\uff5e" + end;
        }
        if (!importTimeScope.contains("currentmonth") && importTimeScope.contains("previousonlymonth")) {
            start = DateUtils.formatDate(DateUtils.getMonthFirstDay(-num), "yyyy-MM-dd");
            end = DateUtils.formatDate(DateUtils.getMonthEndDay(-num), "yyyy-MM-dd");
            return start + "\uff5e" + end;
        }
        if (importTimeScope.contains("currentmonth") && !importTimeScope.contains("previousonlymonth")) {
            start = DateUtils.formatDate(DateUtils.getMonthFirstDay(0), "yyyy-MM-dd");
            end = DateUtils.formatDate(DateUtils.getMonthEndDay(0), "yyyy-MM-dd");
            return start + "\uff5e" + end;
        }
        if (importTimeScope.contains("currentmonth") && importTimeScope.contains("previousonlymonth")) {
            start = DateUtils.formatDate(DateUtils.getMonthFirstDay(-num), "yyyy-MM-dd");
            end = DateUtils.formatDate(DateUtils.getMonthEndDay(-num), "yyyy-MM-dd");
            String str1 = start + "\uff5e" + end;
            start = DateUtils.formatDate(DateUtils.getMonthFirstDay(0), "yyyy-MM-dd");
            end = DateUtils.formatDate(DateUtils.getMonthEndDay(0), "yyyy-MM-dd");
            String str2 = start + "\uff5e" + end;
            return str1 + "\uff1b" + str2;
        }
        return null;
    }

    public static String getTimeStrByImportPeriodScope(String importPeriodScope, Long orgId, String appNum) {
        if (CadEmptyUtils.isEmpty(importPeriodScope) || CadEmptyUtils.isEmpty(orgId)) {
            return null;
        }
        String start = "";
        String end = "";
        long costAccountId = SysParamHelper.getCostAccountByOrg(orgId, appNum);
        DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod(costAccountId);
        DynamicObject nextPeriod = PeriodHelper.getNextPeriod(currentPeriod == null ? null : Long.valueOf(currentPeriod.getLong("id")));
        if (importPeriodScope.contains("currentperiod") && !importPeriodScope.contains("nextperiod")) {
            if (currentPeriod == null) {
                return null;
            }
            start = DateUtils.formatDate(currentPeriod.getDate("begindate"), "yyyy-MM-dd");
            end = DateUtils.formatDate(currentPeriod.getDate("enddate"), "yyyy-MM-dd");
            return start + "\uff5e" + end;
        }
        if (!importPeriodScope.contains("currentperiod") && importPeriodScope.contains("nextperiod")) {
            if (nextPeriod == null) {
                return null;
            }
            start = DateUtils.formatDate(nextPeriod.getDate("begindate"), "yyyy-MM-dd");
            end = DateUtils.formatDate(nextPeriod.getDate("enddate"), "yyyy-MM-dd");
            return start + "\uff5e" + end;
        }
        if (importPeriodScope.contains("currentperiod") && importPeriodScope.contains("nextperiod")) {
            if (currentPeriod == null) {
                return null;
            }
            start = DateUtils.formatDate(currentPeriod.getDate("begindate"), "yyyy-MM-dd");
            end = DateUtils.formatDate(currentPeriod.getDate("enddate"), "yyyy-MM-dd");
            if (nextPeriod != null) {
                end = DateUtils.formatDate(nextPeriod.getDate("enddate"), "yyyy-MM-dd");
            }
            return start + "\uff5e" + end;
        }
        return null;
    }

    public static Boolean getEnableEffectByOrg(Long org, String appnum, String value) {
        String effectcontrol;
        DynamicObject[] costAccumulParams;
        if ("sca".equals(appnum) && ("sca_diycostdriver".equals(value) || "cad_costcentergroup".equals(value) || "cad_plancostdriver".equals(value))) {
            return true;
        }
        if (CadEmptyUtils.isEmpty(org) || value == null) {
            return false;
        }
        QFilter acctOrgFilter = new QFilter("actorg", "=", (Object)org);
        acctOrgFilter.and("tab", "=", (Object)"settingtabpage");
        if (!CadEmptyUtils.isEmpty(appnum)) {
            acctOrgFilter.and("appnum", "=", (Object)appnum);
        }
        if ((costAccumulParams = BusinessDataServiceHelper.load((String)"cad_sysparam", (String)"id,actorg,effectcontrol", (QFilter[])new QFilter[]{acctOrgFilter})).length > 0 && !CadEmptyUtils.isEmpty(effectcontrol = costAccumulParams[0].getString("effectcontrol"))) {
            return effectcontrol.contains(value);
        }
        return false;
    }

    public static Boolean isMergeBill(Long orgId, Long costAccountId, String appId) {
        if ("eca".equals(appId)) {
            return false;
        }
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("costaccount", "=", (Object)costAccountId), new QFilter("tab", "=", (Object)"costaccounttabpage"), new QFilter("appnum", "=", (Object)appId), new QFilter("ismergebill", "=", (Object)Boolean.FALSE)};
        boolean isNotMergeBill = QueryServiceHelper.exists((String)"cad_sysparam", (QFilter[])filters);
        return !isNotMergeBill;
    }

    public static Map<String, Map<String, Set<Long>>> getNotNeedCollectBillBizIdsMap(Long org, String collectionbill, String appNum) {
        HashMap<String, Map<String, Set<Long>>> resultMap = new HashMap<String, Map<String, Set<Long>>>(16);
        QFilter filter = new QFilter("org", "=", (Object)org);
        filter.and("bizsettingentry.collectionbill", "=", (Object)collectionbill);
        filter.and("appnum", "=", (Object)appNum);
        DataSet ccSetting = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.common.helper.SysParamHelper#getNotNeedCollectBillBizIdsMap", (String)"cad_costcollectionsetting", (String)"org,bizsettingentry.collectionbill collectionbill,bizsettingentry.sourcebill sourcebill,bizsettingentry.biztype.fbasedataid.id biztype,bizsettingentry.invscheme.fbasedataid.id invscheme", (QFilter[])new QFilter[]{filter}, null);
        if (ccSetting == null) {
            return resultMap;
        }
        while (ccSetting.hasNext()) {
            Row row = ccSetting.next();
            Map bizIdsMap = resultMap.computeIfAbsent(row.getString("sourcebill"), p -> new HashMap());
            bizIdsMap.computeIfAbsent("biztype", p -> new HashSet()).add(row.getLong("biztype"));
            bizIdsMap.computeIfAbsent("invscheme", p -> new HashSet()).add(row.getLong("invscheme"));
        }
        return resultMap;
    }

    public static Map<String, Set<Long>> getNotNeedCollectBillBizIdsMap(Long org, String collectionBillType, String sourceBillType, String selectFields, String appNum) {
        HashMap<String, Set<Long>> resultMap = new HashMap<String, Set<Long>>(16);
        QFilter filter = new QFilter("org", "=", (Object)org);
        filter.and("bizsettingentry.collectionbill", "=", (Object)collectionBillType);
        filter.and("bizsettingentry.sourcebill", "=", (Object)sourceBillType);
        filter.and("appnum", "=", (Object)appNum);
        DataSet ccSetting = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.common.helper.SysParamHelper#getNotNeedCollectBillBizIdsMap", (String)"cad_costcollectionsetting", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
        String[] selectFieldStr = selectFields.split(",");
        if (ccSetting == null) {
            return resultMap;
        }
        while (ccSetting.hasNext()) {
            Row row = ccSetting.next();
            for (String selectField : selectFieldStr) {
                Long biz = row.getLong(selectField);
                if (CadEmptyUtils.isEmpty(biz)) continue;
                resultMap.computeIfAbsent(selectField, p -> new HashSet()).add(biz);
            }
        }
        return resultMap;
    }

    public static Set<Long> getNotNeedCollectBillBizIds(Long org, String collectionBillType, String sourceBillType, String selectField, String appNum) {
        HashSet<Long> bizIds = new HashSet<Long>(10);
        QFilter filter = new QFilter("org", "=", (Object)org);
        filter.and("bizsettingentry.collectionbill", "=", (Object)collectionBillType);
        filter.and("bizsettingentry.sourcebill", "=", (Object)sourceBillType);
        filter.and("appnum", "=", (Object)appNum);
        DataSet ccSetting = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.common.helper.SysParamHelper#getNotNeedCollectBillBizIds", (String)"cad_costcollectionsetting", (String)selectField, (QFilter[])new QFilter[]{filter}, null);
        if (ccSetting == null) {
            return bizIds;
        }
        while (ccSetting.hasNext()) {
            Row row = ccSetting.next();
            Long biz = row.getLong(selectField);
            bizIds.add(biz);
        }
        return bizIds;
    }

    public static String getCollectParamNewType(String accountOrg, String costCenter, String newTypeKey, String appNum) {
        String result = "";
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!CadEmptyUtils.isEmpty(accountOrg)) {
            filters.add(new QFilter("accountorg", "=", (Object)Long.valueOf(accountOrg)));
        }
        if (!CadEmptyUtils.isEmpty(costCenter)) {
            filters.add(new QFilter("costcenter", "=", (Object)Long.valueOf(costCenter)));
        }
        QFilter appnumFilter = null;
        if (appNum != null) {
            appnumFilter = new QFilter("appnum", "=", (Object)appNum);
        }
        DynamicObject queryOne = null;
        if (!CadEmptyUtils.isEmpty(filters) && filters.size() == 2) {
            if (appnumFilter != null) {
                filters.add(appnumFilter);
            }
            if ((queryOne = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)newTypeKey, (QFilter[])filters.toArray(new QFilter[0]))) == null) {
                ArrayList<QFilter> filters2 = new ArrayList<QFilter>();
                filters2.add(new QFilter("accountorg", "=", (Object)Long.valueOf(accountOrg)));
                filters2.add(new QFilter("costcenter", "=", (Object)0L));
                if (appnumFilter != null) {
                    filters2.add(appnumFilter);
                }
                queryOne = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)newTypeKey, (QFilter[])filters2.toArray(new QFilter[0]));
            }
        }
        if (!CadEmptyUtils.isEmpty(filters) && filters.size() == 1) {
            DynamicObjectCollection query;
            if (appnumFilter != null) {
                filters.add(appnumFilter);
            }
            if (!CadEmptyUtils.isEmpty(query = QueryServiceHelper.query((String)"cad_sysparam", (String)newTypeKey, (QFilter[])filters.toArray(new QFilter[0])))) {
                for (DynamicObject dynamicObject : query) {
                    if (!"MANUAL".equals(dynamicObject.getString(newTypeKey))) continue;
                    return "MANUAL";
                }
                queryOne = (DynamicObject)query.get(0);
            }
        }
        if (queryOne != null) {
            result = queryOne.getString(newTypeKey);
        }
        return result;
    }

    public static Map<String, List<Long>> getInnerSysByCostCenter(Long org, String billType, String appNum, List<Long> costCenterList) {
        List<Object> costCenters = new ArrayList<Long>(10);
        costCenters.addAll(costCenterList);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter orgQf = new QFilter("accountorg", "=", (Object)org);
        if (!CadEmptyUtils.isEmpty(org)) {
            filters.add(orgQf);
        }
        filters.add(new QFilter("appnum", "=", (Object)appNum));
        String field = "";
        switch (billType) {
            case "cad_plannedoutputbill": {
                filters.add(new QFilter("plancollecttype", "=", (Object)"OBJECTRULE"));
                field = "plancollectrange";
                break;
            }
            case "cad_factnedoutputbill": {
                filters.add(new QFilter("completetype", "=", (Object)"OBJECTRULE"));
                field = "billrange";
                break;
            }
            case "sca_resourceuse": {
                filters.add(new QFilter("resourceusetype", "=", (Object)"OBJECTRULE"));
                field = "resourcerange";
                break;
            }
            case "sca_matusecollect": 
            case "aca_matusecollect": {
                filters.add(new QFilter("matcollectway", "=", (Object)"INNERSYSIMPORT"));
                field = "matcollectrange";
                break;
            }
        }
        if (costCenters == null || costCenters.isEmpty()) {
            costCenters = CostCenterHelper.getCostCenterByOrg(org, new Long[]{4L});
        }
        if (costCenters == null) {
            costCenters = new ArrayList(10);
        }
        DynamicObjectCollection sysParam = QueryServiceHelper.query((String)"cad_sysparam", (String)(field + ",costcenter"), (QFilter[])filters.toArray(new QFilter[0]));
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>(16);
        DynamicObject mainDynamicObject = null;
        List<Object> unCostCenters = costCenters;
        for (DynamicObject dy : sysParam) {
            String[] ranges = dy.getString(field).split(",");
            Long costcenter = dy.getLong("costcenter");
            if (costCenters.contains(costcenter)) {
                for (String range : ranges) {
                    if (CadEmptyUtils.isEmpty(range)) continue;
                    List<Long> list = new ArrayList<Long>(10);
                    if (map.containsKey(range)) {
                        list = (List)map.get(range);
                    }
                    list.add(costcenter);
                    map.put(range, list);
                }
                unCostCenters.remove(costcenter);
            }
            if (!CadEmptyUtils.isEmpty(costcenter)) continue;
            mainDynamicObject = dy;
        }
        if (mainDynamicObject != null) {
            String[] ranges;
            for (String range : ranges = mainDynamicObject.getString(field).split(",")) {
                if (CadEmptyUtils.isEmpty(range)) continue;
                if (map.containsKey(range)) {
                    List list = (List)map.get(range);
                    list.addAll(unCostCenters);
                    map.put(range, list);
                    continue;
                }
                map.put(range, unCostCenters);
            }
        }
        return map;
    }

    public static DynamicObject getBillTypeParameter(String formId, long billTypeId) {
        String id = MetadataDao.getIdByNumber((String)formId, (MetaCategory)MetaCategory.Entity);
        EntityMetadata meta = (EntityMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Entity);
        if (meta == null) {
            return null;
        }
        MainEntity entity = meta.getRootEntity();
        if (entity instanceof BillEntity) {
            String paramFormId = ((BillEntity)entity).getBillTypePara();
            return (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)formId, (String)paramFormId, (long)billTypeId);
        }
        return null;
    }

    public static Long getCostAccountByOrg(Long orgId, String appId) {
        DynamicObjectCollection ccs;
        if (CadEmptyUtils.isEmpty(orgId) || CadEmptyUtils.isEmpty(appId)) {
            return 0L;
        }
        QFilter filter = new QFilter("calorg", "in", (Object)orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(orgId)) {
            filter.and(StartCostHelper.getEnableQfilterByOrg(orgId, null, appId));
        }
        return CollectionUtils.isEmpty((Collection)(ccs = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id,name", (QFilter[])new QFilter[]{filter, statusFilter, enableFilter}, (String)"ismainaccount desc,number asc"))) ? 0L : ((DynamicObject)ccs.get(0)).getLong("id");
    }

    public static DynamicObjectCollection getRestoreCalcRangeByCostAccount(Set<Long> costAccIdSet) {
        QFilter prdQFilter = new QFilter("costaccount", "in", costAccIdSet);
        DynamicObjectCollection resCol = QueryServiceHelper.query((String)"cad_sysparam", (String)"id,restoredimension,restorecalcrange", (QFilter[])prdQFilter.toArray());
        return resCol;
    }
}

