/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.List;
import kd.bos.algo.RowMeta;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.helper.ObjectPropertyHelper;

public class TailDiffHelper {
    private static final Log logger = LogFactory.getLog(TailDiffHelper.class);

    public static void tailDiff(List<Object> objList, String amtProperty, BigDecimal diffAmt, int amtScale, RowMeta rowmeta) {
        if (diffAmt == null || diffAmt.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        if (objList == null || objList.size() == 0) {
            return;
        }
        logger.info("\u6210\u672c\u8c03\u5dee\u5f00\u59cb{},{},{}", new Object[]{amtProperty, diffAmt, amtScale});
        BigDecimal total = BigDecimal.ZERO;
        Object maxItem = objList.get(0);
        BigDecimal compareTmp = BigDecimal.ZERO;
        for (Object calObj : objList) {
            BigDecimal tmpAmt = (BigDecimal)ObjectPropertyHelper.getFieldValue(calObj, amtProperty, rowmeta);
            total = total.add(tmpAmt);
            if (tmpAmt.abs().compareTo(compareTmp) <= 0) continue;
            compareTmp = tmpAmt;
            maxItem = calObj;
        }
        BigDecimal maxBigDecimal = (BigDecimal)ObjectPropertyHelper.getFieldValue(maxItem, amtProperty, rowmeta);
        if (maxBigDecimal.abs().divide(diffAmt.abs(), 10, RoundingMode.HALF_UP).compareTo(new BigDecimal("100")) < 0 && total.abs().compareTo(BigDecimal.ZERO) > 0) {
            logger.info("\u6210\u672c\u8c03\u5dee{},{}", (Object)maxBigDecimal, (Object)diffAmt);
            BigDecimal min = BigDecimal.ONE.divide(BigDecimal.valueOf(Math.pow(10.0, amtScale)), amtScale, RoundingMode.HALF_UP);
            block1: for (int count = 0; diffAmt.abs().compareTo(min) > 0 && count < 5; ++count) {
                BigDecimal tmpTotal = total;
                total = BigDecimal.ZERO;
                logger.info("\u6210\u672c\u591a\u6b21\u8c03\u5dee{},{},{}", new Object[]{diffAmt, count, tmpTotal});
                for (Object calObj : objList) {
                    if (tmpTotal.compareTo(BigDecimal.ZERO) == 0) continue block1;
                    BigDecimal tmpAmt = (BigDecimal)ObjectPropertyHelper.getFieldValue(calObj, amtProperty, rowmeta);
                    BigDecimal ratio = tmpAmt.abs().divide(tmpTotal.abs(), 10, RoundingMode.HALF_UP);
                    BigDecimal addDiff = diffAmt.multiply(ratio).setScale(amtScale, RoundingMode.HALF_UP);
                    if (addDiff.abs().compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal addBg = tmpAmt.add(addDiff);
                        ObjectPropertyHelper.setFieldValue(calObj, amtProperty, addBg, rowmeta);
                        diffAmt = diffAmt.subtract(addDiff);
                    }
                    total = total.add((BigDecimal)ObjectPropertyHelper.getFieldValue(calObj, amtProperty, rowmeta));
                    if (diffAmt.compareTo(BigDecimal.ZERO) != 0) continue;
                    continue block1;
                }
            }
        }
        if (diffAmt.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal tmpAmt = (BigDecimal)ObjectPropertyHelper.getFieldValue(maxItem, amtProperty, rowmeta);
            tmpAmt = tmpAmt.add(diffAmt);
            logger.info("\u6210\u672c\u8865\u5dee{},{}", (Object)diffAmt, (Object)tmpAmt);
            ObjectPropertyHelper.setFieldValue(maxItem, amtProperty, tmpAmt, rowmeta);
        }
    }

    public static void tailDiff(List<Object> objList, String qtyProperty, String amtProperty, BigDecimal diffAmt, int amtScale, RowMeta rowmeta, boolean isAbsComp) {
        if (diffAmt == null || diffAmt.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        if (objList == null || objList.isEmpty()) {
            return;
        }
        BigDecimal total = BigDecimal.ZERO;
        Object maxItem = objList.get(0);
        BigDecimal compareTmp = BigDecimal.ZERO;
        for (Object calObj : objList) {
            BigDecimal qty = (BigDecimal)ObjectPropertyHelper.getFieldValue(calObj, qtyProperty, rowmeta);
            total = total.add(qty);
            if (qty.abs().compareTo(compareTmp) <= 0) continue;
            compareTmp = qty;
            maxItem = calObj;
        }
        if (objList.size() > 1) {
            boolean costAfterWay;
            boolean amtAfterWay;
            boolean amtBeforeWay;
            BigDecimal addBg;
            BigDecimal maxBigDecimal = (BigDecimal)ObjectPropertyHelper.getFieldValue(maxItem, amtProperty, rowmeta);
            if (maxBigDecimal.abs().divide(diffAmt.abs(), 0, RoundingMode.HALF_UP).compareTo(new BigDecimal(100)) < 0 && total.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal tempDiffAmt = diffAmt;
                for (Object e : objList) {
                    BigDecimal tmpAmt = (BigDecimal)ObjectPropertyHelper.getFieldValue(e, amtProperty, rowmeta);
                    BigDecimal qty = (BigDecimal)ObjectPropertyHelper.getFieldValue(e, qtyProperty, rowmeta);
                    BigDecimal ratio = qty.abs().divide(total.abs(), 10, RoundingMode.HALF_UP);
                    BigDecimal addDiff = tempDiffAmt.multiply(ratio).setScale(amtScale, RoundingMode.HALF_UP);
                    if (addDiff.compareTo(BigDecimal.ZERO) != 0) {
                        addBg = tmpAmt.add(addDiff);
                        amtBeforeWay = tmpAmt.compareTo(BigDecimal.ZERO) >= 0;
                        boolean bl = amtAfterWay = addBg.compareTo(BigDecimal.ZERO) >= 0;
                        if (amtBeforeWay != amtAfterWay) {
                            addDiff = addDiff.subtract(addBg);
                            addBg = BigDecimal.ZERO;
                        }
                        ObjectPropertyHelper.setFieldValue(e, amtProperty, addBg, rowmeta);
                        diffAmt = diffAmt.subtract(addDiff);
                    }
                    if (diffAmt.compareTo(BigDecimal.ZERO) != 0) continue;
                    break;
                }
            }
            if (diffAmt.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            BigDecimal cost = (BigDecimal)ObjectPropertyHelper.getFieldValue(maxItem, amtProperty, rowmeta);
            BigDecimal addDiffAmt = cost.add(diffAmt);
            boolean bl = cost.compareTo(BigDecimal.ZERO) >= 0;
            boolean bl2 = costAfterWay = addDiffAmt.compareTo(BigDecimal.ZERO) >= 0;
            if (bl == costAfterWay) {
                ObjectPropertyHelper.setFieldValue(maxItem, amtProperty, addDiffAmt, rowmeta);
                return;
            }
            Collections.sort(objList, (o1, o2) -> {
                BigDecimal o1Val = (BigDecimal)ObjectPropertyHelper.getFieldValue(o1, qtyProperty, rowmeta);
                BigDecimal o2Val = (BigDecimal)ObjectPropertyHelper.getFieldValue(o2, qtyProperty, rowmeta);
                if (isAbsComp) {
                    o1Val = o1Val.abs();
                    o2Val = o2Val.abs();
                }
                return o2Val.compareTo(o1Val);
            });
            for (Object calObj : objList) {
                BigDecimal tmpAmt = (BigDecimal)ObjectPropertyHelper.getFieldValue(calObj, amtProperty, rowmeta);
                addBg = tmpAmt.add(diffAmt);
                amtBeforeWay = tmpAmt.compareTo(BigDecimal.ZERO) >= 0;
                boolean bl3 = amtAfterWay = addBg.compareTo(BigDecimal.ZERO) >= 0;
                if (amtBeforeWay != amtAfterWay) {
                    diffAmt = addBg;
                    addBg = BigDecimal.ZERO;
                } else {
                    diffAmt = BigDecimal.ZERO;
                }
                ObjectPropertyHelper.setFieldValue(calObj, amtProperty, addBg, rowmeta);
                if (diffAmt.compareTo(BigDecimal.ZERO) != 0) continue;
                return;
            }
        }
        if (diffAmt.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal tmpAmt = (BigDecimal)ObjectPropertyHelper.getFieldValue(maxItem, amtProperty, rowmeta);
            ObjectPropertyHelper.setFieldValue(maxItem, amtProperty, tmpAmt.add(diffAmt), rowmeta);
        }
    }
}

