/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class TrackNumberSettingHelper {
    public static boolean isHasTrackNumberSetting(Long orgId, Long id) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        if (id > 0L) {
            qFilter.and(new QFilter("id", "!=", (Object)id));
        }
        return QueryServiceHelper.exists((String)"cad_tracknumber_setting", (QFilter[])qFilter.toArray());
    }

    public static Map<Long, Map<String, Set<Long>>> getIsTrackNumberSettingInfo(Set<Long> orgIds) {
        HashMap resultMap = Maps.newHashMap();
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(new QFilter("bizsettingentry.istrack", "=", (Object)Boolean.TRUE));
        if (CadEmptyUtils.isEmpty(orgIds)) {
            filter.and(new QFilter("org", "in", orgIds));
        }
        String selectFields = "org,bizsettingentry.istrack istrack,bizsettingentry.biztype.fbasedataid.id biztype";
        DataSet ccSetting = QueryServiceHelper.queryDataSet((String)"getIsTrackNumberSettingInfo", (String)"cad_tracknumber_setting", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
        if (ccSetting == null) {
            return resultMap;
        }
        while (ccSetting.hasNext()) {
            Row row = ccSetting.next();
            Long org = row.getLong("org");
            if (resultMap.containsKey(org)) {
                Long biztype = row.getLong("biztype");
                if (biztype == 0L) continue;
                ((Set)((Map)resultMap.get(org)).get("biztype")).add(biztype);
                continue;
            }
            HashMap entryMap = Maps.newHashMap();
            Long biztype = row.getLong("biztype");
            HashSet biztypeSet = Sets.newHashSet();
            if (biztype != 0L) {
                biztypeSet.add(biztype);
            }
            entryMap.put("biztype", biztypeSet);
            resultMap.put(org, entryMap);
        }
        return resultMap;
    }

    public static Map<Long, List<String>> getTrackNumberSettingInfo(Set<Long> orgIds) {
        HashMap resultMap = Maps.newHashMap();
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(new QFilter("bizsettingentry.istrack", "=", (Object)Boolean.TRUE));
        if (CadEmptyUtils.isEmpty(orgIds)) {
            filter.and(new QFilter("org", "in", orgIds));
        }
        String selectFields = "org,entryentity.level level,entryentity.trackrule trackrule";
        DataSet ccSetting = QueryServiceHelper.queryDataSet((String)"getTrackNumberSettingInfo", (String)"cad_tracknumber_setting", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
        if (ccSetting == null) {
            return resultMap;
        }
        ccSetting = ccSetting.orderBy(new String[]{"org", "level"});
        while (ccSetting.hasNext()) {
            Row row = ccSetting.next();
            Long org = row.getLong("org");
            if (resultMap.containsKey(org)) {
                String trackRule = row.getString("trackrule");
                ((List)resultMap.get(org)).add(trackRule);
                continue;
            }
            ArrayList tempList = Lists.newArrayList();
            String trackRule = row.getString("trackrule");
            tempList.add(trackRule);
            resultMap.put(org, tempList);
        }
        return resultMap;
    }
}

