/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class WipCostInitHelper {
    private static final Log logger = LogFactory.getLog(WipCostInitHelper.class);
    private static final String[] GROUP_BY = new String[]{"material", "costelement", "costsubelement"};
    private static final String[] GROUP_BY_SUM = new String[]{"material"};
    private static final String SELECT_STR = "material,costelement,costsubelement,baseqty,actualcost";
    private static final String SELECT_STR_SUM = "material,baseqty,actualcost";

    public static DynamicObjectCollection getWipCostInitDyCollection(Long org, Long costaccount) {
        QFilter filters = new QFilter("org", "=", (Object)org);
        filters.and(new QFilter("costaccount", "=", (Object)costaccount));
        filters.and(new QFilter("source", "in", (Object)new String[]{"importmftstock", "import"}));
        DynamicObjectCollection wipCostInitDy = QueryServiceHelper.query((String)"aca_wipcostinit", (String)"id,org,costobject.probill probill,billstatus", (QFilter[])new QFilter[]{filters});
        return wipCostInitDy;
    }

    public static Map<Long, DynamicObject> getExistWipCostInit(Set<Long> wipCostInitIdSet) {
        Object[] ids;
        Object[] wipCostInitsDy;
        HashMap<Long, DynamicObject> returnMap = new HashMap<Long, DynamicObject>();
        if (!CadEmptyUtils.isEmpty(wipCostInitIdSet) && !CadEmptyUtils.isEmpty(wipCostInitsDy = BusinessDataServiceHelper.load((Object[])(ids = wipCostInitIdSet.toArray()), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"aca_wipcostinit")))) {
            for (Object wipCostInitDy : wipCostInitsDy) {
                long proBill = wipCostInitDy.getLong("costobject.probill");
                if (CadEmptyUtils.isEmpty(proBill)) {
                    logger.info("\u6210\u6838\u7b97\u5bf9\u8c61{}\u5de5\u5355\u5206\u5f55Id \u6216\u8005\u6e90\u5355\u7f16\u53f7\u4e3a\u7a7a", (Object)wipCostInitDy.getString("billno"));
                    continue;
                }
                returnMap.put(proBill, (DynamicObject)wipCostInitDy);
            }
        }
        return returnMap;
    }

    public static DataSet getPriceDataSet(Long costAccount, Long curPeriod, Set<Long> stoOrgs, Set<Long> materials, boolean isViewSubItem) {
        logger.info("\u5b58\u8d27\u63a5\u53e3-\u671f\u521d\u52a0\u6743\u5e73\u5747\u4ef7-\u5b58\u8d27\u63a5\u53e3-\u6838\u7b97\u4f59\u989d\u8868-\u5f00\u59cb\u3002\u53c2\u6570\uff1a\u6210\u672c\u8d26\u7c3f\uff1a{}\uff1b\u5f53\u524d\u671f\u95f4\uff1a{}\uff0c\u5e93\u5b58\u7ec4\u7ec7\uff1a{}\uff0c\u7269\u6599\uff1a{}", new Object[]{costAccount, curPeriod, stoOrgs, materials});
        String result = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCostPriceService", (String)"getPeriodBeginCostPriceByCache", (Object[])new Object[]{costAccount, curPeriod, stoOrgs, materials, isViewSubItem});
        DataSet groupRecordDS = Algo.getCacheDataSet((String)result).toDataSet(Algo.create((String)WipCostInitHelper.class.getName()), true);
        if (groupRecordDS.isEmpty()) {
            logger.info("\u5b58\u8d27\u63a5\u53e3-\u671f\u521d\u52a0\u6743\u5e73\u5747\u4ef7-\u5b58\u8d27\u63a5\u53e3-\u6838\u7b97\u4f59\u989d\u8868\uff1a\u83b7\u53d6\u7f13\u5b58\u6570\u636e\u4e3a\u7a7a,\u7f13\u5b58key:{}", (Object)result);
            return null;
        }
        logger.info("\u5b58\u8d27\u63a5\u53e3-\u671f\u521d\u52a0\u6743\u5e73\u5747\u4ef7-\u5b58\u8d27\u63a5\u53e3-\u6838\u7b97\u4f59\u989d\u8868-\u7ed3\u679c\uff1a{}", (Object)groupRecordDS);
        String[] groupByStr = GROUP_BY;
        String selectStr = SELECT_STR;
        if (!isViewSubItem) {
            groupByStr = GROUP_BY_SUM;
            selectStr = SELECT_STR_SUM;
        }
        DataSet dataSet = groupRecordDS.groupBy(groupByStr).sum("baseqty").sum("actualcost").finish();
        dataSet = dataSet.filter("baseqty!=0");
        DataSet copyDataSet = dataSet.copy();
        HashSet<Long> priceMaterials = new HashSet<Long>(10);
        while (copyDataSet.hasNext()) {
            Long material;
            Row row = copyDataSet.next();
            if (row == null || CadEmptyUtils.isEmpty(material = row.getLong("material"))) continue;
            priceMaterials.add(material);
        }
        logger.info("\u5b58\u8d27\u63a5\u53e3-\u671f\u521d\u52a0\u6743\u5e73\u5747\u4ef7-\u5b58\u8d27\u63a5\u53e3-\u6838\u7b97\u4f59\u989d\u8868-\u7ed3\u675f\u3002\u5df2\u53d6\u5230\u4ef7\u7269\u6599\uff1a{}", priceMaterials);
        materials.removeAll(priceMaterials);
        if (!dataSet.isEmpty()) {
            dataSet = dataSet.filter("baseqty >0 and actualcost>0").select(selectStr).orderBy(new String[]{"material"});
        }
        return dataSet;
    }
}

