/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.lock;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.cache.IAppCache;
import kd.bos.instance.Instance;
import kd.bos.monitor.service.LivingServiceUtils;
import kd.bos.servicehelper.TimeServiceHelper;

public class RedisBatchLock
implements AutoCloseable {
    private String oprationKey = "kd.macc.cad.common.lock.RedisBatchLock";
    private Set<String> lockSucessKeys = new HashSet<String>(16);
    private Set<String> lockFailedKeys = new HashSet<String>(16);
    private Map<Object, String> lockFailIdMutOpKeyMap = new HashMap<Object, String>(16);
    private Map<Object, String> lockFailIdMsgMap = new HashMap<Object, String>(16);
    private int expireTime = 15;
    private Set<String> lockKeys;
    private String lockCacheKey = "@LOCK_KEY_CACHE@";
    private String appId = "sca";
    private String dLockKey = "macc-RedisBatchLock-" + CacheKeyUtil.getAcctId();
    private static String LAST_AUTO_CLEAR_TIME = "LASTAUTOCLEARTIME";

    public RedisBatchLock() {
    }

    public RedisBatchLock(String oprationKey, Set<String> lockKeys, String appId, String lockCacheKey) {
        this.oprationKey = oprationKey;
        this.lockKeys = lockKeys;
        this.appId = appId;
        this.lockCacheKey = lockCacheKey;
    }

    public RedisBatchLock(String oprationKey, Long costTypeId, Set<String> lockKeys, String appId) {
        this.oprationKey = oprationKey;
        this.lockKeys = lockKeys;
        this.appId = appId;
        this.lockCacheKey = costTypeId + this.lockCacheKey;
    }

    public void lock() {
        try (DLock dlock = DLock.create((String)this.dLockKey, (String)(this.getClass().getName() + "RedisBatchLock-lock-" + this.oprationKey));){
            dlock.lock();
            this.getRedisLock();
        }
    }

    private void getRedisLock() {
        IAppCache cache = AppCache.get((String)this.appId);
        Date curDate = TimeServiceHelper.now();
        long curTime = curDate.getTime();
        HashMap<String, Object[]> lockKeyOPCacheMap = (HashMap<String, Object[]>)cache.get(this.lockCacheKey, Map.class);
        if (lockKeyOPCacheMap == null) {
            lockKeyOPCacheMap = new HashMap<String, Object[]>(16);
        }
        String errorMsgFmt = ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c%1$s\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"RedisBatchLock_0", (String)"fi-cal-mservice", (Object[])new Object[0]);
        for (String curLockKey : this.lockKeys) {
            boolean isCurLockSucess;
            Object opLockTime = lockKeyOPCacheMap.get(curLockKey);
            Long curLockTime = null;
            String curLockOp = "";
            String instanceId = "";
            if (opLockTime != null) {
                if (opLockTime instanceof List) {
                    List opLockTimeList = (List)opLockTime;
                    curLockOp = (String)opLockTimeList.get(0);
                    curLockTime = (Long)opLockTimeList.get(1);
                    if (opLockTimeList.size() >= 3) {
                        instanceId = (String)opLockTimeList.get(2);
                    }
                } else {
                    Object[] opLockTimeObjs = (Object[])opLockTime;
                    curLockOp = (String)opLockTimeObjs[0];
                    curLockTime = (Long)opLockTimeObjs[1];
                    if (opLockTimeObjs.length >= 3) {
                        instanceId = (String)opLockTimeObjs[2];
                    }
                }
            }
            boolean bl = isCurLockSucess = curLockTime == null || this.isExpire(curTime, curLockTime) || StringUtils.isNotEmpty((CharSequence)instanceId) && !LivingServiceUtils.isInstanceAlive((String)instanceId);
            if (isCurLockSucess) {
                this.lockSucessKeys.add(curLockKey);
                lockKeyOPCacheMap.put(curLockKey, new Object[]{this.oprationKey, curTime, Instance.getInstanceId()});
                continue;
            }
            this.lockFailedKeys.add(curLockKey);
            this.lockFailIdMutOpKeyMap.put(curLockKey, curLockOp);
            this.lockFailIdMsgMap.put(curLockKey, String.format(errorMsgFmt, curLockOp));
        }
        cache.put(this.lockCacheKey, lockKeyOPCacheMap);
    }

    public void unlock(Set<String> lockKeyStrs) {
        if (lockKeyStrs.isEmpty()) {
            return;
        }
        try (DLock dlock = DLock.create((String)this.dLockKey, (String)("RedisBatchLock-unlock-" + this.oprationKey));){
            dlock.lock();
            IAppCache cache = AppCache.get((String)this.appId);
            HashMap lockKeyOPCacheMap = (HashMap)cache.get(this.lockCacheKey, Map.class);
            if (lockKeyOPCacheMap == null) {
                lockKeyOPCacheMap = new HashMap(16);
            }
            for (String lockKey : lockKeyStrs) {
                lockKeyOPCacheMap.remove(lockKey);
            }
            cache.put(this.lockCacheKey, lockKeyOPCacheMap);
            this.autoUnlock();
        }
    }

    public void unlock() {
        this.unlock(this.lockSucessKeys);
    }

    private void autoUnlock() {
        IAppCache cache = AppCache.get((String)this.appId);
        Date curDate = TimeServiceHelper.now();
        long curTime = curDate.getTime();
        Long lastAutoClearTime = (Long)cache.get(LAST_AUTO_CLEAR_TIME, Long.class);
        if (lastAutoClearTime == null) {
            cache.put(LAST_AUTO_CLEAR_TIME, (Object)curTime);
            return;
        }
        boolean isExpire = this.isExpire(curTime, lastAutoClearTime);
        if (!isExpire) {
            return;
        }
        HashMap lockKeyOPCacheMap = (HashMap)cache.get(this.lockCacheKey, Map.class);
        if (lockKeyOPCacheMap == null) {
            lockKeyOPCacheMap = new HashMap(16);
        }
        Iterator lockKeyOPIter = lockKeyOPCacheMap.entrySet().iterator();
        while (lockKeyOPIter.hasNext()) {
            Map.Entry lockKeyOpCache = lockKeyOPIter.next();
            Object lockKeyOpValue = lockKeyOpCache.getValue();
            Long curLockTime = 0L;
            if (lockKeyOpValue != null) {
                if (lockKeyOpValue instanceof List) {
                    List opLockTimeList = (List)lockKeyOpValue;
                    curLockTime = (Long)opLockTimeList.get(1);
                } else {
                    Object[] opLockTimeObjs = (Object[])lockKeyOpValue;
                    curLockTime = (Long)opLockTimeObjs[1];
                }
            }
            if (!this.isExpire(curTime, curLockTime)) continue;
            lockKeyOPIter.remove();
        }
        cache.put(this.lockCacheKey, lockKeyOPCacheMap);
        cache.put(LAST_AUTO_CLEAR_TIME, (Object)curTime);
    }

    public int getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(int lockWait) {
        this.expireTime = lockWait;
    }

    @Override
    public void close() {
        this.unlock();
    }

    private boolean isExpire(long curTime, Long lockTime) {
        if (lockTime == null) {
            return true;
        }
        return (curTime - lockTime) / 1000L / 60L >= (long)this.expireTime;
    }

    public Set<String> getLockKeys() {
        return this.lockKeys;
    }

    public void setLockKeys(Set<String> lockKeys) {
        this.lockKeys = lockKeys;
    }

    public Set<String> getLockSucessKeys() {
        return this.lockSucessKeys;
    }

    public void setLockSucessKeys(Set<String> lockSucessKeys) {
        this.lockSucessKeys = lockSucessKeys;
    }

    public Set<String> getLockFailedKeys() {
        return this.lockFailedKeys;
    }

    public void setLockFailedKeys(Set<String> lockFailedKeys) {
        this.lockFailedKeys = lockFailedKeys;
    }

    public Map<Object, String> getLockFailIdMutOpKeyMap() {
        return this.lockFailIdMutOpKeyMap;
    }

    public void setLockFailIdMutOpKeyMap(Map<Object, String> lockFailIdMutOpKeyMap) {
        this.lockFailIdMutOpKeyMap = lockFailIdMutOpKeyMap;
    }

    public Map<Object, String> getLockFailIdMsgMap() {
        return this.lockFailIdMsgMap;
    }

    public void setLockCacheKey(String lockCacheKey) {
        this.lockCacheKey = lockCacheKey;
    }
}

