/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.price;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.price.PricePluginPojo;
import kd.macc.cad.common.price.PurEventPlugin;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public abstract class PurchasePricing {
    private static final String algoKey = "kd.macc.cad.common.abs.PurchasePricing";
    private static final Integer batchSize = 10000;
    public static final Log logger = LogFactory.getLog(PurchasePricing.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> executeRulePlugin(String entityName, List<Long> orgList, List<Long> accountList, Long createId, Long miCostType, String appNum, String progressId) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        logger.info("executeRulePlugin param entityName==>{},orgList==>{},accountList==>{},costType == >{}", new Object[]{entityName, orgList, accountList, miCostType});
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            int total = 2;
            ProgressHelper.refreshProgress(ResManager.loadKDString((String)"\u53d6\u4ef7\u5f00\u59cb", (String)"PurchasePricing_1", (String)"macc-cad-common", (Object[])new Object[0]), 1, total, Boolean.FALSE, progressId);
            int count = 0;
            map.put("existFailedCalcRule", false);
            StringBuilder failedCalcRuleTips = new StringBuilder();
            for (Long org : orgList) {
                int subCount = 0;
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_calcruleplan", (String)this.getFields(entityName), (QFilter[])new QFilter[]{this.getQFilter(entityName, this.getCostTypes(org, accountList, miCostType))}, null);
                dataSet = dataSet.groupBy(new String[]{"costtype", "rule", "name"}).finish();
                ++total;
                for (Row row : dataSet) {
                    Long costType = row.getLong("costtype");
                    Long ruleId = row.getLong("rule");
                    String planName = row.getString("name");
                    DynamicObject rule = QueryServiceHelper.queryOne((String)"cad_calcrule", (String)"plugin,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ruleId)});
                    String pluginStr = rule.getString("plugin");
                    String ruleName = rule.getString("name");
                    if (CadEmptyUtils.isEmpty(pluginStr)) {
                        logger.info("\u6807\u51c6\u6210\u672c\u5377\u7b97\u4ef7\u76ee\u8868\u91c7\u8d2d\u53d6\u4ef7\uff0c\u91c7\u8d2d\u53d6\u4ef7\u89c4\u5219==>{}\u5bf9\u5e94\u7684\u63d2\u4ef6\u4e3a\u7a7a\uff0c\u53d6\u4ef7\u9000\u51fa\u3002", (Object)rule.getString("name"));
                        continue;
                    }
                    ProgressHelper.refreshProgress(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u6b63\u5728\u53d6\u4ef7", (String)"PurchasePricing_2", (String)"macc-cad-common", (Object[])new Object[0]), ruleName), 1, ++total, Boolean.TRUE, progressId);
                    Class<?> clazz = Class.forName(pluginStr);
                    PurEventPlugin plugin = (PurEventPlugin)clazz.newInstance();
                    List<PricePluginPojo> result = null;
                    try {
                        result = plugin.pricingPluginCall(entityName, org, costType, ruleId, appNum, map);
                    }
                    catch (Exception e) {
                        logger.error("\u91c7\u8d2d\u53d6\u4ef7\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
                        map.put("existFailedCalcRule", true);
                        failedCalcRuleTips.append(e.getMessage()).append("\n");
                    }
                    logger.info("\u81ea\u5b9a\u4e49\u91c7\u8d2d\u53d6\u4ef7\u5171\u8fd4\u56de\u6570\u636e==>{}\u6761", (Object)(result == null ? 0 : result.size()));
                    ProgressHelper.refreshProgress(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u6b63\u5728\u5904\u7406\u53d6\u4ef7\u7ed3\u679c", (String)"PurchasePricing_3", (String)"macc-cad-common", (Object[])new Object[0]), ruleName), 1, ++total, Boolean.TRUE, progressId);
                    if (result != null && !result.isEmpty()) {
                        List partition = Lists.partition(result, (int)batchSize);
                        for (List list : partition) {
                            if ("cad_purprices".equals(entityName)) {
                                subCount += this.purPriceTransform(costType, ruleId, createId, list);
                                continue;
                            }
                            if ("cad_outsourceprice".equals(entityName)) {
                                subCount += this.outPriceTransform(costType, ruleId, createId, list);
                                continue;
                            }
                            if ("cad_resourceout".equals(entityName)) {
                                subCount += this.outResourcePriceTransform(costType, ruleId, createId, list);
                                continue;
                            }
                            if (!"cad_resourcerate".equals(entityName)) continue;
                            subCount += this.selfResourcePriceTransform(costType, ruleId, createId, list);
                        }
                        if (!"cad_resourcerate".equals(entityName)) {
                            this.matNotExistInvalidPrice(entityName, costType, ruleId, createId, result, map);
                        }
                    }
                    ProgressHelper.refreshProgress(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u53d6\u4ef7\u5b8c\u6210", (String)"PurchasePricing_4", (String)"macc-cad-common", (Object[])new Object[0]), ruleName), 1, ++total, Boolean.TRUE, progressId);
                }
                map.put(String.valueOf(org), subCount);
                count += subCount;
            }
            map.put("failedCalcRuleTips", failedCalcRuleTips);
            ProgressHelper.refreshProgress(ResManager.loadKDString((String)"\u53d6\u4ef7\u7ed3\u675f", (String)"PurchasePricing_5", (String)"macc-cad-common", (Object[])new Object[0]), 1, total, Boolean.TRUE, progressId);
            map.put("count", count);
        }
        finally {
            ProgressHelper.refreshProgress(ResManager.loadKDString((String)"", (String)"PurchasePricing_6", (String)"macc-cad-common", (Object[])new Object[0]), -1, 0, Boolean.FALSE, progressId);
        }
        return map;
    }

    private void matNotExistInvalidPrice(String entityName, Long costType, long ruleId, Long createId, List<PricePluginPojo> result, Map<String, Object> map) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_calcrule", (String)"invalidprice", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ruleId)});
        if (dynamicObject != null && dynamicObject.getBoolean("invalidprice")) {
            Date date = new Date();
            ArrayList<String> materialIds = new ArrayList<String>();
            for (PricePluginPojo pricePluginPojo : result) {
                if (CadEmptyUtils.isEmpty(pricePluginPojo.getMaterialId())) continue;
                materialIds.add(String.valueOf(pricePluginPojo.getMaterialId()));
            }
            QFilter filter = new QFilter("costtype", "=", (Object)costType);
            filter.and("effectdate", "<=", (Object)date);
            filter.and("expdate", ">", (Object)date);
            filter.and("pricerule", "=", (Object)ruleId);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"matNotExistInvalidPrice", (String)entityName, (String)"id,material", (QFilter[])new QFilter[]{filter}, null);
            if (!CadEmptyUtils.isEmpty(materialIds)) {
                dataSet = dataSet.filter("material not in (" + String.join((CharSequence)",", materialIds) + ")");
            }
            ArrayList<Long> idList = new ArrayList<Long>(10);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long id = row.getLong("id");
                if (CadEmptyUtils.isEmpty(id)) continue;
                idList.add(id);
            }
            logger.info("\u9700\u8981\u5931\u6548\u7684\u7269\u6599\u4e2a\u6570\uff1a{}", (Object)idList.size());
            if (CadEmptyUtils.isEmpty(idList)) {
                return;
            }
            for (List ids : Lists.partition(idList, (int)10000)) {
                StringJoiner idFilter = new StringJoiner(",", "(", ")");
                for (Long id : ids) {
                    idFilter.add(id.toString());
                }
                map.put("updateCount", idList.size());
                String now = DateUtils.formatDate(DateUtils.getPreSeveralEndDay(date, 1), "yyyy-MM-dd HH:mm:ss");
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
                DB.update((DBRoute)this.getDBRoute(), (String)("update " + entityType.getAlias() + " set fexpdate=" + "'" + now + "'" + ",fmodifytime=" + "'" + now + "'" + ",fmodifierid=" + createId + " where fid in " + idFilter.toString()));
            }
        }
    }

    protected abstract int purPriceTransform(Long var1, long var2, Long var4, List<PricePluginPojo> var5);

    protected abstract int outPriceTransform(Long var1, long var2, Long var4, List<PricePluginPojo> var5);

    protected abstract int outResourcePriceTransform(Long var1, long var2, Long var4, List<PricePluginPojo> var5);

    protected abstract int selfResourcePriceTransform(Long var1, long var2, Long var4, List<PricePluginPojo> var5);

    protected void invalidBill(Date now, List<DynamicObject> invalidateList, String entityNum) {
        logger.info("\u81ea\u5b9a\u4e49\u91c7\u8d2d\u53d6\u4ef7\u5931\u6548\u5355\u636e\u6761\u6570==>{},\u5b9e\u4f53\u7f16\u53f7==>{}", (Object)invalidateList.size(), (Object)entityNum);
        Date expdate = DateUtils.getDayStartTime(now);
        if (!invalidateList.isEmpty()) {
            for (DynamicObject object : invalidateList) {
                object.set("expdate", (Object)expdate);
            }
            SaveServiceHelper.update((DynamicObject[])invalidateList.toArray(new DynamicObject[0]));
        }
    }

    private Set<Long> getCostTypes(Long org, List<Long> accountList, Long costType) {
        HashSet<Long> typeSet = new HashSet<Long>();
        if (!CadEmptyUtils.isEmpty(costType)) {
            typeSet.add(costType);
            return typeSet;
        }
        QFilter filter = new QFilter("calorg", "=", (Object)org);
        if (!accountList.isEmpty()) {
            filter.and("costaccount", "in", accountList);
        }
        Date date = new Date();
        filter.and("effectdate", "<=", (Object)date);
        filter.and("invaliddate", ">", (Object)date);
        filter.and("bizstatus", "=", (Object)"1");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"costtype", (QFilter[])new QFilter[]{filter});
        if (!dynamicObjects.isEmpty()) {
            Set types = dynamicObjects.stream().map(c -> c.getLong("costtype")).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("id", "in", types);
            qFilter.and("type", "=", (Object)"0");
            qFilter.and("costtypeentry.costtypeattr", "=", (Object)"1");
            DynamicObjectCollection objs = QueryServiceHelper.query((String)"cad_costtype", (String)"costtypeentry.costtype.name as name,costtypeentry.costtype as costtype", (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject obj : objs) {
                logger.info("\u6807\u51c6\u6210\u672c\u5377\u7b97\u4ef7\u76ee\u8868\u91c7\u8d2d\u53d6\u4ef7,\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7==>{},\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u6210\u672c\u7c7b\u578b\u4e3a==>{}", (Object)org, (Object)obj.getString("name"));
                typeSet.add(obj.getLong("costtype"));
            }
        }
        return typeSet;
    }

    private QFilter getQFilter(String entityName, Set<Long> costTypes) {
        QFilter filter = new QFilter("costtype", "in", costTypes);
        filter.and("enable", "=", (Object)true);
        if ("cad_purprices".equals(entityName)) {
            filter.and("purpricesentry.purrule", "!=", (Object)PriceRuleConstants.PUR_MANUALLY_ID);
        } else if ("cad_resourceout".equals(entityName)) {
            filter.and("outresourceentry.outresrule", "!=", (Object)PriceRuleConstants.OUTRES_MANUALLY_ID);
        } else if ("cad_resourcerate".equals(entityName)) {
            filter.and("selfresourceentry.seresrule", "!=", (Object)PriceRuleConstants.SELFRES_MANUALLY_ID);
            filter.and("selfresourceentry.seresrule", "!=", (Object)PriceRuleConstants.SELFRES_PLANRESOURCERATE_ID);
        } else {
            filter.and("outpriceentry.outprirule", "!=", (Object)PriceRuleConstants.OUTPRI_MANUALLY_ID);
        }
        return filter;
    }

    private String getFields(String entityName) {
        StringBuilder fields = new StringBuilder("id,name,number,costtype,");
        if ("cad_purprices".equals(entityName)) {
            fields.append("purpricesentry.purrule as rule");
        } else if ("cad_resourceout".equals(entityName)) {
            fields.append("outresourceentry.outresrule as rule");
        } else if ("cad_resourcerate".equals(entityName)) {
            fields.append("selfresourceentry.seresrule as rule");
        } else {
            fields.append("outpriceentry.outprirule as rule");
        }
        return fields.toString();
    }

    protected DBRoute getDBRoute() {
        return DBRoute.of((String)"cal");
    }
}

