/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.bos.unifiedthreadpool.api.ThreadPoolFactory;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategy;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategyFactory;
import kd.macc.cad.common.thread.TaskType;

public class ThreadHelper {
    private static final ThreadExecutorService THREAD_EXECUTOR;

    public static ThreadExecutorService getThreadExecutor() {
        return THREAD_EXECUTOR;
    }

    public static void execute(Runnable command, TaskType taskType) {
        ThreadHelper.execute(command, taskType, null);
    }

    private static void execute(Runnable command, TaskType taskType, RequestContext context) {
        ThreadHelper.execute(command, taskType, context, null);
    }

    private static void execute(Runnable command, TaskType taskType, RequestContext context, OperationContext oc) {
        THREAD_EXECUTOR.execute(command, taskType.getName(), null, null);
    }

    public static <T> Future<T> submit(Callable<T> task, TaskType taskType) {
        return ThreadHelper.submit(task, taskType, null);
    }

    private static <T> Future<T> submit(Callable<T> task, TaskType taskType, RequestContext context) {
        return ThreadHelper.submit(task, taskType, context, null);
    }

    private static <T> Future<T> submit(Callable<T> task, TaskType taskType, RequestContext context, OperationContext oc) {
        return THREAD_EXECUTOR.submit(task, taskType.getName(), context, oc);
    }

    static {
        ThreadPoolStrategy threadPoolStrategy = ThreadPoolStrategyFactory.create();
        threadPoolStrategy.setMaxThreadNum(150);
        threadPoolStrategy.setMinThreadNum(50);
        threadPoolStrategy.setOverflowThreadNum(20);
        threadPoolStrategy.setThreadIdeMinutes(1L);
        for (TaskType taskType : TaskType.values()) {
            threadPoolStrategy.register(taskType.build());
        }
        THREAD_EXECUTOR = ThreadPoolFactory.create((String)"macc", (String)"macc-threadpool", (ThreadPoolStrategy)threadPoolStrategy);
    }
}

