/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.common.enums.AcaMutexEnum;
import org.apache.commons.lang3.StringUtils;

public class AcaMutexHelper {
    private static final Log logger = LogFactory.getLog(AcaMutexHelper.class);

    public static String requireMutex(AcaMutexEnum currentOp, long costAccountId) {
        String costAccountStr = String.valueOf(costAccountId);
        StringBuilder errorTip = new StringBuilder();
        errorTip.append(AcaMutexHelper.checkCalcMutex(currentOp, costAccountStr));
        if (StringUtils.isBlank((CharSequence)errorTip)) {
            boolean requireFlag = AcaMutexHelper.require(currentOp, costAccountStr);
            if (!requireFlag) {
                logger.info("\u68c0\u67e5\u4e92\u65a5\u6210\u529f,\u83b7\u53d6\u4e92\u65a5\u5931\u8d25.");
                return ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u8d26\u7c3f\u3001\u751f\u4ea7\u7ec4\u7ec7\u68c0\u67e5\u4e92\u65a5\u6210\u529f,\u83b7\u53d6\u4e92\u65a5\u5931\u8d25\u3002", (String)"AcaMutexHelper_0", (String)"macc-cad-common", (Object[])new Object[0]);
            }
            logger.info("\u83b7\u53d6\u4e92\u65a5\u6210\u529f.");
            return null;
        }
        logger.info("\u83b7\u53d6\u4e92\u65a5\u5931\u8d25,\u539f\u56e0\u662f:{}", (Object)errorTip);
        return errorTip.toString();
    }

    private static String getCostAccountName(long costAccountId) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costAccountId)}).getString("name");
    }

    public static void releaseMutex(AcaMutexEnum currentOp, long costAccountId) {
        String costAccountStr = String.valueOf(costAccountId);
        boolean releaseCostAccount = MutexHelper.release((String)currentOp.getEntityKey(), (String)currentOp.getOpKey(), (String)costAccountStr);
        logger.info("\u91ca\u653e\uff1a{}\u6210\u672c\u8d26\u7c3f:{}\u7ed3\u679c:{}", new Object[]{currentOp.getEntityKey(), costAccountId, releaseCostAccount});
    }

    private static String checkCalcMutex(AcaMutexEnum currentOp, String costAccountStr) {
        StringBuilder errorInfo = new StringBuilder();
        List<AcaMutexEnum> acaMutexEnums = AcaMutexHelper.initCheckList(currentOp);
        String account = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f:", (String)"AcaMutexHelper_1", (String)"macc-cad-common", (Object[])new Object[0]);
        for (AcaMutexEnum acaMutexEnum : acaMutexEnums) {
            if (AcaMutexHelper.enableReEntrant(acaMutexEnum, costAccountStr)) continue;
            errorInfo.append(String.format(AcaMutexEnum.getErrorTip(acaMutexEnum.getEntityKey()), account + AcaMutexHelper.getCostAccountName(Long.parseLong(costAccountStr))));
        }
        return errorInfo.toString();
    }

    public static String checkAllocCalcMutex(String costAccountStr) {
        StringBuilder errorInfo = new StringBuilder();
        ArrayList acaMutexEnums = Lists.newArrayList((Object[])new AcaMutexEnum[]{AcaMutexEnum.CALC_CALCULATE, AcaMutexEnum.MATALLOC_ALLOCATE});
        String account = ResManager.loadKDString((String)"\u6210\u672c\u8d26\u7c3f:", (String)"AcaMutexHelper_1", (String)"macc-cad-common", (Object[])new Object[0]);
        for (AcaMutexEnum acaMutexEnum : acaMutexEnums) {
            if (AcaMutexHelper.enableReEntrant(acaMutexEnum, costAccountStr)) continue;
            errorInfo.append(String.format(AcaMutexEnum.getErrorTip(acaMutexEnum.getEntityKey()), account + AcaMutexHelper.getCostAccountName(Long.parseLong(costAccountStr))));
        }
        return errorInfo.toString();
    }

    private static List<AcaMutexEnum> initCheckList(AcaMutexEnum mutexEnum) {
        ArrayList<AcaMutexEnum> resultList = new ArrayList<AcaMutexEnum>(8);
        if (mutexEnum == AcaMutexEnum.CALC_CALCULATE) {
            AcaMutexEnum[] values = AcaMutexEnum.values();
            resultList.addAll(Arrays.asList(values));
        } else if (mutexEnum == AcaMutexEnum.REALTIME_CALCULATE) {
            resultList.add(AcaMutexEnum.REALTIME_CALCULATE);
        } else if (mutexEnum == AcaMutexEnum.CALCULATE) {
            resultList.add(AcaMutexEnum.CALCULATE);
        } else {
            resultList.add(mutexEnum);
            resultList.add(AcaMutexEnum.CALC_CALCULATE);
        }
        return resultList;
    }

    private static synchronized boolean enableReEntrant(AcaMutexEnum mutexEnum, String reEntrantKey) {
        return MutexHelper.enableReentrant((String)mutexEnum.getEntityKey(), (Object)reEntrantKey, (String)mutexEnum.getOpKey());
    }

    private static synchronized boolean require(AcaMutexEnum currentOp, String mutexKey) {
        return MutexHelper.require((String)currentOp.getEntityKey(), (Object)mutexKey, (String)currentOp.getOpKey(), (boolean)true, (StringBuilder)new StringBuilder());
    }
}

