/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class BatchUtils {
    private static final Log logger = LogFactory.getLog(BatchUtils.class);

    public static List<List<Long>> batchDataByEntryId(DataSet dataSet, Integer batchSize, String entryIdField) {
        ArrayList<List<Long>> result = new ArrayList<List<Long>>();
        if (dataSet == null || dataSet.isEmpty()) {
            return result;
        }
        if (batchSize < 1) {
            return result;
        }
        ArrayList<Long> batchEntryIds = new ArrayList<Long>();
        for (Row row : dataSet) {
            batchEntryIds.add(row.getLong(entryIdField));
        }
        return Lists.partition(batchEntryIds, (int)batchSize);
    }

    public static List<Set<Long>> batchDataById(DataSet dataSet, Integer batchSize) {
        ArrayList<Set<Long>> result = new ArrayList<Set<Long>>();
        if (dataSet == null || dataSet.isEmpty()) {
            return result;
        }
        if (batchSize < 1) {
            return result;
        }
        HashMap idCount = Maps.newHashMapWithExpectedSize((int)5120);
        for (Row row : dataSet) {
            Long id = row.getLong("id");
            if (idCount.containsKey(id)) {
                Integer count = (Integer)idCount.get(id);
                count = count + 1;
                idCount.put(id, count);
                continue;
            }
            idCount.put(id, 1);
        }
        Iterator iterator = idCount.entrySet().iterator();
        HashSet batchIds = Sets.newHashSetWithExpectedSize((int)5120);
        int sum = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Long id = (Long)entry.getKey();
            Integer count = (Integer)entry.getValue();
            if ((sum += count.intValue()) <= batchSize) {
                batchIds.add(id);
                continue;
            }
            if (!CadEmptyUtils.isEmpty(batchIds)) {
                result.add(batchIds);
            }
            batchIds = Sets.newHashSetWithExpectedSize((int)5120);
            batchIds.add(id);
            sum = count;
        }
        if (!CadEmptyUtils.isEmpty(batchIds)) {
            result.add(batchIds);
        }
        return result;
    }
}

