/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;

public class BigDecimalUtils {
    public static String format(BigDecimal val, String pattern) {
        if (val == null || pattern == null || pattern.length() < 1) {
            return null;
        }
        DecimalFormat df = new DecimalFormat(pattern);
        return df.format(val);
    }

    public static void correctAmt(DynamicObjectCollection entryEntity, String keyField, String corrField, int rate) {
        BigDecimal diffValue = BigDecimal.ZERO;
        BigDecimal maxValue = BigDecimal.ZERO;
        String maxRowIndex = "";
        for (DynamicObject row : entryEntity) {
            BigDecimal value = row.getBigDecimal(corrField);
            if (BigDecimal.ZERO.compareTo(maxValue) == 0 || maxValue.compareTo(value) < 0) {
                maxValue = value;
                maxRowIndex = row.getString(keyField);
            }
            BigDecimal roundValue = value.setScale(rate, 4);
            diffValue = diffValue.add(value.subtract(roundValue));
            row.set(corrField, (Object)roundValue);
        }
        if (StringUtils.isEmpty((CharSequence)keyField)) {
            return;
        }
        for (DynamicObject row : entryEntity) {
            if (!maxRowIndex.equals(row.getString(keyField))) continue;
            row.set(corrField, (Object)maxValue.add(diffValue));
        }
    }

    public static void dealDiff(DynamicObjectCollection entryEntity, String indexField, String diffField, BigDecimal calcValue, int amtprecision) {
        BigDecimal maxValue = BigDecimal.ZERO;
        BigDecimal totalAmout = BigDecimal.ZERO;
        String maxRowIndex = "";
        for (DynamicObject row : entryEntity) {
            BigDecimal value = row.getBigDecimal(diffField);
            totalAmout = totalAmout.add(value);
            if (BigDecimal.ZERO.compareTo(maxValue) != 0 && maxValue.compareTo(value) >= 0) continue;
            maxValue = value;
            maxRowIndex = row.getString(indexField);
        }
        BigDecimal diffValue = calcValue.subtract(totalAmout);
        if (BigDecimal.ZERO.compareTo(diffValue) == 0) {
            return;
        }
        for (DynamicObject row : entryEntity) {
            if (!maxRowIndex.equals(row.getString(indexField))) continue;
            BigDecimal currValue = row.getBigDecimal(diffField);
            row.set(diffField, (Object)currValue.add(diffValue));
        }
    }
}

