/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CadUtils {
    private static final Log logger = LogFactory.getLog(CadUtils.class);
    public static final String DATE_TO_STRING_DETAIAL_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public static String getLocalName(DynamicObject item) {
        if (item == null) {
            return "";
        }
        ILocaleString localeString = item.getLocaleString("name");
        if (localeString != null) {
            return localeString.getLocaleValue();
        }
        return item.getString("number");
    }

    public static boolean isNumber(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    public static <T> List<T> objToList(Object obj, Class<T> cla) {
        ArrayList<T> list = new ArrayList<T>(10);
        if (obj instanceof ArrayList) {
            for (Object o : (List)obj) {
                list.add(cla.cast(o));
            }
        }
        return list;
    }

    public static List<Long> getMultiCostCentersByFilterName(FilterContainerSearchClickArgs args, String filterName, Long orgId) {
        ArrayList<Long> multiCostCenters = new ArrayList<Long>(10);
        DynamicObjectCollection costCentersObject = QueryServiceHelper.query((String)"bos_costcenter", (String)"id", (QFilter[])new QFilter[]{new QFilter("accountorg", "=", (Object)orgId)});
        ArrayList costCenterIds = new ArrayList(10);
        costCentersObject.forEach(p -> costCenterIds.add(p.getLong("id")));
        Object filterValue = args.getFilterValue(filterName);
        List<Long> values = CadUtils.objToList(filterValue, Long.class);
        if (CadEmptyUtils.isEmpty(values)) {
            return multiCostCenters;
        }
        for (Long value : values) {
            if (!costCenterIds.contains(value)) continue;
            multiCostCenters.add(value);
        }
        return multiCostCenters;
    }

    public static Set<Long> getMultiFieldByFilterName(FilterContainerSearchClickArgs args, String filterName) {
        HashSet<Long> multiCostCenters = new HashSet<Long>(10);
        Object filterValue = args.getFilterValue(filterName);
        List<Long> values = CadUtils.objToList(filterValue, Long.class);
        if (CadEmptyUtils.isEmpty(values)) {
            return multiCostCenters;
        }
        for (Long value : values) {
            multiCostCenters.add(value);
        }
        return multiCostCenters;
    }

    public static Date getDeFaultExpDate() {
        return CadUtils.parseDate("2999-12-31 23:59:59");
    }

    public static Date getDefaultEffectDate() {
        return CadUtils.parseDate("2000-01-01 00:00:00");
    }

    public static Date parseDate(String dateStr) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_TO_STRING_DETAIAL_PATTERN);
        Date date = null;
        try {
            date = simpleDateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            logger.error("\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
        }
        return date;
    }

    public static String setToSql(Set<Long> ids) {
        if (CadEmptyUtils.isEmpty(ids)) {
            return "(-1)";
        }
        StringBuilder sql = new StringBuilder();
        sql.append('(');
        for (Long id : ids) {
            sql.append(id).append(',');
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(')');
        return sql.toString();
    }
}

