/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import org.apache.commons.lang.time.DateFormatUtils;

public class DateUtils {
    protected static final Log logger = LogFactory.getLog(DateUtils.class);
    public static final String DATE_TO_STRING_DETAIAL_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public static Date getTimeServiceNow() {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TO_STRING_DETAIAL_PATTERN);
        String date = sdf.format(TimeServiceHelper.now());
        return DateUtils.parseDate(date);
    }

    public static Date getThisWeekMonday() {
        Calendar cal = Calendar.getInstance();
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        cal.add(5, cal.getFirstDayOfWeek() - day);
        return cal.getTime();
    }

    public static Date getThisWeekSunday() {
        Calendar cal = Calendar.getInstance();
        Date thisWeekMonday = DateUtils.getThisWeekMonday();
        cal.setTime(thisWeekMonday);
        cal.add(5, 6);
        return cal.getTime();
    }

    public static Date getLastWeekMonday() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getThisWeekMonday());
        cal.add(5, -7);
        return cal.getTime();
    }

    public static Date getLastWeekSunday() {
        Calendar cal = Calendar.getInstance();
        Date thisWeekMonday = DateUtils.getLastWeekMonday();
        cal.setTime(thisWeekMonday);
        cal.add(5, 6);
        return cal.getTime();
    }

    public static Date getLastMonthFirstDay() {
        Calendar cal_1 = Calendar.getInstance();
        cal_1.add(2, -1);
        cal_1.set(5, 1);
        cal_1.set(11, 0);
        cal_1.set(12, 0);
        cal_1.set(13, 0);
        cal_1.set(14, 0);
        return cal_1.getTime();
    }

    public static Date getMonthFirstDay(int amount) {
        Calendar cal = Calendar.getInstance();
        cal.add(2, amount);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getLastMonthEndDay() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 9999);
        return cal.getTime();
    }

    public static Date getMonthEndDay(int amount) {
        Calendar cal = Calendar.getInstance();
        cal.add(2, amount);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTime();
    }

    public static Date getThisMonthFirstDay() {
        Calendar c = Calendar.getInstance();
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date getThisMonthEndDay() {
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        ca.set(11, 23);
        ca.set(12, 59);
        ca.set(13, 59);
        ca.set(14, 999);
        return ca.getTime();
    }

    public static Date getDayEndTime(Date d) {
        if (d == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getDayStartTime(Date d) {
        if (d == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getCurrentSystemTime() {
        Date date = null;
        try {
            Calendar ca = Calendar.getInstance();
            Date time = ca.getTime();
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_TO_STRING_DETAIAL_PATTERN);
            date = sdf.parse(sdf.format(time));
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
        }
        return date;
    }

    public static Date getCurrentSystemDate() {
        Date date = null;
        try {
            Calendar ca = Calendar.getInstance();
            Date time = ca.getTime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            date = sdf.parse(sdf.format(time));
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
        }
        return date;
    }

    public static boolean compareDate(Date beginTime, Date endTime) {
        boolean result = true;
        result = !beginTime.before(endTime);
        return result;
    }

    public static Date parseDate(String dateStr) {
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TO_STRING_DETAIAL_PATTERN);
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
        }
        return date;
    }

    public static Date parseShortDate(String dateStr) {
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
        }
        return date;
    }

    public static Date getLastDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int day = calendar.get(5);
        calendar.set(5, day - 1);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getLastMinute(Date date, int minute) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, -minute);
        return calendar.getTime();
    }

    public static Date getLastSecond(Date date, int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, -seconds);
        return calendar.getTime();
    }

    public static String formatDate(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        String formatDate = null;
        formatDate = pattern != null && pattern.length() > 0 ? DateFormatUtils.format((Date)date, (String)pattern) : DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd");
        return formatDate;
    }

    public static long getSecond(Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            return 0L;
        }
        return (endTime.getTime() - startTime.getTime()) / 1000L;
    }

    public static Date getDefaultEffectDate() {
        return DateUtils.parseDate("2000-01-01 00:00:00");
    }

    public static Date getDeFaultExpDate() {
        return DateUtils.parseDate("2999-12-31 23:59:59");
    }

    public static Date getMinDate(Date start, Date end) {
        if (start == null && end == null) {
            return null;
        }
        if (start != null && end == null) {
            return start;
        }
        if (start == null && end != null) {
            return end;
        }
        int diff = start.compareTo(end);
        return diff <= 0 ? start : end;
    }

    public static Date getLastSeveralDay(Date curDate, int x) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(curDate);
        int day = calendar.get(5);
        calendar.set(5, day + x);
        return calendar.getTime();
    }

    public static Date getPreSeveralBeginDay(Date curDate, int x) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(curDate);
        int day = calendar.get(5);
        calendar.set(5, day - x);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getPreSeveralEndDay(Date curDate, int x) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(curDate);
        int day = calendar.get(5);
        calendar.set(5, day - x);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getMaxDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2999);
        calendar.set(2, 11);
        calendar.set(5, 31);
        return calendar.getTime();
    }

    public static Date getPriceDate(Date srcAuditDate, Date srcBookDate) {
        String srcBookDateStr;
        if (srcAuditDate == null || srcBookDate == null) {
            return null;
        }
        String srcAuditDateStr = DateFormatUtils.format((Date)srcAuditDate, (String)"yyyy-MM-dd");
        if (srcAuditDateStr.equals(srcBookDateStr = DateFormatUtils.format((Date)srcBookDate, (String)"yyyy-MM-dd"))) {
            return srcAuditDate;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(srcBookDate);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDateByYearAndMonth(int year, int month, String type) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(1, year);
        cal.set(2, month - 1);
        if ("max".equals(type)) {
            int lastDay = cal.getActualMaximum(5);
            cal.set(5, lastDay);
        } else {
            int firstDay = cal.getMinimum(5);
            cal.set(5, firstDay);
        }
        return cal.getTime();
    }

    public static Date getPreviousDay(Date date) {
        Calendar cd = Calendar.getInstance();
        cd.setTime(date);
        cd.add(5, -1);
        cd.set(10, 23);
        cd.set(12, 59);
        cd.set(13, 59);
        cd.set(14, 0);
        return cd.getTime();
    }

    public static boolean isSameYearMonth(Date bizDate, Date tarBizDate) {
        Calendar souCalendar = Calendar.getInstance();
        souCalendar.setTime(bizDate);
        Calendar tarCalendar = Calendar.getInstance();
        tarCalendar.setTime(tarBizDate);
        return souCalendar.get(1) == tarCalendar.get(1) && souCalendar.get(2) == tarCalendar.get(2);
    }
}

