/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.utils.JsonEntryFillFunction;

public class JsonEntryServiceHelper {
    private static final Log logger = LogFactory.getLog(JsonEntryServiceHelper.class);
    private static final String SUBENTRYJSON_FLAG = "_json";

    public static DataSetX queryJsonSubEntryDataSetX(String algoKey, String entityName, String selectFields, String jsonSubEntry, QFilter[] filters, JobSession session) {
        return JsonEntryServiceHelper.queryJsonSubEntryDataSetX(algoKey, entityName, selectFields, jsonSubEntry, filters, session, false);
    }

    public static DataSet queryJsonSubEntryDataSet(String algoKey, String entityName, String selectFields, String jsonSubEntry, QFilter[] filters) {
        JobSession session = AlgoX.createSession((String)algoKey);
        DataSetX input = JsonEntryServiceHelper.queryJsonSubEntryDataSetX(algoKey, entityName, selectFields, jsonSubEntry, filters, session, false);
        DataSetOutput result = new DataSetOutput(input.getRowMeta());
        input.output((Output)result);
        session.commit(1, TimeUnit.HOURS);
        return session.readDataSet(result.getId());
    }

    public static DataSetX queryJsonSubEntryDataSetX(String algoKey, String entityName, String selectFields, String jsonSubEntry, QFilter[] filters, JobSession session, boolean isEmptyReturnNull) {
        if (StringUtils.isEmpty((String)jsonSubEntry)) {
            return null;
        }
        if (StringUtils.isEmpty((String)selectFields)) {
            return null;
        }
        ArrayList<String> subEntryFields = new ArrayList<String>(16);
        ArrayList<String> subEntryAliasFields = new ArrayList<String>(16);
        selectFields = selectFields.replace(" as ", " AS ");
        selectFields = selectFields.replace(" As ", " AS ");
        selectFields = selectFields.replace(" aS ", " AS ");
        String[] ss = selectFields.split(",");
        StringBuilder newSelectSb = new StringBuilder();
        boolean isContainIdField = false;
        for (int i = 0; i < ss.length; ++i) {
            String field = ss[i].trim();
            String asField = null;
            if (field.contains(" AS ")) {
                asField = field.split(" AS ")[1];
                field = field.split(" ")[0];
            } else {
                asField = field;
            }
            if (field.contains(jsonSubEntry)) {
                subEntryFields.add(field);
                subEntryAliasFields.add(asField);
                continue;
            }
            if (asField.equals("id")) {
                isContainIdField = true;
            }
            if (i > 0) {
                newSelectSb.append(",");
            }
            newSelectSb.append(field);
            newSelectSb.append(" as ");
            newSelectSb.append(asField);
        }
        String jsonFieldName = jsonSubEntry + SUBENTRYJSON_FLAG;
        newSelectSb.append(",").append(jsonFieldName);
        String newSelect = newSelectSb.toString();
        if (!isContainIdField) {
            newSelect = "id," + newSelect;
        }
        DataSet srcDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)newSelect, (QFilter[])filters, null);
        if (isEmptyReturnNull && srcDataSet.isEmpty()) {
            return null;
        }
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityName);
        ArrayList<Field> resultFieldsList = new ArrayList<Field>(16);
        for (Field field : srcDataSet.getRowMeta().getFields()) {
            if (field.getName().equals(jsonFieldName)) continue;
            resultFieldsList.add(field);
        }
        IDataEntityType jsonEntryType = JsonEntryServiceHelper.getJsonEntryEntityProperty((IDataEntityType)dt, jsonSubEntry);
        if (jsonEntryType == null) {
            return null;
        }
        JsonEntryServiceHelper.addJsonSubEntryFields(jsonSubEntry, subEntryFields, subEntryAliasFields, resultFieldsList, jsonEntryType);
        DataSetX srcDataSetX = session.fromInput((Input)new DataSetInput(srcDataSet));
        RowMeta resultRowMeta = new RowMeta(resultFieldsList.toArray(new Field[0]));
        srcDataSetX = srcDataSetX.groupBy(new String[]{"id"}).reduceGroup((GroupReduceFunction)new JsonEntryFillFunction(jsonSubEntry, resultRowMeta, subEntryFields, subEntryAliasFields, jsonFieldName));
        return srcDataSetX;
    }

    public static DataSet queryJsonSubEntryDataSet(String algoKey, String entityName, String selectFields, String jsonSubEntry, QFilter[] filters, String orderBys) {
        if (StringUtils.isEmpty((String)jsonSubEntry)) {
            return QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys);
        }
        if (StringUtils.isEmpty((String)selectFields)) {
            return null;
        }
        JobSession session = AlgoX.createSession((String)(algoKey + "jsonQuery"));
        DataSetX srcDataSetX = JsonEntryServiceHelper.queryJsonSubEntryDataSetX(algoKey, entityName, selectFields, jsonSubEntry, filters, session);
        String[] resulFields = srcDataSetX.getRowMeta().getFieldNames();
        DataSetOutput resultSetOutput = new DataSetOutput(srcDataSetX.getRowMeta());
        String resultId = resultSetOutput.getId();
        srcDataSetX.output((Output)resultSetOutput);
        long start = System.currentTimeMillis();
        logger.info("JsonEntryTransfer:start:{}", (Object)start);
        session.commit(1, TimeUnit.HOURS);
        logger.info("JsonEntryTransfer:end:{}", (Object)(System.currentTimeMillis() - start));
        DataSet resultDataSet = session.readDataSet(resultId).select(resulFields);
        if (orderBys != null && StringUtils.isNotEmpty((String)orderBys.trim())) {
            resultDataSet = resultDataSet.orderBy(orderBys.split(","));
        }
        return resultDataSet;
    }

    private static void addJsonSubEntryFields(String jsonSubEntry, List<String> subEntryFields, List<String> subEntryAliasFields, List<Field> resultFieldsList, IDataEntityType jsonEntryType) {
        DataEntityPropertyCollection jsonEntryFields = jsonEntryType.getProperties();
        for (int i = 0; i < subEntryFields.size(); ++i) {
            IDataEntityProperty dp;
            Class type;
            String subEntryField = subEntryFields.get(i);
            String subEntryAliasField = subEntryAliasFields.get(i);
            String field = subEntryField.replace(jsonSubEntry + ".", "");
            if (field.endsWith(".id")) {
                field = field.replace(".id", "_id");
            }
            if ((type = (dp = (IDataEntityProperty)jsonEntryFields.get((Object)field)).getPropertyType()).equals(String.class)) {
                resultFieldsList.add(new Field(subEntryAliasField, (DataType)DataType.StringType));
                continue;
            }
            if (type.equals(BigDecimal.class)) {
                resultFieldsList.add(new Field(subEntryAliasField, (DataType)DataType.BigDecimalType));
                continue;
            }
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                resultFieldsList.add(new Field(subEntryAliasField, (DataType)DataType.IntegerType));
                continue;
            }
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                resultFieldsList.add(new Field(subEntryAliasField, (DataType)DataType.LongType));
                continue;
            }
            if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                resultFieldsList.add(new Field(subEntryAliasField, (DataType)DataType.DoubleType));
                continue;
            }
            if (type.equals(Date.class)) {
                resultFieldsList.add(new Field(subEntryAliasField, (DataType)DataType.DateType));
                continue;
            }
            if (type.equals(BasedataEntityType.class)) {
                resultFieldsList.add(new Field(subEntryAliasField, (DataType)DataType.LongType));
                continue;
            }
            if (!type.equals(DynamicObject.class)) continue;
            resultFieldsList.add(new Field(subEntryAliasField, (DataType)DataType.LongType));
        }
    }

    private static IDataEntityType getJsonEntryEntityProperty(IDataEntityType dt, String jsonSubEntry) {
        String[] ss = jsonSubEntry.split("\\.");
        IDataEntityType tmpDt = dt;
        for (int i = 0; i < ss.length; ++i) {
            IDataEntityProperty dp = (IDataEntityProperty)tmpDt.getProperties().get((Object)ss[i]);
            if (dp instanceof ICollectionProperty) {
                ICollectionProperty dcp = (ICollectionProperty)dp;
                tmpDt = dcp.getItemType();
            }
            if (i != ss.length - 1) continue;
            return tmpDt;
        }
        return null;
    }
}

