/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MaterialPropHelper {
    private static final Log logger = LogFactory.getLog(MaterialPropHelper.class);
    private static final String MAT_MARK = "material";
    private static final String SPLIT = "@";

    public static void queryMaterialPropAndSet(DynamicObjectCollection resResults, String selectFields) {
        Map<Long, String> matIdPropsMap = MaterialPropHelper.queryMatInfo(resResults);
        MaterialPropHelper.setMatProp(resResults, selectFields, matIdPropsMap);
    }

    private static Map<Long, String> queryMatInfo(DynamicObjectCollection resResults) {
        HashSet<Long> matIds = new HashSet<Long>(64);
        HashMap<Long, String> matIdPropMap = new HashMap<Long, String>(64);
        if (resResults != null) {
            for (DynamicObject resResult : resResults) {
                if (!resResult.containsProperty(MAT_MARK)) continue;
                long material = resResult.getLong(MAT_MARK);
                matIds.add(material);
            }
            if (!matIds.isEmpty()) {
                List partitions = Lists.partition(new ArrayList(matIds), (int)20000);
                for (List partition : partitions) {
                    QFilter idQf = new QFilter("id", "in", (Object)partition);
                    DataSet materials = QueryServiceHelper.queryDataSet((String)"collConfigEngine-queryMat", (String)"bd_material", (String)"id,number,name", (QFilter[])new QFilter[]{idQf}, null);
                    for (Row material : materials) {
                        Long id = material.getLong("id");
                        String number = material.getString("number");
                        String name = material.getString("name");
                        matIdPropMap.put(id, number.concat(SPLIT).concat(name));
                    }
                }
            }
        }
        return matIdPropMap;
    }

    private static void setMatProp(DynamicObjectCollection resResults, String selectFields, Map<Long, String> matIdPropMap) {
        if (StringUtils.isNotBlank((String)selectFields) && selectFields.contains(MAT_MARK)) {
            if (resResults != null) {
                if (!CadEmptyUtils.isEmpty(matIdPropMap)) {
                    for (DynamicObject resResult : resResults) {
                        if (!resResult.getDataEntityType().getProperties().containsKey((Object)"materialNumber") || !resResult.getDataEntityType().getProperties().containsKey((Object)"materialName")) continue;
                        long material = resResult.getLong(MAT_MARK);
                        if (matIdPropMap.containsKey(material)) {
                            String props = matIdPropMap.get(material);
                            String[] split = props.split(SPLIT);
                            if (split == null || split.length != 2) continue;
                            resResult.set("materialNumber", (Object)split[0]);
                            resResult.set("materialName", (Object)split[1]);
                            continue;
                        }
                        logger.info("\u7269\u6599id\u5bf9\u5e94\u7269\u6599\u4fe1\u606f\u672a\u627e\u5230key:{}", (Object)material);
                    }
                } else {
                    logger.info("\u7269\u6599id\u5bf9\u5e94\u7269\u6599\u4fe1\u606f\u4e3a\u7a7a");
                }
            } else {
                logger.info("\u6e90\u5355\u96c6\u5408\u4e3a\u7a7a");
            }
        } else {
            logger.info("\u67e5\u8be2\u5b57\u6bb5\u4e3a\u7a7a");
        }
    }
}

