/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.utils;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class SrcBillShowerUtils {
    public static void showSearchUpBill(IFormView view, String entityName, List<Object> ids) {
        if (CadEmptyUtils.isEmpty(ids)) {
            return;
        }
        for (Object id : ids) {
            BillShowParameter bill = new BillShowParameter();
            bill.setFormId(entityName);
            OpenStyle style = new OpenStyle();
            style.setShowType(ShowType.MainNewTabPage);
            bill.setOpenStyle(style);
            bill.setStatus(OperationStatus.VIEW);
            bill.setPkId(id);
            bill.setHasRight(false);
            view.showForm((FormShowParameter)bill);
        }
    }

    public static void showSearchUpBillOrList(IFormView view, String entityName, List<Object> ids, Map<String, Object> customParam) {
        if (CadEmptyUtils.isEmpty(ids)) {
            return;
        }
        if (ids.size() == 1) {
            SrcBillShowerUtils.showSearchUpBill(view, entityName, ids);
        } else {
            SrcBillShowerUtils.showSearchUpBillList(view, entityName, ids, customParam);
        }
    }

    public static void showSearchUpBillList(IFormView view, String entityName, List<Object> ids, Map<String, Object> customParam) {
        if (CadEmptyUtils.isEmpty(ids)) {
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(entityName);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setHasRight(false);
        if (!CadEmptyUtils.isEmpty(customParam)) {
            parameter.setCustomParams(customParam);
        } else {
            parameter.setShowFilter(false);
            parameter.setShowQuickFilter(false);
        }
        LinkQueryPkIdCollection linkQueryPkIdCollection = new LinkQueryPkIdCollection();
        Iterator<Object> iterator = ids.iterator();
        while (iterator.hasNext()) {
            linkQueryPkIdCollection.addLinkQueryPkId(iterator.next());
        }
        parameter.setLinkQueryPkIdCollection(linkQueryPkIdCollection);
        view.showForm((FormShowParameter)parameter);
    }
}

