/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.utils;

import java.util.ArrayList;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class WriteLogUtils {
    public static void writeLog(ILogService logService, RequestContext context, String opName, String opDescription, String entityName, IDataModel model) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(context.getUserId()));
        logInfo.setBizAppID(AppMetadataCache.getAppInfo((String)type.getAppId()).getId());
        logInfo.setBizObjID(model.getDataEntityType().getName());
        logInfo.setOrgID(Long.valueOf(context.getOrgId()));
        logInfo.setOpTime(TimeServiceHelper.now());
        logInfo.setClientType(context.getClient());
        logInfo.setClientIP(context.getLoginIP());
        logInfo.setClientName(context.getClient());
        logInfo.setOpName(opName);
        logInfo.setOpDescription(opDescription);
        logService.addLog(logInfo);
    }

    public static void addBatchLog(ILogService logService, RequestContext context, String bizAppId, String opName, Set<String> descriptions, String entityName) {
        ArrayList<AppLogInfo> appLogInfos = new ArrayList<AppLogInfo>(16);
        for (String description : descriptions) {
            AppLogInfo logInfo = new AppLogInfo();
            logInfo.setUserID(Long.valueOf(context.getUserId()));
            logInfo.setBizAppID(bizAppId);
            logInfo.setBizObjID(entityName);
            logInfo.setOrgID(Long.valueOf(context.getOrgId()));
            logInfo.setOpTime(TimeServiceHelper.now());
            logInfo.setClientType(context.getClient());
            logInfo.setClientIP(context.getLoginIP());
            logInfo.setClientName(context.getClient());
            logInfo.setOpName(opName);
            logInfo.setOpDescription(description);
            appLogInfos.add(logInfo);
        }
        logService.addBatchLog(appLogInfos);
    }

    public static void addLog(ILogService logService, RequestContext context, String opName, String opDescription, String entityName) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(context.getUserId()));
        logInfo.setBizAppID(AppMetadataCache.getAppInfo((String)type.getAppId()).getId());
        logInfo.setBizObjID(entityName);
        logInfo.setOrgID(Long.valueOf(context.getOrgId()));
        logInfo.setOpTime(TimeServiceHelper.now());
        logInfo.setClientType(context.getClient());
        logInfo.setClientIP(context.getLoginIP());
        logInfo.setClientName(context.getClient());
        logInfo.setOpName(opName);
        logInfo.setOpDescription(opDescription);
        logService.addLog(logInfo);
    }

    public static void writeLog(ILogService logService, RequestContext context, String opName, String opDescription, String entityName, String appId) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(context.getUserId()));
        if (StringUtils.isEmpty((CharSequence)appId)) {
            logInfo.setBizAppID(AppMetadataCache.getAppInfo((String)type.getAppId()).getId());
        } else {
            if (CadEmptyUtils.isEmpty(appId)) {
                appId = "sca";
            }
            logInfo.setBizAppID(AppMetadataCache.getAppInfo((String)appId).getId());
        }
        logInfo.setBizObjID(type.getName());
        logInfo.setOrgID(Long.valueOf(context.getOrgId()));
        logInfo.setOpTime(TimeServiceHelper.now());
        logInfo.setClientType(context.getClient());
        logInfo.setClientIP(context.getLoginIP());
        logInfo.setClientName(context.getClient());
        logInfo.setOpName(opName);
        logInfo.setOpDescription(opDescription);
        logService.addLog(logInfo);
    }
}

