/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.macc.cad.algox.calc.helper.CalcMutexHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.servicehelper.RecordCalcDataChangeServiceHelper;

public class BaseCalcDataChangedOp
extends AbstractOperationServicePlugIn {
    Log logger = LogFactory.getLog(BaseCalcDataChangedOp.class);
    private final List<String> opKeyList = new ArrayList<String>(Arrays.asList("audit", "unaudit", "enable", "disable"));

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = RecordCalcDataChangeServiceHelper.getDiffPropsByEntity((String)this.billEntityType.getName());
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            e.getFieldKeys().addAll(keys);
        }
        e.getFieldKeys().add("costtype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.dataEntities;
                HashSet<Long> costTypeIds = new HashSet<Long>(dataEntities.length);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    costTypeIds.add(dataEntity.getDataEntity().getLong("costtype.id"));
                }
                if ("unaudit".equals(this.getOperateKey())) {
                    String lockTip = CalcMutexHelper.enableReentrantAll((String)"update", costTypeIds);
                    if (CadEmptyUtils.isEmpty((String)lockTip)) {
                        return;
                    }
                    if (dataEntities.length > 0) {
                        this.addErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u5f53\u524d\u6b63\u5728\u8fdb\u884c\u66f4\u65b0\uff0c\u8bf7\u66f4\u65b0\u5b8c\u6bd5\u540e\u4fee\u6539\u6570\u636e\u3002", (String)"BaseCalcDataChangedOp_0", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String opKey = e.getOperationKey();
        if (this.opKeyList.contains(opKey)) {
            DynamicObject[] datas = e.getDataEntities();
            try {
                this.logger.info("\u5f53\u524d\u5b9e\u4f53\uff1a" + this.billEntityType.getName() + "\u901a\u8fc7\u64cd\u4f5c" + opKey + "\u53d8\u66f4\u6570\u636e\u6761\u6570\uff1a" + datas.length);
                ArrayList<Object> pks = new ArrayList<Object>(datas.length);
                for (DynamicObject dyo : datas) {
                    pks.add(dyo.get("id"));
                }
                int size = RecordCalcDataChangeServiceHelper.recordCalcChangedData((String)this.billEntityType.getName(), pks, (String)opKey);
                this.logger.info("\u4fdd\u5b58\u5b9e\u4f53\uff1a" + this.billEntityType.getName() + "\u53d8\u66f4\u8bb0\u5f55\u6210\u529f\u6761\u6570\uff1a" + size);
            }
            catch (Exception ex) {
                this.logger.error("\u8bb0\u5f55\u53d8\u66f4\u8bb0\u5f55\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + ex.getMessage());
            }
        }
    }
}

