/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadUtils;
import kd.macc.cad.opplugin.CommonOp;

public class BaseSettingOpHelper {
    public static String checkBomSettingRepeated(DynamicObject item, DynamicObject version, List<QFilter> filters) {
        DynamicObject mat = item.getDynamicObject("material");
        if (mat == null) {
            return null;
        }
        boolean isBomVsersion = BomRouterHelper.isEnableMatversion((DynamicObject)mat);
        boolean isAuxprop = BomRouterHelper.isEnableAuxprop((DynamicObject)mat);
        String repeatErrStrBody = ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u7c7b\u578b\u4e0b\uff0c", (String)"BaseSettingOpHelper_23", (String)"macc-cad-opplugin", (Object[])new Object[0]);
        String matName = CadUtils.getLocalName((DynamicObject)mat);
        String resMatName = ResManager.loadKDString((String)"\u7269\u6599", (String)"BaseSettingOpHelper_1", (String)"macc-cad-opplugin", (Object[])new Object[0]);
        String resAuxName = ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027", (String)"BaseSettingOpHelper_2", (String)"macc-cad-opplugin", (Object[])new Object[0]);
        String resVersionName = ResManager.loadKDString((String)"\u7269\u6599\u7248\u672c", (String)"BaseSettingOpHelper_3", (String)"macc-cad-opplugin", (Object[])new Object[0]);
        String configName = ResManager.loadKDString((String)"\u914d\u7f6e\u53f7", (String)"BaseSettingOpHelper_11", (String)"macc-cad-opplugin", (Object[])new Object[0]);
        String trackName = ResManager.loadKDString((String)"\u8ddf\u8e2a\u53f7", (String)"BaseSettingOpHelper_12", (String)"macc-cad-opplugin", (Object[])new Object[0]);
        String projectName = ResManager.loadKDString((String)"\u9879\u76ee\u53f7", (String)"BaseSettingOpHelper_13", (String)"macc-cad-opplugin", (Object[])new Object[0]);
        String lotName = ResManager.loadKDString((String)"\u6279\u53f7", (String)"BaseSettingOpHelper_14", (String)"macc-cad-opplugin", (Object[])new Object[0]);
        StringBuilder sg = new StringBuilder();
        sg.append(repeatErrStrBody);
        if (!isBomVsersion && !isAuxprop) {
            sg.append(resMatName);
            sg.append("[");
            sg.append(mat.getString("number"));
            sg.append("/");
            sg.append(matName);
            sg.append("]");
        } else if (isBomVsersion && !isAuxprop) {
            sg.append(resMatName);
            sg.append("[");
            sg.append(mat.getString("number"));
            sg.append("/");
            sg.append(matName);
            sg.append("]+");
            sg.append(resVersionName);
            sg.append("[");
            sg.append(version == null ? "" : version.getString("number"));
            sg.append("/");
            sg.append(CadUtils.getLocalName((DynamicObject)version));
            sg.append("]");
        } else if (!isBomVsersion && isAuxprop) {
            sg.append(resMatName);
            sg.append("[");
            sg.append(mat.getString("number"));
            sg.append("/");
            sg.append(matName);
            sg.append("]+");
            sg.append(resAuxName);
        } else if (isBomVsersion && isAuxprop) {
            sg.append(resMatName);
            sg.append("[");
            sg.append(mat.getString("number"));
            sg.append("/");
            sg.append(matName);
            sg.append("]+");
            sg.append(resVersionName);
            sg.append("[");
            sg.append(version == null ? "" : version.getString("number"));
            sg.append("/");
            sg.append(CadUtils.getLocalName((DynamicObject)version));
            sg.append("]+");
            sg.append(resAuxName);
        }
        if (item.get("configuredcode") != null) {
            sg.append("+");
            sg.append(configName);
            sg.append("[");
            sg.append(item.getString("configuredcode.number"));
            sg.append("]");
        }
        if (item.get("tracknumber") != null) {
            sg.append("+");
            sg.append(trackName);
            sg.append("[");
            sg.append(item.getString("tracknumber.number"));
            sg.append("]");
        }
        if (item.get("project") != null) {
            sg.append("+");
            sg.append(projectName);
            sg.append("[");
            sg.append(item.getString("project.number"));
            sg.append("]");
        }
        if (!CadEmptyUtils.isEmpty((String)item.getString("lot"))) {
            sg.append("+");
            sg.append(lotName);
            sg.append("[");
            sg.append(item.getString("lot"));
            sg.append("]");
        }
        if (item.get("configuredcode") != null) {
            repeatErrStrBody = repeatErrStrBody + "+" + configName;
        }
        if (item.get("tracknumber") != null) {
            repeatErrStrBody = repeatErrStrBody + "+" + trackName;
        }
        if (item.get("project") != null) {
            repeatErrStrBody = repeatErrStrBody + "+" + projectName;
        }
        if (!CadEmptyUtils.isEmpty((String)item.getString("lot"))) {
            repeatErrStrBody = repeatErrStrBody + "+" + lotName;
        }
        filters.add(new QFilter("configuredcode", "=", (Object)item.getLong("configuredcode.id")));
        filters.add(new QFilter("tracknumber", "=", (Object)item.getLong("tracknumber.id")));
        filters.add(new QFilter("project", "=", (Object)item.getLong("project.id")));
        filters.add(new QFilter("lot", "=", (Object)item.getString("lot")));
        if (QueryServiceHelper.exists((String)"cad_bomsetting", (QFilter[])filters.toArray(new QFilter[0]))) {
            return sg.toString();
        }
        return null;
    }

    public static String checkSameMaterial(DynamicObject item) {
        DynamicObjectCollection rows = item.getDynamicObjectCollection("materialentry");
        HashMap<String, List> matInfoMap = new HashMap<String, List>(16);
        for (DynamicObject row : rows) {
            String key = row.getLong("material.id") + "@" + row.getString("auxpty.id") + "@" + row.getString("configuredcode.number") + "@" + row.getString("tracknumber.number") + "@" + row.getString("project.number") + "@" + row.getString("lot");
            matInfoMap.computeIfAbsent(key, p -> new ArrayList()).add(row);
        }
        String repeatErrStrBody = ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u7c7b\u578b\u4e0b\uff0c\u7269\u6599", (String)"BaseSettingOpHelper_15", (String)"macc-cad-opplugin", (Object[])new Object[0]);
        StringBuilder sg = new StringBuilder();
        int size = 0;
        for (Map.Entry entry : matInfoMap.entrySet()) {
            List list = (List)entry.getValue();
            if (list.size() == 1) continue;
            ++size;
        }
        int count = 1;
        for (Map.Entry entry : matInfoMap.entrySet()) {
            String lot;
            DynamicObject project;
            DynamicObject tracknumber;
            DynamicObject configuredcode;
            DynamicObject auxpty;
            List values = (List)entry.getValue();
            if (values.size() == 1) continue;
            DynamicObject row = (DynamicObject)values.get(0);
            DynamicObject material = row.getDynamicObject("material");
            String matInfo = "[" + material.getString("number") + "/" + CadUtils.getLocalName((DynamicObject)material) + "]";
            sg.append(matInfo);
            HashSet<Long> allAuxptyId = new HashSet<Long>();
            Boolean isUseAuxpty = material.getBoolean("isuseauxpty");
            if (isUseAuxpty.booleanValue()) {
                DynamicObjectCollection isaffectprice = material.getDynamicObjectCollection("auxptyentry");
                for (DynamicObject isPrice : isaffectprice) {
                    allAuxptyId.add(isPrice.getLong("auxpty.id"));
                }
            }
            if ((auxpty = row.getDynamicObject("auxpty")) != null) {
                String auxptyInfo = CommonOp.getAuptyInfo(allAuxptyId, (String)auxpty.get(1));
                sg.append(String.format(ResManager.loadKDString((String)"+\u8f85\u52a9\u5c5e\u6027[%s]", (String)"BaseSettingOpHelper_16", (String)"macc-cad-opplugin", (Object[])new Object[0]), auxptyInfo));
            }
            if ((configuredcode = row.getDynamicObject("configuredcode")) != null) {
                sg.append(String.format(ResManager.loadKDString((String)"+\u914d\u7f6e\u53f7[%s]", (String)"BaseSettingOpHelper_17", (String)"macc-cad-opplugin", (Object[])new Object[0]), configuredcode.getString("number")));
            }
            if ((tracknumber = row.getDynamicObject("tracknumber")) != null) {
                sg.append(String.format(ResManager.loadKDString((String)"+\u8ddf\u8e2a\u53f7[%s]", (String)"BaseSettingOpHelper_18", (String)"macc-cad-opplugin", (Object[])new Object[0]), tracknumber.getString("number")));
            }
            if ((project = row.getDynamicObject("project")) != null) {
                sg.append(String.format(ResManager.loadKDString((String)"+\u9879\u76ee\u53f7[%s]", (String)"BaseSettingOpHelper_19", (String)"macc-cad-opplugin", (Object[])new Object[0]), project.getString("number")));
            }
            if (!CadEmptyUtils.isEmpty((String)(lot = row.getString("lot")))) {
                sg.append(String.format(ResManager.loadKDString((String)"+\u6279\u53f7[%s]", (String)"BaseSettingOpHelper_20", (String)"macc-cad-opplugin", (Object[])new Object[0]), lot));
            }
            if (count < size) {
                sg.append("\u3001");
            }
            ++count;
        }
        if (CadEmptyUtils.isEmpty((String)sg.toString())) {
            return null;
        }
        String str = repeatErrStrBody + sg;
        return String.format(ResManager.loadKDString((String)"%s\u5df2\u5b58\u5728\u76f8\u540c\u7684\u7ef4\u5ea6\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"BaseSettingOpHelper_21", (String)"macc-cad-opplugin", (Object[])new Object[0]), str);
    }

    public static String checkHashMaterial(DynamicObject item, List<QFilter> filters) {
        DynamicObjectCollection rows = item.getDynamicObjectCollection("materialentry");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)rows)) {
            String tips = ResManager.loadKDString((String)"\u975e\u901a\u7528\u5de5\u827a\u7c7b\u578b\uff0c\u7269\u6599\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BaseSettingOpHelper_4", (String)"macc-cad-opplugin", (Object[])new Object[0]);
            return tips;
        }
        String repeatErrStrBody = ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u7c7b\u578b\u4e0b\uff0c\u7269\u6599", (String)"BaseSettingOpHelper_15", (String)"macc-cad-opplugin", (Object[])new Object[0]);
        for (DynamicObject row : rows) {
            String lot;
            DynamicObject project;
            DynamicObject tracknumber;
            DynamicObject configuredcode;
            DynamicObject mat = row.getDynamicObject("material");
            if (mat == null) continue;
            if (!mat.getBoolean("enableproduct")) {
                String tips = ResManager.loadKDString((String)"\u7269\u6599\u5fc5\u987b\u5305\u542b\u53ef\u751f\u4ea7\u5c5e\u6027\u3002", (String)"BaseSettingOpHelper_6", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                return tips;
            }
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
            filterList.addAll(filters);
            filterList.add(new QFilter("materialentry.material", "=", mat.getPkValue()));
            filterList.add(new QFilter("materialentry.auxpty", "=", (Object)row.getLong("auxpty.id")));
            filterList.add(new QFilter("materialentry.configuredcode", "=", (Object)row.getLong("configuredcode.id")));
            filterList.add(new QFilter("materialentry.tracknumber", "=", (Object)row.getLong("tracknumber.id")));
            filterList.add(new QFilter("materialentry.project", "=", (Object)row.getLong("project.id")));
            filterList.add(new QFilter("materialentry.lot", "=", (Object)row.getString("lot")));
            if (!QueryServiceHelper.exists((String)"cad_routersetting", (QFilter[])filterList.toArray(new QFilter[0]))) continue;
            HashSet<Long> allAuxptyId = new HashSet<Long>();
            Boolean isUseAuxpty = mat.getBoolean("isuseauxpty");
            if (isUseAuxpty.booleanValue()) {
                DynamicObjectCollection isaffectprice = mat.getDynamicObjectCollection("auxptyentry");
                for (DynamicObject isPrice : isaffectprice) {
                    allAuxptyId.add(isPrice.getLong("auxpty.id"));
                }
            }
            StringBuilder sg = new StringBuilder();
            DynamicObject auxpty = row.getDynamicObject("auxpty");
            if (auxpty != null) {
                filters.add(new QFilter("auxpty", "=", auxpty.getPkValue()));
                String auxptyInfo = CommonOp.getAuptyInfo(allAuxptyId, (String)auxpty.get(1));
                sg.append(String.format(ResManager.loadKDString((String)"+\u8f85\u52a9\u5c5e\u6027[%s]", (String)"BaseSettingOpHelper_16", (String)"macc-cad-opplugin", (Object[])new Object[0]), auxptyInfo));
            }
            if ((configuredcode = row.getDynamicObject("configuredcode")) != null) {
                filters.add(new QFilter("configuredcode", "=", configuredcode.getPkValue()));
                sg.append(String.format(ResManager.loadKDString((String)"+\u914d\u7f6e\u53f7[%s]", (String)"BaseSettingOpHelper_17", (String)"macc-cad-opplugin", (Object[])new Object[0]), configuredcode.getString("number")));
            }
            if ((tracknumber = row.getDynamicObject("tracknumber")) != null) {
                filters.add(new QFilter("tracknumber", "=", tracknumber.getPkValue()));
                sg.append(String.format(ResManager.loadKDString((String)"+\u8ddf\u8e2a\u53f7[%s]", (String)"BaseSettingOpHelper_18", (String)"macc-cad-opplugin", (Object[])new Object[0]), tracknumber.getString("number")));
            }
            if ((project = row.getDynamicObject("project")) != null) {
                filters.add(new QFilter("project", "=", project.getPkValue()));
                sg.append(String.format(ResManager.loadKDString((String)"+\u9879\u76ee\u53f7[%s]", (String)"BaseSettingOpHelper_19", (String)"macc-cad-opplugin", (Object[])new Object[0]), project.getString("number")));
            }
            if (!CadEmptyUtils.isEmpty((String)(lot = row.getString("lot")))) {
                filters.add(new QFilter("lot", "=", (Object)lot));
                sg.append(String.format(ResManager.loadKDString((String)"+\u6279\u53f7[%s]", (String)"BaseSettingOpHelper_20", (String)"macc-cad-opplugin", (Object[])new Object[0]), lot));
            }
            String str = repeatErrStrBody + "[" + mat.getString("number") + "/" + CadUtils.getLocalName((DynamicObject)mat) + "]" + sg;
            return String.format(ResManager.loadKDString((String)"%s\u5df2\u7ecf\u8bbe\u7f6e\u4e86\u6210\u672c\u5de5\u827a\u8def\u7ebf\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"BaseSettingOpHelper_22", (String)"macc-cad-opplugin", (Object[])new Object[0]), str);
        }
        return null;
    }

    public static String checkNonMaterial(DynamicObject item, List<QFilter> filters) {
        filters.add(new QFilter("routertype", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        if (QueryServiceHelper.exists((String)"cad_routersetting", (QFilter[])filters.toArray(new QFilter[0]))) {
            String repeatErrStrHead = item.getDynamicObject("costtype").getLocaleString("name").getLocaleValue();
            return String.format(ResManager.loadKDString((String)"%s\u5df2\u7ecf\u6709\u76f8\u540c\u7684\u7ec4\u5408\u3002", (String)"BaseSettingOpHelper_10", (String)"macc-cad-opplugin", (Object[])new Object[0]), repeatErrStrHead);
        }
        return null;
    }
}

