/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class BomRuleSettingOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("costtype");
        fieldKeys.add("srcbom");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                HashMap<Long, Set> curCostTypeSrcBomMap = new HashMap<Long, Set>(16);
                HashSet<Long> ids = new HashSet<Long>(10);
                HashSet<Long> costTypeIds = new HashSet<Long>(10);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject ruleObj = dataEntity.getDataEntity();
                    Long costType = ruleObj.getLong("costtype.id");
                    costTypeIds.add(costType);
                    ids.add(ruleObj.getLong("id"));
                    curCostTypeSrcBomMap.computeIfAbsent(costType, p -> new HashSet()).add(ruleObj.getString("srcbom"));
                }
                HashMap<Long, Set> existCostTypeSrcBomMap = new HashMap<Long, Set>(16);
                QFilter filter = new QFilter("costtype", "in", costTypeIds);
                filter.and(new QFilter("id", "not in", ids));
                filter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
                DynamicObjectCollection rules = QueryServiceHelper.query((String)"cad_bomrulesetting", (String)"costtype,srcbom", (QFilter[])new QFilter[]{filter});
                for (DynamicObject rule : rules) {
                    existCostTypeSrcBomMap.computeIfAbsent(rule.getLong("costtype"), p -> new HashSet()).add(rule.getString("srcbom"));
                }
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject ruleObj = dataEntity.getDataEntity();
                    Long costType = ruleObj.getLong("costtype.id");
                    String srcRoute = ruleObj.getString("srcbom");
                    String existSrcBom = "";
                    if (existCostTypeSrcBomMap.containsKey(costType)) {
                        Set srcBoms = (Set)existCostTypeSrcBomMap.get(costType);
                        if (srcBoms.size() > 1) {
                            if (CadEmptyUtils.isEmpty((Long)costType)) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u4e3a\u7a7a\u7684\u89c4\u5219\u5df2\u8bbe\u7f6e\u4e86\u591a\u79cdBOM\u6765\u6e90\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u540e\u518d\u8bbe\u7f6e\u3002", (String)"BomRuleSettingOp_1", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                            } else {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u3010%1$s\u3011\u5df2\u8bbe\u7f6e\u4e86\u591a\u79cdBOM\u6765\u6e90\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u540e\u518d\u8bbe\u7f6e\u3002", (String)"BomRuleSettingOp_2", (String)"macc-cad-opplugin", (Object[])new Object[0]), ruleObj.getString("costtype.name")));
                            }
                        } else {
                            existSrcBom = srcBoms.toArray(new String[0])[0];
                        }
                    }
                    Set curSrcBoms = (Set)curCostTypeSrcBomMap.get(costType);
                    if (CadEmptyUtils.isEmpty((String)existSrcBom) && curSrcBoms.size() > 1) {
                        if (CadEmptyUtils.isEmpty((Long)costType)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u4e3a\u7a7a\u7684\u89c4\u5219\u5df2\u8bbe\u7f6e\u4e86\u591a\u79cdBOM\u6765\u6e90\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u540e\u518d\u8bbe\u7f6e\u3002", (String)"BomRuleSettingOp_1", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u3010%1$s\u3011\u5df2\u8bbe\u7f6e\u4e86\u591a\u79cdBOM\u6765\u6e90\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u540e\u518d\u8bbe\u7f6e\u3002", (String)"BomRuleSettingOp_2", (String)"macc-cad-opplugin", (Object[])new Object[0]), ruleObj.getString("costtype.name")));
                        continue;
                    }
                    if (CadEmptyUtils.isEmpty((String)existSrcBom) || existSrcBom.equals(srcRoute)) continue;
                    if ("cad_costbom".equals(existSrcBom)) {
                        if (CadEmptyUtils.isEmpty((Long)costType)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u4e3a\u7a7a\u7684\u89c4\u5219\u5df2\u8bbe\u7f6e\u4e86BOM\u6765\u6e90\u4e3a\u6210\u672cBOM\uff0c\u4e0d\u80fd\u518d\u8bbe\u7f6e\u4e3a\u5236\u9020BOM\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"BomRuleSettingOp_3", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u3010%1$s\u3011\u5df2\u8bbe\u7f6e\u4e86BOM\u6765\u6e90\u4e3a\u6210\u672cBOM\uff0c\u4e0d\u80fd\u518d\u8bbe\u7f6e\u4e3a\u5236\u9020BOM\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"BomRuleSettingOp_4", (String)"macc-cad-opplugin", (Object[])new Object[0]), ruleObj.getString("costtype.name")));
                        continue;
                    }
                    if (CadEmptyUtils.isEmpty((Long)costType)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u4e3a\u7a7a\u7684\u89c4\u5219\u5df2\u8bbe\u7f6e\u4e86BOM\u6765\u6e90\u4e3a\u5236\u9020BOM\uff0c\u4e0d\u80fd\u518d\u8bbe\u7f6e\u4e3a\u6210\u672cBOM\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"BomRuleSettingOp_5", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u3010%1$s\u3011\u5df2\u8bbe\u7f6e\u4e86BOM\u6765\u6e90\u4e3a\u5236\u9020BOM\uff0c\u4e0d\u80fd\u518d\u8bbe\u7f6e\u4e3a\u6210\u672cBOM\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"BomRuleSettingOp_6", (String)"macc-cad-opplugin", (Object[])new Object[0]), ruleObj.getString("costtype.name")));
                }
            }
        });
    }
}

