/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.opplugin.BaseSettingOpHelper;

public class BomSettingEnableOpValidate
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.dataEntities;
        HashMap<String, ExtendedDataEntity> dataMap = new HashMap<String, ExtendedDataEntity>();
        for (int i = 0; i < datas.length; ++i) {
            ExtendedDataEntity dataEntity = datas[i];
            this.checkUnique(dataEntity, dataMap);
        }
    }

    private void checkUnique(ExtendedDataEntity dataEntity, Map<String, ExtendedDataEntity> dataMap) {
        StringBuilder sbKey = new StringBuilder();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject item = BusinessDataServiceHelper.loadSingle((Object)dataEntity.getBillPkId(), (String)"cad_bomsetting");
        DynamicObject ct = item.getDynamicObject("costtype");
        DynamicObject mat = item.getDynamicObject("material");
        DynamicObject version = item.getDynamicObject("bomversion");
        DynamicObject aupty = item.getDynamicObject("auxprop");
        filters.add(new QFilter("id", "!=", item.getPkValue()));
        filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("costtype", "=", ct.getPkValue()));
        filters.add(new QFilter("material", "=", mat.getPkValue()));
        sbKey.append(ct.getPkValue()).append(mat.getPkValue());
        if (version != null) {
            filters.add(new QFilter("bomversion", "=", version.getPkValue()));
            sbKey.append(version.getPkValue());
        }
        if (aupty != null) {
            filters.add(new QFilter("auxprop", "=", aupty.getPkValue()));
            sbKey.append(aupty.getPkValue());
        }
        String repeatErrStrBody = item.getString("number") + ": " + BaseSettingOpHelper.checkBomSettingRepeated(item, version, filters);
        ExtendedDataEntity enabeDataEntity = dataMap.get(sbKey.toString());
        if (enabeDataEntity != null || QueryServiceHelper.exists((String)"cad_bomsetting", (QFilter[])filters.toArray(new QFilter[0]))) {
            repeatErrStrBody = String.format(ResManager.loadKDString((String)"%s\u5df2\u7ecf\u6709\u53ef\u7528\u7684\u6210\u672cBOM\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u542f\u7528\u3002", (String)"BomSettingEnableOpValidate_1", (String)"macc-cad-opplugin", (Object[])new Object[0]), repeatErrStrBody);
            this.addErrorMessage(dataEntity, repeatErrStrBody);
        } else {
            dataMap.putIfAbsent(sbKey.toString(), dataEntity);
        }
    }
}

