/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CadBomSettingDeleteOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("costtype");
        fieldKeys.add("keycol");
        fieldKeys.add("number");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] cadBomSettings = this.getDataEntities();
                Long costTypeId = 0L;
                HashMap<String, String> matNumberMap = new HashMap<String, String>(16);
                for (ExtendedDataEntity cadBomSetting : cadBomSettings) {
                    DynamicObject dataEntity = cadBomSetting.getDataEntity();
                    DynamicObject costType = dataEntity.getDynamicObject("costtype");
                    if (CadEmptyUtils.isEmpty((Long)costTypeId) && costType != null) {
                        costTypeId = costType.getLong("id");
                    }
                    matNumberMap.put(dataEntity.getString("keycol"), dataEntity.getString("number"));
                }
                Set hasResKeyCols = CadBomSettingDeleteOpPlugin.this.getHasResKeyCols(costTypeId, matNumberMap.keySet());
                for (ExtendedDataEntity cadBomSetting : cadBomSettings) {
                    DynamicObject dataEntity = cadBomSetting.getDataEntity();
                    String keycol = dataEntity.getString("keycol");
                    if (!hasResKeyCols.contains(keycol)) continue;
                    String tip = ResManager.loadKDString((String)"\u6210\u672cBOM\u8bbe\u7f6e\u3010\u7f16\u53f7\uff1a%s\u3011\u5bf9\u5e94\u7684\u7269\u6599\u5b58\u5728\u5377\u7b97\u7ed3\u679c\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"CadBomSettingDeleteOpPlugin_1", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(cadBomSetting, String.format(tip, matNumberMap.get(keycol)));
                }
            }
        });
    }

    private Set<String> getHasResKeyCols(Long costtypeId, Set<String> keyCols) {
        HashSet<String> hasResKeyCols = new HashSet<String>(16);
        QFilter filter = new QFilter("costtype", "=", (Object)costtypeId);
        filter.and(new QFilter("keycol", "in", keyCols));
        DynamicObjectCollection results = QueryServiceHelper.query((String)"cad_calcsimulationresult", (String)"keycol", (QFilter[])new QFilter[]{filter});
        for (DynamicObject result : results) {
            String keycol = result.getString("keycol");
            hasResKeyCols.add(keycol);
        }
        return hasResKeyCols;
    }
}

