/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.helper.CalcDimenHelper;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.opplugin.CadBomSettingSaveOpValidator;

public class CadBomSettingSaveOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bomversion");
        fieldKeys.add("auxprop");
        fieldKeys.add("chargedefsubelement");
        fieldKeys.add("costtype");
        fieldKeys.add("matcalcprop");
        fieldKeys.add("bom");
        fieldKeys.add("configuredcode");
        fieldKeys.add("tracknumber");
        fieldKeys.add("project");
        fieldKeys.add("lot");
        fieldKeys.add("keycol");
        fieldKeys.add("keycolid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CadBomSettingSaveOpValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if ("save".equals(e.getOperationKey())) {
            for (DynamicObject bomSetting : dataEntities) {
                bomSetting.set("istoupdate", (Object)Boolean.TRUE);
                if (!CostTypeHelper.isUseMatVersion((Long)bomSetting.getLong("costtype.id"))) {
                    bomSetting.set("bomversion", null);
                }
                this.setMatCalcProp(bomSetting);
                if (!CadEmptyUtils.isEmpty((String)bomSetting.getString("keycol"))) continue;
                HashMap<String, Object> keycolMap = new HashMap<String, Object>(16);
                keycolMap.put("material", bomSetting.get("material.masterid"));
                keycolMap.put("auxproperty", CalcDimenHelper.getAffectAuxpty((Object)bomSetting.get("material"), (Object)bomSetting.get("auxprop")));
                keycolMap.put("configuredcode", bomSetting.getLong("configuredcode.id"));
                keycolMap.put("tracknumber", bomSetting.getLong("tracknumber.id"));
                keycolMap.put("project", bomSetting.getLong("project.id"));
                keycolMap.put("lot", bomSetting.getString("lot"));
                Keycol calcKey = CalcKeyHelper.getCalcKey(keycolMap, new ArrayList(), (boolean)true);
                bomSetting.set("keycol", (Object)calcKey.getKeycol());
                bomSetting.set("keycolid", (Object)calcKey.getId());
                bomSetting.set("keycolid_id", (Object)calcKey.getId());
            }
            SaveServiceHelper.update((DynamicObject[])dataEntities);
        }
    }

    private void setMatCalcProp(DynamicObject bomSetting) {
        String matCalcProp;
        switch (matCalcProp = bomSetting.getString("matcalcprop")) {
            case "A": 
            case "C": {
                bomSetting.set("isdowncalc", (Object)true);
                break;
            }
            case "B": {
                bomSetting.set("isdowncalc", (Object)false);
                break;
            }
        }
    }
}

