/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.opplugin.BaseSettingOpHelper;
import kd.macc.cad.opplugin.BaseSettingSaveOpValidate;

public class CadBomSettingSaveOpValidator
extends BaseSettingSaveOpValidate {
    @Override
    protected void validateSave(ExtendedDataEntity dataEntity) {
        QFilter filter;
        QFilter filterId;
        String tips;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        boolean isFronCheck = this.validateCommon(dataEntity, filters);
        DynamicObject item = dataEntity.getDataEntity();
        if (item == null) {
            return;
        }
        if ("C".equals(item.getString("status"))) {
            return;
        }
        DynamicObject mat = item.getDynamicObject("material");
        if (!mat.getBoolean("enableproduct")) {
            String tips2 = ResManager.loadKDString((String)"\u4ea7\u54c1\u5fc5\u987b\u5305\u542b\u53ef\u751f\u4ea7\u5c5e\u6027\u3002", (String)"CadBomSettingSaveOpValidator_0", (String)"macc-cad-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, tips2);
        }
        filters.add(new QFilter("material", "=", (Object)((Long)mat.getPkValue())));
        boolean isBomVsersion = BomRouterHelper.isEnableMatversion((DynamicObject)mat);
        DynamicObject version = item.getDynamicObject("bomversion");
        DynamicObject costType = item.getDynamicObject("costtype");
        if (isBomVsersion && CostTypeHelper.isUseMatVersion((Long)(CadEmptyUtils.isEmpty((DynamicObject)costType) ? 0L : costType.getLong("id")))) {
            if (version != null) {
                filters.add(new QFilter("bomversion", "=", (Object)((Long)version.getPkValue())));
            } else {
                String tips3 = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u660e\u7ec6\u4fe1\u606f\u201d\u548c\u201c\u7269\u6599\u7248\u672c\u201d\u3002", (String)"CadBomSettingSaveOpValidator_1", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, tips3);
                isFronCheck = false;
            }
        }
        boolean isAuxprop = BomRouterHelper.isEnableAuxprop((DynamicObject)mat);
        DynamicObject auxprop = item.getDynamicObject("auxprop");
        if (isAuxprop) {
            if (auxprop != null) {
                filters.add(new QFilter("auxprop", "=", auxprop.getPkValue()));
            } else {
                String tips4 = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u660e\u7ec6\u4fe1\u606f\u201d\u548c\u201c\u8f85\u52a9\u5c5e\u6027\u201d", (String)"CadBomSettingSaveOpValidator_2", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, tips4);
                isFronCheck = false;
            }
        }
        DynamicObject bom = item.getDynamicObject("bom");
        DynamicObject bomType = item.getDynamicObject("bomtype");
        if (bomType == null) {
            tips = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201cBOM\u7c7b\u578b\u201d\u3002", (String)"CadBomSettingSaveOpValidator_3", (String)"macc-cad-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, tips);
            isFronCheck = false;
        }
        if (bomType != null && bomType.getLong("id") != bom.getDynamicObject("type").getLong("id")) {
            tips = ResManager.loadKDString((String)"BOM\u7c7b\u578b\u4e0eBOM\u4e0d\u5339\u914d\u3002", (String)"CadBomSettingSaveOpValidator_4", (String)"macc-cad-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, tips);
            isFronCheck = false;
        }
        long verId = Optional.ofNullable(version).map(s -> s.getLong("id")).orElse(0L);
        DynamicObject bomVsr = bom.getDynamicObject("version");
        if (isBomVsersion && (bomVsr == null || verId != bomVsr.getLong("id")) && CostTypeHelper.isUseMatVersion((Long)(CadEmptyUtils.isEmpty((DynamicObject)costType) ? 0L : costType.getLong("id")))) {
            String tips5 = ResManager.loadKDString((String)"\u7269\u6599\u7248\u672c\u4e0eBOM\u7684\u7248\u672c\u4e0d\u5339\u914d\u3002", (String)"CadBomSettingSaveOpValidator_5", (String)"macc-cad-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, tips5);
            isFronCheck = false;
        }
        long auxPropId = Optional.ofNullable(auxprop).map(s -> s.getLong("id")).orElse(0L);
        DynamicObject bomAux = bom.getDynamicObject("auxproperty");
        if (isAuxprop && (bomAux == null || auxPropId != bomAux.getLong("id"))) {
            String tips6 = ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u4e0eBOM\u7684\u8f85\u52a9\u5c5e\u6027\u4e0d\u5339\u914d\u3002", (String)"CadBomSettingSaveOpValidator_6", (String)"macc-cad-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, tips6);
            isFronCheck = false;
        }
        if (!QueryServiceHelper.exists((String)"cad_costbom", (QFilter[])new QFilter[]{filterId = new QFilter("id", "=", bom.getPkValue()), filter = new QFilter("material.masterid", "=", (Object)mat.getLong("masterid"))})) {
            String tips7 = ResManager.loadKDString((String)"\u4ea7\u54c1\u7f16\u7801\u4e0eBOM\u4e0d\u5339\u914d\u3002", (String)"CadBomSettingSaveOpValidator_7", (String)"macc-cad-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, tips7);
            isFronCheck = false;
        }
        DynamicObject subEle = (DynamicObject)item.get("chargedefsubelement");
        BigDecimal stdRate = (BigDecimal)item.get("chargestdrate");
        if (subEle != null && stdRate.compareTo(new BigDecimal("0")) == 0) {
            String errMsg = ResManager.loadKDString((String)"\u9009\u62e9\u7269\u6599\u201c\u8d39\u7528\u9ed8\u8ba4\u5b50\u8981\u7d20\u201d\u540e\u987b\u586b\u5199\u201c\u7269\u6599\u8d39\u7528\u6807\u51c6\u8d39\u7387\u201d\u3002", (String)"CadBomSettingSaveOpValidator_8", (String)"macc-cad-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, errMsg);
            isFronCheck = false;
        }
        if (!isFronCheck) {
            return;
        }
        String repeatErrStrBody = BaseSettingOpHelper.checkBomSettingRepeated(item, version, filters);
        if (QueryServiceHelper.exists((String)"cad_bomsetting", (QFilter[])filters.toArray(new QFilter[0]))) {
            repeatErrStrBody = String.format(ResManager.loadKDString((String)"%s\u5df2\u7ecf\u8bbe\u7f6e\u4e86\u6210\u672cBOM\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"CadBomSettingSaveOpValidator_10", (String)"macc-cad-opplugin", (Object[])new Object[0]), repeatErrStrBody);
            this.addErrorMessage(dataEntity, repeatErrStrBody);
        }
    }
}

