/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.opplugin.CadRouterSettingSaveOpValidator;

public class CadRouterSettingSaveOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("materialentry");
        fieldKeys.add("material");
        fieldKeys.add("auxpty");
        fieldKeys.add("routertype");
        fieldKeys.add("costtype");
        fieldKeys.add("configuredcode");
        fieldKeys.add("tracknumber");
        fieldKeys.add("project");
        fieldKeys.add("lot");
        fieldKeys.add("keycol");
        fieldKeys.add("keycolid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CadRouterSettingSaveOpValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.endOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection materialEntrys = dataEntity.getDynamicObjectCollection("materialentry");
            for (DynamicObject materialEntry : materialEntrys) {
                String keycol = materialEntry.getString("keycol");
                if (!CadEmptyUtils.isEmpty((String)keycol)) continue;
                HashMap<String, Object> coEntryKeycolMap = new HashMap<String, Object>(16);
                coEntryKeycolMap.put("material", materialEntry.get("material.masterid"));
                DynamicObject auxpty = (DynamicObject)materialEntry.get("auxpty");
                coEntryKeycolMap.put("auxproperty", auxpty == null ? Long.valueOf(0L) : auxpty.getPkValue());
                coEntryKeycolMap.put("configuredcode", materialEntry.get("configuredcode.id"));
                coEntryKeycolMap.put("tracknumber", materialEntry.get("tracknumber.id"));
                coEntryKeycolMap.put("project", materialEntry.get("project.id"));
                coEntryKeycolMap.put("lot", materialEntry.get("lot"));
                Keycol calcKey = CalcKeyHelper.getCalcKey(coEntryKeycolMap, new ArrayList(), (boolean)true);
                materialEntry.set("keycol", (Object)calcKey.getKeycol());
                materialEntry.set("keycolid", (Object)calcKey.getId());
                materialEntry.set("keycolid_id", (Object)calcKey.getId());
            }
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
    }
}

