/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.opplugin.BaseSettingOpHelper;
import kd.macc.cad.opplugin.BaseSettingSaveOpValidate;

public class CadRouterSettingSaveOpValidator
extends BaseSettingSaveOpValidate {
    private final List<String> routerTypeList = Arrays.asList("A", "B", "C");

    @Override
    protected void validateSave(ExtendedDataEntity dataEntity) {
        String routerType;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject item = dataEntity.getDataEntity();
        if (item == null) {
            return;
        }
        if (!this.checkBaseInfo(dataEntity, item)) {
            return;
        }
        this.validateCommon(dataEntity, filters);
        String errTips = null;
        errTips = BaseSettingOpHelper.checkSameMaterial(item);
        if (StringUtils.isNotEmpty((String)errTips)) {
            this.addErrorMessage(dataEntity, errTips);
        }
        if (StringUtils.isNotEmpty((String)(errTips = "C".equals(routerType = item.getString("routertype")) ? BaseSettingOpHelper.checkNonMaterial(item, filters) : BaseSettingOpHelper.checkHashMaterial(item, filters)))) {
            this.addErrorMessage(dataEntity, errTips);
        }
        DynamicObjectCollection entrys = item.getDynamicObjectCollection("materialentry");
        for (DynamicObject entry : entrys) {
            DynamicObject mat = entry.getDynamicObject("material");
            if (mat == null) {
                String tips = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599\u4fe1\u606f.\u7269\u6599\u7f16\u7801\u201d\u5b57\u6bb5", (String)"CadRouterSettingSaveOpValidator_8", (String)"macc-cad-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, tips);
                return;
            }
            boolean isAuxprop = BomRouterHelper.isEnableAuxprop((DynamicObject)mat);
            DynamicObject auxprop = entry.getDynamicObject("auxpty");
            if (!isAuxprop || auxprop != null) continue;
            String tips = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7269\u6599\u4fe1\u606f.\u8f85\u52a9\u5c5e\u6027\u201d\u5b57\u6bb5", (String)"CadRouterSettingSaveOpValidator_7", (String)"macc-cad-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, tips);
        }
    }

    private boolean checkBaseInfo(ExtendedDataEntity dataEntity, DynamicObject item) {
        String routerType;
        DynamicObject costType = item.getDynamicObject("costtype");
        boolean result = true;
        if (costType == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"CadRouterSettingSaveOpValidator_0", (String)"macc-cad-opplugin", (Object[])new Object[0]));
            result = false;
        }
        if (item.getDynamicObject("router") == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u4e0d\u5b58\u5728\u3002", (String)"CadRouterSettingSaveOpValidator_1", (String)"macc-cad-opplugin", (Object[])new Object[0]));
            result = false;
        }
        if (StringUtils.isEmpty((String)(routerType = item.getString("routertype")))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"CadRouterSettingSaveOpValidator_2", (String)"macc-cad-opplugin", (Object[])new Object[0]));
            result = false;
        }
        if (!this.routerTypeList.contains(routerType)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5de5\u827a\u7c7b\u578b\u6240\u586b\u503c\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u4e3a(A,B,C)\u3002", (String)"CadRouterSettingSaveOpValidator_3", (String)"macc-cad-opplugin", (Object[])new Object[0]));
            result = false;
        }
        return result;
    }
}

