/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;

public class CheckItemSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CheckItemSaveOp.class);
    private static final String CHECKMODE = "checkmode";
    private static final String BIZOBJECT = "bizobject";
    private static final String CUSTOMFILTERTEXT = "customfiltertext";
    private static final String CUSTOMFILTER = "customfilter_tag";
    private static final String PLUGIN = "plugin";
    private static final String NUMBER = "number";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add(CHECKMODE);
        e.getFieldKeys().add(BIZOBJECT);
        e.getFieldKeys().add(CUSTOMFILTERTEXT);
        e.getFieldKeys().add(CUSTOMFILTER);
        e.getFieldKeys().add(PLUGIN);
        e.getFieldKeys().add(NUMBER);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] checkItems;
                block11: for (ExtendedDataEntity checkItem : checkItems = this.getDataEntities()) {
                    String checkMode;
                    DynamicObject item = checkItem.getDataEntity();
                    switch (checkMode = item.getString(CheckItemSaveOp.CHECKMODE)) {
                        case "A": {
                            String plugin = item.getString(CheckItemSaveOp.PLUGIN);
                            if (plugin == null || "".equals(plugin)) {
                                this.addFatalErrorMessage(checkItem, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u63d2\u4ef6\u201d\u3002", (String)"CheckItemSaveOp_1", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                                continue block11;
                            }
                            try {
                                Class<?> clazz = Class.forName(plugin);
                                AbstractSingleCalcCheckAction abstractSingleCalcCheckAction = (AbstractSingleCalcCheckAction)clazz.newInstance();
                            }
                            catch (ClassNotFoundException exp) {
                                logger.error("\u914d\u7f6e\u7684\u63d2\u4ef6\u4e0d\u5b58\u5728", (Throwable)exp);
                                this.addErrorMessage(checkItem, ResManager.loadKDString((String)"\u60a8\u914d\u7f6e\u7684\u63d2\u4ef6\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u8f93\u5165\u3002", (String)"CheckItemSaveOp_2", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                            }
                            catch (Throwable exp) {
                                this.addErrorMessage(checkItem, exp.getMessage());
                            }
                            continue block11;
                        }
                        case "B": {
                            String filterText;
                            DynamicObject bizObject = item.getDynamicObject(CheckItemSaveOp.BIZOBJECT);
                            if (bizObject == null) {
                                this.addFatalErrorMessage(checkItem, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4e1a\u52a1\u5bf9\u8c61\u201d\u3002", (String)"CheckItemSaveOp_3", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                            }
                            if ((filterText = item.getString(CheckItemSaveOp.CUSTOMFILTER)) != null && !"".equals(filterText)) continue block11;
                            this.addFatalErrorMessage(checkItem, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8fc7\u6ee4\u6761\u4ef6\u201d\u3002", (String)"CheckItemSaveOp_4", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                        }
                    }
                }
            }
        });
    }

    private QFilter getCustomQfilter(DynamicObject item, MainEntityType entityType) {
        String filterStr = item.getString(CUSTOMFILTER);
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
        FilterCondition filterCondition = condition.getFilterCondition();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityType.getName());
        FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
        filterBuilder.buildFilter();
        QFilter baseQ = filterBuilder.getQFilter();
        String experss = condition.getExpression();
        if (!"".equals(experss)) {
            String[] subExpressArray = experss.split(" ");
            StringBuilder newExperss = new StringBuilder();
            for (String subExpress : subExpressArray) {
                String nameHead = subExpress.split("\\.")[0];
                IDataEntityProperty fieldProperty = mainEntityType.findProperty(nameHead);
                if (fieldProperty != null && fieldProperty.getParent() instanceof EntryType) {
                    EntryType entry = (EntryType)fieldProperty.getParent();
                    String entryName = entry.getName();
                    subExpress = entryName + "." + subExpress;
                }
                newExperss.append(subExpress);
                newExperss.append(' ');
            }
            QFilter expressFilter = QFilter.of((String)newExperss.toString().trim(), (Object[])new Object[0]);
            if (baseQ != null) {
                baseQ.and(expressFilter);
            } else {
                baseQ = expressFilter;
            }
        }
        return baseQ;
    }
}

