/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.helper.CalcDimenHelper;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.CostTypeHelper;

public class CommonOp {
    public static Map<Long, Long> getElementRelation(Long[] subElementId) {
        HashMap<Long, Long> mapElement = new HashMap<Long, Long>();
        QFilter qfSubElementId = new QFilter("subelement", "in", (Object)subElementId);
        DynamicObjectCollection ele = QueryServiceHelper.query((String)"cad_elementdetail", (String)"element,subelement", (QFilter[])new QFilter[]{qfSubElementId});
        for (DynamicObject el : ele) {
            long subElement = el.getLong("subelement");
            if (mapElement.containsKey(subElement)) continue;
            mapElement.put(subElement, el.getLong("element"));
        }
        return mapElement;
    }

    public static void updateData(EndOperationTransactionArgs e, String entityName, Boolean isHaveCurrency, Boolean isEntity) {
        DynamicObject[] updateData;
        DynamicObject[] datas = e.getDataEntities();
        HashSet<Object> ids = new HashSet<Object>();
        HashSet<Long> subElementId = new HashSet<Long>();
        for (DynamicObject data : datas) {
            if (isHaveCurrency.booleanValue() && data.get("currency") == null) {
                ids.add(data.getPkValue());
            }
            if (data.get("element") == null) {
                ids.add(data.getPkValue());
                subElementId.add(data.getLong("subelement.id"));
            }
            if (isEntity.booleanValue()) {
                DynamicObjectCollection entity = data.getDynamicObjectCollection("entryentity");
                for (DynamicObject en : entity) {
                    if (en.get("extsubelement") == null) continue;
                    ids.add(data.getPkValue());
                    subElementId.add(en.getLong("extsubelement.id"));
                }
            }
            if ("cad_resourcerate".equals(data.getDataEntityType().getName()) || "cad_resourceout".equals(data.getDataEntityType().getName())) continue;
            data.set("auxpty", (Object)CalcDimenHelper.getAffectAuxpty((Object)data.get("material"), (Object)data.get("auxpty")));
            HashMap<String, Object> keycolMap = new HashMap<String, Object>(16);
            keycolMap.put("material", data.get("material.masterid"));
            keycolMap.put("auxproperty", data.get("auxpty"));
            keycolMap.put("configuredcode", data.get("configuredcode.id"));
            keycolMap.put("tracknumber", data.get("tracknumber.id"));
            keycolMap.put("project", data.get("project.id"));
            keycolMap.put("lot", data.get("lot"));
            Keycol calcKey = CalcKeyHelper.getCalcKey(keycolMap, new ArrayList(), (boolean)true);
            data.set("keycol", (Object)calcKey.getKeycol());
            data.set("keycolid", (Object)calcKey.getId());
            data.set("keycolid_id", (Object)calcKey.getId());
        }
        SaveServiceHelper.update((DynamicObject[])datas);
        if (ids.size() == 0) {
            return;
        }
        Map<Long, Long> mapElement = CommonOp.getElementRelation(subElementId.toArray(new Long[0]));
        for (DynamicObject data : updateData = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName))) {
            if (isHaveCurrency.booleanValue() && data.get("currency") == null) {
                DynamicObject costType = (DynamicObject)data.get("costtype");
                data.set("currency", (Object)costType.getLong("currency.id"));
            }
            if ("cad_outsourceprice".equals(entityName) && "save".equals(e.getOperationKey()) && !CostTypeHelper.isUseMatVersion((Long)data.getLong("costtype.id"))) {
                data.set("matversion", (Object)0L);
            }
            if (data.get("element") == null) {
                DynamicObject subElement = (DynamicObject)data.get("subelement");
                data.set("element", (Object)mapElement.get(subElement.getLong("id")));
            }
            if (!isEntity.booleanValue()) continue;
            DynamicObjectCollection entity = data.getDynamicObjectCollection("entryentity");
            for (DynamicObject en : entity) {
                if (en.get("extsubelement") == null) continue;
                en.set("extelement", (Object)mapElement.get(en.get("extsubelement.id")));
            }
        }
        SaveServiceHelper.update((DynamicObject[])updateData);
    }

    public static String getAuptyInfo(Set<Long> auxptyId, String Flex) {
        DynamicObject[] auxpty;
        String[] flexs;
        HashMap<String, String> mapFlex = new HashMap<String, String>(16);
        if (!Flex.startsWith("{")) {
            return null;
        }
        Flex = Flex.substring(1, Flex.length() - 1);
        for (String flex : flexs = Flex.split(",")) {
            String[] f = flex.split(":");
            mapFlex.put(f[0].replace("\"", ""), f[1]);
        }
        StringBuilder auptyInfo = new StringBuilder();
        block5: for (DynamicObject aux : auxpty = BusinessDataServiceHelper.load((Object[])auxptyId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_auxproperty"))) {
            String flexField = aux.getString("flexfield");
            if (!Flex.contains(flexField)) continue;
            Object val = mapFlex.get(flexField);
            String typeName = aux.getString("name");
            int valueType = aux.getInt("valuetype");
            switch (valueType) {
                case 1: 
                case 2: {
                    String valueSource = aux.getString("valuesource.number");
                    if (2 == valueType && StringUtils.isEmpty((String)valueSource)) {
                        valueSource = "bos_assistantdata_detail";
                    }
                    DynamicObject dyFlex = BusinessDataServiceHelper.loadSingle(val, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)valueSource));
                    auptyInfo.append(typeName);
                    auptyInfo.append(':');
                    auptyInfo.append(dyFlex.getString("name"));
                    auptyInfo.append("||");
                    continue block5;
                }
                case 3: {
                    auptyInfo.append(typeName);
                    auptyInfo.append(':');
                    auptyInfo.append(val);
                    auptyInfo.append("||");
                }
            }
        }
        String returnInfo = auptyInfo.toString();
        if (returnInfo.endsWith("||")) {
            return returnInfo.substring(0, returnInfo.length() - 2);
        }
        return auptyInfo.toString();
    }
}

