/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class CostBomImportOp
implements IImportPlugin {
    private static final Log logger = LogFactory.getLog(CostBomImportOp.class);

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        try {
            HashSet<String> numberSet = new HashSet<String>(16);
            HashMap materialMap = (HashMap)JSONUtils.cast((String)data.get("material").toString(), HashMap.class);
            String materialNumber = (String)materialMap.get("number");
            numberSet.add(materialNumber);
            List copentry = JSON.parseArray((String)data.get("copentry").toString(), HashMap.class);
            for (HashMap entry : copentry) {
                HashMap copentrymaterial = (HashMap)JSONUtils.cast((String)entry.get("copentrymaterial").toString(), HashMap.class);
                String copMatNumber = (String)copentrymaterial.get("number");
                numberSet.add(copMatNumber);
            }
            if (numberSet.size() != copentry.size() + 1) {
                importlogs.add(new ImportLogger.ImportLog("\u5f15\u5165\u5931\u8d25\u3002\u4e3b\u4ea7\u54c1\u3001\u8054\u4ea7\u54c1\u3001\u526f\u4ea7\u54c1\u7f16\u53f7\u5b58\u5728\u91cd\u590d\u3002"));
                return false;
            }
        }
        catch (IOException e) {
            importlogs.add(new ImportLogger.ImportLog("\u5f15\u5165\u5931\u8d25\u3002\u6570\u636e\u89e3\u6790\u5f02\u5e38\u3002"));
            logger.error(e.getMessage());
            return false;
        }
        return true;
    }

    public void afterImportData(List<Object> pkIds, List<ImportLogger.ImportLog> importlogs) {
        if (!CollectionUtils.isEmpty(pkIds)) {
            DynamicObject[] costBoms;
            for (DynamicObject costBom : costBoms = BusinessDataServiceHelper.load((String)"cad_costbom", (String)"createorg,ctrlstrategy", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)})) {
                String createOrgId = costBom.getDynamicObject("createorg").getString("id");
                if (!StringUtils.isEmpty((String)costBom.getString("ctrlstrategy"))) continue;
                String bdCtrlStrgy = BaseDataServiceHelper.getBdCtrlStrgy((String)"cad_costbom", (String)createOrgId);
                costBom.set("ctrlstrategy", (Object)bdCtrlStrgy);
            }
            SaveServiceHelper.save((DynamicObject[])costBoms);
        }
    }
}

