/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.algox.utils.FormulaUtil;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.opplugin.CostDriverWorkActUniqueValidator;

public class CostDriverSaveOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CostDriverSaveOpPlugin.class);
    private static final String OPERATOR = "+-*/()";
    private static final String COSTCENTER = "COSTCENTER";
    private static final String COSTOBJECT = "COSTOBJECT";
    private static final String MATERIALGROUP = "MATERIALGROUP";
    private static final String MATERIAL = "MATERIAL";
    private static final String DIGITAL = "DIGITAL";
    private boolean isComplexNumber;
    private String cacheKey;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("iscomplexcd");
        fieldKeys.add("isrelatedwork");
        fieldKeys.add("islinkresource");
        fieldKeys.add("allocclass");
        fieldKeys.add("formula");
        fieldKeys.add("number");
        fieldKeys.add("workactivity");
        fieldKeys.add("auditor");
        fieldKeys.add("auditdate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] costDrivers;
                for (ExtendedDataEntity dataEntity : costDrivers = this.getDataEntities()) {
                    boolean exists;
                    DynamicObject costDriver = dataEntity.getDataEntity();
                    boolean isComplex = costDriver.getBoolean("iscomplexcd");
                    if (CostDriverSaveOpPlugin.isStartingWithDigit(costDriver.getString("number"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u6210\u672c\u52a8\u56e0\u7f16\u7801\u4e0d\u5141\u8bb8\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u8bf7\u4fee\u6539\u7f16\u7801\u3002", (String)"CostDriverSaveOpPlugin_17", (String)"macc-cad-opplugin", (Object[])new Object[0]), this.getOperationName()));
                    }
                    if (isComplex && StringUtils.isEmpty((CharSequence)costDriver.getString("formula"))) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u201c\u590d\u5408\u6210\u672c\u52a8\u56e0\u201d\u5f00\u5173\u5df2\u6253\u5f00\uff0c\u8bf7\u586b\u5199\u516c\u5f0f\u6216\u5173\u95ed\u5f00\u5173\u3002", (String)"CostDriverSaveOpPlugin_0", (String)"macc-cad-opplugin", (Object[])new Object[0]), this.getOperationName()));
                    }
                    if (exists = CostDriverSaveOpPlugin.this.validateNumber(costDriver)) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u201c\u7f16\u53f7\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CostDriverSaveOpPlugin_1", (String)"macc-cad-opplugin", (Object[])new Object[0]), this.getOperationName()));
                    }
                    if (isComplex) {
                        int isDiff = 0;
                        try {
                            isDiff = CostDriverSaveOpPlugin.this.validateDiffAlloc(costDriver);
                        }
                        catch (Exception e) {
                            logger.error("validateDiffAlloc error,formula is {}", (Object)costDriver.getString("formula"), (Object)e);
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u516c\u5f0f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CostDriverSaveOpPlugin_2", (String)"macc-cad-opplugin", (Object[])new Object[0]), this.getOperationName()));
                        }
                        switch (isDiff) {
                            case 1: {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u516c\u5f0f\u4e2d\u5b58\u5728\u4e0d\u540c\u5206\u914d\u5c42\u7ea7\u7684\u6210\u672c\u52a8\u56e0\u7684\u52a0\u51cf\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CostDriverSaveOpPlugin_3", (String)"macc-cad-opplugin", (Object[])new Object[0]), this.getOperationName()));
                                break;
                            }
                            case 2: {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u516c\u5f0f\u4e2d\u5b58\u5728\u7269\u6599\u7ea7\u6210\u672c\u52a8\u56e0\u4e0e\u6210\u672c\u4e2d\u5fc3\u7ea7\u6210\u672c\u52a8\u56e0\u7684\u4e58\u9664\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CostDriverSaveOpPlugin_4", (String)"macc-cad-opplugin", (Object[])new Object[0]), this.getOperationName()));
                                break;
                            }
                            case 3: {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u516c\u5f0f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CostDriverSaveOpPlugin_2", (String)"macc-cad-opplugin", (Object[])new Object[0]), this.getOperationName()));
                                break;
                            }
                            case 4: {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u516c\u5f0f\u4e2d\u5b58\u5728\u975e\u5ba1\u6838\u6216\u7981\u7528\u72b6\u6001\u7684\u6210\u672c\u52a8\u56e0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CostDriverSaveOpPlugin_5", (String)"macc-cad-opplugin", (Object[])new Object[0]), this.getOperationName()));
                                break;
                            }
                            case 5: {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u516c\u5f0f\u8fd0\u7b97\u7ed3\u679c\u5c42\u7ea7\u975e\u6210\u672c\u4e2d\u5fc3\u7ea7\u6216\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7ea7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CostDriverSaveOpPlugin_6", (String)"macc-cad-opplugin", (Object[])new Object[0]), this.getOperationName()));
                                break;
                            }
                            case 6: {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u516c\u5f0f\u4e2d\u5b58\u5728\u7269\u6599\u5206\u7c7b\u7ea7\u6210\u672c\u52a8\u56e0\u4e0e\u6210\u672c\u4e2d\u5fc3\u7ea7\u6210\u672c\u52a8\u56e0\u7684\u4e58\u9664\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CostDriverSaveOpPlugin_7", (String)"macc-cad-opplugin", (Object[])new Object[0]), this.getOperationName()));
                                break;
                            }
                        }
                        boolean isNest = CostDriverSaveOpPlugin.this.validateNesting(costDriver);
                        if (isNest) {
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff0c\u516c\u5f0f\u4e0e%2$s\u5b58\u5728\u5d4c\u5957\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CostDriverSaveOpPlugin_16", (String)"macc-cad-opplugin", (Object[])new Object[0]), this.getOperationName(), CostDriverSaveOpPlugin.this.cacheKey));
                        }
                    }
                    String allocClass = costDriver.getString("allocclass");
                    boolean isRelatedWork = costDriver.getBoolean("isrelatedwork");
                    boolean isLinkResource = costDriver.getBoolean("islinkresource");
                    switch (allocClass) {
                        case "MATERIAL": {
                            if (isRelatedWork) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u7269\u6599\u5c42\u7ea7\u7684\u6210\u672c\u52a8\u56e0\u4e0d\u80fd\u5173\u8054\u4f5c\u4e1a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CostDriverSaveOpPlugin_9", (String)"macc-cad-opplugin", (Object[])new Object[0]), this.getOperationName()));
                            }
                            if (isLinkResource) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u7269\u6599\u5c42\u7ea7\u7684\u6210\u672c\u52a8\u56e0\u4e0d\u80fd\u5173\u8054\u8d44\u6e90\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CostDriverSaveOpPlugin_10", (String)"macc-cad-opplugin", (Object[])new Object[0]), this.getOperationName()));
                            }
                            if (!isComplex) break;
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u7269\u6599\u5c42\u7ea7\u7684\u6210\u672c\u52a8\u56e0\u4e0d\u80fd\u52fe\u9009\u590d\u5408\u6210\u672c\u52a8\u56e0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CostDriverSaveOpPlugin_11", (String)"macc-cad-opplugin", (Object[])new Object[0]), this.getOperationName()));
                            break;
                        }
                        case "MATERIALGROUP": {
                            if (isRelatedWork) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u7269\u6599\u5206\u7c7b\u5c42\u7ea7\u7684\u6210\u672c\u52a8\u56e0\u4e0d\u80fd\u5173\u8054\u4f5c\u4e1a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CostDriverSaveOpPlugin_12", (String)"macc-cad-opplugin", (Object[])new Object[0]), this.getOperationName()));
                            }
                            if (isLinkResource) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u7269\u6599\u5206\u7c7b\u5c42\u7ea7\u7684\u6210\u672c\u52a8\u56e0\u4e0d\u80fd\u5173\u8054\u8d44\u6e90\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CostDriverSaveOpPlugin_13", (String)"macc-cad-opplugin", (Object[])new Object[0]), this.getOperationName()));
                            }
                            if (!isComplex) break;
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u7269\u6599\u5c42\u7ea7\u7684\u6210\u672c\u52a8\u56e0\u4e0d\u80fd\u52fe\u9009\u590d\u5408\u6210\u672c\u52a8\u56e0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CostDriverSaveOpPlugin_11", (String)"macc-cad-opplugin", (Object[])new Object[0]), this.getOperationName()));
                            break;
                        }
                        case "COSTOBJECT": {
                            if (!isRelatedWork) break;
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5c42\u7ea7\u7684\u6210\u672c\u52a8\u56e0\u4e0d\u80fd\u5173\u8054\u4f5c\u4e1a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CostDriverSaveOpPlugin_14", (String)"macc-cad-opplugin", (Object[])new Object[0]), this.getOperationName()));
                            break;
                        }
                    }
                    int openNum = 0;
                    if (isRelatedWork) {
                        ++openNum;
                    }
                    if (isLinkResource) {
                        ++openNum;
                    }
                    if (isComplex) {
                        ++openNum;
                    }
                    if (openNum <= 1) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u5931\u8d25\uff0c\u5173\u8054\u4f5c\u4e1a\u3001\u5173\u8054\u8d44\u6e90\u3001\u590d\u5408\u6210\u672c\u52a8\u56e0\u4e09\u4e2a\u5f00\u5173\u4e92\u65a5\uff0c\u4e0d\u80fd\u540c\u65f6\u6253\u5f00\u591a\u4e2a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CostDriverSaveOpPlugin_15", (String)"macc-cad-opplugin", (Object[])new Object[0]), this.getOperationName()));
                }
            }
        });
        e.getValidators().add(new CostDriverWorkActUniqueValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject data : dataEntities = e.getDataEntities()) {
            String formula = data.getString("formula");
            if (!StringUtils.isNotEmpty((CharSequence)formula)) continue;
            formula = this.changeFormulaNumberToFid(formula);
            data.set("formula", (Object)formula);
        }
    }

    private String changeFormulaNumberToFid(String formula) {
        List<String> numbers = this.getNumbers(formula);
        QFilter numberFilter = new QFilter("number", "in", numbers);
        DynamicObjectCollection costDriverCollection = QueryServiceHelper.query((String)"cad_costdriver", (String)"id,number", (QFilter[])new QFilter[]{numberFilter});
        HashMap<String, String> driverNumFidMap = new HashMap<String, String>();
        for (DynamicObject driver : costDriverCollection) {
            driverNumFidMap.put(driver.getString("number"), driver.getString("id"));
        }
        for (String number : numbers) {
            formula = formula.replaceAll(number, (String)driverNumFidMap.get(number));
        }
        return formula;
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if ("audit".equals(e.getOperationKey())) {
            for (DynamicObject data : dataEntities) {
                data.set("auditor", (Object)RequestContext.get().getUserId());
                data.set("auditor_id", (Object)RequestContext.get().getUserId());
                data.set("auditdate", (Object)TimeServiceHelper.now());
            }
            SaveServiceHelper.save((DynamicObject[])dataEntities);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int validateDiffAlloc(DynamicObject costDriver) {
        List suffixList;
        String formula = costDriver.getString("formula");
        if (!StringUtils.isNotEmpty((CharSequence)formula) || CadEmptyUtils.isEmpty((List)(suffixList = FormulaUtil.analyticFormula((String)formula)))) return 0;
        logger.info("suffixList is:{}", (Object)suffixList.toString());
        Stack<String> opStack = new Stack<String>();
        String opResult = "";
        while (suffixList.size() > 0) {
            String number = (String)suffixList.remove(0);
            if (OPERATOR.indexOf(number) >= 0) {
                String firstType = (String)opStack.pop();
                String secondType = (String)opStack.pop();
                switch (number) {
                    case "+": 
                    case "-": {
                        if (!firstType.equals(secondType)) {
                            return 1;
                        }
                        opResult = firstType;
                        break;
                    }
                    case "*": 
                    case "/": {
                        if (firstType.equals(secondType)) {
                            opResult = firstType;
                            break;
                        }
                        if (firstType.equals(COSTCENTER) && secondType.equals(MATERIAL) || firstType.equals(MATERIAL) && secondType.equals(COSTCENTER)) {
                            return 2;
                        }
                        if (firstType.equals(COSTCENTER) && secondType.equals(MATERIALGROUP) || firstType.equals(MATERIALGROUP) && secondType.equals(COSTCENTER)) {
                            return 6;
                        }
                        if (firstType.equals(DIGITAL)) {
                            opResult = secondType;
                            break;
                        }
                        if (secondType.equals(DIGITAL)) {
                            opResult = firstType;
                            break;
                        }
                        opResult = COSTOBJECT;
                        break;
                    }
                }
                opStack.push(opResult);
                continue;
            }
            QFilter qFilter = new QFilter("number", "=", (Object)number);
            DynamicObject subCostDriver = QueryServiceHelper.queryOne((String)"cad_costdriver", (String)"allocclass,status,enable", (QFilter[])new QFilter[]{qFilter});
            boolean isDigital = false;
            if (subCostDriver == null) {
                boolean isInteger = CostDriverSaveOpPlugin.isInteger(number);
                if (isInteger) {
                    long id = Long.parseLong(number);
                    qFilter = new QFilter("id", "=", (Object)id);
                    subCostDriver = QueryServiceHelper.queryOne((String)"cad_costdriver", (String)"allocclass,status,enable", (QFilter[])new QFilter[]{qFilter});
                }
                if (subCostDriver == null) {
                    if (!CostDriverSaveOpPlugin.isNumeric(number)) return 3;
                    isDigital = true;
                } else {
                    this.isComplexNumber = false;
                }
            } else {
                this.isComplexNumber = true;
            }
            if (isDigital) {
                opStack.push(DIGITAL);
                continue;
            }
            if (!subCostDriver.getString("status").equals("C") || !subCostDriver.getString("enable").equals("1")) {
                return 4;
            }
            opStack.push(subCostDriver.getString("allocclass"));
        }
        if (opResult.equals(COSTCENTER) || opResult.equals(COSTOBJECT)) return 0;
        return 5;
    }

    public static boolean isStartingWithDigit(String number) {
        return number.matches("^\\d.*");
    }

    public static boolean isInteger(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    public static boolean isNumeric(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("-?[0-9]+.?[0-9]*");
        return pattern.matcher(str).matches();
    }

    private boolean validateNesting(DynamicObject costDriver) {
        String formula = costDriver.getString("formula");
        Long costDriverId = costDriver.getLong("id");
        if (!StringUtils.isEmpty((CharSequence)formula) && this.isComplexNumber) {
            formula = this.changeFormulaNumberToFid(formula);
        }
        return this.checkNest(formula, costDriverId);
    }

    public boolean checkNest(String formula, long costDriverId) {
        if (StringUtils.isNotEmpty((CharSequence)formula)) {
            List<Object> costDriverIds = CostDriverSaveOpPlugin.getCostDriverIds(formula);
            QFilter qFilter = new QFilter("id", "in", costDriverIds);
            qFilter.and(new QFilter("iscomplexcd", "=", (Object)Boolean.TRUE));
            DynamicObjectCollection costDrivers = QueryServiceHelper.query((String)"cad_costdriver", (String)"id,formula,name", (QFilter[])qFilter.toArray(), (String)"createtime desc");
            for (DynamicObject costDriver : costDrivers) {
                String subFormula = costDriver.getString("formula");
                String id = costDriver.getString("id");
                List<Object> costDriverIdList = CostDriverSaveOpPlugin.getCostDriverIds(subFormula);
                if (costDriverIdList.contains(costDriverId)) {
                    this.cacheKey = costDriver.getString("name");
                    return true;
                }
                formula = formula.replaceAll(id, subFormula);
                this.checkNest(formula, costDriverId);
            }
        }
        return false;
    }

    private List<String> getNumbers(String formula) {
        ArrayList<String> list = new ArrayList<String>();
        if (!StringUtils.isEmpty((CharSequence)formula)) {
            String[] numbers = FormulaEngine.extractVariables((String)formula);
            return Arrays.asList(numbers);
        }
        return list;
    }

    private static List<Object> getCostDriverIds(String formula) {
        String[] formulaArr;
        String formulaString = formula.replaceAll("\\s*", "");
        ArrayList<Object> costDriverIds = new ArrayList<Object>();
        if (StringUtils.isNotEmpty((CharSequence)formulaString) && (formulaArr = formulaString.split("\\D")) != null) {
            for (String id : formulaArr) {
                if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                costDriverIds.add(Long.valueOf(id));
            }
        }
        return costDriverIds;
    }

    private boolean validateNumber(DynamicObject costDriver) {
        String number = costDriver.getString("number");
        Object pkValue = costDriver.getPkValue();
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        QFilter idFilter = new QFilter("id", "!=", pkValue);
        return QueryServiceHelper.exists((String)"cad_costdriver", (QFilter[])new QFilter[]{numberFilter, idFilter});
    }
}

