/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.enums.CostTypePtyEnum;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.opplugin.ImportSaveOpValidate;

public class OutSourceSaveOpValidate
extends ImportSaveOpValidate {
    @Override
    protected void validateSave(ExtendedDataEntity dataEntity, List<String> repeatKeyList) {
        DynamicObject item = dataEntity.getDataEntity();
        item.set("pricerule", (Object)PriceRuleConstants.OUTPRI_MANUALLY_ID);
        item.set("pricerule_id", (Object)PriceRuleConstants.OUTPRI_MANUALLY_ID);
        item.set("effectdate", (Object)DateUtils.getDayStartTime((Date)item.getDate("effectdate")));
        BigDecimal price = item.getBigDecimal("price");
        if (price == null || price.compareTo(BigDecimal.ZERO) <= 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6807\u51c6\u5355\u4ef7\u201d\u3002", (String)"OutSourceSaveOpValidate_9", (String)"macc-cad-opplugin", (Object[])new Object[0]));
        }
        DynamicObject costType = item.getDynamicObject("costtype");
        if (CostTypePtyEnum.CALCULATING.getValue().equals(costType.getString("type"))) {
            String tips = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6210\u672c\u7c7b\u578b\u4e3a\u201c\u6838\u7b97\u6210\u672c\u201d\u7684\u5f15\u5165\u3002", (String)"OutSourceSaveOpValidate_0", (String)"macc-cad-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, tips);
        }
        StringBuilder sg = new StringBuilder(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u5f53\u524d\u6210\u672c\u7c7b\u578b\u4e0b%s", (String)"OutSourceSaveOpValidate_11", (String)"macc-cad-opplugin", (Object[])new Object[0]), "\uff0c"));
        DynamicObject mat = item.getDynamicObject("material");
        if (mat == null) {
            return;
        }
        sg.append(this.getCombineStr(ResManager.loadKDString((String)"\u7269\u6599", (String)"OutSourceSaveOpValidate_2", (String)"macc-cad-opplugin", (Object[])new Object[0]), mat.get("number"), mat.get("name")));
        HashSet<Long> auxptyId = new HashSet<Long>();
        Boolean isAuxprop = false;
        boolean isUseauxpty = mat.getBoolean("isuseauxpty");
        DynamicObject auxpty = item.getDynamicObject("auxpty");
        if (isUseauxpty) {
            DynamicObjectCollection isaffectprice = mat.getDynamicObjectCollection("auxptyentry");
            for (DynamicObject isPrice : isaffectprice) {
                if (!isPrice.getBoolean("isaffectprice")) continue;
                auxptyId.add(isPrice.getLong("auxpty.id"));
                isAuxprop = true;
            }
            if (isAuxprop.booleanValue()) {
                if (auxpty == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u672a\u586b\u5199\u3002", (String)"OutSourceSaveOpValidate_5", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                } else {
                    Boolean notAuxpty = this.checkAuxptyExist(auxptyId, (String)auxpty.get(1));
                    if (notAuxpty.booleanValue()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u672a\u586b\u5199\u3002", (String)"OutSourceSaveOpValidate_5", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        }
        DynamicObjectCollection entryEntity = item.getDynamicObjectCollection("entryentity");
        int index = 1;
        HashSet<Long> innerSubElement = new HashSet<Long>(16);
        HashSet subElementIdSet = new HashSet(10);
        entryEntity.forEach(e -> subElementIdSet.add(e.getLong("extsubelement.id")));
        Map subElementDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"cad_subelement", (QFilter[])new QFilter[]{new QFilter("id", "in", subElementIdSet)});
        for (DynamicObject entry : entryEntity) {
            String type;
            long subElementId = entry.getLong("extsubelement.id");
            DynamicObject subElement = (DynamicObject)subElementDynamicObjectMap.get(subElementId);
            if (!(subElement == null || "002".contains(type = subElement.getString("type")) || "003".contains(type) || "004".contains(type))) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\u6210\u672c\u5b50\u8981\u7d20\u7684\u5c5e\u6027\u4e0d\u662f\u7269\u6599\u8d39\u7528\u3001\u5236\u9020\u8d39\u7528\u548c\u8d44\u6e90\u3002", (String)"OutSourceSaveOpValidate_12", (String)"macc-cad-opplugin", (Object[])new Object[0]), index));
            }
            if (innerSubElement.contains(subElementId)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\u6210\u672c\u8981\u7d20\u4e0e\u6210\u672c\u5b50\u8981\u7d20\u91cd\u590d\u3002", (String)"OutSourceSaveOpValidate_10", (String)"macc-cad-opplugin", (Object[])new Object[0]), index));
            } else {
                innerSubElement.add(subElementId);
            }
            ++index;
        }
    }

    private Boolean checkAuxptyExist(Set<Long> auxptyId, String flex) {
        DynamicObject[] auxpty;
        Boolean isNotExist = false;
        for (DynamicObject aux : auxpty = BusinessDataServiceHelper.load((Object[])auxptyId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_auxproperty"))) {
            if (flex.contains(aux.getString("flexfield"))) continue;
            isNotExist = true;
            break;
        }
        return isNotExist;
    }
}

