/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.utils.DateUtils;

public class PriceAuditPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("costtype");
        fieldKeys.add("pricerule");
        fieldKeys.add("effectdate");
        fieldKeys.add("expdate");
        fieldKeys.add("billstatus");
        String entityName = this.billEntityType.getName();
        if ("cad_purprices".equals(entityName) || "cad_outsourceprice".equals(entityName)) {
            fieldKeys.add("auxpty");
            fieldKeys.add("configuredcode");
            fieldKeys.add("tracknumber");
            fieldKeys.add("project");
            fieldKeys.add("lot");
            fieldKeys.add("material");
        }
        if ("cad_resourcerate".equals(entityName)) {
            fieldKeys.add("workcenter");
            fieldKeys.add("resource");
        }
        if ("cad_resourceout".equals(entityName)) {
            fieldKeys.add("material");
            fieldKeys.add("resource");
            fieldKeys.add("auxpty");
            fieldKeys.add("route");
            fieldKeys.add("processseq");
            fieldKeys.add("operationno");
            fieldKeys.add("manuorg");
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){
            String entityName;
            {
                this.entityName = PriceAuditPlugin.this.billEntityType.getName();
            }

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.dataEntities;
                if (dataEntities == null) {
                    return;
                }
                if ("audit".equals(this.getOperateKey())) {
                    ArrayList<String> keys = new ArrayList<String>(dataEntities.length);
                    for (ExtendedDataEntity dataEntity : dataEntities) {
                        DynamicObject dynamicObject = dataEntity.getDataEntity();
                        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
                        filters.add(new QFilter("costtype", "=", (Object)dynamicObject.getLong("costtype.id")));
                        filters.add(new QFilter("pricerule", "=", (Object)dynamicObject.getLong("pricerule.id")));
                        filters.add(new QFilter("billstatus", "=", (Object)"C"));
                        QFilter effFilter = new QFilter("effectdate", "=", (Object)dynamicObject.getDate("effectdate"));
                        QFilter expFilter = new QFilter("expdate", "=", (Object)dynamicObject.getDate("expdate"));
                        filters.add(effFilter);
                        filters.add(expFilter);
                        String key = dynamicObject.getString("costtype.id") + "@" + dynamicObject.getString("pricerule.id");
                        if ("cad_purprices".equals(this.entityName) || "cad_outsourceprice".equals(this.entityName)) {
                            filters.add(new QFilter("material", "=", (Object)dynamicObject.getLong("material.id")));
                            filters.add(new QFilter("auxpty", "=", (Object)dynamicObject.getLong("auxpty.id")));
                            filters.add(new QFilter("configuredcode", "=", (Object)dynamicObject.getLong("configuredcode.id")));
                            filters.add(new QFilter("tracknumber", "=", (Object)dynamicObject.getLong("tracknumber.id")));
                            filters.add(new QFilter("project", "=", (Object)dynamicObject.getLong("project.id")));
                            filters.add(new QFilter("lot", "=", (Object)dynamicObject.getString("lot")));
                            key = key + "@" + dynamicObject.getString("material.id") + "@" + dynamicObject.getString("auxpty.id") + "@" + dynamicObject.getString("configuredcode.id") + "@" + dynamicObject.getLong("tracknumber.id") + "@" + dynamicObject.getString("project.id") + "@" + dynamicObject.getString("lot");
                        }
                        if ("cad_resourcerate".equals(this.entityName)) {
                            filters.add(new QFilter("workcenter", "=", (Object)dynamicObject.getLong("workcenter.id")));
                            filters.add(new QFilter("resource", "=", (Object)dynamicObject.getLong("resource.id")));
                            key = key + "@" + dynamicObject.getString("workcenter.id") + "@" + dynamicObject.getString("resource.id");
                        }
                        if ("cad_resourceout".equals(this.entityName)) {
                            filters.add(new QFilter("resource", "=", (Object)dynamicObject.getLong("resource.id")));
                            filters.add(new QFilter("route", "=", (Object)dynamicObject.getLong("route.id")));
                            filters.add(new QFilter("processseq", "=", (Object)dynamicObject.getString("processseq")));
                            filters.add(new QFilter("operationno", "=", (Object)dynamicObject.getString("operationno")));
                            key = key + "@" + dynamicObject.getString("resource.id") + "@" + dynamicObject.getLong("route.id") + "@" + dynamicObject.getString("processseq") + "@" + dynamicObject.getString("operationno");
                        }
                        if (keys.contains(key)) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u76f8\u540c\u7ef4\u5ea6\u7684\u7ec4\u5408\u4e0d\u5141\u8bb8\u540c\u65f6\u5ba1\u6838\u3002", (String)"PriceAuditPlugin_0", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                        } else {
                            filters.remove(effFilter);
                            filters.remove(expFilter);
                            boolean exists = QueryServiceHelper.exists((String)this.entityName, (QFilter[])filters.toArray(new QFilter[0]));
                            if (exists) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u7ec4\u5408\u5df2\u7ecf\u5b58\u5728\u5df2\u5ba1\u6838\u7684\u4ef7\u76ee\u8868\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u5ba1\u6838\u3002", (String)"PriceAuditPlugin_1", (String)"macc-cad-opplugin", (Object[])new Object[0]));
                            }
                        }
                        keys.add(key);
                    }
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String entityName = this.billEntityType.getName();
        DynamicObject[] dynamicObjects = e.getDataEntities();
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>();
        for (DynamicObject data : dynamicObjects) {
            DynamicObject[] objs;
            ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
            filters.add(new QFilter("id", "!=", (Object)data.getLong("id")));
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
            filters.add(new QFilter("costtype", "=", (Object)data.getLong("costtype.id")));
            filters.add(new QFilter("pricerule", "=", (Object)data.getLong("pricerule.id")));
            filters.add(new QFilter("expdate", "=", (Object)DateUtils.getDeFaultExpDate()));
            if ("cad_purprices".equals(entityName) || "cad_outsourceprice".equals(entityName)) {
                filters.add(new QFilter("material", "=", (Object)data.getLong("material.id")));
                filters.add(new QFilter("auxpty", "=", (Object)data.getLong("auxpty.id")));
                filters.add(new QFilter("configuredcode", "=", (Object)data.getLong("configuredcode.id")));
                filters.add(new QFilter("tracknumber", "=", (Object)data.getLong("tracknumber.id")));
                filters.add(new QFilter("project", "=", (Object)data.getLong("project.id")));
                filters.add(new QFilter("lot", "=", (Object)data.getString("lot")));
            }
            if ("cad_resourcerate".equals(entityName)) {
                filters.add(new QFilter("workcenter", "=", (Object)data.getLong("workcenter.id")));
                filters.add(new QFilter("resource", "=", (Object)data.getLong("resource.id")));
            }
            if ("cad_resourceout".equals(entityName)) {
                filters.add(new QFilter("resource", "=", (Object)data.getLong("resource.id")));
                filters.add(new QFilter("route", "=", (Object)data.getLong("route.id")));
                filters.add(new QFilter("processseq", "=", (Object)data.getString("processseq")));
                filters.add(new QFilter("operationno", "=", (Object)data.getString("operationno")));
            }
            for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)entityName, (String)"expdate", (QFilter[])filters.toArray(new QFilter[0]))) {
                obj.set("expdate", (Object)data.getDate("effectdate"));
                saveList.add(obj);
            }
        }
        SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
    }
}

