/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.opplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.ElementHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class PurPriceImportOpPlugin
extends BatchImportPlugin {
    private Log logger = LogFactory.getLog(PurPriceImportOpPlugin.class);

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        this.fillSubElementInfo(billdatas);
    }

    private void fillSubElementInfo(List<ImportBillData> billdatas) {
        HashSet materialNums = Sets.newHashSetWithExpectedSize((int)10);
        HashSet costtypeNums = Sets.newHashSetWithExpectedSize((int)10);
        for (ImportBillData billdata : billdatas) {
            JSONObject costtypeObj;
            JSONObject obj = billdata.getData();
            JSONObject jsonObj = obj.getJSONObject("material");
            if (jsonObj != null) {
                String materialNum = jsonObj.getString("number");
                materialNums.add(materialNum);
            }
            if ((costtypeObj = obj.getJSONObject("costtype")) == null) continue;
            String costtypeNum = costtypeObj.getString("number");
            costtypeNums.add(costtypeNum);
        }
        Map<String, Long> materialMap = this.getMaterialId(materialNums);
        Map<String, Long> costtypeMap = this.getCostTypeId(costtypeNums);
        HashSet materialIds = Sets.newHashSetWithExpectedSize((int)10);
        HashMap costTypeDynMap = Maps.newHashMapWithExpectedSize((int)10);
        int size = 0;
        for (ImportBillData billdata : billdatas) {
            JSONObject materialObj;
            JSONObject costtypeObj;
            JSONObject obj = billdata.getData();
            JSONArray entryentity = obj.getJSONArray("entryentity");
            boolean isHasElement = true;
            if (entryentity != null && !entryentity.isEmpty()) {
                for (int i = 0; i < entryentity.size(); ++i) {
                    JSONObject entryobj = entryentity.getJSONObject(i);
                    if (entryobj.containsKey((Object)"subelement")) continue;
                    isHasElement = false;
                }
            }
            if (isHasElement || (costtypeObj = obj.getJSONObject("costtype")) == null || (materialObj = obj.getJSONObject("material")) == null) continue;
            Long costtypeId = costtypeMap.get(costtypeObj.getString("number"));
            Long materialId = materialMap.get(materialObj.getString("number"));
            if (CadEmptyUtils.isEmpty((Long)costtypeId) || CadEmptyUtils.isEmpty((Long)materialId)) continue;
            materialIds.add(materialId);
            costTypeDynMap.computeIfAbsent(costtypeId, t -> new ArrayList()).add(billdata);
            ++size;
        }
        this.logger.info("\u7269\u6599\u6807\u51c6\u6210\u672c\u4ef7\u76ee\u8868-\u586b\u5145\u5b50\u8981\u7d20\u7684\u5355\u636e\u6570\uff1a{}", (Object)size);
        HashMap subelementMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap elementMap = Maps.newHashMapWithExpectedSize((int)10);
        for (Map.Entry entry : costTypeDynMap.entrySet()) {
            List orgIds = CostTypeHelper.getOrgByCostType((Long)((Long)entry.getKey()));
            if (CadEmptyUtils.isEmpty((List)orgIds)) {
                return;
            }
            Map materialToEleMap = ElementHelper.getDefSubEles((Long)((Long)orgIds.get(0)), (Set)materialIds, (boolean)true);
            for (ImportBillData data : (List)entry.getValue()) {
                JSONObject obj = data.getData();
                JSONArray entryentity = obj.getJSONArray("entryentity");
                JSONObject materialObj = obj.getJSONObject("material");
                Long materialId = materialMap.get(materialObj.getString("number"));
                for (int i = 0; i < entryentity.size(); ++i) {
                    Long[] eleArr;
                    JSONObject entryobj = entryentity.getJSONObject(i);
                    if (entryobj.containsKey((Object)"subelement") || (eleArr = (Long[])materialToEleMap.get(materialId)) == null) continue;
                    DynamicObject subElement = (DynamicObject)subelementMap.get(eleArr[1]);
                    if (subElement == null) {
                        subElement = BusinessDataServiceHelper.loadSingleFromCache((Object)eleArr[1], (String)"cad_subelement");
                        subelementMap.put(eleArr[1], subElement);
                    }
                    if (subElement == null) continue;
                    DynamicObject elementDyn = (DynamicObject)elementMap.get(eleArr[0]);
                    if (elementDyn == null) {
                        elementDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)eleArr[0], (String)"cad_element");
                        subelementMap.put(eleArr[0], elementDyn);
                    }
                    if (elementDyn == null) continue;
                    JSONObject subelement = new JSONObject();
                    subelement.put("importprop", (Object)"number");
                    subelement.put("number", (Object)subElement.getString("number"));
                    subelement.put("name", (Object)subElement.getString("name"));
                    entryobj.put("subelement", (Object)subelement);
                    JSONObject element = new JSONObject();
                    element.put("importprop", (Object)"number");
                    element.put("number", (Object)elementDyn.getString("number"));
                    element.put("name", (Object)elementDyn.getString("name"));
                    entryobj.put("element", (Object)element);
                }
            }
        }
    }

    private Map<String, Long> getMaterialId(Set<String> numbers) {
        HashMap materialMap = Maps.newHashMapWithExpectedSize((int)10);
        QFilter filter = new QFilter("number", "in", numbers);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"material", (String)"bd_material", (String)"number,id", (QFilter[])filter.toArray(), null);
        for (Row row : ds) {
            materialMap.put(row.getString("number"), row.getLong("id"));
        }
        return materialMap;
    }

    private Map<String, Long> getCostTypeId(Set<String> numbers) {
        HashMap costtypeMap = Maps.newHashMapWithExpectedSize((int)10);
        QFilter filter = new QFilter("number", "in", numbers);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"material", (String)"cad_costtype", (String)"number,id", (QFilter[])filter.toArray(), null);
        for (Row row : ds) {
            costtypeMap.put(row.getString("number"), row.getLong("id"));
        }
        return costtypeMap;
    }
}

